package com.sforce.soap.enterprise.wsc;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.bind.TypeMapper;

import java.util.HashMap;

import javax.xml.namespace.QName;

/**
 * Generated class, please do not edit.
 */
public class EnterpriseConnection {

  private TypeMapper __typeMapper = new TypeMapper();
  private ConnectorConfig __config;
  private HashMap<QName, XMLizable> __extraHeaders = new HashMap<QName, XMLizable>();

  public ConnectorConfig getConfig() {
    return __config;
  }

  
  private com.sforce.soap.enterprise.wsc.LoginScopeHeader_element __LoginScopeHeader;

  public void setLoginScopeHeader(java.lang.String organizationId,java.lang.String portalId) {
    __LoginScopeHeader = new com.sforce.soap.enterprise.wsc.LoginScopeHeader_element();
     
       __LoginScopeHeader.setOrganizationId(organizationId);
       __LoginScopeHeader.setPortalId(portalId);
  }

  public void clearLoginScopeHeader() {
    __LoginScopeHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.LoginScopeHeader_element getLoginScopeHeader() {
    return  __LoginScopeHeader;
  }

  public void __setLoginScopeHeader(com.sforce.soap.enterprise.wsc.LoginScopeHeader_element __header) {
    __LoginScopeHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.AllOrNoneHeader_element __AllOrNoneHeader;

  public void setAllOrNoneHeader(boolean allOrNone) {
    __AllOrNoneHeader = new com.sforce.soap.enterprise.wsc.AllOrNoneHeader_element();
     
       __AllOrNoneHeader.setAllOrNone(allOrNone);
  }

  public void clearAllOrNoneHeader() {
    __AllOrNoneHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.AllOrNoneHeader_element getAllOrNoneHeader() {
    return  __AllOrNoneHeader;
  }

  public void __setAllOrNoneHeader(com.sforce.soap.enterprise.wsc.AllOrNoneHeader_element __header) {
    __AllOrNoneHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.MruHeader_element __MruHeader;

  public void setMruHeader(boolean updateMru) {
    __MruHeader = new com.sforce.soap.enterprise.wsc.MruHeader_element();
     
       __MruHeader.setUpdateMru(updateMru);
  }

  public void clearMruHeader() {
    __MruHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.MruHeader_element getMruHeader() {
    return  __MruHeader;
  }

  public void __setMruHeader(com.sforce.soap.enterprise.wsc.MruHeader_element __header) {
    __MruHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.UserTerritoryDeleteHeader_element __UserTerritoryDeleteHeader;

  public void setUserTerritoryDeleteHeader(java.lang.String transferToUserId) {
    __UserTerritoryDeleteHeader = new com.sforce.soap.enterprise.wsc.UserTerritoryDeleteHeader_element();
     
       __UserTerritoryDeleteHeader.setTransferToUserId(transferToUserId);
  }

  public void clearUserTerritoryDeleteHeader() {
    __UserTerritoryDeleteHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.UserTerritoryDeleteHeader_element getUserTerritoryDeleteHeader() {
    return  __UserTerritoryDeleteHeader;
  }

  public void __setUserTerritoryDeleteHeader(com.sforce.soap.enterprise.wsc.UserTerritoryDeleteHeader_element __header) {
    __UserTerritoryDeleteHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.OwnerChangeOptions_element __OwnerChangeOptions;

  public void setOwnerChangeOptions(com.sforce.soap.enterprise.wsc.OwnerChangeOption[] options) {
    __OwnerChangeOptions = new com.sforce.soap.enterprise.wsc.OwnerChangeOptions_element();
     
       __OwnerChangeOptions.setOptions(options);
  }

  public void clearOwnerChangeOptions() {
    __OwnerChangeOptions = null;
  }

  public com.sforce.soap.enterprise.wsc.OwnerChangeOptions_element getOwnerChangeOptions() {
    return  __OwnerChangeOptions;
  }

  public void __setOwnerChangeOptions(com.sforce.soap.enterprise.wsc.OwnerChangeOptions_element __header) {
    __OwnerChangeOptions = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.DuplicateRuleHeader_element __DuplicateRuleHeader;

  public void setDuplicateRuleHeader(boolean allowSave,boolean includeRecordDetails,boolean runAsCurrentUser) {
    __DuplicateRuleHeader = new com.sforce.soap.enterprise.wsc.DuplicateRuleHeader_element();
     
       __DuplicateRuleHeader.setAllowSave(allowSave);
       __DuplicateRuleHeader.setIncludeRecordDetails(includeRecordDetails);
       __DuplicateRuleHeader.setRunAsCurrentUser(runAsCurrentUser);
  }

  public void clearDuplicateRuleHeader() {
    __DuplicateRuleHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.DuplicateRuleHeader_element getDuplicateRuleHeader() {
    return  __DuplicateRuleHeader;
  }

  public void __setDuplicateRuleHeader(com.sforce.soap.enterprise.wsc.DuplicateRuleHeader_element __header) {
    __DuplicateRuleHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.StreamingEnabledHeader_element __StreamingEnabledHeader;

  public void setStreamingEnabledHeader(boolean streamingEnabled) {
    __StreamingEnabledHeader = new com.sforce.soap.enterprise.wsc.StreamingEnabledHeader_element();
     
       __StreamingEnabledHeader.setStreamingEnabled(streamingEnabled);
  }

  public void clearStreamingEnabledHeader() {
    __StreamingEnabledHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.StreamingEnabledHeader_element getStreamingEnabledHeader() {
    return  __StreamingEnabledHeader;
  }

  public void __setStreamingEnabledHeader(com.sforce.soap.enterprise.wsc.StreamingEnabledHeader_element __header) {
    __StreamingEnabledHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.AllowFieldTruncationHeader_element __AllowFieldTruncationHeader;

  public void setAllowFieldTruncationHeader(boolean allowFieldTruncation) {
    __AllowFieldTruncationHeader = new com.sforce.soap.enterprise.wsc.AllowFieldTruncationHeader_element();
     
       __AllowFieldTruncationHeader.setAllowFieldTruncation(allowFieldTruncation);
  }

  public void clearAllowFieldTruncationHeader() {
    __AllowFieldTruncationHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.AllowFieldTruncationHeader_element getAllowFieldTruncationHeader() {
    return  __AllowFieldTruncationHeader;
  }

  public void __setAllowFieldTruncationHeader(com.sforce.soap.enterprise.wsc.AllowFieldTruncationHeader_element __header) {
    __AllowFieldTruncationHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.LimitInfoHeader_element __LimitInfoHeader;

  public void setLimitInfoHeader(com.sforce.soap.enterprise.wsc.LimitInfo[] limitInfo) {
    __LimitInfoHeader = new com.sforce.soap.enterprise.wsc.LimitInfoHeader_element();
     
       __LimitInfoHeader.setLimitInfo(limitInfo);
  }

  public void clearLimitInfoHeader() {
    __LimitInfoHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.LimitInfoHeader_element getLimitInfoHeader() {
    return  __LimitInfoHeader;
  }

  public void __setLimitInfoHeader(com.sforce.soap.enterprise.wsc.LimitInfoHeader_element __header) {
    __LimitInfoHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.DebuggingInfo_element __DebuggingInfo;

  public void setDebuggingInfo(java.lang.String debugLog) {
    __DebuggingInfo = new com.sforce.soap.enterprise.wsc.DebuggingInfo_element();
     
       __DebuggingInfo.setDebugLog(debugLog);
  }

  public void clearDebuggingInfo() {
    __DebuggingInfo = null;
  }

  public com.sforce.soap.enterprise.wsc.DebuggingInfo_element getDebuggingInfo() {
    return  __DebuggingInfo;
  }

  public void __setDebuggingInfo(com.sforce.soap.enterprise.wsc.DebuggingInfo_element __header) {
    __DebuggingInfo = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.AssignmentRuleHeader_element __AssignmentRuleHeader;

  public void setAssignmentRuleHeader(java.lang.String assignmentRuleId,java.lang.Boolean useDefaultRule) {
    __AssignmentRuleHeader = new com.sforce.soap.enterprise.wsc.AssignmentRuleHeader_element();
     
       __AssignmentRuleHeader.setAssignmentRuleId(assignmentRuleId);
       __AssignmentRuleHeader.setUseDefaultRule(useDefaultRule);
  }

  public void clearAssignmentRuleHeader() {
    __AssignmentRuleHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.AssignmentRuleHeader_element getAssignmentRuleHeader() {
    return  __AssignmentRuleHeader;
  }

  public void __setAssignmentRuleHeader(com.sforce.soap.enterprise.wsc.AssignmentRuleHeader_element __header) {
    __AssignmentRuleHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.DisableFeedTrackingHeader_element __DisableFeedTrackingHeader;

  public void setDisableFeedTrackingHeader(boolean disableFeedTracking) {
    __DisableFeedTrackingHeader = new com.sforce.soap.enterprise.wsc.DisableFeedTrackingHeader_element();
     
       __DisableFeedTrackingHeader.setDisableFeedTracking(disableFeedTracking);
  }

  public void clearDisableFeedTrackingHeader() {
    __DisableFeedTrackingHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.DisableFeedTrackingHeader_element getDisableFeedTrackingHeader() {
    return  __DisableFeedTrackingHeader;
  }

  public void __setDisableFeedTrackingHeader(com.sforce.soap.enterprise.wsc.DisableFeedTrackingHeader_element __header) {
    __DisableFeedTrackingHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.LocaleOptions_element __LocaleOptions;

  public void setLocaleOptions(java.lang.String language,boolean localizeErrors) {
    __LocaleOptions = new com.sforce.soap.enterprise.wsc.LocaleOptions_element();
     
       __LocaleOptions.setLanguage(language);
       __LocaleOptions.setLocalizeErrors(localizeErrors);
  }

  public void clearLocaleOptions() {
    __LocaleOptions = null;
  }

  public com.sforce.soap.enterprise.wsc.LocaleOptions_element getLocaleOptions() {
    return  __LocaleOptions;
  }

  public void __setLocaleOptions(com.sforce.soap.enterprise.wsc.LocaleOptions_element __header) {
    __LocaleOptions = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.DebuggingHeader_element __DebuggingHeader;

  public void setDebuggingHeader(com.sforce.soap.enterprise.wsc.LogInfo[] categories,com.sforce.soap.enterprise.wsc.DebugLevel debugLevel) {
    __DebuggingHeader = new com.sforce.soap.enterprise.wsc.DebuggingHeader_element();
     
       __DebuggingHeader.setCategories(categories);
       __DebuggingHeader.setDebugLevel(debugLevel);
  }

  public void clearDebuggingHeader() {
    __DebuggingHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.DebuggingHeader_element getDebuggingHeader() {
    return  __DebuggingHeader;
  }

  public void __setDebuggingHeader(com.sforce.soap.enterprise.wsc.DebuggingHeader_element __header) {
    __DebuggingHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.PackageVersionHeader_element __PackageVersionHeader;

  public void setPackageVersionHeader(com.sforce.soap.enterprise.wsc.PackageVersion[] packageVersions) {
    __PackageVersionHeader = new com.sforce.soap.enterprise.wsc.PackageVersionHeader_element();
     
       __PackageVersionHeader.setPackageVersions(packageVersions);
  }

  public void clearPackageVersionHeader() {
    __PackageVersionHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.PackageVersionHeader_element getPackageVersionHeader() {
    return  __PackageVersionHeader;
  }

  public void __setPackageVersionHeader(com.sforce.soap.enterprise.wsc.PackageVersionHeader_element __header) {
    __PackageVersionHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.SessionHeader_element __SessionHeader;

  public void setSessionHeader(java.lang.String sessionId) {
    __SessionHeader = new com.sforce.soap.enterprise.wsc.SessionHeader_element();
     
       __SessionHeader.setSessionId(sessionId);
  }

  public void clearSessionHeader() {
    __SessionHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.SessionHeader_element getSessionHeader() {
    return  __SessionHeader;
  }

  public void __setSessionHeader(com.sforce.soap.enterprise.wsc.SessionHeader_element __header) {
    __SessionHeader = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.QueryOptions_element __QueryOptions;

  public void setQueryOptions(int batchSize) {
    __QueryOptions = new com.sforce.soap.enterprise.wsc.QueryOptions_element();
     
       __QueryOptions.setBatchSize(batchSize);
  }

  public void clearQueryOptions() {
    __QueryOptions = null;
  }

  public com.sforce.soap.enterprise.wsc.QueryOptions_element getQueryOptions() {
    return  __QueryOptions;
  }

  public void __setQueryOptions(com.sforce.soap.enterprise.wsc.QueryOptions_element __header) {
    __QueryOptions = __header ;
  }

  
  private com.sforce.soap.enterprise.wsc.EmailHeader_element __EmailHeader;

  public void setEmailHeader(boolean triggerAutoResponseEmail,boolean triggerOtherEmail,boolean triggerUserEmail) {
    __EmailHeader = new com.sforce.soap.enterprise.wsc.EmailHeader_element();
     
       __EmailHeader.setTriggerAutoResponseEmail(triggerAutoResponseEmail);
       __EmailHeader.setTriggerOtherEmail(triggerOtherEmail);
       __EmailHeader.setTriggerUserEmail(triggerUserEmail);
  }

  public void clearEmailHeader() {
    __EmailHeader = null;
  }

  public com.sforce.soap.enterprise.wsc.EmailHeader_element getEmailHeader() {
    return  __EmailHeader;
  }

  public void __setEmailHeader(com.sforce.soap.enterprise.wsc.EmailHeader_element __header) {
    __EmailHeader = __header ;
  }

  

  public EnterpriseConnection(ConnectorConfig config) throws ConnectionException {
    this.__config = config;
    this.__typeMapper.setPackagePrefix("wsc");
    this.__typeMapper.setConfig(config);

    
    config.verifyEnterpriseEndpoint();
    if (!config.isManualLogin()) {
      if (config.getSessionId()==null) {
        config.setServiceEndpoint(config.getAuthEndpoint());
        com.sforce.soap.enterprise.wsc.LoginResult result = login(config.getUsername(), config.getPassword());
        config.setSessionId(result.getSessionId());
        config.setServiceEndpoint(result.getServerUrl());
      } else {
        if (config.getServiceEndpoint() == null) {
          throw new com.sforce.ws.ConnectionException("Please set ServiceEndpoint");
        }
      }
    }
    

    
      __SessionHeader = new SessionHeader_element();
      __SessionHeader.setSessionId(config.getSessionId());
    
  }

  private com.sforce.ws.transport.SoapConnection newConnection() {
      com.sforce.ws.transport.SoapConnection __c   = new com.sforce.ws.transport.SoapConnection(
           __config.getServiceEndpoint(), "urn:sobject.enterprise.soap.sforce.com", __typeMapper, __config);

      __c.setConnection(this);
      __c.setKnownHeaders(knownHeaders);
      return __c;
   }

  
  public com.sforce.soap.enterprise.wsc.SaveResult[] create(com.sforce.soap.enterprise.sobject.wsc.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Create_element __request = new com.sforce.soap.enterprise.wsc.Create_element();
    
    com.sforce.soap.enterprise.wsc.CreateResponse_element __response = null;

  
    __request.setSObjects(sObjects);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.CreateResponse_element) __connection.send("",
       create_qname, __request, createResponse_qname,
       com.sforce.soap.enterprise.wsc.CreateResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSoftphoneLayoutResult describeSoftphoneLayout()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSoftphoneLayout_element __request = new com.sforce.soap.enterprise.wsc.DescribeSoftphoneLayout_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSoftphoneLayoutResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSoftphoneLayoutResponse_element) __connection.send("",
       describeSoftphoneLayout_qname, __request, describeSoftphoneLayoutResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSoftphoneLayoutResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSearchScopeOrderResult[] describeSearchScopeOrder()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSearchScopeOrder_element __request = new com.sforce.soap.enterprise.wsc.DescribeSearchScopeOrder_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSearchScopeOrderResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSearchScopeOrderResponse_element) __connection.send("",
       describeSearchScopeOrder_qname, __request, describeSearchScopeOrderResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSearchScopeOrderResponse_element.class);

    return __response.getResult();
  }
  
  public void logout()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Logout_element __request = new com.sforce.soap.enterprise.wsc.Logout_element();
    @SuppressWarnings("unused")
    com.sforce.soap.enterprise.wsc.LogoutResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.LogoutResponse_element) __connection.send("",
       logout_qname, __request, logoutResponse_qname,
       com.sforce.soap.enterprise.wsc.LogoutResponse_element.class);

    
  }
  
  public com.sforce.soap.enterprise.wsc.InvalidateSessionsResult[] invalidateSessions(java.lang.String[] sessionIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.InvalidateSessions_element __request = new com.sforce.soap.enterprise.wsc.InvalidateSessions_element();
    
    com.sforce.soap.enterprise.wsc.InvalidateSessionsResponse_element __response = null;

  
    __request.setSessionIds(sessionIds);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.InvalidateSessionsResponse_element) __connection.send("",
       invalidateSessions_qname, __request, invalidateSessionsResponse_qname,
       com.sforce.soap.enterprise.wsc.InvalidateSessionsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSearchLayoutResult[] describeSearchLayouts(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSearchLayouts_element __request = new com.sforce.soap.enterprise.wsc.DescribeSearchLayouts_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSearchLayoutsResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSearchLayoutsResponse_element) __connection.send("",
       describeSearchLayouts_qname, __request, describeSearchLayoutsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSearchLayoutsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.MergeResult[] merge(com.sforce.soap.enterprise.wsc.MergeRequest[] request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Merge_element __request = new com.sforce.soap.enterprise.wsc.Merge_element();
    
    com.sforce.soap.enterprise.wsc.MergeResponse_element __response = null;

  
    __request.setRequest(request);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.MergeResponse_element) __connection.send("",
       merge_qname, __request, mergeResponse_qname,
       com.sforce.soap.enterprise.wsc.MergeResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSObjectResult describeSObject(java.lang.String sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSObject_element __request = new com.sforce.soap.enterprise.wsc.DescribeSObject_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSObjectResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSObjectResponse_element) __connection.send("",
       describeSObject_qname, __request, describeSObjectResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSObjectResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.SetPasswordResult setPassword(java.lang.String userId,java.lang.String password)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.SetPassword_element __request = new com.sforce.soap.enterprise.wsc.SetPassword_element();
    
    com.sforce.soap.enterprise.wsc.SetPasswordResponse_element __response = null;

  
    __request.setUserId(userId);
    __request.setPassword(password);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.SetPasswordResponse_element) __connection.send("",
       setPassword_qname, __request, setPasswordResponse_qname,
       com.sforce.soap.enterprise.wsc.SetPasswordResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.ResetPasswordResult resetPassword(java.lang.String userId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.ResetPassword_element __request = new com.sforce.soap.enterprise.wsc.ResetPassword_element();
    
    com.sforce.soap.enterprise.wsc.ResetPasswordResponse_element __response = null;

  
    __request.setUserId(userId);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.ResetPasswordResponse_element) __connection.send("",
       resetPassword_qname, __request, resetPasswordResponse_qname,
       com.sforce.soap.enterprise.wsc.ResetPasswordResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.QuickActionTemplateResult[] retrieveQuickActionTemplates(java.lang.String[] quickActionNames,java.lang.String contextId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.RetrieveQuickActionTemplates_element __request = new com.sforce.soap.enterprise.wsc.RetrieveQuickActionTemplates_element();
    
    com.sforce.soap.enterprise.wsc.RetrieveQuickActionTemplatesResponse_element __response = null;

  
    __request.setQuickActionNames(quickActionNames);
    __request.setContextId(contextId);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.RetrieveQuickActionTemplatesResponse_element) __connection.send("",
       retrieveQuickActionTemplates_qname, __request, retrieveQuickActionTemplatesResponse_qname,
       com.sforce.soap.enterprise.wsc.RetrieveQuickActionTemplatesResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.GetServerTimestampResult getServerTimestamp()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.GetServerTimestamp_element __request = new com.sforce.soap.enterprise.wsc.GetServerTimestamp_element();
    
    com.sforce.soap.enterprise.wsc.GetServerTimestampResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.GetServerTimestampResponse_element) __connection.send("",
       getServerTimestamp_qname, __request, getServerTimestampResponse_qname,
       com.sforce.soap.enterprise.wsc.GetServerTimestampResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.UndeleteResult[] undelete(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Undelete_element __request = new com.sforce.soap.enterprise.wsc.Undelete_element();
    
    com.sforce.soap.enterprise.wsc.UndeleteResponse_element __response = null;

  
    __request.setIds(ids);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.UndeleteResponse_element) __connection.send("",
       undelete_qname, __request, undeleteResponse_qname,
       com.sforce.soap.enterprise.wsc.UndeleteResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.sobject.wsc.SObject[] retrieve(java.lang.String fieldList,java.lang.String sObjectType,java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Retrieve_element __request = new com.sforce.soap.enterprise.wsc.Retrieve_element();
    
    com.sforce.soap.enterprise.wsc.RetrieveResponse_element __response = null;

  
    __request.setFieldList(fieldList);
    __request.setSObjectType(sObjectType);
    __request.setIds(ids);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.RetrieveResponse_element) __connection.send("",
       retrieve_qname, __request, retrieveResponse_qname,
       com.sforce.soap.enterprise.wsc.RetrieveResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.KnowledgeSettings describeKnowledgeSettings()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeKnowledgeSettings_element __request = new com.sforce.soap.enterprise.wsc.DescribeKnowledgeSettings_element();
    
    com.sforce.soap.enterprise.wsc.DescribeKnowledgeSettingsResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeKnowledgeSettingsResponse_element) __connection.send("",
       describeKnowledgeSettings_qname, __request, describeKnowledgeSettingsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeKnowledgeSettingsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.ExecuteListViewResult executeListView(com.sforce.soap.enterprise.wsc.ExecuteListViewRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.ExecuteListView_element __request = new com.sforce.soap.enterprise.wsc.ExecuteListView_element();
    
    com.sforce.soap.enterprise.wsc.ExecuteListViewResponse_element __response = null;

  
    __request.setRequest(request);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.ExecuteListViewResponse_element) __connection.send("",
       executeListView_qname, __request, executeListViewResponse_qname,
       com.sforce.soap.enterprise.wsc.ExecuteListViewResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplateResult renderStoredEmailTemplate(com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplateRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplate_element __request = new com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplate_element();
    
    com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplateResponse_element __response = null;

  
    __request.setRequest(request);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplateResponse_element) __connection.send("",
       renderStoredEmailTemplate_qname, __request, renderStoredEmailTemplateResponse_qname,
       com.sforce.soap.enterprise.wsc.RenderStoredEmailTemplateResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeVisualForceResult describeVisualForce(boolean includeAllDetails,java.lang.String namespacePrefix)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeVisualForce_element __request = new com.sforce.soap.enterprise.wsc.DescribeVisualForce_element();
    
    com.sforce.soap.enterprise.wsc.DescribeVisualForceResponse_element __response = null;

  
    __request.setIncludeAllDetails(includeAllDetails);
    __request.setNamespacePrefix(namespacePrefix);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeVisualForceResponse_element) __connection.send("",
       describeVisualForce_qname, __request, describeVisualForceResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeVisualForceResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.FindDuplicatesResult[] findDuplicatesByIds(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.FindDuplicatesByIds_element __request = new com.sforce.soap.enterprise.wsc.FindDuplicatesByIds_element();
    
    com.sforce.soap.enterprise.wsc.FindDuplicatesByIdsResponse_element __response = null;

  
    __request.setIds(ids);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.FindDuplicatesByIdsResponse_element) __connection.send("",
       findDuplicatesByIds_qname, __request, findDuplicatesByIdsResponse_qname,
       com.sforce.soap.enterprise.wsc.FindDuplicatesByIdsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeNounResult[] describeNouns(java.lang.String[] nouns,boolean onlyRenamed,boolean includeFields)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeNouns_element __request = new com.sforce.soap.enterprise.wsc.DescribeNouns_element();
    
    com.sforce.soap.enterprise.wsc.DescribeNounsResponse_element __response = null;

  
    __request.setNouns(nouns);
    __request.setOnlyRenamed(onlyRenamed);
    __request.setIncludeFields(includeFields);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeNounsResponse_element) __connection.send("",
       describeNouns_qname, __request, describeNounsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeNounsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeThemeResult describeTheme(java.lang.String[] sobjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeTheme_element __request = new com.sforce.soap.enterprise.wsc.DescribeTheme_element();
    
    com.sforce.soap.enterprise.wsc.DescribeThemeResponse_element __response = null;

  
    __request.setSobjectType(sobjectType);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeThemeResponse_element) __connection.send("",
       describeTheme_qname, __request, describeThemeResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeThemeResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.UpsertResult[] upsert(java.lang.String externalIDFieldName,com.sforce.soap.enterprise.sobject.wsc.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Upsert_element __request = new com.sforce.soap.enterprise.wsc.Upsert_element();
    
    com.sforce.soap.enterprise.wsc.UpsertResponse_element __response = null;

  
    __request.setExternalIDFieldName(externalIDFieldName);
    __request.setSObjects(sObjects);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    
    if (__OwnerChangeOptions != null) __connection.addHeader(OwnerChangeOptions_qname, __OwnerChangeOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.UpsertResponse_element) __connection.send("",
       upsert_qname, __request, upsertResponse_qname,
       com.sforce.soap.enterprise.wsc.UpsertResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.RenderEmailTemplateResult[] renderEmailTemplate(com.sforce.soap.enterprise.wsc.RenderEmailTemplateRequest[] renderRequests)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.RenderEmailTemplate_element __request = new com.sforce.soap.enterprise.wsc.RenderEmailTemplate_element();
    
    com.sforce.soap.enterprise.wsc.RenderEmailTemplateResponse_element __response = null;

  
    __request.setRenderRequests(renderRequests);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.RenderEmailTemplateResponse_element) __connection.send("",
       renderEmailTemplate_qname, __request, renderEmailTemplateResponse_qname,
       com.sforce.soap.enterprise.wsc.RenderEmailTemplateResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.SendEmailResult[] sendEmailMessage(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.SendEmailMessage_element __request = new com.sforce.soap.enterprise.wsc.SendEmailMessage_element();
    
    com.sforce.soap.enterprise.wsc.SendEmailMessageResponse_element __response = null;

  
    __request.setIds(ids);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.SendEmailMessageResponse_element) __connection.send("",
       sendEmailMessage_qname, __request, sendEmailMessageResponse_qname,
       com.sforce.soap.enterprise.wsc.SendEmailMessageResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSObjectResult[] describeSObjects(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSObjects_element __request = new com.sforce.soap.enterprise.wsc.DescribeSObjects_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSObjectsResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSObjectsResponse_element) __connection.send("",
       describeSObjects_qname, __request, describeSObjectsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSObjectsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.PerformQuickActionResult[] performQuickActions(com.sforce.soap.enterprise.wsc.PerformQuickActionRequest[] quickActions)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.PerformQuickActions_element __request = new com.sforce.soap.enterprise.wsc.PerformQuickActions_element();
    
    com.sforce.soap.enterprise.wsc.PerformQuickActionsResponse_element __response = null;

  
    __request.setQuickActions(quickActions);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    
    if (__OwnerChangeOptions != null) __connection.addHeader(OwnerChangeOptions_qname, __OwnerChangeOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.PerformQuickActionsResponse_element) __connection.send("",
       performQuickActions_qname, __request, performQuickActionsResponse_qname,
       com.sforce.soap.enterprise.wsc.PerformQuickActionsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeQuickActionResult[] describeQuickActions(java.lang.String[] quickActions)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeQuickActions_element __request = new com.sforce.soap.enterprise.wsc.DescribeQuickActions_element();
    
    com.sforce.soap.enterprise.wsc.DescribeQuickActionsResponse_element __response = null;

  
    __request.setQuickActions(quickActions);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeQuickActionsResponse_element) __connection.send("",
       describeQuickActions_qname, __request, describeQuickActionsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeQuickActionsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.QueryResult query(java.lang.String queryString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Query_element __request = new com.sforce.soap.enterprise.wsc.Query_element();
    
    com.sforce.soap.enterprise.wsc.QueryResponse_element __response = null;

  
    __request.setQueryString(queryString);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.QueryResponse_element) __connection.send("",
       query_qname, __request, queryResponse_qname,
       com.sforce.soap.enterprise.wsc.QueryResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeAvailableQuickActionResult[] describeAvailableQuickActions(java.lang.String contextType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeAvailableQuickActions_element __request = new com.sforce.soap.enterprise.wsc.DescribeAvailableQuickActions_element();
    
    com.sforce.soap.enterprise.wsc.DescribeAvailableQuickActionsResponse_element __response = null;

  
    __request.setContextType(contextType);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeAvailableQuickActionsResponse_element) __connection.send("",
       describeAvailableQuickActions_qname, __request, describeAvailableQuickActionsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeAvailableQuickActionsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribePathAssistantsResult describePathAssistants(java.lang.String sObjectType,java.lang.String picklistValue,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribePathAssistants_element __request = new com.sforce.soap.enterprise.wsc.DescribePathAssistants_element();
    
    com.sforce.soap.enterprise.wsc.DescribePathAssistantsResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setPicklistValue(picklistValue);
    __request.setRecordTypeIds(recordTypeIds);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribePathAssistantsResponse_element) __connection.send("",
       describePathAssistants_qname, __request, describePathAssistantsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribePathAssistantsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.GetUpdatedResult getUpdated(java.lang.String sObjectType,java.util.Calendar startDate,java.util.Calendar endDate)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.GetUpdated_element __request = new com.sforce.soap.enterprise.wsc.GetUpdated_element();
    
    com.sforce.soap.enterprise.wsc.GetUpdatedResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setStartDate(startDate);
    __request.setEndDate(endDate);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.GetUpdatedResponse_element) __connection.send("",
       getUpdated_qname, __request, getUpdatedResponse_qname,
       com.sforce.soap.enterprise.wsc.GetUpdatedResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.SearchResult search(java.lang.String searchString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Search_element __request = new com.sforce.soap.enterprise.wsc.Search_element();
    
    com.sforce.soap.enterprise.wsc.SearchResponse_element __response = null;

  
    __request.setSearchString(searchString);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.SearchResponse_element) __connection.send("",
       search_qname, __request, searchResponse_qname,
       com.sforce.soap.enterprise.wsc.SearchResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.SendEmailResult[] sendEmail(com.sforce.soap.enterprise.wsc.Email[] messages)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.SendEmail_element __request = new com.sforce.soap.enterprise.wsc.SendEmail_element();
    
    com.sforce.soap.enterprise.wsc.SendEmailResponse_element __response = null;

  
    __request.setMessages(messages);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.SendEmailResponse_element) __connection.send("",
       sendEmail_qname, __request, sendEmailResponse_qname,
       com.sforce.soap.enterprise.wsc.SendEmailResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeTabSetResult[] describeTabs()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeTabs_element __request = new com.sforce.soap.enterprise.wsc.DescribeTabs_element();
    
    com.sforce.soap.enterprise.wsc.DescribeTabsResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeTabsResponse_element) __connection.send("",
       describeTabs_qname, __request, describeTabsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeTabsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.GetDeletedResult getDeleted(java.lang.String sObjectType,java.util.Calendar startDate,java.util.Calendar endDate)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.GetDeleted_element __request = new com.sforce.soap.enterprise.wsc.GetDeleted_element();
    
    com.sforce.soap.enterprise.wsc.GetDeletedResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setStartDate(startDate);
    __request.setEndDate(endDate);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.GetDeletedResponse_element) __connection.send("",
       getDeleted_qname, __request, getDeletedResponse_qname,
       com.sforce.soap.enterprise.wsc.GetDeletedResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.SaveResult[] update(com.sforce.soap.enterprise.sobject.wsc.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Update_element __request = new com.sforce.soap.enterprise.wsc.Update_element();
    
    com.sforce.soap.enterprise.wsc.UpdateResponse_element __response = null;

  
    __request.setSObjects(sObjects);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AssignmentRuleHeader != null) __connection.addHeader(AssignmentRuleHeader_qname, __AssignmentRuleHeader);
    
    if (__MruHeader != null) __connection.addHeader(MruHeader_qname, __MruHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    
    if (__OwnerChangeOptions != null) __connection.addHeader(OwnerChangeOptions_qname, __OwnerChangeOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.UpdateResponse_element) __connection.send("",
       update_qname, __request, updateResponse_qname,
       com.sforce.soap.enterprise.wsc.UpdateResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.LoginResult login(java.lang.String username,java.lang.String password)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Login_element __request = new com.sforce.soap.enterprise.wsc.Login_element();
    
    com.sforce.soap.enterprise.wsc.LoginResponse_element __response = null;

  
    __request.setUsername(username);
    __request.setPassword(password);

    
    if (__LoginScopeHeader != null) __connection.addHeader(LoginScopeHeader_qname, __LoginScopeHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.LoginResponse_element) __connection.send("",
       login_qname, __request, loginResponse_qname,
       com.sforce.soap.enterprise.wsc.LoginResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.QueryResult queryAll(java.lang.String queryString)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.QueryAll_element __request = new com.sforce.soap.enterprise.wsc.QueryAll_element();
    
    com.sforce.soap.enterprise.wsc.QueryAllResponse_element __response = null;

  
    __request.setQueryString(queryString);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.QueryAllResponse_element) __connection.send("",
       queryAll_qname, __request, queryAllResponse_qname,
       com.sforce.soap.enterprise.wsc.QueryAllResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DeleteResult[] delete(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Delete_element __request = new com.sforce.soap.enterprise.wsc.Delete_element();
    
    com.sforce.soap.enterprise.wsc.DeleteResponse_element __response = null;

  
    __request.setIds(ids);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__UserTerritoryDeleteHeader != null) __connection.addHeader(UserTerritoryDeleteHeader_qname, __UserTerritoryDeleteHeader);
    
    if (__EmailHeader != null) __connection.addHeader(EmailHeader_qname, __EmailHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__AllOrNoneHeader != null) __connection.addHeader(AllOrNoneHeader_qname, __AllOrNoneHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DeleteResponse_element) __connection.send("",
       delete_qname, __request, deleteResponse_qname,
       com.sforce.soap.enterprise.wsc.DeleteResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSoqlListViewResult describeSObjectListViews(java.lang.String sObjectType,boolean recentsOnly,com.sforce.soap.enterprise.wsc.ListViewIsSoqlCompatible isSoqlCompatible,int limit,int offset)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSObjectListViews_element __request = new com.sforce.soap.enterprise.wsc.DescribeSObjectListViews_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSObjectListViewsResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setRecentsOnly(recentsOnly);
    __request.setIsSoqlCompatible(isSoqlCompatible);
    __request.setLimit(limit);
    __request.setOffset(offset);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSObjectListViewsResponse_element) __connection.send("",
       describeSObjectListViews_qname, __request, describeSObjectListViewsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSObjectListViewsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.LeadConvertResult[] convertLead(com.sforce.soap.enterprise.wsc.LeadConvert[] leadConverts)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.ConvertLead_element __request = new com.sforce.soap.enterprise.wsc.ConvertLead_element();
    
    com.sforce.soap.enterprise.wsc.ConvertLeadResponse_element __response = null;

  
    __request.setLeadConverts(leadConverts);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.ConvertLeadResponse_element) __connection.send("",
       convertLead_qname, __request, convertLeadResponse_qname,
       com.sforce.soap.enterprise.wsc.ConvertLeadResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSoqlListViewResult describeSoqlListViews(com.sforce.soap.enterprise.wsc.DescribeSoqlListViewsRequest request)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSoqlListViews_element __request = new com.sforce.soap.enterprise.wsc.DescribeSoqlListViews_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSoqlListViewsResponse_element __response = null;

  
    __request.setRequest(request);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSoqlListViewsResponse_element) __connection.send("",
       describeSoqlListViews_qname, __request, describeSoqlListViewsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSoqlListViewsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.ChangeOwnPasswordResult changeOwnPassword(java.lang.String oldPassword,java.lang.String newPassword)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.ChangeOwnPassword_element __request = new com.sforce.soap.enterprise.wsc.ChangeOwnPassword_element();
    
    com.sforce.soap.enterprise.wsc.ChangeOwnPasswordResponse_element __response = null;

  
    __request.setOldPassword(oldPassword);
    __request.setNewPassword(newPassword);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.ChangeOwnPasswordResponse_element) __connection.send("",
       changeOwnPassword_qname, __request, changeOwnPasswordResponse_qname,
       com.sforce.soap.enterprise.wsc.ChangeOwnPasswordResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeCompactLayoutsResult describeCompactLayouts(java.lang.String sObjectType,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeCompactLayouts_element __request = new com.sforce.soap.enterprise.wsc.DescribeCompactLayouts_element();
    
    com.sforce.soap.enterprise.wsc.DescribeCompactLayoutsResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setRecordTypeIds(recordTypeIds);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeCompactLayoutsResponse_element) __connection.send("",
       describeCompactLayouts_qname, __request, describeCompactLayoutsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeCompactLayoutsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.EmptyRecycleBinResult[] emptyRecycleBin(java.lang.String[] ids)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.EmptyRecycleBin_element __request = new com.sforce.soap.enterprise.wsc.EmptyRecycleBin_element();
    
    com.sforce.soap.enterprise.wsc.EmptyRecycleBinResponse_element __response = null;

  
    __request.setIds(ids);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.EmptyRecycleBinResponse_element) __connection.send("",
       emptyRecycleBin_qname, __request, emptyRecycleBinResponse_qname,
       com.sforce.soap.enterprise.wsc.EmptyRecycleBinResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeApprovalLayoutResult describeApprovalLayout(java.lang.String sObjectType,java.lang.String[] approvalProcessNames)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeApprovalLayout_element __request = new com.sforce.soap.enterprise.wsc.DescribeApprovalLayout_element();
    
    com.sforce.soap.enterprise.wsc.DescribeApprovalLayoutResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setApprovalProcessNames(approvalProcessNames);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeApprovalLayoutResponse_element) __connection.send("",
       describeApprovalLayout_qname, __request, describeApprovalLayoutResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeApprovalLayoutResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeGlobalTheme describeGlobalTheme()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeGlobalTheme_element __request = new com.sforce.soap.enterprise.wsc.DescribeGlobalTheme_element();
    
    com.sforce.soap.enterprise.wsc.DescribeGlobalThemeResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeGlobalThemeResponse_element) __connection.send("",
       describeGlobalTheme_qname, __request, describeGlobalThemeResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeGlobalThemeResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.GetUserInfoResult getUserInfo()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.GetUserInfo_element __request = new com.sforce.soap.enterprise.wsc.GetUserInfo_element();
    
    com.sforce.soap.enterprise.wsc.GetUserInfoResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.GetUserInfoResponse_element) __connection.send("",
       getUserInfo_qname, __request, getUserInfoResponse_qname,
       com.sforce.soap.enterprise.wsc.GetUserInfoResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeAppMenuResult describeAppMenu(com.sforce.soap.enterprise.wsc.AppMenuType appMenuType,java.lang.String networkId)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeAppMenu_element __request = new com.sforce.soap.enterprise.wsc.DescribeAppMenu_element();
    
    com.sforce.soap.enterprise.wsc.DescribeAppMenuResponse_element __response = null;

  
    __request.setAppMenuType(appMenuType);
    __request.setNetworkId(networkId);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeAppMenuResponse_element) __connection.send("",
       describeAppMenu_qname, __request, describeAppMenuResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeAppMenuResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeLayoutResult describeLayout(java.lang.String sObjectType,java.lang.String layoutName,java.lang.String[] recordTypeIds)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeLayout_element __request = new com.sforce.soap.enterprise.wsc.DescribeLayout_element();
    
    com.sforce.soap.enterprise.wsc.DescribeLayoutResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);
    __request.setLayoutName(layoutName);
    __request.setRecordTypeIds(recordTypeIds);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeLayoutResponse_element) __connection.send("",
       describeLayout_qname, __request, describeLayoutResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeLayoutResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeSearchableEntityResult[] describeSearchableEntities(boolean includeOnlyEntitiesWithTabs)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeSearchableEntities_element __request = new com.sforce.soap.enterprise.wsc.DescribeSearchableEntities_element();
    
    com.sforce.soap.enterprise.wsc.DescribeSearchableEntitiesResponse_element __response = null;

  
    __request.setIncludeOnlyEntitiesWithTabs(includeOnlyEntitiesWithTabs);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeSearchableEntitiesResponse_element) __connection.send("",
       describeSearchableEntities_qname, __request, describeSearchableEntitiesResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeSearchableEntitiesResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeCompactLayout[] describePrimaryCompactLayouts(java.lang.String[] sObjectTypes)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribePrimaryCompactLayouts_element __request = new com.sforce.soap.enterprise.wsc.DescribePrimaryCompactLayouts_element();
    
    com.sforce.soap.enterprise.wsc.DescribePrimaryCompactLayoutsResponse_element __response = null;

  
    __request.setSObjectTypes(sObjectTypes);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribePrimaryCompactLayoutsResponse_element) __connection.send("",
       describePrimaryCompactLayouts_qname, __request, describePrimaryCompactLayoutsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribePrimaryCompactLayoutsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.QueryResult queryMore(java.lang.String queryLocator)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.QueryMore_element __request = new com.sforce.soap.enterprise.wsc.QueryMore_element();
    
    com.sforce.soap.enterprise.wsc.QueryMoreResponse_element __response = null;

  
    __request.setQueryLocator(queryLocator);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__QueryOptions != null) __connection.addHeader(QueryOptions_qname, __QueryOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.QueryMoreResponse_element) __connection.send("",
       queryMore_qname, __request, queryMoreResponse_qname,
       com.sforce.soap.enterprise.wsc.QueryMoreResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupStructureResult[] describeDataCategoryGroupStructures(com.sforce.soap.enterprise.wsc.DataCategoryGroupSobjectTypePair[] pairs,boolean topCategoriesOnly)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupStructures_element __request = new com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupStructures_element();
    
    com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupStructuresResponse_element __response = null;

  
    __request.setPairs(pairs);
    __request.setTopCategoriesOnly(topCategoriesOnly);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupStructuresResponse_element) __connection.send("",
       describeDataCategoryGroupStructures_qname, __request, describeDataCategoryGroupStructuresResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupStructuresResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeTab[] describeAllTabs()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeAllTabs_element __request = new com.sforce.soap.enterprise.wsc.DescribeAllTabs_element();
    
    com.sforce.soap.enterprise.wsc.DescribeAllTabsResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeAllTabsResponse_element) __connection.send("",
       describeAllTabs_qname, __request, describeAllTabsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeAllTabsResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeGlobalResult describeGlobal()
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeGlobal_element __request = new com.sforce.soap.enterprise.wsc.DescribeGlobal_element();
    
    com.sforce.soap.enterprise.wsc.DescribeGlobalResponse_element __response = null;

  

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeGlobalResponse_element) __connection.send("",
       describeGlobal_qname, __request, describeGlobalResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeGlobalResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.ProcessResult[] process(com.sforce.soap.enterprise.wsc.ProcessRequest[] actions)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.Process_element __request = new com.sforce.soap.enterprise.wsc.Process_element();
    
    com.sforce.soap.enterprise.wsc.ProcessResponse_element __response = null;

  
    __request.setActions(actions);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__AllowFieldTruncationHeader != null) __connection.addHeader(AllowFieldTruncationHeader_qname, __AllowFieldTruncationHeader);
    
    if (__DisableFeedTrackingHeader != null) __connection.addHeader(DisableFeedTrackingHeader_qname, __DisableFeedTrackingHeader);
    
    if (__StreamingEnabledHeader != null) __connection.addHeader(StreamingEnabledHeader_qname, __StreamingEnabledHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    
    if (__DebuggingHeader != null) __connection.addHeader(DebuggingHeader_qname, __DebuggingHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.ProcessResponse_element) __connection.send("",
       process_qname, __request, processResponse_qname,
       com.sforce.soap.enterprise.wsc.ProcessResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.FindDuplicatesResult[] findDuplicates(com.sforce.soap.enterprise.sobject.wsc.SObject[] sObjects)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.FindDuplicates_element __request = new com.sforce.soap.enterprise.wsc.FindDuplicates_element();
    
    com.sforce.soap.enterprise.wsc.FindDuplicatesResponse_element __response = null;

  
    __request.setSObjects(sObjects);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__DuplicateRuleHeader != null) __connection.addHeader(DuplicateRuleHeader_qname, __DuplicateRuleHeader);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.FindDuplicatesResponse_element) __connection.send("",
       findDuplicates_qname, __request, findDuplicatesResponse_qname,
       com.sforce.soap.enterprise.wsc.FindDuplicatesResponse_element.class);

    return __response.getResult();
  }
  
  public com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupResult[] describeDataCategoryGroups(java.lang.String[] sObjectType)
       throws com.sforce.ws.ConnectionException {
    com.sforce.ws.transport.SoapConnection __connection = newConnection();
    com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroups_element __request = new com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroups_element();
    
    com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupsResponse_element __response = null;

  
    __request.setSObjectType(sObjectType);

    
    if (__SessionHeader != null) __connection.addHeader(SessionHeader_qname, __SessionHeader);
    
    if (__PackageVersionHeader != null) __connection.addHeader(PackageVersionHeader_qname, __PackageVersionHeader);
    
    if (__LocaleOptions != null) __connection.addHeader(LocaleOptions_qname, __LocaleOptions);
    

    addHeaders(__connection);

    __response = (com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupsResponse_element) __connection.send("",
       describeDataCategoryGroups_qname, __request, describeDataCategoryGroupsResponse_qname,
       com.sforce.soap.enterprise.wsc.DescribeDataCategoryGroupsResponse_element.class);

    return __response.getResult();
  }
  


  private void addHeaders(com.sforce.ws.transport.SoapConnection __connection) {
    for(java.util.Map.Entry<QName, XMLizable> entry : __extraHeaders.entrySet()) {
      __connection.addHeader(entry.getKey(), entry.getValue());
    }
  }

  public void addExtraHeader(QName __headerName, XMLizable __value) {
    __extraHeaders.put(__headerName, __value);
  }

	public void removeExtraHeader(QName __headerName) {
		__extraHeaders.remove(__headerName);
	}

	public XMLizable getExtraHeader(QName __headerName) {
		return __extraHeaders.get(__headerName);
	}
	
	public void clearExtraHeaders() {
		__extraHeaders = new HashMap<QName, XMLizable>();
	}    private static final javax.xml.namespace.QName create_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "create");
    private static final javax.xml.namespace.QName createResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "createResponse");
    private static final javax.xml.namespace.QName describeSoftphoneLayout_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSoftphoneLayout");
    private static final javax.xml.namespace.QName describeSoftphoneLayoutResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSoftphoneLayoutResponse");
    private static final javax.xml.namespace.QName describeSearchScopeOrder_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSearchScopeOrder");
    private static final javax.xml.namespace.QName describeSearchScopeOrderResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSearchScopeOrderResponse");
    private static final javax.xml.namespace.QName logout_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "logout");
    private static final javax.xml.namespace.QName logoutResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "logoutResponse");
    private static final javax.xml.namespace.QName invalidateSessions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "invalidateSessions");
    private static final javax.xml.namespace.QName invalidateSessionsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "invalidateSessionsResponse");
    private static final javax.xml.namespace.QName describeSearchLayouts_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSearchLayouts");
    private static final javax.xml.namespace.QName describeSearchLayoutsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSearchLayoutsResponse");
    private static final javax.xml.namespace.QName merge_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "merge");
    private static final javax.xml.namespace.QName mergeResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "mergeResponse");
    private static final javax.xml.namespace.QName describeSObject_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSObject");
    private static final javax.xml.namespace.QName describeSObjectResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSObjectResponse");
    private static final javax.xml.namespace.QName setPassword_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "setPassword");
    private static final javax.xml.namespace.QName setPasswordResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "setPasswordResponse");
    private static final javax.xml.namespace.QName resetPassword_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "resetPassword");
    private static final javax.xml.namespace.QName resetPasswordResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "resetPasswordResponse");
    private static final javax.xml.namespace.QName retrieveQuickActionTemplates_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "retrieveQuickActionTemplates");
    private static final javax.xml.namespace.QName retrieveQuickActionTemplatesResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "retrieveQuickActionTemplatesResponse");
    private static final javax.xml.namespace.QName getServerTimestamp_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getServerTimestamp");
    private static final javax.xml.namespace.QName getServerTimestampResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getServerTimestampResponse");
    private static final javax.xml.namespace.QName undelete_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "undelete");
    private static final javax.xml.namespace.QName undeleteResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "undeleteResponse");
    private static final javax.xml.namespace.QName retrieve_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "retrieve");
    private static final javax.xml.namespace.QName retrieveResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "retrieveResponse");
    private static final javax.xml.namespace.QName describeKnowledgeSettings_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeKnowledgeSettings");
    private static final javax.xml.namespace.QName describeKnowledgeSettingsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeKnowledgeSettingsResponse");
    private static final javax.xml.namespace.QName executeListView_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "executeListView");
    private static final javax.xml.namespace.QName executeListViewResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "executeListViewResponse");
    private static final javax.xml.namespace.QName renderStoredEmailTemplate_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "renderStoredEmailTemplate");
    private static final javax.xml.namespace.QName renderStoredEmailTemplateResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "renderStoredEmailTemplateResponse");
    private static final javax.xml.namespace.QName describeVisualForce_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeVisualForce");
    private static final javax.xml.namespace.QName describeVisualForceResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeVisualForceResponse");
    private static final javax.xml.namespace.QName findDuplicatesByIds_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "findDuplicatesByIds");
    private static final javax.xml.namespace.QName findDuplicatesByIdsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "findDuplicatesByIdsResponse");
    private static final javax.xml.namespace.QName describeNouns_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeNouns");
    private static final javax.xml.namespace.QName describeNounsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeNounsResponse");
    private static final javax.xml.namespace.QName describeTheme_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeTheme");
    private static final javax.xml.namespace.QName describeThemeResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeThemeResponse");
    private static final javax.xml.namespace.QName upsert_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "upsert");
    private static final javax.xml.namespace.QName upsertResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "upsertResponse");
    private static final javax.xml.namespace.QName renderEmailTemplate_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "renderEmailTemplate");
    private static final javax.xml.namespace.QName renderEmailTemplateResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "renderEmailTemplateResponse");
    private static final javax.xml.namespace.QName sendEmailMessage_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "sendEmailMessage");
    private static final javax.xml.namespace.QName sendEmailMessageResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "sendEmailMessageResponse");
    private static final javax.xml.namespace.QName describeSObjects_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSObjects");
    private static final javax.xml.namespace.QName describeSObjectsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSObjectsResponse");
    private static final javax.xml.namespace.QName performQuickActions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "performQuickActions");
    private static final javax.xml.namespace.QName performQuickActionsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "performQuickActionsResponse");
    private static final javax.xml.namespace.QName describeQuickActions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeQuickActions");
    private static final javax.xml.namespace.QName describeQuickActionsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeQuickActionsResponse");
    private static final javax.xml.namespace.QName query_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "query");
    private static final javax.xml.namespace.QName queryResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "queryResponse");
    private static final javax.xml.namespace.QName describeAvailableQuickActions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeAvailableQuickActions");
    private static final javax.xml.namespace.QName describeAvailableQuickActionsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeAvailableQuickActionsResponse");
    private static final javax.xml.namespace.QName describePathAssistants_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describePathAssistants");
    private static final javax.xml.namespace.QName describePathAssistantsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describePathAssistantsResponse");
    private static final javax.xml.namespace.QName getUpdated_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getUpdated");
    private static final javax.xml.namespace.QName getUpdatedResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getUpdatedResponse");
    private static final javax.xml.namespace.QName search_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "search");
    private static final javax.xml.namespace.QName searchResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "searchResponse");
    private static final javax.xml.namespace.QName sendEmail_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "sendEmail");
    private static final javax.xml.namespace.QName sendEmailResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "sendEmailResponse");
    private static final javax.xml.namespace.QName describeTabs_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeTabs");
    private static final javax.xml.namespace.QName describeTabsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeTabsResponse");
    private static final javax.xml.namespace.QName getDeleted_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getDeleted");
    private static final javax.xml.namespace.QName getDeletedResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getDeletedResponse");
    private static final javax.xml.namespace.QName update_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "update");
    private static final javax.xml.namespace.QName updateResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "updateResponse");
    private static final javax.xml.namespace.QName login_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "login");
    private static final javax.xml.namespace.QName loginResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "loginResponse");
    private static final javax.xml.namespace.QName queryAll_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "queryAll");
    private static final javax.xml.namespace.QName queryAllResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "queryAllResponse");
    private static final javax.xml.namespace.QName delete_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "delete");
    private static final javax.xml.namespace.QName deleteResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "deleteResponse");
    private static final javax.xml.namespace.QName describeSObjectListViews_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSObjectListViews");
    private static final javax.xml.namespace.QName describeSObjectListViewsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSObjectListViewsResponse");
    private static final javax.xml.namespace.QName convertLead_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "convertLead");
    private static final javax.xml.namespace.QName convertLeadResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "convertLeadResponse");
    private static final javax.xml.namespace.QName describeSoqlListViews_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSoqlListViews");
    private static final javax.xml.namespace.QName describeSoqlListViewsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSoqlListViewsResponse");
    private static final javax.xml.namespace.QName changeOwnPassword_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "changeOwnPassword");
    private static final javax.xml.namespace.QName changeOwnPasswordResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "changeOwnPasswordResponse");
    private static final javax.xml.namespace.QName describeCompactLayouts_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeCompactLayouts");
    private static final javax.xml.namespace.QName describeCompactLayoutsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeCompactLayoutsResponse");
    private static final javax.xml.namespace.QName emptyRecycleBin_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "emptyRecycleBin");
    private static final javax.xml.namespace.QName emptyRecycleBinResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "emptyRecycleBinResponse");
    private static final javax.xml.namespace.QName describeApprovalLayout_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeApprovalLayout");
    private static final javax.xml.namespace.QName describeApprovalLayoutResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeApprovalLayoutResponse");
    private static final javax.xml.namespace.QName describeGlobalTheme_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeGlobalTheme");
    private static final javax.xml.namespace.QName describeGlobalThemeResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeGlobalThemeResponse");
    private static final javax.xml.namespace.QName getUserInfo_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getUserInfo");
    private static final javax.xml.namespace.QName getUserInfoResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "getUserInfoResponse");
    private static final javax.xml.namespace.QName describeAppMenu_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeAppMenu");
    private static final javax.xml.namespace.QName describeAppMenuResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeAppMenuResponse");
    private static final javax.xml.namespace.QName describeLayout_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeLayout");
    private static final javax.xml.namespace.QName describeLayoutResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeLayoutResponse");
    private static final javax.xml.namespace.QName describeSearchableEntities_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSearchableEntities");
    private static final javax.xml.namespace.QName describeSearchableEntitiesResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeSearchableEntitiesResponse");
    private static final javax.xml.namespace.QName describePrimaryCompactLayouts_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describePrimaryCompactLayouts");
    private static final javax.xml.namespace.QName describePrimaryCompactLayoutsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describePrimaryCompactLayoutsResponse");
    private static final javax.xml.namespace.QName queryMore_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "queryMore");
    private static final javax.xml.namespace.QName queryMoreResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "queryMoreResponse");
    private static final javax.xml.namespace.QName describeDataCategoryGroupStructures_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeDataCategoryGroupStructures");
    private static final javax.xml.namespace.QName describeDataCategoryGroupStructuresResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeDataCategoryGroupStructuresResponse");
    private static final javax.xml.namespace.QName describeAllTabs_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeAllTabs");
    private static final javax.xml.namespace.QName describeAllTabsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeAllTabsResponse");
    private static final javax.xml.namespace.QName describeGlobal_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeGlobal");
    private static final javax.xml.namespace.QName describeGlobalResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeGlobalResponse");
    private static final javax.xml.namespace.QName process_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "process");
    private static final javax.xml.namespace.QName processResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "processResponse");
    private static final javax.xml.namespace.QName findDuplicates_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "findDuplicates");
    private static final javax.xml.namespace.QName findDuplicatesResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "findDuplicatesResponse");
    private static final javax.xml.namespace.QName describeDataCategoryGroups_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeDataCategoryGroups");
    private static final javax.xml.namespace.QName describeDataCategoryGroupsResponse_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "describeDataCategoryGroupsResponse");
    private static final javax.xml.namespace.QName LoginScopeHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "LoginScopeHeader");
    private static final javax.xml.namespace.QName AllOrNoneHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "AllOrNoneHeader");
    private static final javax.xml.namespace.QName MruHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "MruHeader");
    private static final javax.xml.namespace.QName UserTerritoryDeleteHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "UserTerritoryDeleteHeader");
    private static final javax.xml.namespace.QName OwnerChangeOptions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "OwnerChangeOptions");
    private static final javax.xml.namespace.QName DuplicateRuleHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "DuplicateRuleHeader");
    private static final javax.xml.namespace.QName StreamingEnabledHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "StreamingEnabledHeader");
    private static final javax.xml.namespace.QName AllowFieldTruncationHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "AllowFieldTruncationHeader");
    private static final javax.xml.namespace.QName LimitInfoHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "LimitInfoHeader");
    private static final javax.xml.namespace.QName DebuggingInfo_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "DebuggingInfo");
    private static final javax.xml.namespace.QName AssignmentRuleHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "AssignmentRuleHeader");
    private static final javax.xml.namespace.QName DisableFeedTrackingHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "DisableFeedTrackingHeader");
    private static final javax.xml.namespace.QName LocaleOptions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "LocaleOptions");
    private static final javax.xml.namespace.QName DebuggingHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "DebuggingHeader");
    private static final javax.xml.namespace.QName PackageVersionHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "PackageVersionHeader");
    private static final javax.xml.namespace.QName SessionHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "SessionHeader");
    private static final javax.xml.namespace.QName QueryOptions_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "QueryOptions");
    private static final javax.xml.namespace.QName EmailHeader_qname = new javax.xml.namespace.QName("urn:enterprise.soap.sforce.com", "EmailHeader");


  private static final HashMap<QName, java.lang.Class<?>> knownHeaders = new HashMap<QName, java.lang.Class<?>>();

  static {  knownHeaders.put(LoginScopeHeader_qname,com.sforce.soap.enterprise.wsc.LoginScopeHeader_element.class);
  knownHeaders.put(AllOrNoneHeader_qname,com.sforce.soap.enterprise.wsc.AllOrNoneHeader_element.class);
  knownHeaders.put(MruHeader_qname,com.sforce.soap.enterprise.wsc.MruHeader_element.class);
  knownHeaders.put(UserTerritoryDeleteHeader_qname,com.sforce.soap.enterprise.wsc.UserTerritoryDeleteHeader_element.class);
  knownHeaders.put(OwnerChangeOptions_qname,com.sforce.soap.enterprise.wsc.OwnerChangeOptions_element.class);
  knownHeaders.put(DuplicateRuleHeader_qname,com.sforce.soap.enterprise.wsc.DuplicateRuleHeader_element.class);
  knownHeaders.put(StreamingEnabledHeader_qname,com.sforce.soap.enterprise.wsc.StreamingEnabledHeader_element.class);
  knownHeaders.put(AllowFieldTruncationHeader_qname,com.sforce.soap.enterprise.wsc.AllowFieldTruncationHeader_element.class);
  knownHeaders.put(LimitInfoHeader_qname,com.sforce.soap.enterprise.wsc.LimitInfoHeader_element.class);
  knownHeaders.put(DebuggingInfo_qname,com.sforce.soap.enterprise.wsc.DebuggingInfo_element.class);
  knownHeaders.put(AssignmentRuleHeader_qname,com.sforce.soap.enterprise.wsc.AssignmentRuleHeader_element.class);
  knownHeaders.put(DisableFeedTrackingHeader_qname,com.sforce.soap.enterprise.wsc.DisableFeedTrackingHeader_element.class);
  knownHeaders.put(LocaleOptions_qname,com.sforce.soap.enterprise.wsc.LocaleOptions_element.class);
  knownHeaders.put(DebuggingHeader_qname,com.sforce.soap.enterprise.wsc.DebuggingHeader_element.class);
  knownHeaders.put(PackageVersionHeader_qname,com.sforce.soap.enterprise.wsc.PackageVersionHeader_element.class);
  knownHeaders.put(SessionHeader_qname,com.sforce.soap.enterprise.wsc.SessionHeader_element.class);
  knownHeaders.put(QueryOptions_qname,com.sforce.soap.enterprise.wsc.QueryOptions_element.class);
  knownHeaders.put(EmailHeader_qname,com.sforce.soap.enterprise.wsc.EmailHeader_element.class);

  }
}