/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.shim;

import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.eclipse.sisu.locators.EntryListAdapter;
import org.eclipse.sisu.locators.EntryMapAdapter;
import org.eclipse.sisu.plexus.binders.PlexusBeanManager;
import org.eclipse.sisu.plexus.config.Hints;
import org.eclipse.sisu.plexus.config.PlexusBean;
import org.eclipse.sisu.plexus.config.PlexusBeanLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
final class PseudoPlexusContainer
implements PlexusContainer {
    final PlexusBeanLocator locator;
    final PlexusBeanManager manager;
    final Context context;

    @Inject
    PseudoPlexusContainer(PlexusBeanLocator locator, PlexusBeanManager manager, Context context) {
        this.locator = locator;
        this.manager = manager;
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Object lookup(String role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public Object lookup(String role, String hint) throws ComponentLookupException {
        return this.lookup(null, role, hint);
    }

    @Override
    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    @Override
    public <T> T lookup(Class<T> type, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type, hint).iterator().next().getValue();
        }
        catch (RuntimeException e) {
            throw new ComponentLookupException(e, null != role ? role : type.getName(), hint);
        }
    }

    @Override
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return new EntryMapAdapter(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        return new EntryMapAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public boolean hasComponent(String role) {
        return this.hasComponent(role, "");
    }

    @Override
    public boolean hasComponent(String role, String hint) {
        return this.hasComponent((Class)null, role, hint);
    }

    public boolean hasComponent(Class role) {
        return this.hasComponent(role, "");
    }

    public boolean hasComponent(Class role, String hint) {
        return this.hasComponent(role, (String)null, hint);
    }

    public boolean hasComponent(Class type, String role, String hint) {
        return PseudoPlexusContainer.hasPlexusBeans(this.locate(role, type, hint));
    }

    @Override
    public void addComponent(Object component, String role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void addComponent(T component, Class<?> role, String hint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void addComponentDescriptor(ComponentDescriptor<T> descriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role, String hint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String hint) {
        throw new UnsupportedOperationException();
    }

    public List getComponentDescriptorList(String role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        throw new UnsupportedOperationException();
    }

    public Map getComponentDescriptorMap(String role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassRealm getContainerRealm() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassRealm setLookupRealm(ClassRealm realm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassRealm getLookupRealm() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void release(Object component) {
        this.manager.unmanage(component);
    }

    @Override
    public void releaseAll(Map<String, ?> components) {
        for (Object o : components.values()) {
            this.release(o);
        }
    }

    @Override
    public void releaseAll(List<?> components) {
        for (Object o : components) {
            this.release(o);
        }
    }

    @Override
    public void dispose() {
        this.manager.unmanage();
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type, String ... hints) {
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (null == role || null != type && type.getName().equals(role)) {
            return this.locator.locate(TypeLiteral.get(type), canonicalHints);
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(role);
            Iterable beans = this.locator.locate(TypeLiteral.get(clazz), canonicalHints);
            if (PseudoPlexusContainer.hasPlexusBeans(beans)) {
                return beans;
            }
        }
        catch (Exception e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        return Collections.EMPTY_SET;
    }

    private static <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }
}

