/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import com.mestrelab.components.shared.TElement;
import com.mestrelab.components.shared.TIsotope;
import com.mestrelab.components.shared.TPeriodicTable;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.Element4SymbolVO;
import com.mestrelab.components.shared.util.ParserVO;
import com.mestrelab.components.shared.util.TFormulaParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilMolFormula {
    public static void splitIsotope(QString aSymbol, QString aElement, QString aIsoMassNumber) {
        aIsoMassNumber.clear();
        aElement.clear();
        int i = 0;
        char c = (char)aSymbol.getChars()[i];
        while (Character.isDigit(c)) {
            aIsoMassNumber.append(Character.toString(c));
            c = (char)aSymbol.getChars()[++i];
        }
        while (i < aSymbol.size()) {
            aElement.append(Character.toString((char)aSymbol.getChars()[i]));
            ++i;
        }
    }

    public static Element4SymbolVO element4Symbol(QString aSymbol, TElement aElement) {
        return UtilMolFormula.element4Symbol(aSymbol, aElement, null);
    }

    public static Element4SymbolVO element4Symbol(QString aSymbol, TElement aElement, TIsotope aIsotopePtr) {
        if (aIsotopePtr != null) {
            aIsotopePtr = null;
        }
        QString isotope = new QString("");
        QString atom = new QString("");
        UtilMolFormula.splitIsotope(aSymbol, atom, isotope);
        if (atom.isEmpty()) {
            return new Element4SymbolVO(aElement, aIsotopePtr, false);
        }
        int massNumber = 0;
        if (!isotope.isEmpty() && (massNumber = isotope.toInt()) == Integer.MIN_VALUE) {
            return new Element4SymbolVO(aElement, aIsotopePtr, false);
        }
        aElement = TPeriodicTable.getInstance().operatorElementSymbol(atom);
        if (aElement != null && !isotope.isEmpty()) {
            if (massNumber <= 0) {
                return new Element4SymbolVO(aElement, aIsotopePtr, false);
            }
            for (int i = 0; i < aElement.getfIsotopes().getfCount(); ++i) {
                TIsotope curIso = aElement.getfIsotopes().getfArray()[i];
                if (curIso.getfMassNumber() != massNumber) continue;
                if (aIsotopePtr != null) {
                    aIsotopePtr = curIso;
                }
                return new Element4SymbolVO(aElement, aIsotopePtr, true);
            }
            return new Element4SymbolVO(aElement, aIsotopePtr, false);
        }
        return new Element4SymbolVO(aElement, aIsotopePtr, true);
    }

    public static ParserVO validateElementsMap(QMap<QString, Integer> aElements, int aCharge) {
        for (QString key : aElements.keys()) {
            TElement pEl = new TElement();
            Element4SymbolVO vo = UtilMolFormula.element4Symbol(key, pEl);
            pEl = vo.fElement;
            if (vo.result && pEl.getfAtomicNumber() != 0) continue;
            return new ParserVO(aElements, aCharge, false);
        }
        return new ParserVO(aElements, aCharge, true);
    }

    public static boolean validateSyntax(QString aFormula, boolean aAllowCharge) {
        if (aFormula.isEmpty()) {
            return false;
        }
        QMap<QString, Integer> elements = new QMap<QString, Integer>();
        int charge = 0;
        return UtilMolFormula.parse((QString)aFormula, elements, (int)(aAllowCharge ? charge : 0), (boolean)true).result;
    }

    public static double elementsMapMass(QMap<QString, Integer> aElements, boolean aAverage) {
        double mass = 0.0;
        for (QString el : aElements.keys()) {
            TIsotope pIso = null;
            TElement pEl = new TElement();
            Element4SymbolVO vo = UtilMolFormula.element4Symbol(el, pEl, pIso);
            pEl = vo.fElement;
            pIso = vo.fIsotope;
            if (!vo.result) continue;
            double n = aElements.find(el).intValue();
            if (aAverage) {
                mass += n * pEl.getfAverageMass();
                continue;
            }
            if (pIso != null) {
                mass += n * pIso.getfMass();
                continue;
            }
            mass += n * pEl.getfMonoisotopicMass();
        }
        return mass;
    }

    public static double molecularMass(QString aFormula, boolean aAverage) {
        QMap<QString, Integer> elements = new QMap<QString, Integer>();
        ParserVO vo = UtilMolFormula.parse(aFormula, elements);
        elements = vo.fElements;
        if (!vo.result) {
            return 0.0;
        }
        return UtilMolFormula.elementsMapMass(elements, aAverage);
    }

    public static ParserVO parse(QString aFormula, QMap<QString, Integer> aElements) {
        return UtilMolFormula.parse(aFormula, aElements, 0, false);
    }

    public static ParserVO parse(QString aFormula, QMap<QString, Integer> aElements, int aCharge, boolean aValidate) {
        TFormulaParser ctx = new TFormulaParser(aFormula);
        if (!ctx.parse(aCharge != 0)) {
            return new ParserVO(aElements, aCharge, false);
        }
        aElements = ctx.fElements;
        if (aCharge != 0) {
            aCharge = ctx.fCharge;
        }
        if (!aValidate) {
            return new ParserVO(aElements, aCharge, true);
        }
        return UtilMolFormula.validateElementsMap(ctx.fElements, aCharge);
    }

    public static QString htmlFormula(QString aFormula, boolean aAllowCharge) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static QString normalize(QString aFormula, QMap<QString, Integer> aMap) throws Exception {
        throw new Exception("Method not implemented");
    }
}

