/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import com.mestrelab.components.client.moleditor.constants.Canvas;
import com.mestrelab.components.shared.qt.QLineF;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMatrix;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRect;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.Units;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilGeometry
implements Serializable {
    public static double pi = Math.PI;
    public static double piHalf = 1.5707963267948966;
    public static double piQuarter = 0.7853981633974483;
    public static double piDouble = Math.PI * 2;

    public static QMatrix rect2Rect(QRectF aSource, QRectF aDest) {
        double sourceWidth = aSource.width() - 1.0;
        double sourceHeight = aSource.height() - 1.0;
        double sX = (aDest.width() - 1.0) / (sourceWidth != 0.0 ? sourceWidth : 1.0);
        double sY = (aDest.height() - 1.0) / (sourceHeight != 0.0 ? sourceHeight : 1.0);
        return new QMatrix(sX, 0.0, 0.0, sY, aDest.x() - aSource.x() * sX, aDest.y() - aSource.y() * sY);
    }

    public static QMatrix rect2Rect(QRect aSource, QRect aDest) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static QMatrix rect2RectQt(QRect aSource, QRect aDest) {
        double sourceWidth = aSource.width();
        double sourceHeight = aSource.height();
        double sX = (double)aDest.width() / (sourceWidth != 0.0 ? sourceWidth : 1.0);
        double sY = (double)aDest.height() / (sourceHeight != 0.0 ? sourceHeight : 1.0);
        return new QMatrix(sX, 0.0, 0.0, sY, (double)aDest.x() - (double)aSource.x() * sX, (double)aDest.y() - (double)aSource.y() * sY);
    }

    public static QMatrix rect2RectQt(QRectF aSource, QRectF aDest) {
        double sourceWidth = aSource.width();
        double sourceHeight = aSource.height();
        double sX = aDest.width() / (sourceWidth != 0.0 ? sourceWidth : 1.0);
        double sY = aDest.height() / (sourceHeight != 0.0 ? sourceHeight : 1.0);
        return new QMatrix(sX, 0.0, 0.0, sY, aDest.x() - aSource.x() * sX, aDest.y() - aSource.y() * sY);
    }

    public void range2Range(double aSrcFrom, double aSrcTo, double aDestFrom, double aDestTo, double aShift, double aScale) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static QRectF getRectAspectRatioKeepWidth(QRectF aOriginalRect, QRectF aAspectRatioRect) {
        QRectF result = new QRectF(aOriginalRect);
        result.setHeight(aOriginalRect.width() * aAspectRatioRect.height() / aAspectRatioRect.width());
        return result;
    }

    public static QRectF getRectAspectRatioKeepHeight(QRectF aOriginalRect, QRectF aAspectRatioRect) {
        QRectF result = new QRectF(aOriginalRect);
        result.setWidth(aOriginalRect.height() * aAspectRatioRect.width() / aAspectRatioRect.height());
        return result;
    }

    public static QRectF getRectAspectRatio(QRectF aOriginRect, QRectF aDestinationRect) {
        if (Math.abs(aDestinationRect.width() / aOriginRect.width()) <= Math.abs(aDestinationRect.height() / aOriginRect.height())) {
            return UtilGeometry.getRectAspectRatioKeepWidth(aOriginRect, aDestinationRect);
        }
        return UtilGeometry.getRectAspectRatioKeepHeight(aOriginRect, aDestinationRect);
    }

    public static QRectF getRectAspectRatioInside(QRectF aRect, QRectF aContainerRect) {
        if (Math.abs(aContainerRect.width() / aRect.width()) <= Math.abs(aContainerRect.height() / aRect.height())) {
            return UtilGeometry.getRectAspectRatioKeepWidth(aContainerRect, aRect);
        }
        return UtilGeometry.getRectAspectRatioKeepHeight(aContainerRect, aRect);
    }

    public QMatrix rect2RectQt(QRectF aOriginRect, QPoint<Double> aDestinationPoint, QPoint<Double> aCommonPoint, boolean keepAspectRatio) {
        QRectF destination = new QRectF();
        if (aCommonPoint == aOriginRect.bottomRight()) {
            destination.setBottomRight(aCommonPoint);
            destination.setTopLeft(aDestinationPoint);
            if (keepAspectRatio) {
                destination = UtilGeometry.getRectAspectRatio(destination, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - destination.bottomRight().x());
                result.setY(aCommonPoint.y() - destination.bottomRight().y());
                destination.translate(result);
            }
        } else if (aCommonPoint == aOriginRect.topRight()) {
            destination.setTopRight(aCommonPoint);
            destination.setBottomLeft(aDestinationPoint);
            if (keepAspectRatio) {
                destination = UtilGeometry.getRectAspectRatio(destination, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - destination.topRight().x());
                result.setY(aCommonPoint.y() - destination.topRight().y());
                destination.translate(result);
            }
        } else if (aCommonPoint == aOriginRect.topLeft()) {
            destination.setTopLeft(aCommonPoint);
            destination.setBottomRight(aDestinationPoint);
            if (keepAspectRatio) {
                destination = UtilGeometry.getRectAspectRatio(destination, aOriginRect);
            }
        } else if (aCommonPoint == aOriginRect.bottomLeft()) {
            destination.setBottomLeft(aCommonPoint);
            destination.setTopRight(aDestinationPoint);
            if (keepAspectRatio) {
                destination = UtilGeometry.getRectAspectRatio(destination, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - destination.bottomLeft().x());
                result.setY(aCommonPoint.y() - destination.bottomLeft().y());
                destination.translate(result);
            }
        } else {
            return new QMatrix();
        }
        return UtilGeometry.rect2RectQt(aOriginRect, destination);
    }

    public QMatrix rect2RectQtMidPoint(QRectF aOriginRect, QPoint<Double> aDestinationPoint, QPoint<Double> aCommonPoint, boolean keepAspectRatio) {
        QRectF destinationRect = null;
        if (aCommonPoint.y().doubleValue() == aOriginRect.top()) {
            destinationRect.setTopLeft(aOriginRect.topLeft());
            destinationRect.setBottomRight(new QPoint<Double>(aOriginRect.right(), aDestinationPoint.y()));
            if (keepAspectRatio) {
                destinationRect = UtilGeometry.getRectAspectRatioKeepHeight(destinationRect, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - new QPoint<Double>(destinationRect.center().x(), destinationRect.y()).x());
                result.setY(aCommonPoint.y() - new QPoint<Double>(destinationRect.center().x(), destinationRect.y()).y());
                destinationRect.translate(result);
            }
        } else if (aCommonPoint.x().doubleValue() == aOriginRect.right()) {
            destinationRect.setTopLeft(new QPoint<Double>(aDestinationPoint.x(), aOriginRect.y()));
            destinationRect.setBottomRight(aOriginRect.bottomRight());
            if (keepAspectRatio) {
                destinationRect = UtilGeometry.getRectAspectRatioKeepWidth(destinationRect, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - new QPoint<Double>(destinationRect.right(), destinationRect.center().y()).x());
                result.setY(aCommonPoint.y() - new QPoint<Double>(destinationRect.right(), destinationRect.center().y()).y());
                destinationRect.translate(result);
            }
        } else if (aCommonPoint.y().doubleValue() == aOriginRect.bottom()) {
            destinationRect.setTopLeft(new QPoint<Double>(aOriginRect.x(), aDestinationPoint.y()));
            destinationRect.setBottomRight(aOriginRect.bottomRight());
            if (keepAspectRatio) {
                destinationRect = UtilGeometry.getRectAspectRatioKeepHeight(destinationRect, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - new QPoint<Double>(destinationRect.center().x(), destinationRect.bottom()).x());
                result.setY(aCommonPoint.y() - new QPoint<Double>(destinationRect.center().x(), destinationRect.bottom()).y());
                destinationRect.translate(result);
            }
        } else if (aCommonPoint.x().doubleValue() == aOriginRect.left()) {
            destinationRect.setTopRight(new QPoint<Double>(aDestinationPoint.x(), aOriginRect.top()));
            destinationRect.setBottomLeft(aOriginRect.bottomLeft());
            if (keepAspectRatio) {
                destinationRect = UtilGeometry.getRectAspectRatioKeepWidth(destinationRect, aOriginRect);
                QPoint<Double> result = new QPoint<Double>();
                result.setX(aCommonPoint.x() - new QPoint<Double>(destinationRect.x(), destinationRect.center().y()).x());
                result.setY(aCommonPoint.y() - new QPoint<Double>(destinationRect.x(), destinationRect.center().y()).y());
                destinationRect.translate(result);
            }
        } else {
            return new QMatrix();
        }
        return UtilGeometry.rect2RectQt(aOriginRect, destinationRect);
    }

    public static QMatrix rotate(QPoint<Double> aPivot, double aAngleInRadians) {
        QMatrix m = new QMatrix();
        m.translate(aPivot.x(), aPivot.y());
        m.rotate(UtilGeometry.rad2Deg(aAngleInRadians));
        m.translate(-aPivot.x().doubleValue(), -aPivot.y().doubleValue());
        return m;
    }

    public static double rad2Deg(double angle) {
        return angle * 180.0 / pi;
    }

    public static double deg2Rad(double angle) {
        return angle * pi / 180.0;
    }

    public static double distance(QPoint<Double> pt1, QPoint<Double> pt2) {
        return Math.sqrt(Math.pow(pt2.x() - pt1.x(), 2.0) + Math.pow(pt2.y() - pt1.y(), 2.0));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static QRect unite(QList<QRect> aList) {
        if (aList.count() == 0) {
            return new QRect();
        }
        QRect result = new QRect();
        for (QRect i : aList) {
            result = result.unite(i);
        }
        return result;
    }

    public static QRectF intersect(QRectF aRc1, QRectF aRc2) {
        if (aRc1.isNull() || aRc2.isNull()) {
            return new QRectF();
        }
        QRectF r1 = aRc1.normalized();
        QRectF r2 = aRc2.normalized();
        QRectF tmp = new QRectF();
        tmp.setLeft(Math.max(r1.left(), r2.left()));
        tmp.setTop(Math.max(r1.top(), r2.top()));
        tmp.setRight(Math.min(r1.right(), r2.right()));
        tmp.setBottom(Math.min(r1.bottom(), r2.bottom()));
        if (tmp.height() < 0.0 || tmp.width() < 0.0) {
            return new QRectF();
        }
        return tmp;
    }

    public static double twips2MM(double aTwips) {
        return aTwips * Canvas.mmPerInch / 1440.0;
    }

    public static double MM2Twips(double aMM) {
        return aMM * 1440.0 / Canvas.mmPerInch;
    }

    public static int upperPowerOf2(int aValue) {
        --aValue;
        for (int i = 1; i < 32; i <<= 1) {
            aValue |= aValue >> i;
        }
        return aValue + 1;
    }

    public static int lowerPowerOf2(int aValue) {
        int pow;
        for (pow = 1; pow < aValue; pow *= 2) {
        }
        return pow - 1;
    }

    public static int nearestPowerOf2(int aValue) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static boolean isPowerOf2(int n) {
        return (n & n - 1) != 0;
    }

    public static boolean diffLineRect(QPoint<Double> aPt1, QPoint<Double> aPt2, QRectF aRectF) {
        QLineF theLine = new QLineF(aPt1, aPt2);
        QPoint<Double> iPt = new QPoint<Double>(new Double(-0.0), new Double(0.0));
        int cutMode = 0;
        boolean vInside = false;
        boolean hInside = false;
        boolean is1stOut = false;
        QPoint<Double> outPt = new QPoint<Double>(aPt2.x(), aPt2.y());
        if (aRectF.contains(aPt2)) {
            outPt.setX(aPt1.x());
            outPt.setY(aPt1.y());
            is1stOut = true;
        }
        if (outPt.y() < aRectF.top()) {
            QLineF topL = new QLineF(aRectF.topLeft(), aRectF.topRight());
            if (theLine.intersect(topL, iPt) == QLineF.IntersectType.BoundedIntersection) {
                if (is1stOut) {
                    aPt2.setX(iPt.x());
                    aPt2.setY(iPt.y());
                } else {
                    aPt1.setX(iPt.x());
                    aPt1.setY(iPt.y());
                }
                cutMode = 1;
            }
        } else if (outPt.y() > aRectF.bottom()) {
            QLineF botL = new QLineF(aRectF.bottomLeft(), aRectF.bottomRight());
            if (theLine.intersect(botL, iPt) == QLineF.IntersectType.BoundedIntersection) {
                if (is1stOut) {
                    aPt2.setX(iPt.x());
                    aPt2.setY(iPt.y());
                } else {
                    aPt1.setX(iPt.x());
                    aPt1.setY(iPt.y());
                }
                cutMode = 2;
            }
        } else {
            vInside = true;
        }
        if (outPt.x() < aRectF.left()) {
            QLineF leftL = new QLineF(aRectF.topLeft(), aRectF.bottomLeft());
            if (theLine.intersect(leftL, iPt) == QLineF.IntersectType.BoundedIntersection) {
                if (is1stOut) {
                    aPt2.setX(iPt.x());
                    aPt2.setY(iPt.y());
                } else {
                    aPt1.setX(iPt.x());
                    aPt1.setY(iPt.y());
                }
                cutMode |= 4;
            }
        } else if (outPt.x() > aRectF.right()) {
            QLineF rightL = new QLineF(aRectF.topRight(), aRectF.bottomRight());
            if (theLine.intersect(rightL, iPt) == QLineF.IntersectType.BoundedIntersection) {
                if (is1stOut) {
                    aPt2.setX(iPt.x());
                    aPt2.setY(iPt.y());
                } else {
                    aPt1.setX(iPt.x());
                    aPt1.setY(iPt.y());
                }
                cutMode |= 8;
            }
        } else {
            hInside = true;
        }
        if (vInside && hInside) {
            return false;
        }
        return cutMode != 0;
    }

    public static double valueToUnits(double aValue, Units aFrom, Units aTo) {
        switch (aFrom) {
            case uDots: {
                return UtilGeometry.Dots2Unit(aValue, aTo);
            }
            case uMM: {
                return UtilGeometry.MM2Unit(aValue, aTo);
            }
            case uInches: {
                return UtilGeometry.Inch2Unit(aValue, aTo);
            }
        }
        return 0.0;
    }

    public static double MM2Unit(double aValue, Units aTo) {
        switch (aTo) {
            case uDots: {
                return UtilGeometry.MM2Dots(aValue);
            }
            case uMM: {
                return aValue;
            }
            case uInches: {
                return UtilGeometry.MM2Inch(aValue);
            }
        }
        return 0.0;
    }

    public static double Inch2Unit(double aValue, Units aTo) {
        switch (aTo) {
            case uDots: {
                return UtilGeometry.Inch2Dots(aValue);
            }
            case uMM: {
                return UtilGeometry.Inch2MM(aValue);
            }
            case uInches: {
                return aValue;
            }
        }
        return 0.0;
    }

    public static double Dots2Unit(double aValue, Units aTo) {
        switch (aTo) {
            case uDots: {
                return aValue;
            }
            case uMM: {
                return UtilGeometry.Dots2MM(aValue);
            }
            case uInches: {
                return UtilGeometry.Dots2Inch(aValue);
            }
        }
        return 0.0;
    }

    public static double MM2Inch(double aMM) {
        return aMM / Canvas.mmPerInch;
    }

    public static double Inch2MM(double aInch) {
        return aInch * Canvas.mmPerInch;
    }

    public static double MM2Dots(double aMM) {
        return aMM * Canvas.mmPerInch;
    }

    public static QPoint<Double> MM2Dots(QPoint<Double> aPoint) {
        QPoint<Double> result = new QPoint<Double>();
        result.setX(aPoint.x() * Canvas.dotsPerMm);
        result.setY(aPoint.y() * Canvas.dotsPerMm);
        return result;
    }

    public static double Dots2MM(double aDots) {
        return aDots / Canvas.dotsPerMm;
    }

    public static QPoint<Double> Dots2MM(QPoint<Double> aPoint) {
        QPoint<Double> result = new QPoint<Double>();
        result.setX(aPoint.x() / Canvas.dotsPerMm);
        result.setY(aPoint.y() / Canvas.dotsPerMm);
        return result;
    }

    public static double Inch2Dots(double aInch) {
        return aInch * Canvas.dotsPerInch;
    }

    public static double Dots2Inch(double aDots) {
        return aDots / Canvas.dotsPerInch;
    }

    public static boolean clipPointToRect(QRectF aRect, QPoint<Double> aPt) {
        boolean ret = true;
        if (aPt.x() > aRect.right()) {
            aPt.setX(aRect.right());
            ret = false;
        } else if (aPt.x() < aRect.left()) {
            aPt.setX(aRect.left());
            ret = false;
        }
        if (aPt.y() > aRect.bottom()) {
            aPt.setY(aRect.bottom());
            ret = false;
        } else if (aPt.y() < aRect.top()) {
            aPt.setY(aRect.top());
            ret = false;
        }
        return ret;
    }

    public static void generateEllipseMask(QVector<Double> vMask, int nRows, int nCols, boolean fuzzy) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static int toPerCent(double aValue, double aMax) {
        return (int)Math.round(aValue * 100.0 / aMax);
    }

    public static double fromPerCent(int aValue, double aMax) {
        return (double)aValue * aMax / 100.0;
    }

    public static double twips2Dots(double aTwips) {
        return Canvas.dotsPerMm * UtilGeometry.twips2MM(aTwips);
    }

    public static QRectF twips2Dots(QRectF aRect) {
        QRectF rect = new QRectF();
        rect.setLeft(UtilGeometry.twips2Dots(aRect.left()));
        rect.setRight(UtilGeometry.twips2Dots(aRect.right()));
        rect.setTop(-UtilGeometry.twips2Dots(aRect.top()));
        rect.setBottom(-UtilGeometry.twips2Dots(aRect.bottom()));
        return rect;
    }

    public static double dots2Twips(double aDots) {
        return UtilGeometry.MM2Twips(aDots / Canvas.dotsPerMm);
    }

    public static QRectF dots2Twips(QRectF aRect) {
        QRectF rect = new QRectF();
        rect.setLeft(UtilGeometry.dots2Twips(aRect.left()));
        rect.setRight(UtilGeometry.dots2Twips(aRect.right()));
        rect.setTop(-UtilGeometry.dots2Twips(aRect.top()));
        rect.setBottom(-UtilGeometry.dots2Twips(aRect.bottom()));
        return rect;
    }

    public static double round(double aValue, int aPrecision) {
        double prec = Math.pow(10.0, aPrecision);
        return (double)Math.round(aValue * prec) / prec;
    }

    public static int compareToRange(double aValue, double aFrom, double aTo) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static double minimumDistance(double aValue, double aFrom, double aTo) {
        return Math.min(Math.abs(aValue - aFrom), Math.abs(aValue - aTo));
    }

    public static double minimumDistance(double aFrom1, double aTo1, double aFrom2, double aTo2) {
        return Math.min(UtilGeometry.minimumDistance(aFrom1, aFrom2, aTo2), UtilGeometry.minimumDistance(aTo1, aFrom2, aTo2));
    }

    public static int intersects(double aFromValue1, double aToValue1, double aFromValue2, double aToValue2) throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean fitRangeToRange(double aFromValue, double aToValue, double aRangeFrom, double aRangeTo) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static double gauss2D(double aHeight, double aX, double aY, double aX0, double aY0, double aSigmaX, double aSigmaY) {
        double f = 2.772588722239781;
        double x = (aX - aX0) / aSigmaX;
        x *= x;
        double y = (aY - aY0) / aSigmaY;
        y *= y;
        double g = Math.exp(-f * (x + y));
        return g;
    }

    public static QLineF normalLineStartingAtPos(QLineF aLine, QPoint<Double> aPos) {
        QLineF lineToMouse = new QLineF(aLine.p1(), aPos);
        double angle = aLine.angle(lineToMouse);
        QLineF newLine = new QLineF(aLine);
        newLine.setLength(lineToMouse.length() * Math.cos(UtilGeometry.deg2Rad(angle)));
        QLineF lineFromMouse = new QLineF(aPos, newLine.p2());
        lineFromMouse.setLength(lineFromMouse.length() + 1.0);
        return lineFromMouse;
    }

    public static int precision2NumberOfDecimals(double aPrec) {
        double logVal = Math.log10(aPrec);
        if (logVal >= 0.0) {
            return 0;
        }
        return (int)Math.round(Math.abs(logVal) + 0.4999999);
    }

    public static QPoint<Double> ellipseFocus(QRectF aEllipseRect) throws Exception {
        throw new Exception("Method not implemented");
    }

    public static QPolygonF polyStar5(QRectF aRect) {
        double[] xFactors = new double[]{0.5, 0.6328125, 1.0, 0.71609375, 0.808984375, 0.5, 0.191015625, 0.28390625, 0.0, 0.3671875};
        double[] yFactors = new double[]{0.0, 0.35984375, 0.381640625, 0.626171875, 0.999140625, 0.79171875, 0.999140625, 0.62578125, 0.381640625, 0.35984375};
        QPolygonF star = new QPolygonF(10);
        double w = aRect.width();
        double h = aRect.height();
        QPoint<Double> org = aRect.topLeft();
        QPoint<Double> cur = new QPoint<Double>();
        for (int i = 0; i < 10; ++i) {
            cur = new QPoint();
            cur.setX(org.x() + xFactors[i] * w);
            cur.setY(org.y() + yFactors[i] * h);
            star.append(cur);
        }
        return star;
    }
}

