/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.UtilMolFormula;

public class TMFElement {
    public int fCount;
    public QString fElement;

    public TMFElement() {
        this.fCount = 0;
        this.fElement = new QString();
    }

    public TMFElement(QString fSymbol, int n) {
        this.fElement = fSymbol;
        this.fCount = n;
    }

    public QString getElementHtml() {
        QString atom = new QString();
        QString iso = new QString();
        UtilMolFormula.splitIsotope(this.fElement, atom, iso);
        if (iso.isEmpty()) {
            return this.fElement;
        }
        return new QString("<sup>" + iso.toString() + "</sup>" + atom.toString());
    }

    public QString getHtml() {
        if (this.fCount == 0) {
            return new QString();
        }
        if (this.fCount > 1) {
            QString element = this.getElementHtml();
            return new QString(element.toString() + "<sub>" + this.fCount + "</sub>");
        }
        return this.getElementHtml();
    }

    public QString getString() {
        if (this.fCount == 0) {
            return new QString();
        }
        if (this.fCount == 1) {
            return this.fElement;
        }
        return new QString(this.fElement.toString() + this.fCount);
    }
}

