/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.TMFElement;
import com.mestrelab.components.shared.util.TState;

public class TFormulaParser {
    public QString fFormula;
    public QString fNumber;
    public QString fSymbol;
    public int fPos;
    public TState fState;
    public int fMultiplicity;
    public QMap<QString, Integer> fElements;
    public QVector<TMFElement> fMFElements;
    public int fCharge;

    public TFormulaParser(QString aFormula) {
        this.fFormula = new QString(aFormula.toString());
        this.fNumber = new QString();
        this.fSymbol = new QString();
        this.fPos = 0;
        this.fState = TState.eSymbol;
        this.fMultiplicity = 1;
        this.fElements = new QMap();
        this.fMFElements = new QVector();
        this.fCharge = 0;
    }

    public TFormulaParser(QString aFormula, int aPos) {
        this.fFormula = new QString(aFormula.toString());
        this.fNumber = new QString();
        this.fSymbol = new QString();
        this.fPos = aPos;
        this.fState = TState.eSymbol;
        this.fMultiplicity = 1;
        this.fElements = new QMap();
        this.fMFElements = new QVector();
        this.fCharge = 0;
    }

    public char firstChar() {
        if (this.fPos < 0 || this.fPos >= this.fFormula.size()) {
            return '\u0000';
        }
        return (char)this.fFormula.getChars()[this.fPos];
    }

    public char nextChar() {
        ++this.fPos;
        if (this.fPos < 0 || this.fPos >= this.fFormula.size()) {
            return '\u0000';
        }
        return (char)this.fFormula.getChars()[this.fPos];
    }

    public static boolean isWilcardSymbol(char aChar) {
        return aChar == '*' || aChar == '?';
    }

    public static boolean validSymbolChar(char aChar) {
        return Character.isLetter(aChar) || TFormulaParser.isWilcardSymbol(aChar);
    }

    public static boolean isChargeChar(char aChar) {
        return aChar == '+' || aChar == '-';
    }

    public boolean needsParenthesis() {
        return this.fMultiplicity > 1;
    }

    public void newSymbol() {
        if (!this.fSymbol.isEmpty()) {
            int n = 1;
            if (!this.fNumber.isEmpty() && (n = this.fNumber.toInt()) == Integer.MIN_VALUE) {
                n = 1;
            }
            if (this.fElements.contains(this.fSymbol)) {
                this.fElements.add(new QString(this.fSymbol.toString()), this.fElements.find(this.fSymbol) + n);
            } else {
                this.fElements.insert(new QString(this.fSymbol.toString()), n);
            }
            this.fMFElements.append(new TMFElement(new QString(this.fSymbol.toString()), n));
        }
        this.fSymbol.clear();
        this.fNumber.clear();
    }

    public boolean parseGroup(boolean aAllowCharge) {
        this.newSymbol();
        TFormulaParser groupCtx = new TFormulaParser(this.fFormula, this.fPos + 1);
        if (!groupCtx.parse(aAllowCharge)) {
            return false;
        }
        if (aAllowCharge && groupCtx.fCharge != 0) {
            if (this.fCharge != 0) {
                return false;
            }
            this.fCharge = groupCtx.fCharge;
        }
        for (QString gIt : groupCtx.fElements.keys()) {
            if (this.fElements.contains(gIt)) {
                this.fElements.add(gIt, this.fElements.find(gIt) + groupCtx.fElements.find(gIt) * groupCtx.fMultiplicity);
                continue;
            }
            this.fElements.add(gIt, groupCtx.fElements.find(gIt) * groupCtx.fMultiplicity);
        }
        if (groupCtx.needsParenthesis()) {
            groupCtx.fMFElements.insert(0, new TMFElement(new QString("("), 1));
            groupCtx.fMFElements.append(new TMFElement(new QString(")"), groupCtx.fMultiplicity));
        }
        for (TMFElement e : groupCtx.fMFElements) {
            this.fMFElements.append(e);
        }
        this.fPos = groupCtx.fPos;
        this.fSymbol.clear();
        this.fNumber.clear();
        return true;
    }

    public void parseNumber(TState aState, char aChar) {
        this.fNumber.append(Character.toString(aChar));
        this.fState = aState;
    }

    public void parseSymbol(char aChar) {
        if (this.fState == TState.eIsotope) {
            this.fSymbol.append(this.fNumber);
            this.fNumber.clear();
        } else if (Character.isUpperCase(aChar) || TFormulaParser.isWilcardSymbol(aChar)) {
            this.newSymbol();
        }
        this.fSymbol.append(Character.toString(aChar));
        this.fState = TState.eSymbol;
    }

    public void endGroup() {
        this.fState = TState.eEnd;
        if (this.fElements.isEmpty()) {
            return;
        }
        if (!this.fNumber.isEmpty()) {
            boolean ok = false;
            this.fMultiplicity = this.fNumber.toInt();
            if (this.fMultiplicity == Integer.MIN_VALUE) {
                this.fMultiplicity = 1;
            }
            this.fNumber.clear();
        }
    }

    public void setState(TState aState) {
        this.newSymbol();
        this.fState = aState;
    }

    public boolean setCharge() {
        if (this.fSymbol.isEmpty()) {
            return true;
        }
        if (this.fCharge != 0) {
            return false;
        }
        int q = 0;
        if (this.fSymbol.getChars()[0] == 43) {
            q = 1;
        } else if (this.fSymbol.getChars()[0] == 45) {
            q = -1;
        } else {
            return false;
        }
        this.fSymbol.clear();
        int n = 1;
        if (!this.fNumber.isEmpty()) {
            n = this.fNumber.toInt();
            if (n == Integer.MIN_VALUE) {
                return false;
            }
            this.fNumber.clear();
        }
        this.fCharge = q * n;
        return true;
    }

    public boolean parse() {
        return this.parse(true);
    }

    public boolean parse(boolean aAllowCharge) {
        char c = this.firstChar();
        while (c != '\u0000') {
            switch (this.fState) {
                case eIsotope: {
                    if (Character.isDigit(c)) {
                        this.parseNumber(TState.eIsotope, c);
                        break;
                    }
                    if (TFormulaParser.validSymbolChar(c)) {
                        this.parseSymbol(c);
                        break;
                    }
                    this.setState(TState.eFail);
                    return false;
                }
                case eSymbol: 
                case eSymbolMult: {
                    if (Character.isDigit(c)) {
                        if (this.fSymbol.isEmpty()) {
                            this.parseNumber(TState.eIsotope, c);
                            break;
                        }
                        this.parseNumber(TState.eSymbolMult, c);
                        break;
                    }
                    if (TFormulaParser.validSymbolChar(c)) {
                        this.parseSymbol(c);
                        break;
                    }
                    if (c == '(') {
                        if (this.parseGroup(aAllowCharge)) break;
                        this.setState(TState.eFail);
                        return false;
                    }
                    if (c == ')') {
                        this.setState(TState.eGroupEnd);
                        break;
                    }
                    if (Character.isSpace(c)) {
                        this.setState(TState.eSymbol);
                        break;
                    }
                    if (TFormulaParser.isChargeChar(c)) {
                        if (aAllowCharge) {
                            this.newSymbol();
                            this.fSymbol = new QString(Character.toString(c));
                            this.fState = TState.eCharge;
                            break;
                        }
                        this.setState(TState.eFail);
                        return false;
                    }
                    this.setState(TState.eFail);
                    return false;
                }
                case eGroupEnd: 
                case eGroupMult: {
                    if (Character.isDigit(c)) {
                        this.parseNumber(TState.eGroupMult, c);
                        break;
                    }
                    if (TFormulaParser.isChargeChar(c)) {
                        if (aAllowCharge) {
                            this.endGroup();
                            this.fSymbol = new QString(Character.toString(c));
                            this.fState = TState.eCharge;
                            break;
                        }
                        this.setState(TState.eFail);
                        return false;
                    }
                    if (Character.isSpace(c)) break;
                    --this.fPos;
                    this.endGroup();
                    return true;
                }
                case eCharge: 
                case eChargeMult: {
                    if (Character.isDigit(c)) {
                        this.parseNumber(TState.eChargeMult, c);
                        break;
                    }
                    if (Character.isSpace(c)) break;
                    this.setState(TState.eFail);
                    return false;
                }
            }
            c = this.nextChar();
        }
        if (this.fState != TState.eIsotope) {
            switch (this.fState) {
                case eSymbol: 
                case eSymbolMult: {
                    this.newSymbol();
                    break;
                }
                case eGroupEnd: 
                case eGroupMult: {
                    this.endGroup();
                    break;
                }
                case eCharge: 
                case eChargeMult: {
                    if (this.setCharge()) break;
                    this.setState(TState.eFail);
                    return false;
                }
            }
            this.setState(TState.eEnd);
            return true;
        }
        this.setState(TState.eFail);
        return false;
    }
}

