/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import com.mestrelab.components.shared.qt.QPoint;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class T3DPointF
extends QPoint<Double>
implements Serializable {
    private double zp = 0.0;

    public T3DPointF() {
        this.zp = 0.0;
    }

    public T3DPointF(Double x, Double y) {
        super(x, y);
        this.zp = 0.0;
    }

    public T3DPointF(Double x, Double y, Double z) {
        super(x, y);
        this.zp = z;
    }

    public double rz() {
        return this.zp;
    }

    public void setZ(double aZ) {
        this.zp = aZ;
    }

    public double z() {
        return this.zp;
    }

    public T3DPointF rotateXY(double aRadValue) {
        double cos = Math.cos(aRadValue);
        double sin = Math.sin(aRadValue);
        double newX = (Double)this.x() * cos - (Double)this.y() * sin;
        double newY = (Double)this.x() * sin + (Double)this.y() * cos;
        this.setX(newX);
        this.setY(newY);
        return this;
    }

    public T3DPointF scalarProduc(double aValue) {
        this.setX((Double)this.rx() * aValue);
        this.setY((Double)this.ry() * aValue);
        this.zp *= aValue;
        return this;
    }

    public double distance(T3DPointF aPoint) {
        return Math.sqrt(Math.pow((Double)this.x() - (Double)aPoint.x(), 2.0) + Math.pow((Double)this.y() - (Double)aPoint.y(), 2.0) + Math.pow(this.z() - aPoint.z(), 2.0));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.zp);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        T3DPointF other = (T3DPointF)obj;
        return Double.doubleToLongBits(this.zp) == Double.doubleToLongBits(other.zp);
    }

    public double getZp() {
        return this.zp;
    }

    public void setZp(double zp) {
        this.zp = zp;
    }
}

