/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHEX {
    protected static final String[][] ATTR_ESCAPES = new String[][]{{"&", "&amp;"}, {"'", "&apos;"}, {"\"", "&quot;"}, {"<", "&lt;"}, {">", "&gt;"}};
    protected static final String XLATE = "0123456789abcdef";

    public static String hexlate(byte[] bytes, int count) {
        if (bytes == null) {
            return "";
        }
        count = Math.min(count, bytes.length);
        char[] chars = new char[count * 2];
        for (int i = 0; i < count; ++i) {
            int val = bytes[i];
            if (val < 0) {
                val += 256;
            }
            chars[2 * i] = XLATE.charAt(val / 16);
            chars[2 * i + 1] = XLATE.charAt(val % 16);
        }
        return new String(chars);
    }

    public static String hexlate(byte[] bytes) {
        return bytes == null ? "" : StringHEX.hexlate(bytes, bytes.length);
    }

    public static byte[] unhexlate(String hex) {
        if (hex == null || hex.length() % 2 != 0) {
            return null;
        }
        hex = hex.toLowerCase();
        byte[] data = new byte[hex.length() / 2];
        for (int ii = 0; ii < hex.length(); ii += 2) {
            int value = XLATE.indexOf(hex.charAt(ii)) << 4;
            data[ii / 2] = (byte)(value += XLATE.indexOf(hex.charAt(ii + 1)));
        }
        return data;
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static String getOr(String value, String defval) {
        return StringHEX.isBlank(value) ? defval : value;
    }

    public static String escapeAttribute(String value) {
        for (int ii = 0; ii < ATTR_ESCAPES.length; ++ii) {
            value = value.replace(ATTR_ESCAPES[ii][0], ATTR_ESCAPES[ii][1]);
        }
        return value;
    }

    public static String sanitizeAttribute(String value) {
        for (int ii = 0; ii < ATTR_ESCAPES.length; ++ii) {
            value = value.replace(ATTR_ESCAPES[ii][0], "");
        }
        return value;
    }

    public static String truncate(String str, int limit) {
        return StringHEX.truncate(str, limit, "");
    }

    public static String truncate(String str, int limit, String appendage) {
        if (str == null || str.length() <= limit) {
            return str;
        }
        return str.substring(0, limit - appendage.length()) + appendage;
    }

    public static String capitalize(String s) {
        if (StringHEX.isBlank(s)) {
            return s;
        }
        char c = s.charAt(0);
        if (Character.isUpperCase(c)) {
            return s;
        }
        return String.valueOf(Character.toUpperCase(c)) + s.substring(1);
    }

    public static String join(Iterable<?> items) {
        return StringHEX.join(items, ", ");
    }

    public static String join(Iterable<?> items, String sep) {
        Iterator<?> i = items.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(String.valueOf(i.next()));
        while (i.hasNext()) {
            buf.append(sep).append(i.next());
        }
        return buf.toString();
    }
}

