/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.util;

import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.Cutils;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreLoad<T>
implements Serializable {
    private static StoreLoad INSTANCE = new StoreLoad();

    public static StoreLoad getInstance() {
        return INSTANCE;
    }

    public T copy(T aFrom, T aTo) {
        Object newaTom = aTo;
        if (aTo instanceof TMolecule && aFrom instanceof TMolecule) {
            int i;
            TMolecule aFromM = (TMolecule)aFrom;
            TMolecule aToM = (TMolecule)aTo;
            for (i = 0; i < aFromM.getAtoms().size(); ++i) {
                aToM.addAtom(new TAtom(aFromM.atom(i)));
            }
            for (i = 0; i < aFromM.getBonds().size(); ++i) {
                aToM.addBond(new TBond(aFromM.bond(i)), true);
            }
            aToM.getfPolymers().append(aFromM.getfPolymers());
            aToM.setfOriginalMolfile(aFromM.getfOriginalMolfile());
            if (!aFromM.getTvariantDataAB().isEmpty()) {
                aToM.gettVariantData().clear();
                for (String key : aFromM.getTvariantDataAB().keySet()) {
                    aToM.gettVariantData().setData(new QString(key), new QString(aFromM.getTvariantDataAB().get(key)));
                }
            }
            newaTom = aToM;
        }
        return newaTom;
    }

    public int compare(T aObj1, T aObj2) {
        QByteArray data1 = new QByteArray();
        QByteArray data2 = new QByteArray();
        data1 = this.toByteArray(aObj1, data1);
        data2 = this.toByteArray(aObj2, data2);
        if (data1.size() < data2.size()) {
            return -1;
        }
        if (data1.size() > data2.size()) {
            return 1;
        }
        return Cutils.memcmp(data1.toString(), data2.toString(), data1.size());
    }

    public QByteArray<T> toByteArray(T aObj, QByteArray<T> aData) {
        aData.setData(aObj);
        return aData;
    }
}

