/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.IQString;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QVariant;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QString
extends QVariant
implements Serializable,
Comparator<QString>,
IQString {
    private String qString = null;
    private Date start = null;

    public QString() {
        this.qString = new String();
    }

    public QString(String data) {
        this.qString = data;
    }

    public boolean isEmpty() {
        if (this.qString != null) {
            return this.qString.isEmpty();
        }
        return true;
    }

    public void clear() {
        this.qString = new String();
    }

    public QString append(String data) {
        this.qString = this.qString.concat(data);
        return new QString(this.qString);
    }

    public QString append(QString data) {
        this.qString = this.qString.concat(data.toString());
        return new QString(this.qString);
    }

    public QString prepend(QString data) {
        this.qString = data.toString() + this.qString;
        return new QString(this.qString);
    }

    public int size() {
        return this.qString.length();
    }

    public QString remove(QString str) {
        return new QString(this.qString.replace(str.toString(), ""));
    }

    public QString remove(int position, int n) {
        return new QString(this.qString.substring(0, position).concat(this.qString.substring(position + n, this.qString.length())));
    }

    public void removeCharacter(String data) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QString trimmed() {
        return new QString(this.qString.trim());
    }

    public void setUtf16(String data, int index) {
        byte[] utf8 = new byte[index];
        byte[] utf8Converted = null;
        try {
            utf8Converted = data.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (int i = 0; i < utf8.length; ++i) {
            utf8[i] = utf8Converted[i];
        }
        this.qString = new String(utf8);
    }

    public void replace(String regex, String replacement) {
        regex = regex.replace(new String("{"), new String("\\{"));
        regex = regex.replace(new String("}"), new String("\\}"));
        this.qString = this.qString.replaceAll(regex, replacement);
    }

    public QString left(int number) {
        if (number > this.qString.length()) {
            number = this.qString.length();
        }
        return new QString(this.qString.substring(0, number));
    }

    public QString leftJustified(int width, char fill) {
        return this.leftJustified(width, fill, false);
    }

    public QString leftJustified(int width, char fill, boolean truncate) {
        char[] chars = new char[width];
        for (int i = 0; i < width; ++i) {
            chars[i] = fill;
        }
        int limit = width > this.size() ? this.size() : width;
        for (int i = 0; i < limit; ++i) {
            chars[i] = this.qString.charAt(i);
        }
        if (truncate) {
            return new QString(new String(chars)).left(width);
        }
        return new QString(new String(chars));
    }

    private QString fill(int width, char fill, boolean truncate) {
        char[] chars = new char[width];
        while (width > 0) {
            chars[--width] = fill;
        }
        int limit = width > this.size() ? this.size() : width;
        for (int i = 0; i < limit; ++i) {
            chars[i] = this.qString.charAt(i);
        }
        return new QString(new String(chars));
    }

    public void fill(char afill) {
        this.fill(afill, this.qString.length());
    }

    public void fill(char fill, int count) {
        char[] chars = new char[count];
        while (count > 0) {
            chars[--count] = fill;
        }
        this.qString = new String(chars);
    }

    public QString mid(int position) {
        return this.mid(position, -1);
    }

    public QString mid(int position, int n) {
        if (this.qString == null || position >= this.qString.length()) {
            return new QString();
        }
        if (n < 0) {
            n = this.qString.length() - position;
        }
        if (position < 0) {
            n += position;
            position = 0;
        }
        if (n + position > this.qString.length()) {
            n = this.qString.length() - position;
        }
        if (position == 0 && n == this.qString.length()) {
            return new QString(this.qString);
        }
        return new QString(String.copyValueOf(this.qString.toCharArray(), position, n));
    }

    public QString arg(int value, int fieldwidth, char fillChar) {
        char[] chars = new char[Math.abs(fieldwidth)];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = fillChar;
        }
        char[] valueChar = Character.toChars(value);
        int j = 0;
        if (fieldwidth < 0) {
            for (int i = chars.length - 1; i >= 0 && j < valueChar.length; ++j, --i) {
                chars[i] = valueChar[j];
            }
        } else {
            for (int i = 0; i < chars.length && i < valueChar.length; ++i) {
                chars[i] = valueChar[i];
            }
        }
        return new QString(this.qString + new String(chars));
    }

    public QString arg(String value, int fieldwidth, char fillChar) {
        char[] chars = new char[Math.abs(fieldwidth)];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = fillChar;
        }
        char[] valueChar = value.toCharArray();
        int j = 0;
        if (fieldwidth < 0) {
            for (int i = chars.length - 1; i >= 0 && j < valueChar.length; ++j, --i) {
                chars[i] = valueChar[j];
            }
        } else {
            for (int i = 0; i < chars.length && i < valueChar.length; ++i) {
                chars[i] = valueChar[i];
            }
        }
        return new QString(this.qString + new String(chars));
    }

    public QList<QString> split(String pattern) {
        String[] parts = this.qString.split(pattern.toString());
        QList<QString> result = new QList<QString>();
        for (String el : parts) {
            result.append(new QString(el));
        }
        return result;
    }

    public double toFloat() {
        return Double.parseDouble(this.qString.trim());
    }

    public double toDouble() {
        return Double.parseDouble(this.qString.trim());
    }

    public int toInt() {
        return this.toInt(10);
    }

    public int toInt(int base) {
        int result = 0;
        try {
            result = Integer.parseInt(this.qString.trim(), base);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean startsWith(String aux) {
        return this.qString.startsWith(aux);
    }

    public boolean startsWith(QString aux) {
        return this.qString.startsWith(aux.toString());
    }

    public boolean endsWith(QString aux) {
        return this.qString.endsWith(aux.toString());
    }

    public String toString() {
        return this.qString;
    }

    public int indexOf(String str) {
        return this.qString.indexOf(str);
    }

    public byte[] getChars() {
        return this.qString.getBytes();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qString == null ? 0 : this.qString.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QString other = (QString)obj;
        if (this.qString == null ? other.qString != null : !this.qString.equals(other.qString)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    @Override
    public int compare(QString o1, QString o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public QString toUpper() {
        return new QString(this.qString.toUpperCase());
    }

    public QString toUpperFirstLeter() {
        return new QString(this.qString.substring(0, 1).toUpperCase() + (this.qString.length() > 1 ? this.qString.substring(1).toLowerCase() : ""));
    }

    public int elapsed() {
        if (this.start != null) {
            long trans = this.start.getTime();
            this.start = new Date();
            return (int)(this.start.getTime() - trans);
        }
        return 0;
    }

    public void start() {
        this.start = new Date();
    }

    @Override
    public String getqString() {
        return this.qString;
    }

    @Override
    public void setqString(String qString) {
        this.qString = qString;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public QString toLower() {
        return new QString(this.qString.toLowerCase());
    }

    public QString right(int n) {
        if (n >= this.qString.length() || n < 0) {
            return this;
        }
        return new QString(this.qString.substring(this.qString.length() - n));
    }

    public void chop(int i) {
        this.qString = this.qString.substring(0, this.qString.length() - i);
    }
}

