/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QRect;
import com.mestrelab.components.shared.qt.QSize;
import com.mestrelab.components.shared.qt.QVariant;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QRectF
extends QVariant
implements Serializable {
    private double xp;
    private double yp;
    private double w;
    private double h;

    public QRectF() {
        this.xp = 0.0;
        this.yp = 0.0;
        this.w = 0.0;
        this.h = 0.0;
    }

    public QRectF(double aleft, double atop, double awidth, double aheight) {
        this.xp = aleft;
        this.yp = atop;
        this.w = awidth;
        this.h = aheight;
    }

    public QRectF(QPoint<Double> atopLeft, QSize<Double> asize) {
        this.xp = atopLeft.x();
        this.yp = atopLeft.y();
        this.w = asize.width();
        this.h = asize.height();
    }

    public QRectF(QPoint<Double> atopLeft, QPoint<Double> abottomRight) {
        this.xp = atopLeft.x();
        this.yp = atopLeft.y();
        this.w = abottomRight.x() - this.xp;
        this.h = abottomRight.y() - this.yp;
    }

    public QRectF(QRectF r) {
        this.xp = r.x();
        this.yp = r.y();
        this.w = r.width();
        this.h = r.height();
    }

    public boolean isNull() {
        return this.w == 0.0 && this.h == 0.0;
    }

    public boolean isEmpty() {
        return !this.isValid();
    }

    public boolean isValid() {
        return this.left() < this.right() && this.top() < this.bottom();
    }

    public double x() {
        return this.xp;
    }

    public double y() {
        return this.yp;
    }

    public void setLeft(double pos) {
        double diff = pos - this.xp;
        this.xp += diff;
        this.w -= diff;
    }

    public void setRight(double pos) {
        this.w = pos - this.xp;
    }

    public void setTop(double pos) {
        double diff = pos - this.yp;
        this.yp += diff;
        this.h -= diff;
    }

    public void setBottom(double pos) {
        this.h = pos - this.yp;
    }

    public void setTopLeft(QPoint<Double> p) {
        this.setLeft(p.x());
        this.setTop(p.y());
    }

    public void setTopRight(QPoint<Double> p) {
        this.setRight(p.x());
        this.setTop(p.y());
    }

    public void setBottomLeft(QPoint<Double> p) {
        this.setLeft(p.x());
        this.setBottom(p.y());
    }

    public void setBottomRight(QPoint<Double> p) {
        this.setRight(p.x());
        this.setBottom(p.y());
    }

    public QPoint<Double> center() {
        return new QPoint<Double>(this.xp + this.w / 2.0, this.yp + this.h / 2.0);
    }

    public void moveLeft(double pos) {
        this.xp = pos;
    }

    public void moveTop(double pos) {
        this.yp = pos;
    }

    public void moveRight(double pos) {
        this.xp = pos - this.w;
    }

    public void moveBottom(double pos) {
        this.yp = pos - this.h;
    }

    public void moveTopLeft(QPoint<Double> p) {
        this.moveLeft(p.x());
        this.moveTop(p.y());
    }

    public void moveTopRight(QPoint<Double> p) {
        this.moveRight(p.x());
        this.moveTop(p.y());
    }

    public void moveBottomLeft(QPoint<Double> p) {
        this.moveLeft(p.x());
        this.moveBottom(p.y());
    }

    public void moveBottomRight(QPoint<Double> p) {
        this.moveRight(p.x());
        this.moveBottom(p.y());
    }

    public void moveCenter(QPoint<Double> p) {
        this.xp = p.x() - this.w / 2.0;
        this.yp = p.y() - this.h / 2.0;
    }

    public double width() {
        return this.w;
    }

    public double height() {
        return this.h;
    }

    public QSize<Double> size() {
        return new QSize<Double>(this.w, this.h);
    }

    public void translate(double dx, double dy) {
        this.xp += dx;
        this.yp += dy;
    }

    public void translate(QPoint<Double> p) {
        this.xp += p.x().doubleValue();
        this.yp += p.y().doubleValue();
    }

    public void moveTo(double ax, double ay) {
        this.xp = ax;
        this.yp = ay;
    }

    public void moveTo(QPoint<Double> p) {
        this.xp = p.x();
        this.yp = p.y();
    }

    public QRectF translated(double dx, double dy) {
        return new QRectF(this.xp + dx, this.yp + dy, this.w, this.h);
    }

    public QRectF translated(QPoint<Double> p) {
        return new QRectF(this.xp + p.x(), this.yp + p.y(), this.w, this.h);
    }

    public void setCoords(QRectF r) {
        this.xp = r.x();
        this.yp = r.y();
        this.w = r.width();
        this.h = r.height();
    }

    public void setCoords(double xp1, double yp1, double xp2, double yp2) {
        this.xp = xp1;
        this.yp = yp1;
        this.w = xp2 - xp1;
        this.h = yp2 - yp1;
    }

    public void adjust(double xp1, double yp1, double xp2, double yp2) {
        this.xp += xp1;
        this.yp += yp1;
        this.w += xp2 - xp1;
        this.h += yp2 - yp1;
    }

    public QRectF adjusted(double xp1, double yp1, double xp2, double yp2) {
        return new QRectF(this.xp + xp1, this.yp + yp1, this.w + xp2 - xp1, this.h + yp2 - yp1);
    }

    public void setWidth(double aw) {
        this.w = aw;
    }

    public void setHeight(double ah) {
        this.h = ah;
    }

    public void setSize(QSize<Double> s) {
        this.w = s.width();
        this.h = s.height();
    }

    public boolean contains(double ax, double ay) {
        return this.contains(new QPoint<Double>(ax, ay));
    }

    public boolean contains(QPoint<Double> p) {
        double l = this.xp;
        double r = this.xp;
        if (this.w < 0.0) {
            l += this.w;
        } else {
            r += this.w;
        }
        if (l == r) {
            return false;
        }
        if (p.x() < l || p.x() > r) {
            return false;
        }
        double t = this.yp;
        double b = this.yp;
        if (this.h < 0.0) {
            t += this.h;
        } else {
            b += this.h;
        }
        if (t == b) {
            return false;
        }
        return !(p.y() < t) && !(p.y() > b);
    }

    public boolean contains(QRectF r) {
        double l1 = this.xp;
        double r1 = this.xp;
        if (this.w < 0.0) {
            l1 += this.w;
        } else {
            r1 += this.w;
        }
        if (l1 == r1) {
            return false;
        }
        double l2 = r.xp;
        double r2 = r.xp;
        if (r.w < 0.0) {
            l2 += r.w;
        } else {
            r2 += r.w;
        }
        if (l2 == r2) {
            return false;
        }
        if (l2 < l1 || r2 > r1) {
            return false;
        }
        double t1 = this.yp;
        double b1 = this.yp;
        if (this.h < 0.0) {
            t1 += this.h;
        } else {
            b1 += this.h;
        }
        if (t1 == b1) {
            return false;
        }
        double t2 = r.yp;
        double b2 = r.yp;
        if (r.h < 0.0) {
            t2 += r.h;
        } else {
            b2 += r.h;
        }
        if (t2 == b2) {
            return false;
        }
        return !(t2 < t1) && !(b2 > b1);
    }

    public QRectF intersect(QRectF r) {
        double l1 = this.xp;
        double r1 = this.xp;
        if (this.w < 0.0) {
            l1 += this.w;
        } else {
            r1 += this.w;
        }
        if (l1 == r1) {
            return new QRectF();
        }
        double l2 = r.xp;
        double r2 = r.xp;
        if (r.w < 0.0) {
            l2 += r.w;
        } else {
            r2 += r.w;
        }
        if (l2 == r2) {
            return new QRectF();
        }
        if (l1 >= r2 || l2 >= r1) {
            return new QRectF();
        }
        double t1 = this.yp;
        double b1 = this.yp;
        if (this.h < 0.0) {
            t1 += this.h;
        } else {
            b1 += this.h;
        }
        if (t1 == b1) {
            return new QRectF();
        }
        double t2 = r.yp;
        double b2 = r.yp;
        if (r.h < 0.0) {
            t2 += r.h;
        } else {
            b2 += r.h;
        }
        if (t2 == b2) {
            return new QRectF();
        }
        if (t1 >= b2 || t2 >= b1) {
            return new QRectF();
        }
        QRectF tmp = new QRectF();
        tmp.xp = Math.max(l1, l2);
        tmp.yp = Math.max(t1, t2);
        tmp.w = Math.min(r1, r2) - tmp.xp;
        tmp.h = Math.min(b1, b2) - tmp.yp;
        return tmp;
    }

    public QRectF intersected(QRectF r) {
        return this.intersect(r);
    }

    public QRectF unite(QRectF r) {
        if (this.isNull()) {
            return r;
        }
        if (r.isNull()) {
            return this;
        }
        double left = this.xp;
        double right = this.xp;
        if (this.w < 0.0) {
            left += this.w;
        } else {
            right += this.w;
        }
        if (r.w < 0.0) {
            left = Math.min(left, r.xp + r.w);
            right = Math.max(right, r.xp);
        } else {
            left = Math.min(left, r.xp);
            right = Math.max(right, r.xp + r.w);
        }
        double top = this.yp;
        double bottom = this.yp;
        if (this.h < 0.0) {
            top += this.h;
        } else {
            bottom += this.h;
        }
        if (r.h < 0.0) {
            top = Math.min(top, r.yp + r.h);
            bottom = Math.max(bottom, r.yp);
        } else {
            top = Math.min(top, r.yp);
            bottom = Math.max(bottom, r.yp + r.h);
        }
        return new QRectF(left, top, right - left, bottom - top);
    }

    public QRectF united(QRectF r) {
        return this.unite(r);
    }

    public QRectF normalized() {
        QRectF r = this;
        if (r.w < 0.0) {
            r.xp += r.w;
            r.w = -r.w;
        }
        if (r.h < 0.0) {
            r.yp += r.h;
            r.h = -r.h;
        }
        return r;
    }

    public double left() {
        return this.xp;
    }

    public double top() {
        return this.yp;
    }

    public double right() {
        return this.xp + this.w;
    }

    public double bottom() {
        return this.yp + this.h;
    }

    public QPoint<Double> topLeft() {
        return new QPoint<Double>(this.xp, this.yp);
    }

    public QPoint<Double> bottomRight() {
        return new QPoint<Double>(this.xp + this.w, this.yp + this.h);
    }

    public QPoint<Double> topRight() {
        return new QPoint<Double>(this.xp + this.w, this.yp);
    }

    public QPoint<Double> bottomLeft() {
        return new QPoint<Double>(this.xp, this.yp + this.h);
    }

    public QRect toRect() {
        return new QRect((int)Math.round(this.xp), (int)Math.round(this.yp), (int)Math.round(this.w), (int)Math.round(this.h));
    }

    public boolean intersects(QRectF r) {
        double l1 = this.xp;
        double r1 = this.xp;
        if (this.w < 0.0) {
            l1 += this.w;
        } else {
            r1 += this.w;
        }
        if (l1 == r1) {
            return false;
        }
        double l2 = r.xp;
        double r2 = r.xp;
        if (r.w < 0.0) {
            l2 += r.w;
        } else {
            r2 += r.w;
        }
        if (l2 == r2) {
            return false;
        }
        if (l1 >= r2 || l2 >= r1) {
            return false;
        }
        double t1 = this.yp;
        double b1 = this.yp;
        if (this.h < 0.0) {
            t1 += this.h;
        } else {
            b1 += this.h;
        }
        if (t1 == b1) {
            return false;
        }
        double t2 = r.yp;
        double b2 = r.yp;
        if (r.h < 0.0) {
            t2 += r.h;
        } else {
            b2 += r.h;
        }
        if (t2 == b2) {
            return false;
        }
        return !(t1 >= b2) && !(t2 >= b1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.h);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.xp);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.yp);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QRectF other = (QRectF)obj;
        if (Double.doubleToLongBits(this.h) != Double.doubleToLongBits(other.h)) {
            return false;
        }
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.xp) != Double.doubleToLongBits(other.xp)) {
            return false;
        }
        return Double.doubleToLongBits(this.yp) == Double.doubleToLongBits(other.yp);
    }

    public double getXp() {
        return this.xp;
    }

    public void setXp(double xp) {
        this.xp = xp;
    }

    public double getYp() {
        return this.yp;
    }

    public void setYp(double yp) {
        this.yp = yp;
    }

    public double getW() {
        return this.w;
    }

    public void setW(double w) {
        this.w = w;
    }

    public double getH() {
        return this.h;
    }

    public void setH(double h) {
        this.h = h;
    }
}

