/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QSize;
import com.mestrelab.components.shared.qt.QVariant;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QRect
extends QVariant
implements Serializable {
    private int xp;
    private int yp;
    private int w;
    private int h;

    public QRect() {
        this.xp = 0;
        this.yp = 0;
        this.w = 0;
        this.h = 0;
    }

    public QRect(int aleft, int atop, int awidth, int aheight) {
        this.xp = aleft;
        this.yp = atop;
        this.w = awidth;
        this.h = aheight;
    }

    public QRect(QPoint<Integer> atopLeft, QSize<Integer> asize) {
        this.xp = atopLeft.x();
        this.yp = atopLeft.y();
        this.w = asize.width();
        this.h = asize.height();
    }

    public QRect(QPoint<Integer> atopLeft, QPoint<Integer> abottomRight) {
        this.xp = atopLeft.x();
        this.yp = atopLeft.y();
        this.w = abottomRight.x() - this.xp;
        this.h = abottomRight.y() - this.yp;
    }

    public QRect(QRect r) {
        this.xp = r.x();
        this.yp = r.y();
        this.w = r.width();
        this.h = r.height();
    }

    public boolean isNull() {
        return this.w == 0 && this.h == 0;
    }

    public boolean isEmpty() {
        return this.w <= 0 || this.h <= 0;
    }

    public boolean isValid() {
        return this.w > 0 && this.h > 0;
    }

    public int x() {
        return this.xp;
    }

    public int y() {
        return this.yp;
    }

    public void setLeft(int pos) {
        int diff = pos - this.xp;
        this.xp += diff;
        this.w -= diff;
    }

    public void setRight(int pos) {
        this.w = pos - this.xp;
    }

    public void setTop(int pos) {
        int diff = pos - this.yp;
        this.yp += diff;
        this.h -= diff;
    }

    public void setBottom(int pos) {
        this.h = pos - this.yp;
    }

    public void setTopLeft(QPoint<Integer> p) {
        this.setLeft(p.x());
        this.setTop(p.y());
    }

    public void setTopRight(QPoint<Integer> p) {
        this.setRight(p.x());
        this.setTop(p.y());
    }

    public void setBottomLeft(QPoint<Integer> p) {
        this.setLeft(p.x());
        this.setBottom(p.y());
    }

    public void setBottomRight(QPoint<Integer> p) {
        this.setRight(p.x());
        this.setBottom(p.y());
    }

    public QPoint<Integer> center() {
        return new QPoint<Integer>(this.xp + this.w / 2, this.yp + this.h / 2);
    }

    public void moveLeft(int pos) {
        this.xp = pos;
    }

    public void moveTop(int pos) {
        this.yp = pos;
    }

    public void moveRight(int pos) {
        this.xp = pos - this.w;
    }

    public void moveBottom(int pos) {
        this.yp = pos - this.h;
    }

    public void moveTopLeft(QPoint<Integer> p) {
        this.moveLeft(p.x());
        this.moveTop(p.y());
    }

    public void moveTopRight(QPoint<Integer> p) {
        this.moveRight(p.x());
        this.moveTop(p.y());
    }

    public void moveBottomLeft(QPoint<Integer> p) {
        this.moveLeft(p.x());
        this.moveBottom(p.y());
    }

    public void moveBottomRight(QPoint<Integer> p) {
        this.moveRight(p.x());
        this.moveBottom(p.y());
    }

    public void moveCenter(QPoint<Integer> p) {
        this.xp = p.x() - this.w / 2;
        this.yp = p.y() - this.h / 2;
    }

    public int width() {
        return this.w;
    }

    public int height() {
        return this.h;
    }

    public QSize<Integer> size() {
        return new QSize<Integer>(this.w, this.h);
    }

    public void translate(int dx, int dy) {
        this.xp += dx;
        this.yp += dy;
    }

    public void translate(QPoint<Integer> p) {
        this.xp += p.x().intValue();
        this.yp += p.y().intValue();
    }

    public void moveTo(int ax, int ay) {
        this.xp = ax;
        this.yp = ay;
    }

    public void moveTo(QPoint<Integer> p) {
        this.xp = p.x();
        this.yp = p.y();
    }

    public QRect translated(int dx, int dy) {
        return new QRect(this.xp + dx, this.yp + dy, this.w, this.h);
    }

    public QRect translated(QPoint<Integer> p) {
        return new QRect(this.xp + p.x(), this.yp + p.y(), this.w, this.h);
    }

    public void setCoords(int xp1, int yp1, int xp2, int yp2) {
        this.xp = xp1;
        this.yp = yp1;
        this.w = xp2 - xp1;
        this.h = yp2 - yp1;
    }

    public void adjust(int xp1, int yp1, int xp2, int yp2) {
        this.xp += xp1;
        this.yp += yp1;
        this.w += xp2 - xp1;
        this.h += yp2 - yp1;
    }

    public QRect adjusted(int xp1, int yp1, int xp2, int yp2) {
        return new QRect(this.xp + xp1, this.yp + yp1, this.w + xp2 - xp1, this.h + yp2 - yp1);
    }

    public void setWidth(int aw) {
        this.w = aw;
    }

    public void setHeight(int ah) {
        this.h = ah;
    }

    public void setSize(QSize<Integer> s) {
        this.w = s.width();
        this.h = s.height();
    }

    public boolean contains(int ax, int ay) {
        return this.contains(new QPoint<Integer>(ax, ay));
    }

    public boolean contains(QPoint<Integer> p) {
        int l = this.xp;
        int r = this.xp;
        if (this.w < 0) {
            l += this.w;
        } else {
            r += this.w;
        }
        if (l == r) {
            return false;
        }
        if (p.x() < l || p.x() > r) {
            return false;
        }
        int t = this.yp;
        int b = this.yp;
        if (this.h < 0) {
            t += this.h;
        } else {
            b += this.h;
        }
        if (t == b) {
            return false;
        }
        return p.y() >= t && p.y() <= b;
    }

    private QRect intersect(QRect r) {
        int l1 = this.xp;
        int r1 = this.xp;
        if (this.w < 0) {
            l1 += this.w;
        } else {
            r1 += this.w;
        }
        if (l1 == r1) {
            return new QRect();
        }
        int l2 = r.xp;
        int r2 = r.xp;
        if (r.w < 0) {
            l2 += r.w;
        } else {
            r2 += r.w;
        }
        if (l2 == r2) {
            return new QRect();
        }
        if (l1 >= r2 || l2 >= r1) {
            return new QRect();
        }
        int t1 = this.yp;
        int b1 = this.yp;
        if (this.h < 0) {
            t1 += this.h;
        } else {
            b1 += this.h;
        }
        if (t1 == b1) {
            return new QRect();
        }
        int t2 = r.yp;
        int b2 = r.yp;
        if (r.h < 0) {
            t2 += r.h;
        } else {
            b2 += r.h;
        }
        if (t2 == b2) {
            return new QRect();
        }
        if (t1 >= b2 || t2 >= b1) {
            return new QRect();
        }
        QRect tmp = new QRect();
        tmp.xp = Math.max(l1, l2);
        tmp.yp = Math.max(t1, t2);
        tmp.w = Math.min(r1, r2) - tmp.xp;
        tmp.h = Math.min(b1, b2) - tmp.yp;
        return tmp;
    }

    public QRect intersected(QRect r) {
        return this.intersect(r);
    }

    public QRect unite(QRect r) {
        if (this.isNull()) {
            return r;
        }
        if (r.isNull()) {
            return this;
        }
        int left = this.xp;
        int right = this.xp;
        if (this.w < 0) {
            left += this.w;
        } else {
            right += this.w;
        }
        if (r.w < 0) {
            left = Math.min(left, r.xp + r.w);
            right = Math.max(right, r.xp);
        } else {
            left = Math.min(left, r.xp);
            right = Math.max(right, r.xp + r.w);
        }
        int top = this.yp;
        int bottom = this.yp;
        if (this.h < 0) {
            top += this.h;
        } else {
            bottom += this.h;
        }
        if (r.h < 0) {
            top = Math.min(top, r.yp + r.h);
            bottom = Math.max(bottom, r.yp);
        } else {
            top = Math.min(top, r.yp);
            bottom = Math.max(bottom, r.yp + r.h);
        }
        return new QRect(left, top, right - left, bottom - top);
    }

    public QRect united(QRect r) {
        return this.unite(r);
    }

    public QRect normalized() {
        QRect r = this;
        if (r.w < 0) {
            r.xp += r.w;
            r.w = -r.w;
        }
        if (r.h < 0) {
            r.yp += r.h;
            r.h = -r.h;
        }
        return r;
    }

    public int left() {
        return this.xp;
    }

    public int top() {
        return this.yp;
    }

    public int right() {
        return this.xp + this.w;
    }

    public int bottom() {
        return this.yp + this.h;
    }

    public QPoint<Integer> topLeft() {
        return new QPoint<Integer>(this.xp, this.yp);
    }

    public QPoint<Integer> bottomRight() {
        return new QPoint<Integer>(this.xp + this.w, this.yp + this.h);
    }

    public QPoint<Integer> topRight() {
        return new QPoint<Integer>(this.xp + this.w, this.yp);
    }

    public QPoint<Integer> bottomLeft() {
        return new QPoint<Integer>(this.xp, this.yp + this.h);
    }

    public QRect toRect() {
        return new QRect(Math.round(this.xp), Math.round(this.yp), Math.round(this.w), Math.round(this.h));
    }

    public boolean intersects(QRect r) {
        int l1 = this.xp;
        int r1 = this.xp;
        if (this.w < 0) {
            l1 += this.w;
        } else {
            r1 += this.w;
        }
        if (l1 == r1) {
            return false;
        }
        int l2 = r.xp;
        int r2 = r.xp;
        if (r.w < 0) {
            l2 += r.w;
        } else {
            r2 += r.w;
        }
        if (l2 == r2) {
            return false;
        }
        if (l1 >= r2 || l2 >= r1) {
            return false;
        }
        int t1 = this.yp;
        int b1 = this.yp;
        if (this.h < 0) {
            t1 += this.h;
        } else {
            b1 += this.h;
        }
        if (t1 == b1) {
            return false;
        }
        int t2 = r.yp;
        int b2 = r.yp;
        if (r.h < 0) {
            t2 += r.h;
        } else {
            b2 += r.h;
        }
        if (t2 == b2) {
            return false;
        }
        return t1 < b2 && t2 < b1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.h;
        result = 31 * result + this.w;
        result = 31 * result + this.xp;
        result = 31 * result + this.yp;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QRect other = (QRect)obj;
        if (this.h != other.h) {
            return false;
        }
        if (this.w != other.w) {
            return false;
        }
        if (this.xp != other.xp) {
            return false;
        }
        return this.yp == other.yp;
    }
}

