/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.QT_FillRule;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygon;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QVector;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QPolygonF
extends QVector<QPoint<Double>>
implements Serializable {
    public QPolygonF() {
    }

    public QPolygonF(int count) {
        super(count);
    }

    public QPolygonF(QRectF r) {
        this.add(new QPoint<Double>(r.x(), r.y()));
        this.add(new QPoint<Double>(r.x() + r.width(), r.y()));
        this.add(new QPoint<Double>(r.x() + r.width(), r.y() + r.height()));
        this.add(new QPoint<Double>(r.x(), r.y() + r.height()));
    }

    public QPolygonF(QRectF r, boolean closed) {
        this(r);
        if (closed) {
            this.add(new QPoint<Double>(r.left(), r.top()));
        }
    }

    public QPolygonF(QVector<QPoint<Double>> lassoPoints) {
        for (int i = 0; i < lassoPoints.count(); ++i) {
            this.add(new QPoint<Double>(lassoPoints.get(i).x(), lassoPoints.get(i).y()));
        }
    }

    public void add(QPoint<Double> point) {
        this.append(point);
    }

    public QPoint<Double> at(int aPos) {
        return (QPoint)this.get(aPos);
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public int size() {
        return this.count();
    }

    public QRectF boundingRect() {
        double maxy;
        double maxx;
        if (this.isEmpty()) {
            return new QRectF(0.0, 0.0, 0.0, 0.0);
        }
        QPoint pd = (QPoint)this.get(0);
        double minx = maxx = ((Double)pd.x()).doubleValue();
        double miny = maxy = ((Double)pd.y()).doubleValue();
        if (this.count() > 1) {
            pd = (QPoint)this.get(1);
            for (int i = 1; i < this.size(); ++i) {
                if ((Double)pd.x() < minx) {
                    minx = (Double)pd.x();
                } else if ((Double)pd.x() > maxx) {
                    maxx = (Double)pd.x();
                }
                if ((Double)pd.y() < miny) {
                    miny = (Double)pd.y();
                } else if ((Double)pd.y() > maxy) {
                    maxy = (Double)pd.y();
                }
                pd = (QPoint)this.get(i);
            }
        }
        return new QRectF(new QPoint<Double>(minx, miny), new QPoint<Double>(maxx, maxy));
    }

    public QPolygon toPolygon() {
        QPolygon a = new QPolygon();
        for (int i = 0; i < this.size(); ++i) {
            a.append(this.at(i).toPoint());
        }
        return a;
    }

    public boolean containsPoint(QPoint<Double> pt, QT_FillRule fillRule) {
        if (this.isEmpty()) {
            return false;
        }
        int winding_number = 0;
        QPoint<Double> last_pt = new QPoint<Double>(this.at(0).x(), this.at(0).y());
        QPoint<Double> last_start = new QPoint<Double>(this.at(0).x(), this.at(0).y());
        for (int i = 1; i < this.size(); ++i) {
            QPoint<Double> e = this.at(i);
            winding_number += QPolygonF.qt_polygon_isect_line(last_pt, e, pt);
            last_pt.setX(e.x());
            last_pt.setY(e.y());
        }
        if (!last_pt.equals(last_start)) {
            winding_number += QPolygonF.qt_polygon_isect_line(last_pt, last_start, pt);
        }
        return fillRule == QT_FillRule.WindingFill ? winding_number != 0 : winding_number % 2 != 0;
    }

    private static int qt_polygon_isect_line(QPoint<Double> p1, QPoint<Double> p2, QPoint<Double> pos) {
        double x;
        double x1 = p1.x();
        double y1 = p1.y();
        double x2 = p2.x();
        double y2 = p2.y();
        double y = pos.y();
        int winding = 0;
        int dir = 1;
        if (QPolygonF.qFuzzyCompare(y1, y2)) {
            return winding;
        }
        if (y2 < y1) {
            double x_tmp = x2;
            x2 = x1;
            x1 = x_tmp;
            double y_tmp = y2;
            y2 = y1;
            y1 = y_tmp;
            dir = -1;
        }
        if (y >= y1 && y < y2 && (x = x1 + (x2 - x1) / (y2 - y1) * (y - y1)) <= pos.x()) {
            winding += dir;
        }
        return winding;
    }

    private static boolean qFuzzyCompare(double y1, double y2) {
        return y1 == y2;
    }
}

