/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QRect;
import com.mestrelab.components.shared.qt.QVector;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QPolygon
extends QVector<QPoint<Integer>>
implements Serializable {
    public QPolygon() {
    }

    public QPolygon(QRect r) {
        this();
        this.add(new QPoint<Integer>(r.x(), r.y()));
        this.add(new QPoint<Integer>(r.x() + r.width(), r.y()));
        this.add(new QPoint<Integer>(r.x() + r.width(), r.y() + r.height()));
        this.add(new QPoint<Integer>(r.x(), r.y() + r.height()));
    }

    public QPolygon(QRect r, boolean closed) {
        this(r);
        if (closed) {
            this.add(new QPoint<Integer>(r.left(), r.top()));
        }
    }

    public void add(QPoint point) {
        this.append(point);
    }

    public QPoint at(int aPos) {
        return (QPoint)this.get(aPos);
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public int size() {
        return this.count();
    }

    public QRect boundingRect() {
        int maxy;
        int maxx;
        if (this.isEmpty()) {
            return new QRect(0, 0, 0, 0);
        }
        QPoint pd = (QPoint)this.get(0);
        int minx = maxx = ((Integer)pd.x()).intValue();
        int miny = maxy = ((Integer)pd.y()).intValue();
        pd = (QPoint)this.get(1);
        for (int i = 1; i < this.size(); ++i) {
            if ((Integer)pd.x() < minx) {
                minx = (Integer)pd.x();
            } else if ((Integer)pd.x() > maxx) {
                maxx = (Integer)pd.x();
            }
            if ((Integer)pd.y() < miny) {
                miny = (Integer)pd.y();
            } else if ((Integer)pd.y() > maxy) {
                maxy = (Integer)pd.y();
            }
            pd = (QPoint)this.get(i);
        }
        return new QRect(new QPoint<Integer>(minx, miny), new QPoint<Integer>(maxx, maxy));
    }
}

