/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.client.moleditor.QPainterPath;
import com.mestrelab.components.shared.qt.QLineF;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygon;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRect;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QRegion;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QMatrix
implements Serializable {
    private double _m11;
    private double _m12;
    private double _m21;
    private double _m22;
    private double _dx;
    private double _dy;
    public static double deg2rad = Math.PI / 180;

    public QMatrix() {
        this._m11 = 1.0;
        this._m12 = 0.0;
        this._m21 = 0.0;
        this._m22 = 1.0;
        this._dx = 0.0;
        this._dy = 0.0;
    }

    public QMatrix(double m11, double m12, double m21, double m22, double dx, double dy) {
        this._m11 = m11;
        this._m12 = m12;
        this._m21 = m21;
        this._m22 = m22;
        this._dx = dx;
        this._dy = dy;
    }

    public QMatrix(QMatrix matrix) {
        this._m11 = matrix._m11;
        this._m12 = matrix._m12;
        this._m21 = matrix._m21;
        this._m22 = matrix._m22;
        this._dx = matrix._dx;
        this._dy = matrix._dy;
    }

    public void setMatrix(double m11, double m12, double m21, double m22, double dx, double dy) {
        this._m11 = m11;
        this._m12 = m12;
        this._m21 = m21;
        this._m22 = m22;
        this._dx = dx;
        this._dy = dy;
    }

    public double m11() {
        return this._m11;
    }

    public double m12() {
        return this._m12;
    }

    public double m21() {
        return this._m21;
    }

    public double m22() {
        return this._m22;
    }

    public double dx() {
        return this._dx;
    }

    public double dy() {
        return this._dy;
    }

    public void map(int x, int y, int tx, int ty) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void map(double x, double y, double tx, double ty) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QRect mapRect(QRect r) throws Exception {
        throw new Exception("Method not implemented");
    }

    public double[] MAPDOUBLE(double x, double y) {
        double fx = x;
        double fy = y;
        double nx = this._m11 * fx + this._m21 * fy + this._dx;
        double ny = this._m12 * fx + this._m22 * fy + this._dy;
        return new double[]{nx, ny};
    }

    public double[] MAPINT(double x, double y) {
        double fx = x;
        double fy = y;
        double nx = Math.round(this._m11 * fx + this._m21 * fy + this._dx);
        double ny = Math.round(this._m12 * fx + this._m22 * fy + this._dy);
        return new double[]{nx, ny};
    }

    public QRectF mapRect(QRectF rect) {
        QRectF result = new QRectF();
        if (this._m12 == 0.0 && this._m21 == 0.0) {
            double x = this._m11 * rect.x() + this._dx;
            double y = this._m22 * rect.y() + this._dy;
            double w = this._m11 * rect.width();
            double h = this._m22 * rect.height();
            if (w < 0.0) {
                w = -w;
                x -= w;
            }
            if (h < 0.0) {
                h = -h;
                y -= h;
            }
            result = new QRectF(x, y, w, h);
        } else {
            double[] values = this.MAPDOUBLE(rect.x(), rect.y());
            double x0 = values[0];
            double y0 = values[1];
            double xmin = x0;
            double ymin = y0;
            double xmax = x0;
            double ymax = y0;
            values = this.MAPDOUBLE(rect.x() + rect.width(), rect.y());
            double x = values[0];
            double y = values[1];
            xmin = Math.min(xmin, x);
            ymin = Math.min(ymin, y);
            xmax = Math.max(xmax, x);
            ymax = Math.max(ymax, y);
            values = this.MAPDOUBLE(rect.x() + rect.width(), rect.y() + rect.height());
            x = values[0];
            y = values[1];
            xmin = Math.min(xmin, x);
            ymin = Math.min(ymin, y);
            xmax = Math.max(xmax, x);
            ymax = Math.max(ymax, y);
            values = this.MAPDOUBLE(rect.x(), rect.y() + rect.height());
            x = values[0];
            y = values[1];
            xmin = Math.min(xmin, x);
            ymin = Math.min(ymin, y);
            xmax = Math.max(xmax, x);
            ymax = Math.max(ymax, y);
            result = new QRectF(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        return result;
    }

    public QPoint<Double> map(QPoint<Double> point) {
        double fx = point.x();
        double fy = point.y();
        return new QPoint<Double>(this._m11 * fx + this._m21 * fy + this._dx, this._m12 * fx + this._m22 * fy + this._dy);
    }

    public QMatrix inverted() {
        return this.inverted(false);
    }

    public QMatrix inverted(boolean invertible) {
        double dtr = this.determinant();
        if (dtr == 0.0) {
            if (invertible) {
                invertible = false;
            }
            return new QMatrix();
        }
        if (invertible) {
            invertible = true;
        }
        double dinv = 1.0 / dtr;
        return new QMatrix(this._m22 * dinv, -this._m12 * dinv, -this._m21 * dinv, this._m11 * dinv, (this._m21 * this._dy - this._m22 * this._dx) * dinv, (this._m12 * this._dx - this._m11 * this._dy) * dinv);
    }

    public QLineF map(QLineF line) {
        return new QLineF(this.map(line.p1()), this.map(line.p2()));
    }

    public QPolygonF map(QPolygon a) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QPolygonF map(QPolygonF a) {
        int size = a.size();
        QPolygonF p = new QPolygonF(size);
        double[] values = null;
        for (int i = 0; i < size; ++i) {
            values = this.MAPDOUBLE((Double)((QPoint)a.get(i)).x(), (Double)((QPoint)a.get(i)).y());
            p.set(i, new QPoint<Double>(values[0], values[1]));
        }
        return p;
    }

    public QRegion map(QRegion r) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QPainterPath map(QPainterPath p) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QPolygon mapToPolygon(QRect r) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void reset() throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean isIdentity() throws Exception {
        throw new Exception("Method not implemented");
    }

    public QMatrix translate(double dx, double dy) {
        this._dx += dx * this._m11 + dy * this._m21;
        this._dy += dy * this._m22 + dx * this._m12;
        return this;
    }

    public QMatrix scale(double sx, double sy) {
        this._m11 *= sx;
        this._m12 *= sx;
        this._m21 *= sy;
        this._m22 *= sy;
        return this;
    }

    public QMatrix shear(double sh, double sv) {
        double tm11 = sv * this._m21;
        double tm12 = sv * this._m22;
        double tm21 = sh * this._m11;
        double tm22 = sh * this._m12;
        this._m11 += tm11;
        this._m12 += tm12;
        this._m21 += tm21;
        this._m22 += tm22;
        return this;
    }

    public QMatrix rotate(double a) {
        double sina = 0.0;
        double cosa = 0.0;
        if (a == 90.0 || a == -270.0) {
            sina = 1.0;
        } else if (a == 270.0 || a == -90.0) {
            sina = -1.0;
        } else if (a == 180.0) {
            cosa = -1.0;
        } else {
            double b = deg2rad * a;
            sina = Math.sin(b);
            cosa = Math.cos(b);
        }
        double tm11 = cosa * this._m11 + sina * this._m21;
        double tm12 = cosa * this._m12 + sina * this._m22;
        double tm21 = -sina * this._m11 + cosa * this._m21;
        double tm22 = -sina * this._m12 + cosa * this._m22;
        this._m11 = tm11;
        this._m12 = tm12;
        this._m21 = tm21;
        this._m22 = tm22;
        return this;
    }

    public boolean isInvertible() throws Exception {
        throw new Exception("Method not implemented");
    }

    public double determinant() {
        return this._m11 * this._m22 - this._m12 * this._m21;
    }

    public QMatrix multiply(QMatrix m) {
        double tm11 = this._m11 * m._m11 + this._m12 * m._m21;
        double tm12 = this._m11 * m._m12 + this._m12 * m._m22;
        double tm21 = this._m21 * m._m11 + this._m22 * m._m21;
        double tm22 = this._m21 * m._m12 + this._m22 * m._m22;
        double tdx = this._dx * m._m11 + this._dy * m._m21 + m._dx;
        double tdy = this._dx * m._m12 + this._dy * m._m22 + m._dy;
        return new QMatrix(tm11, tm12, tm21, tm22, tdx, tdy);
    }
}

