/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.qt.QVariant;
import com.mestrelab.components.shared.qt.QVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QList<T>
extends QVariant
implements Serializable,
Iterable<T> {
    private ArrayList<T> qList = new ArrayList();

    public QList() {
    }

    public QList(QList<T> list) {
        this.qList.addAll(list.arrayList());
    }

    public void append(T aData) {
        T variable = aData;
        if (variable instanceof QList) {
            QList<T> newList = new QList<T>();
            newList.arrayList().addAll(((QList)aData).arrayList());
            this.qList.add(newList);
        } else {
            this.qList.add(variable);
        }
    }

    public void append(QList<T> aData) {
        for (int i = 0; i < aData.size(); ++i) {
            this.qList.add(aData.at(i));
        }
    }

    public T at(int i) {
        return this.qList.get(i);
    }

    public QString join(String parameter) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.qList.size(); ++i) {
            result.append(this.qList.get(i).toString()).append(parameter);
        }
        if (result.length() > 0) {
            return new QString(result.substring(0, result.length() - parameter.length()));
        }
        return new QString(result.substring(0));
    }

    public void clear() {
        this.qList.clear();
    }

    public void removeAll(T aItem) {
        if (this.qList.contains(aItem)) {
            int index = this.qList.indexOf(aItem);
            ArrayList<T> delete = new ArrayList<T>();
            delete.add(this.qList.get(index));
            this.qList.removeAll(delete);
        }
    }

    public void removeOne(T aItem) {
        this.qList.remove(aItem);
    }

    public void replace(int aPost, T value) {
        this.qList.set(aPost, value);
    }

    public void removeLast() {
        this.qList.remove(this.qList.size() - 1);
    }

    public int count() {
        return this.qList.size();
    }

    public int count(T elem) {
        int count = 0;
        for (int i = 0; i < this.qList.size(); ++i) {
            if (!this.qList.get(i).equals(elem)) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this.qList.size();
    }

    public boolean isEmpty() {
        return this.qList.isEmpty();
    }

    public void prepend(T aItem) {
        this.insert(0, aItem);
    }

    public void push_back(T aItem) {
        this.append(aItem);
    }

    public T first() {
        return this.qList.get(0);
    }

    public T last() {
        return this.qList.get(this.qList.size() - 1);
    }

    public boolean empty() {
        return this.qList.isEmpty();
    }

    public T end() {
        return this.last();
    }

    public boolean contains(T aItem) {
        return this.qList.contains(aItem);
    }

    public int indexOf(T aItem) {
        if (this.contains(aItem)) {
            return this.qList.indexOf(aItem);
        }
        return -1;
    }

    public int indexOf(T aItem, int aFrom) {
        List<T> sublist = this.qList.subList(aFrom, this.qList.size());
        if (sublist.contains(aItem)) {
            return sublist.indexOf(aItem);
        }
        return -1;
    }

    public void insert(T aItem) {
        this.qList.add(aItem);
    }

    public void insert(int aBefore, T aItem) {
        this.qList.add(aBefore, aItem);
    }

    public void erase(int aPos) {
        this.qList.remove(aPos);
    }

    public void erase(int aFirst, int aLast) {
        aLast = aLast >= this.qList.size() ? this.qList.size() - 1 : aLast;
        for (int i = aFirst = aFirst < 0 ? 0 : aFirst; i < aLast; ++i) {
            this.qList.remove(i);
        }
    }

    public void removeAt(int aPos) {
        this.erase(aPos);
    }

    public T takeAt(int aPos) {
        T result = this.at(aPos);
        this.removeAt(aPos);
        return result;
    }

    public T takeFirst() {
        return this.takeAt(0);
    }

    public T takeLast() {
        return this.takeAt(this.qList.size() - 1);
    }

    public void move(int aFrom, int aTo) {
        if (aFrom < aTo && aFrom < this.qList.size() && aTo < this.qList.size()) {
            this.insert(aTo, this.takeAt(aFrom));
        }
    }

    public QVector<T> toVector() {
        return new QVector(this);
    }

    public ArrayList<T> arrayList() {
        return this.qList;
    }

    @Override
    public Iterator<T> iterator() {
        return this.qList.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qList == null ? 0 : this.qList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QList other = (QList)obj;
        return !(this.qList == null ? other.qList != null : !this.qList.equals(other.qList));
    }

    public QList sameDataIdItems(QUuid selectedDataId) {
        return this;
    }

    public ArrayList getqList() {
        return this.qList;
    }

    public void setqList(ArrayList qList) {
        this.qList = qList;
    }
}

