/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.qt.QPoint;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLineF
implements Serializable {
    private QPoint<Double> pt1;
    private QPoint<Double> pt2;

    public QLineF() {
        this.pt1 = new QPoint<Double>(0.0, 0.0);
        this.pt2 = new QPoint<Double>(0.0, 0.0);
    }

    public QLineF(QPoint<Double> pt1, QPoint<Double> pt2) {
        this.pt1 = new QPoint<Double>(pt1.x(), pt1.y());
        this.pt2 = new QPoint<Double>(pt2.x(), pt2.y());
    }

    public QLineF(double x1, double y1, double x2, double y2) {
        this.pt1 = new QPoint<Double>(x1, y1);
        this.pt2 = new QPoint<Double>(x2, y2);
    }

    public QLineF(QLineF line) {
        this.pt1 = new QPoint<Double>(line.pt1.x(), line.pt1.y());
        this.pt2 = new QPoint<Double>(line.pt2.x(), line.pt2.y());
    }

    public boolean isNull() {
        return this.pt1.equals(this.pt2);
    }

    public double x1() {
        return this.pt1.x();
    }

    public double y1() {
        return this.pt1.y();
    }

    public double x2() {
        return this.pt2.x();
    }

    public double y2() {
        return this.pt2.y();
    }

    public QPoint<Double> p1() {
        return this.pt1;
    }

    public QPoint<Double> p2() {
        return this.pt2;
    }

    public double dx() {
        return this.pt2.x() - this.pt1.x();
    }

    public double dy() {
        return this.pt2.y() - this.pt1.y();
    }

    public IntersectType intersect(QLineF l, QPoint<Double> intersectionPoint) {
        QPoint<Double> a = new QPoint<Double>(this.pt2.x() - this.pt1.x(), this.pt2.y() - this.pt1.y());
        QPoint<Double> b = new QPoint<Double>(l.pt1.x() - l.pt2.x(), l.pt1.y() - l.pt2.y());
        QPoint<Double> c = new QPoint<Double>(this.pt1.x() - l.pt1.x(), this.pt1.y() - l.pt1.y());
        double denominator = a.y() * b.x() - a.x() * b.y();
        if (denominator == 0.0 || Double.isInfinite(denominator)) {
            return IntersectType.NoIntersection;
        }
        double reciprocal = 1.0 / denominator;
        double na = (b.y() * c.x() - b.x() * c.y()) * reciprocal;
        if (intersectionPoint != null) {
            intersectionPoint.setX(this.pt1.x());
            intersectionPoint.setY(this.pt1.y());
            QPoint<Double> aux = new QPoint<Double>(a.x(), a.y());
            aux.setX(a.x() * na);
            aux.setY(a.y() * na);
            intersectionPoint.setX(intersectionPoint.x() + aux.x());
            intersectionPoint.setY(intersectionPoint.y() + aux.y());
        }
        if (na < 0.0 || na > 1.0) {
            return IntersectType.UnboundedIntersection;
        }
        double nb = (a.x() * c.y() - a.y() * c.x()) * reciprocal;
        if (nb < 0.0 || nb > 1.0) {
            return IntersectType.UnboundedIntersection;
        }
        return IntersectType.BoundedIntersection;
    }

    public void translate(QPoint<Double> point) {
        this.pt1.setX(this.pt1.x() + point.x());
        this.pt2.setX(this.pt2.x() + point.x());
        this.pt1.setY(this.pt1.y() + point.y());
        this.pt2.setY(this.pt2.y() + point.y());
    }

    public void translate(double adx, double ady) {
        this.translate(new QPoint<Double>(adx, ady));
    }

    public QLineF translated(QPoint<Double> p) {
        QPoint<Double> newpt1 = new QPoint<Double>(this.pt1.x(), this.pt1.y());
        newpt1.setX(newpt1.x() + p.x());
        newpt1.setY(newpt1.y() + p.y());
        QPoint<Double> newpt2 = new QPoint<Double>(this.pt2.x(), this.pt2.y());
        newpt2.setX(newpt2.x() + p.x());
        newpt2.setY(newpt2.y() + p.y());
        return new QLineF(newpt1, newpt2);
    }

    public QLineF translated(double adx, double ady) {
        return this.translated(new QPoint<Double>(adx, ady));
    }

    public void setP1(QPoint<Double> p1) {
        this.pt1 = new QPoint<Double>(p1.x(), p1.y());
    }

    public void setP2(QPoint<Double> p2) {
        this.pt2 = new QPoint<Double>(p2.x(), p2.y());
    }

    public void setPoints(QPoint<Double> aP1, QPoint<Double> aP2) {
        this.setP1(aP1);
        this.setP2(aP2);
    }

    public void setLine(double aX1, double aY1, double aX2, double aY2) {
        this.pt1 = new QPoint<Double>(aX1, aY1);
        this.pt2 = new QPoint<Double>(aX2, aY2);
    }

    private static double q_rad2deg(double x) {
        return x * 57.29577951308232;
    }

    public double angle() {
        double theta_normalized;
        double dx = this.pt2.x() - this.pt1.x();
        double dy = this.pt2.y() - this.pt1.y();
        double theta = QLineF.q_rad2deg(Math.atan2(-dy, dx));
        double d = theta_normalized = theta < 0.0 ? theta + 360.0 : theta;
        if (theta_normalized == 360.0) {
            return 0.0;
        }
        return theta_normalized;
    }

    public double angle(QLineF l) {
        if (this.isNull() || l.isNull()) {
            return 0.0;
        }
        double cos_line = (this.dx() * l.dx() + this.dy() * l.dy()) / (this.length() * l.length());
        double rad = 0.0;
        if (cos_line >= -1.0 && cos_line <= 1.0) {
            rad = Math.acos(cos_line);
        }
        return QLineF.q_rad2deg(rad);
    }

    public double angleTo(QLineF l) {
        double delta_normalized;
        if (this.isNull() || l.isNull()) {
            return 0.0;
        }
        double a1 = this.angle();
        double a2 = l.angle();
        double delta = a2 - a1;
        double d = delta_normalized = delta < 0.0 ? delta + 360.0 : delta;
        if (delta == 360.0) {
            return 0.0;
        }
        return delta_normalized;
    }

    public double length() {
        double x = this.pt2.x() - this.pt1.x();
        double y = this.pt2.y() - this.pt1.y();
        return Math.sqrt(x * x + y * y);
    }

    private static double q_deg2rad(double x) {
        return x * (Math.PI / 180);
    }

    public void setAngle(double angle) {
        double angleR = QLineF.q_deg2rad(angle);
        double l = this.length();
        double dx = Math.cos(angleR) * l;
        double dy = -Math.sin(angleR) * l;
        this.pt2.setX(this.pt1.x() + dx);
        this.pt2.setY(this.pt1.y() + dy);
    }

    public QLineF normalVector() {
        QPoint<Double> aux = new QPoint<Double>(this.p1().x(), this.p1().y());
        aux.setX(aux.x() + this.dy());
        aux.setY(aux.y() - this.dx());
        return new QLineF(this.p1(), aux);
    }

    public void setLength(double len) {
        if (this.isNull()) {
            return;
        }
        QLineF v = this.unitVector();
        this.pt2 = new QPoint<Double>(this.pt1.x() + v.dx() * len, this.pt1.y() + v.dy() * len);
    }

    public QPoint<Double> pointAt(double t) {
        double vx = this.pt2.x() - this.pt1.x();
        double vy = this.pt2.y() - this.pt1.y();
        return new QPoint<Double>(this.pt1.x() + vx * t, this.pt1.y() + vy * t);
    }

    public QLineF unitVector() {
        double x = this.pt2.x() - this.pt1.x();
        double y = this.pt2.y() - this.pt1.y();
        double len = Math.sqrt(x * x + y * y);
        QLineF f = new QLineF(this.p1(), new QPoint<Double>(this.pt1.x() + x / len, this.pt1.y() + y / len));
        return f;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QLineF other = (QLineF)obj;
        if (this.pt1 == null ? other.pt1 != null : !this.pt1.equals(other.pt1)) {
            return false;
        }
        return !(this.pt2 == null ? other.pt2 != null : !this.pt2.equals(other.pt2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntersectType {
        NoIntersection,
        BoundedIntersection,
        UnboundedIntersection;

    }
}

