/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.qt;

import com.mestrelab.components.shared.qt.QVariant;
import java.io.Serializable;

public class QColor
extends QVariant
implements Serializable {
    public static QColor WHITE = new QColor(255, 255, 255);
    public static QColor LIGHT_GRAY = new QColor(192, 192, 192);
    public static QColor GRAY = new QColor(128, 128, 128);
    public static QColor DARK_GRAY = new QColor(64, 64, 64);
    public static QColor BLACK = new QColor(0, 0, 0);
    public static QColor RED = new QColor(255, 0, 0);
    public static QColor PINK = new QColor(255, 175, 175);
    public static QColor ORANGE = new QColor(255, 200, 0);
    public static QColor YELLOW = new QColor(255, 255, 0);
    public static QColor GREEN = new QColor(0, 255, 0);
    public static QColor MAGENTA = new QColor(255, 0, 255);
    public static QColor CYAN = new QColor(0, 255, 255);
    public static QColor BLUE = new QColor(0, 0, 255);
    public static QColor NONE = new QColor("");
    private String color;
    private int r = -1;
    private int g = -1;
    private int b = -1;
    private double alphaF = 1.0;

    public QColor() {
        this.color = "";
    }

    public QColor(String value) {
        this.color = value;
    }

    public QColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public String getValue() {
        return this.color;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public String getHexValue() {
        if (this.color != null) {
            return this.color;
        }
        return "#" + this.pad(Integer.toHexString(this.r)) + this.pad(Integer.toHexString(this.g)) + this.pad(Integer.toHexString(this.b));
    }

    private String pad(String in) {
        if (in.length() == 0) {
            return "00";
        }
        if (in.length() == 1) {
            return "0" + in;
        }
        return in;
    }

    public String toString() {
        if (this.color != null) {
            return this.color;
        }
        return "red=" + this.r + ", green=" + this.g + ", blue=" + this.b;
    }

    public boolean isValid() {
        return !this.color.isEmpty() || this.r != -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.b;
        result = prime * result + (this.color == null ? 0 : this.color.hashCode());
        result = prime * result + this.g;
        result = prime * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QColor other = (QColor)obj;
        if (this.b != other.b) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }

    public void setAlphaF(double d) {
        this.alphaF = d;
    }

    public double getAlphaF() {
        return this.alphaF;
    }

    public void setColor(String color) {
        this.color = color;
    }
}

