/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared.handler;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.DragEnterEvent;
import com.google.gwt.event.dom.client.DragEnterHandler;
import com.google.gwt.event.dom.client.DragLeaveEvent;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverEvent;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.mestrelab.components.client.PanelMolEditor;
import com.mestrelab.components.client.moleditor.QHelpEvent;
import com.mestrelab.components.client.moleditor.QKeyEvent;
import com.mestrelab.components.client.moleditor.QMouseEvent;
import com.mestrelab.components.client.moleditor.QWheelEvent;
import com.mestrelab.components.client.moleditor.TMoleculePluginGui;
import com.mestrelab.components.client.util.FileUtilDND;
import com.mestrelab.components.client.util.Utils_Molfile;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.event.UploadFileBinaryEvent;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QString;
import java.util.logging.Logger;
import org.vectomatic.dnd.DataTransferExt;
import org.vectomatic.file.Blob;
import org.vectomatic.file.ErrorCode;
import org.vectomatic.file.File;
import org.vectomatic.file.FileError;
import org.vectomatic.file.FileList;
import org.vectomatic.file.FileReader;
import org.vectomatic.file.events.ErrorEvent;
import org.vectomatic.file.events.ErrorHandler;
import org.vectomatic.file.events.LoadEndEvent;
import org.vectomatic.file.events.LoadEndHandler;

public class MolEditorHandler
implements DoubleClickHandler,
MouseDownHandler,
MouseMoveHandler,
MouseOverHandler,
MouseOutHandler,
MouseUpHandler,
MouseWheelHandler,
KeyUpHandler,
KeyDownHandler,
ContextMenuHandler,
DropHandler,
DragEnterHandler,
DragLeaveHandler,
DragOverHandler,
Event.NativePreviewHandler {
    private TMoleculePluginGui plugin;
    private PanelMolEditor panelMolEditor;
    private Logger logger = Logger.getLogger(MolEditorHandler.class.getName());
    private FileReader reader = null;

    public MolEditorHandler(PanelMolEditor panelMoleEditor) {
        this.plugin = panelMoleEditor.gettMoleculePlugin();
        this.panelMolEditor = panelMoleEditor;
        if (FileUtilDND.supportFileAPI()) {
            this.reader = new FileReader();
            this.reader.addLoadEndHandler(new LoadEndHandler(){

                public void onLoadEnd(LoadEndEvent event) {
                    if (MolEditorHandler.this.reader.getError() == null) {
                        String text = MolEditorHandler.this.reader.getStringResult();
                        if (text != null && !text.equals("") && !MolEditorHandler.checkBinary(text)) {
                            QByteArray<QString> aMolContent = new QByteArray<QString>();
                            aMolContent.append(new QString(text));
                            TMolecule molecule = Utils_Molfile.read(aMolContent, false);
                            if (molecule.getAtoms().size() > 0) {
                                MolEditorHandler.this.getPlugin().updateTMolecule(molecule, MolEditorHandler.this.getPlugin().activeMolecule().canvas());
                            }
                        } else if (MolEditorHandler.checkBinary(text)) {
                            MolEditorHandler.this.getPanelMolEditor().getEventBus().fireEvent((GwtEvent)new UploadFileBinaryEvent(text));
                        }
                    }
                }
            });
            this.reader.addErrorHandler(new ErrorHandler(){

                public void onError(ErrorEvent event) {
                }
            });
        }
    }

    public static boolean checkBinary(String content) {
        byte[] data = content.getBytes();
        int ascii = 0;
        int other = 0;
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            if (b < 9) {
                return true;
            }
            if (b == 9 || b == 10 || b == 12 || b == 13) {
                ++ascii;
                continue;
            }
            if (b >= 32 && b <= 126) {
                ++ascii;
                continue;
            }
            ++other;
        }
        if (other == 0) {
            return false;
        }
        return 100 * other / (ascii + other) > 95;
    }

    public void onMouseMove(MouseMoveEvent event) {
        event.preventDefault();
        event.stopPropagation();
        this.plugin.eventMouseMove(new QMouseEvent((MouseEvent)event));
    }

    public void onMouseUp(MouseUpEvent event) {
        event.preventDefault();
        event.stopPropagation();
        if (event.getNativeButton() == 1) {
            this.plugin.eventMouseBtnRelease(new QMouseEvent((MouseEvent)event));
        }
    }

    public void onMouseDown(MouseDownEvent event) {
        event.preventDefault();
        event.stopPropagation();
        if (event.getNativeButton() == 1) {
            this.plugin.eventMouseBtnPress(new QMouseEvent((MouseEvent)event));
        }
    }

    public void onMouseWheel(MouseWheelEvent event) {
        event.preventDefault();
        event.stopPropagation();
        this.plugin.eventWheel(new QWheelEvent(event));
    }

    public void onKeyUp(KeyUpEvent event) {
        event.preventDefault();
        event.stopPropagation();
        NativeEvent ne = event.getNativeEvent();
        if (!ne.getCtrlKey()) {
            this.plugin.eventKeyRelease(new QKeyEvent((KeyEvent)event));
        }
    }

    public void onKeyDown(KeyDownEvent event) {
        event.preventDefault();
        event.stopPropagation();
        NativeEvent ne = event.getNativeEvent();
        if (ne.getCtrlKey() && ne.getKeyCode() == 90) {
            this.plugin.undo();
        } else if (ne.getCtrlKey() && ne.getKeyCode() == 89) {
            this.plugin.redo();
        } else if (!ne.getCtrlKey()) {
            this.plugin.eventShortcutOverride(new QKeyEvent((KeyEvent)event));
        }
    }

    public void onDoubleClick(DoubleClickEvent event) {
        event.preventDefault();
        event.stopPropagation();
        this.plugin.eventMouseDoubleClick(new QMouseEvent((MouseEvent)event));
    }

    public void onContextMenu(ContextMenuEvent event) {
        event.preventDefault();
        event.stopPropagation();
        this.plugin.eventToolTip(new QHelpEvent(event));
    }

    public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        this.plugin.getfFramework().canvasView().canvas().getPainter().setFocus(true);
    }

    public void onMouseOver(MouseOverEvent event) {
        this.plugin.getfFramework().canvasView().canvas().getPainter().setFocus(true);
    }

    public void onMouseOut(MouseOutEvent event) {
        if (this.plugin.getfFramework().canvasView().canvas().getPainter() != null) {
            this.plugin.getfFramework().update();
            this.plugin.getfFramework().canvasView().canvas().getPainter().setFocus(false);
            this.plugin.activeMolecule().invalidate();
            this.plugin.activeMolecule().update();
        }
    }

    private void processFiles(FileList files) {
        if (this.reader != null) {
            for (File file : files) {
                try {
                    File blob = file;
                    this.reader.readAsText((Blob)blob);
                }
                catch (Throwable t) {
                    this.handleError(file);
                }
            }
        }
    }

    private void handleError(File file) {
        if (this.reader != null) {
            ErrorCode errorCode;
            FileError error = this.reader.getError();
            String errorDesc = "";
            if (error != null && (errorCode = error.getCode()) != null) {
                errorDesc = ": " + errorCode.name();
            }
            Window.alert((String)("File loading error for file: " + file.getName() + "\n" + errorDesc));
        }
    }

    public void onDrop(DropEvent event) {
        this.getPanelMolEditor().getLoadingPanel().setVisible(true);
        this.processFiles(((DataTransferExt)event.getDataTransfer().cast()).getFiles());
        this.plugin.activeMolecule().invalidate();
        this.plugin.activeMolecule().update();
        this.getPanelMolEditor().getLoadingPanel().setVisible(false);
        event.preventDefault();
        event.stopPropagation();
    }

    public void onDragEnter(DragEnterEvent event) {
        event.preventDefault();
        event.stopPropagation();
    }

    public void onDragLeave(DragLeaveEvent event) {
        event.preventDefault();
        event.stopPropagation();
    }

    public void onDragOver(DragOverEvent event) {
        event.preventDefault();
        event.stopPropagation();
    }

    public TMoleculePluginGui getPlugin() {
        return this.plugin;
    }

    public PanelMolEditor getPanelMolEditor() {
        return this.panelMolEditor;
    }
}

