/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TAtomData;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondStereo;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TCodeElement;
import com.mestrelab.components.shared.TElement;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TMoleculeAnalyzer;
import com.mestrelab.components.shared.TNeighbour;
import com.mestrelab.components.shared.TPeriodicTable;
import com.mestrelab.components.shared.TStereoDescriptor;
import com.mestrelab.components.shared.qt.QLineF;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.T3DPointF;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TStereoAnalyzer
extends TMoleculeAnalyzer
implements Serializable {
    private TMolecule fMolecule;

    public TStereoAnalyzer() {
    }

    public TStereoAnalyzer(TMolecule aMol) {
        super(aMol);
        this.fMolecule = aMol;
    }

    public static boolean atomNameBetter(QString aElementSymbol1, QString aElementSymbol2) {
        boolean found2;
        if (aElementSymbol1.equals(aElementSymbol2)) {
            return false;
        }
        TElement el1 = TPeriodicTable.getInstance().operatorElementSymbol(aElementSymbol1);
        boolean found1 = el1 == TPeriodicTable.getInstance().nullElement();
        TElement el2 = TPeriodicTable.getInstance().operatorElementSymbol(aElementSymbol2);
        boolean bl = found2 = el2 == TPeriodicTable.getInstance().nullElement();
        if (!found1 && !found2) {
            return el1.getfAtomicNumber() > el2.getfAtomicNumber();
        }
        return false;
    }

    public boolean isStereoUp(TBond aBond) {
        return aBond.bondStereo() == TBondStereo.bsUp;
    }

    public boolean isStereoDown(TBond aBond) {
        return aBond.bondStereo() == TBondStereo.bsDown;
    }

    public boolean isStereoWedge(TBond aBond) {
        return aBond.bondType() == TBondType.btSingle && (aBond.bondStereo() == TBondStereo.bsUp || aBond.bondStereo() == TBondStereo.bsDown);
    }

    public boolean canProcessAtom(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null) {
            return false;
        }
        int nSingle = 0;
        int nDown = 0;
        int nUp = 0;
        for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
            TNeighbour nb = atm.getfNeighbours().at(i);
            if (this.isStereoUp(nb.getfBond())) {
                ++nUp;
                continue;
            }
            if (this.isStereoDown(nb.getfBond())) {
                ++nDown;
                continue;
            }
            if (nb.getfBond().bondType() == TBondType.btSingle) {
                ++nSingle;
                continue;
            }
            return false;
        }
        int nTotal = nUp + nDown + nSingle;
        if (nTotal + atm.nH() != 4) {
            return false;
        }
        if (nUp == 4 || nDown == 4) {
            return false;
        }
        if (nTotal == 4) {
            return true;
        }
        if (nTotal != 3) {
            return false;
        }
        if (nUp == 3 || nDown == 3) {
            return true;
        }
        if (nUp + nDown == 3 || nUp == 1 && nDown == 1 && nSingle == 1) {
            return false;
        }
        return nSingle == 1 && nUp + nDown == 2 || nSingle == 2 && nUp + nDown == 1;
    }

    public boolean isStereoBond(int aIndex1, int aIndex2) {
        TAtom atm1 = this.fMolecule.atom(aIndex1);
        TAtom atm2 = this.fMolecule.atom(aIndex2);
        if (atm1 == null || atm2 == null) {
            return false;
        }
        TBond bnd = this.fMolecule.findBond(aIndex1, aIndex2);
        if (bnd == null || bnd.bondType() != TBondType.btDouble) {
            return false;
        }
        if (bnd.cyclic()) {
            return false;
        }
        TAtom atm = new TAtom();
        for (int time = 0; time < 2; ++time) {
            atm = time != 0 ? atm1 : atm2;
            int nSingle = 0;
            int nDouble = 0;
            for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
                TNeighbour nb = atm.getfNeighbours().at(i);
                if (nb.getfBond().bondType() == TBondType.btDouble) {
                    ++nDouble;
                    continue;
                }
                if (nb.getfBond().bondType() == TBondType.btSingle) {
                    ++nSingle;
                    continue;
                }
                return false;
            }
            if (nSingle == 0 && nDouble == true) continue;
            return false;
        }
        return true;
    }

    public TCodeElement createAndCollectSubcodes(int aIndex) {
        int i;
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null) {
            return new TCodeElement(new QString(""), -1, aIndex, this.fMolecule);
        }
        TCodeElement codeElement = new TCodeElement(atm.elementSymbol(), -1, aIndex, this.fMolecule);
        codeElement.getfWasThere().set(aIndex, 1);
        for (i = 0; i < atm.getfNeighbours().size(); ++i) {
            TNeighbour nb = atm.getfNeighbours().at(i);
            if (nb.getfBond().bondType() != TBondType.btSingle) continue;
            int neighIndex = nb.getfBond().getSecond(aIndex);
            TCodeElement subCode = new TCodeElement(nb.getfAtom().elementSymbol(), aIndex, neighIndex, this.fMolecule);
            subCode.setfWasThere(codeElement.getfWasThere());
            subCode.getfWasThere().set(neighIndex, 2);
            codeElement.addSubCode(subCode);
        }
        for (i = 0; i < atm.nH(); ++i) {
            codeElement.addSubH();
        }
        return codeElement;
    }

    public static int quickCompare(TCodeElement aCodeElement1, TCodeElement aCodeElement2) {
        if (TStereoAnalyzer.atomNameBetter(aCodeElement1.getfName(), aCodeElement2.getfName())) {
            return -1;
        }
        if (TStereoAnalyzer.atomNameBetter(aCodeElement2.getfName(), aCodeElement1.getfName())) {
            return 1;
        }
        return 0;
    }

    public static int compare(TCodeElement aCodeElement1, TCodeElement aCodeElement2, int aStage) {
        int val = TStereoAnalyzer.quickCompare(aCodeElement1, aCodeElement2);
        if (val != 0) {
            return val;
        }
        if (aStage == 0) {
            return 0;
        }
        val = TStereoAnalyzer.subCodesCompare(aCodeElement1.getfSubCodes(), aCodeElement2.getfSubCodes());
        if (val != 0) {
            return val;
        }
        if (aCodeElement1.isfDoNextStep() && !aCodeElement2.isfDoNextStep()) {
            return -1;
        }
        if (!aCodeElement1.isfDoNextStep() && aCodeElement2.isfDoNextStep()) {
            return 1;
        }
        if (!aCodeElement1.isfDoNextStep() && !aCodeElement2.isfDoNextStep()) {
            return 0;
        }
        if (aStage == 1) {
            return 0;
        }
        val = TStereoAnalyzer.subTreeCompare(aCodeElement1, aCodeElement2);
        if (val != 0) {
            return val;
        }
        return 0;
    }

    public static int subCodesCompare(QList<TCodeElement> subCodes1, QList<TCodeElement> subCodes2) {
        int upLim = subCodes1.size();
        if (subCodes2.size() < upLim) {
            upLim = subCodes2.size();
        }
        for (int i = 0; i < upLim; ++i) {
            int val = TStereoAnalyzer.quickCompare(subCodes1.at(i), subCodes2.at(i));
            if (val == 0) continue;
            return val;
        }
        if (subCodes1.size() > subCodes2.size()) {
            return -1;
        }
        if (subCodes1.size() < subCodes2.size()) {
            return 1;
        }
        return 0;
    }

    public static QList<TCodeElement> collectNextLevelSubcodes(QList<TCodeElement> aSubCodes) {
        QList<TCodeElement> res = new QList<TCodeElement>();
        if (aSubCodes.isEmpty()) {
            return res;
        }
        for (int i = 0; i < aSubCodes.size(); ++i) {
            TCodeElement subCode = aSubCodes.at(i);
            if (subCode.canDoNextStep()) {
                subCode.buildSubCodes();
                subCode.buildAndSortSubcodes();
            }
            if (subCode.getfSubCodes().isEmpty()) continue;
            res.append(subCode.getfSubCodes());
        }
        return res;
    }

    public static int subTreeCompare(TCodeElement aCodeElement1, TCodeElement aCodeElement2) {
        QList<TCodeElement> currLevel1 = new QList<TCodeElement>();
        QList<TCodeElement> currLevel2 = new QList<TCodeElement>();
        currLevel1.append(aCodeElement1.getfSubCodes());
        currLevel2.append(aCodeElement2.getfSubCodes());
        while (!currLevel1.isEmpty() && !currLevel2.isEmpty()) {
            int val = TStereoAnalyzer.subCodesCompare(currLevel1, currLevel2);
            if (val != 0) {
                return val;
            }
            currLevel1 = TStereoAnalyzer.collectNextLevelSubcodes(currLevel1);
            currLevel2 = TStereoAnalyzer.collectNextLevelSubcodes(currLevel2);
        }
        return 0;
    }

    public TCodeElement buildStereoTree(int aIndex) {
        TCodeElement codeElement = this.createAndCollectSubcodes(aIndex);
        if (codeElement.getfSubCodes().empty()) {
            return codeElement;
        }
        codeElement.buildAndSortSubcodes();
        return codeElement;
    }

    public QList<T3DPointF> fillLigandsInfo(TCodeElement aCodeElement, double aX, double aY, double aZ) {
        return this.fillLigandsInfo(aCodeElement, aX, aY, aZ, true);
    }

    public QList<T3DPointF> fillLigandsInfo(TCodeElement aCodeElement, double aX, double aY, double aZ, boolean aTurnYCoord) {
        QList<T3DPointF> ligandsInfo = new QList<T3DPointF>();
        TAtom atm = this.fMolecule.atom(aCodeElement.getfCurr());
        if (atm == null || aCodeElement.getfSubCodes().isEmpty()) {
            return ligandsInfo;
        }
        double maxDist = 0.0;
        for (int i = 0; i < aCodeElement.getfSubCodes().size(); ++i) {
            TCodeElement subCode = aCodeElement.getfSubCodes().at(i);
            T3DPointF ligandInfo = new T3DPointF(aX, aY, aZ);
            if (!subCode.isfIsPhantomH() || subCode.isfDoNextStep()) {
                TAtom neigh = null;
                if (subCode.getfCurr() >= 0) {
                    neigh = this.fMolecule.atom(subCode.getfCurr());
                }
                if (neigh != null) {
                    double dist;
                    TBond bnd = this.fMolecule.findBond(aCodeElement.getfCurr(), subCode.getfCurr());
                    if (bnd != null) {
                        double conn = 0.0;
                        if (this.isStereoUp(bnd)) {
                            conn = 1.0;
                        } else if (this.isStereoDown(bnd)) {
                            conn = -1.0;
                        }
                        ligandInfo.setX(neigh.x());
                        ligandInfo.setY(neigh.y());
                        ligandInfo.setZ(conn);
                    }
                    if ((dist = atm.distance(neigh)) > maxDist) {
                        maxDist = dist;
                    }
                }
            }
            ligandsInfo.append(ligandInfo);
        }
        QRectF rect = this.fMolecule.getBound();
        double centerY = rect.center().y();
        for (int i = 0; i < ligandsInfo.size(); ++i) {
            T3DPointF ligandInfo = ligandsInfo.at(i);
            if (aTurnYCoord) {
                ligandInfo.setY(centerY * 2.0 - (Double)ligandInfo.y());
            }
            ligandInfo.setZ(ligandInfo.z() * maxDist);
        }
        return ligandsInfo;
    }

    public double detPrim(double aX1, double aY1, double aX2, double aY2, double aX3, double aY3) {
        return (aX1 - aX3) * (aY2 - aY3) - (aY1 - aY3) * (aX2 - aX3);
    }

    public int getSign(QList<T3DPointF> aLigandsInfo) {
        if (aLigandsInfo == null || aLigandsInfo.size() != 4) {
            return 0;
        }
        T3DPointF c1 = aLigandsInfo.at(0);
        T3DPointF c2 = aLigandsInfo.at(1);
        T3DPointF c3 = aLigandsInfo.at(2);
        T3DPointF c4 = aLigandsInfo.at(3);
        double det1 = this.detPrim((Double)c2.x(), (Double)c2.y(), (Double)c3.x(), (Double)c3.y(), (Double)c4.x(), (Double)c4.y());
        double det2 = this.detPrim((Double)c1.x(), (Double)c1.y(), (Double)c3.x(), (Double)c3.y(), (Double)c4.x(), (Double)c4.y());
        double det3 = this.detPrim((Double)c1.x(), (Double)c1.y(), (Double)c2.x(), (Double)c2.y(), (Double)c4.x(), (Double)c4.y());
        double det4 = this.detPrim((Double)c1.x(), (Double)c1.y(), (Double)c2.x(), (Double)c2.y(), (Double)c3.x(), (Double)c3.y());
        double min = Math.min(Math.abs(det1), Math.min(Math.abs(det2), Math.min(Math.abs(det3), Math.abs(det4))));
        if (min == Math.abs(det1) && min < 0.05 * Math.min(Math.abs(det2), Math.min(Math.abs(det3), Math.abs(det4)))) {
            det1 = 0.0;
        }
        if (min == Math.abs(det2) && min < 0.05 * Math.min(Math.abs(det1), Math.min(Math.abs(det3), Math.abs(det4)))) {
            det2 = 0.0;
        }
        if (min == Math.abs(det3) && min < 0.05 * Math.min(Math.abs(det1), Math.min(Math.abs(det2), Math.abs(det4)))) {
            det3 = 0.0;
        }
        if (min == Math.abs(det4) && min < 0.05 * Math.min(Math.abs(det1), Math.min(Math.abs(det2), Math.abs(det3)))) {
            det4 = 0.0;
        }
        det1 = c1.z() * det1;
        det2 = -c2.z() * det2;
        det3 = c3.z() * det3;
        det4 = -c4.z() * det4;
        if (det1 == 0.0 && det2 == 0.0 && det3 == 0.0 && det4 == 0.0) {
            return 0;
        }
        if (det1 >= 0.0 && det2 >= 0.0 && det3 >= 0.0 && det4 >= 0.0) {
            return -1;
        }
        if (det1 <= 0.0 && det2 <= 0.0 && det3 <= 0.0 && det4 <= 0.0) {
            return 1;
        }
        return 0;
    }

    public TStereoDescriptor makeStereoAtomName(int aIndex) {
        QList<T3DPointF> ligandsInfo;
        if (!this.canProcessAtom(aIndex)) {
            return TStereoDescriptor.sd_None;
        }
        TCodeElement codeElement = this.buildStereoTree(aIndex);
        if (codeElement.getfSubCodes().isEmpty()) {
            return TStereoDescriptor.sd_None;
        }
        if (!codeElement.uniqueSubcodes()) {
            return TStereoDescriptor.sd_None;
        }
        double hZ = 0.0;
        double hY = 0.0;
        double hX = 0.0;
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm != null && atm.nH() > 0) {
            hX = (Double)atm.x();
            hY = (Double)atm.y();
        }
        if ((ligandsInfo = this.fillLigandsInfo(codeElement, hX, hY, hZ)).isEmpty()) {
            return TStereoDescriptor.sd_None;
        }
        int sign = this.getSign(ligandsInfo);
        if (sign == 1) {
            return TStereoDescriptor.sd_SAtom;
        }
        if (sign == -1) {
            return TStereoDescriptor.sd_RAtom;
        }
        return TStereoDescriptor.sd_None;
    }

    public TStereoDescriptor makeStereoBondName(int aIndex1, int aIndex2) {
        TCodeElement codeElement1 = this.buildStereoTree(aIndex1);
        TCodeElement codeElement2 = this.buildStereoTree(aIndex2);
        if (codeElement1.getfSubCodes().isEmpty() || codeElement2.getfSubCodes().empty()) {
            return TStereoDescriptor.sd_None;
        }
        if (!codeElement1.uniqueSubcodes() || !codeElement2.uniqueSubcodes()) {
            return TStereoDescriptor.sd_None;
        }
        int neigh1 = codeElement1.getfSubCodes().at(0).getfCurr();
        int neigh2 = codeElement2.getfSubCodes().at(0).getfCurr();
        if (neigh1 < 0 || neigh2 < 0) {
            return TStereoDescriptor.sd_None;
        }
        return this.calcCisTrans(aIndex1, aIndex2, neigh1, neigh2);
    }

    public boolean hasStereoDescriptors() {
        if (this.fMolecule == null) {
            return false;
        }
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atm = this.fMolecule.atom(i);
            if (atm.getTatomData().stereoDescriptor() == TStereoDescriptor.sd_None) continue;
            return true;
        }
        return false;
    }

    public void stereoBondsProc() {
        if (this.fMolecule == null) {
            return;
        }
        for (int i = 0; i < this.fMolecule.bonds().size(); ++i) {
            TStereoDescriptor descr;
            TBond bnd = this.fMolecule.bond(i);
            if (!this.isStereoBond(bnd.atom1(), bnd.atom2()) || (descr = this.makeStereoBondName(bnd.atom1(), bnd.atom2())) != TStereoDescriptor.sd_EBond && descr != TStereoDescriptor.sd_ZBond) continue;
            this.fMolecule.atom(bnd.atom1()).getTatomData().setStereoDescriptor(descr);
            this.fMolecule.atom(bnd.atom2()).getTatomData().setStereoDescriptor(descr);
        }
    }

    public void stereoAtomProc(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null || atm.getTatomData().stereoDescriptor() != TStereoDescriptor.sd_None) {
            return;
        }
        TStereoDescriptor descr = this.makeStereoAtomName(aIndex);
        if (descr != TStereoDescriptor.sd_None) {
            atm.getTatomData().setStereoDescriptor(descr);
        }
    }

    public void stereoAtomsProc() {
        if (this.getfMolecule() == null) {
            return;
        }
        for (int i = 0; i < this.fMolecule.bonds().size(); ++i) {
            TBond bnd = this.fMolecule.bond(i);
            if (!this.isStereoWedge(bnd)) continue;
            this.stereoAtomProc(bnd.atom1());
            this.stereoAtomProc(bnd.atom2());
        }
    }

    public void clearSetreodescriptors() {
        if (this.fMolecule == null) {
            return;
        }
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atm = this.fMolecule.atom(i);
            atm.getTatomData().deleteData(TAtomData.cStereoDescriptor);
        }
    }

    public void stereoProc() {
        this.detectCyclicBonds();
        this.clearSetreodescriptors();
        this.stereoBondsProc();
        this.stereoAtomsProc();
    }

    public boolean canBeCentralCarbon(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        return atm.isCarbon() && atm.nHAll() <= 1 || atm.isNitrogen() && this.isCyclicAtom(aIndex) && atm.getfCharge() == 1;
    }

    public int findCentralCarbon(boolean aIsAchiral, int aCH2, QVector<Integer> aVect) {
        aIsAchiral = true;
        if (this.fMolecule == null) {
            return -1;
        }
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            if (aVect != null && !aVect.contains(i)) continue;
            TAtom atm = this.fMolecule.atom(i);
            if (!this.canBeCentralCarbon(i)) continue;
            if (atm.getTatomData().stereoDescriptor() == TStereoDescriptor.sd_RAtom || atm.getTatomData().stereoDescriptor() == TStereoDescriptor.sd_SAtom) {
                aIsAchiral = false;
                return i;
            }
            boolean badBondFlag = false;
            for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                TNeighbour nb = atm.getfNeighbours().at(j);
                if (nb.getfBond().bondType() == TBondType.btSingle) continue;
                badBondFlag = true;
                break;
            }
            if (badBondFlag) continue;
            boolean goNext = false;
            for (int j = 0; j < atm.getfNeighbours().size() - 1; ++j) {
                TNeighbour nb1 = atm.getfNeighbours().at(j);
                int neigh1 = nb1.getfBond().getSecond(i);
                for (int k = j + 1; k < atm.getfNeighbours().size(); ++k) {
                    TNeighbour nb2 = atm.getfNeighbours().at(k);
                    int neigh2 = nb2.getfBond().getSecond(i);
                    if (!this.isSymmetricalAtoms(neigh1, neigh2)) continue;
                    if (aCH2 == -1 || this.inOneLigand(i, neigh1, aCH2) || this.inOneLigand(i, neigh2, aCH2)) {
                        return i;
                    }
                    goNext = true;
                }
            }
            if (goNext) continue;
            aIsAchiral = false;
            return i;
        }
        return -1;
    }

    public void addStereoWedge(int aIndex, int aCH2) {
        TBond bnd;
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null) {
            return;
        }
        int nSingle = 0;
        int nDown = 0;
        int nUp = 0;
        for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
            TNeighbour nb = atm.getfNeighbours().at(i);
            if (this.isStereoUp(nb.getfBond())) {
                ++nUp;
                continue;
            }
            if (this.isStereoDown(nb.getfBond())) {
                ++nDown;
                continue;
            }
            if (nb.getfBond().bondType() == TBondType.btSingle) {
                ++nSingle;
                continue;
            }
            return;
        }
        if (nUp != 0 || nDown != 0) {
            return;
        }
        int terminalNeigh = -1;
        int noCH2Neigh = -1;
        for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
            TNeighbour nb = atm.getfNeighbours().at(i);
            int neigh = nb.getfBond().getSecond(aIndex);
            if (terminalNeigh < 0 && this.fMolecule.atom(neigh).getfNeighbours().size() == 1) {
                terminalNeigh = neigh;
            }
            if (noCH2Neigh >= 0 || neigh == aCH2) continue;
            noCH2Neigh = neigh;
        }
        if (terminalNeigh < 0) {
            terminalNeigh = noCH2Neigh;
        }
        if ((bnd = this.fMolecule.findBond(aIndex, terminalNeigh)) != null) {
            bnd.setBondStereo(TBondStereo.bsUp);
        }
    }

    public int getFirstRSAtom() {
        for (int i = 0; i < this.fMolecule.atoms().size(); ++i) {
            TAtom atm = this.fMolecule.atom(i);
            if (atm.getTatomData().stereoDescriptor() != TStereoDescriptor.sd_RAtom && atm.getTatomData().stereoDescriptor() != TStereoDescriptor.sd_SAtom) continue;
            return i;
        }
        return -1;
    }

    public QPoint<Double> calculateNewAtomPos(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        QPoint<Double> atom2 = new QPoint<Double>((Double)atm.x(), (Double)atm.y());
        atom2.setX((Double)atom2.x() + 100.0);
        QLineF bestLine = new QLineF(atm, atom2);
        double maxAngle = 0.0;
        for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
            QLineF line1 = new QLineF(atm, this.fMolecule.atom(atm.getNeighByNum(i, aIndex)));
            double minAngle = 0.0;
            for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                if (i == j) continue;
                QLineF line2 = new QLineF(atm, this.fMolecule.atom(atm.getNeighByNum(j, aIndex)));
                double angle = line1.angleTo(line2);
                if (minAngle == 0.0 && !(angle < minAngle)) continue;
                minAngle = angle;
            }
            if (maxAngle == 0.0 && !(minAngle > maxAngle)) continue;
            maxAngle = minAngle;
            bestLine = line1;
        }
        bestLine.setAngle(bestLine.angle() + maxAngle / 2.0);
        return bestLine.p2();
    }

    public boolean checkDiastereotopicSubstitution(int aCH2, int aCentralCarbon) {
        TNeighbour nb;
        if (this.fMolecule == null) {
            return false;
        }
        TAtom atm = this.fMolecule.atom(aCH2);
        TAtom centralCarbon = this.fMolecule.atom(aCentralCarbon);
        if (atm == null || centralCarbon == null) {
            return false;
        }
        boolean processCarbons = atm.nCH3() == 2;
        int h1 = -1;
        int h2 = -1;
        if (processCarbons) {
            for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
                nb = atm.getfNeighbours().at(i);
                if (!nb.getfAtom().isCH3()) continue;
                if (h1 < 0) {
                    h1 = nb.getfBond().getSecond(aCH2);
                    continue;
                }
                if (h2 >= 0) continue;
                h2 = nb.getfBond().getSecond(aCH2);
            }
        } else {
            for (int i = 0; i < atm.getfNeighbours().size(); ++i) {
                nb = atm.getfNeighbours().at(i);
                if (!nb.getfAtom().isHydrogen()) continue;
                if (h1 < 0) {
                    h1 = nb.getfBond().getSecond(aCH2);
                    continue;
                }
                if (h2 >= 0) continue;
                h2 = nb.getfBond().getSecond(aCH2);
            }
            if (h1 < 0) {
                QPoint<Double> pos = this.calculateNewAtomPos(aCH2);
                this.fMolecule.addNewAtomTo(aCH2, pos, TBondStereo.bsNone);
                h1 = this.fMolecule.atoms().size() - 1;
            }
            if (h2 < 0) {
                QPoint<Double> pos = this.calculateNewAtomPos(aCH2);
                this.fMolecule.addNewAtomTo(aCH2, pos, TBondStereo.bsNone);
                h2 = this.fMolecule.atoms().size() - 1;
            }
        }
        if (h1 < 0 || h2 < 0) {
            return false;
        }
        TBond bnd = this.fMolecule.findBond(aCH2, h1);
        if (bnd != null) {
            bnd.setBondStereo(TBondStereo.bsUp);
        }
        if (processCarbons) {
            this.fMolecule.atom(h1).setElementSymbol(new QString("C"));
        } else {
            this.fMolecule.atom(h1).setElementSymbol(new QString("H"));
        }
        this.fMolecule.atom(h2).setElementSymbol(new QString("D"));
        TStereoDescriptor descrCH2A = this.makeStereoAtomName(aCH2);
        TStereoDescriptor descrCarbonA = this.makeStereoAtomName(aCentralCarbon);
        this.fMolecule.atom(h1).setElementSymbol(new QString("D"));
        if (processCarbons) {
            this.fMolecule.atom(h2).setElementSymbol(new QString("C"));
        } else {
            this.fMolecule.atom(h2).setElementSymbol(new QString("H"));
        }
        TStereoDescriptor descrCH2B = this.makeStereoAtomName(aCH2);
        TStereoDescriptor descrCarbonB = this.makeStereoAtomName(aCentralCarbon);
        if (descrCH2A == TStereoDescriptor.sd_None || descrCarbonA == TStereoDescriptor.sd_None || descrCH2B == TStereoDescriptor.sd_None || descrCarbonB == TStereoDescriptor.sd_None) {
            return false;
        }
        return descrCH2A == descrCH2B && descrCarbonA != descrCarbonB || descrCH2A != descrCH2B && descrCarbonA == descrCarbonB;
    }

    public boolean isDiastereotopic(int aCH2, int aDist) {
        aDist = 0;
        if (this.fMolecule == null) {
            return false;
        }
        this.detectCyclicBonds();
        if (!this.fMolecule.isEnhancedCH2GroupFast(aCH2)) {
            return false;
        }
        TMolecule storeMol = this.fMolecule;
        TMolecule copyMol = new TMolecule(this.fMolecule);
        this.setMolecule(copyMol);
        this.stereoProc();
        boolean res = false;
        QVector<Integer> prev = new QVector<Integer>();
        QVector<Integer> curr = new QVector<Integer>();
        QVector<Integer> next = new QVector();
        curr.append(aCH2);
        while (!curr.isEmpty()) {
            ++aDist;
            boolean isAchiral = false;
            next = this.getNextSphere(prev, curr);
            int centralInd = this.findCentralCarbon(isAchiral, aCH2, next);
            if (centralInd >= 0) {
                this.addStereoWedge(centralInd, aCH2);
                if (isAchiral && this.makeStereoAtomName(centralInd) != TStereoDescriptor.sd_None) {
                    this.setMolecule(storeMol);
                    return false;
                }
                res = this.checkDiastereotopicSubstitution(aCH2, centralInd);
                break;
            }
            prev = curr;
            curr = next;
        }
        this.setMolecule(storeMol);
        return res;
    }

    public int isEnhancedCH2Group(int aIndex) {
        if (this.fMolecule == null || !this.fMolecule.isEnhancedCH2GroupFast(aIndex)) {
            return 0;
        }
        this.detectCyclicBonds();
        if (this.isCyclicAtom(aIndex)) {
            return 2;
        }
        return 1;
    }

    public TMolecule getfMolecule() {
        return this.fMolecule;
    }

    public void setMolecule(TMolecule molecule) {
        this.fMolecule = molecule;
    }
}

