/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TAtomIndex;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QString;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TProtonNotation implements Serializable
{
    pn_First(0),
    pn_QUOTES(0),
    pn_AB(1),
    pn_ALPHABETA(2),
    pn_CISTRANS(3),
    pn_AXIALEQUATORIAL(4),
    pn_Last(4);

    private int value;

    private TProtonNotation(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    public char toAbc(QString aNotationStr) {
        if (aNotationStr.toString() == "a" || aNotationStr.toString() == "'" || aNotationStr.toString() == TProtonNotation.alphaStr().toString() || aNotationStr.toString() == "cis" || aNotationStr.toString() == "ax" || aNotationStr.toString() == "alpha") {
            return 'a';
        }
        if (aNotationStr.toString() == "b" || aNotationStr.toString() == "''" || aNotationStr.toString() == TProtonNotation.betaStr().toString() || aNotationStr.toString() == "trans" || aNotationStr.toString() == "eq" || aNotationStr.toString() == "beta") {
            return 'b';
        }
        return TAtomIndex.cHeavyHIndex;
    }

    public static QString alphaStr() {
        String alpha = new String("\u03b1");
        QString result = new QString(alpha);
        result.setUtf16(alpha, 1);
        return result;
    }

    public static QString betaStr() {
        String beta = new String("\u03b2");
        QString result = new QString(beta);
        result.setUtf16(beta, 1);
        return result;
    }

    public static QList<QString> allProtonLabels(int aHIndex) {
        QList<QString> labels = new QList<QString>();
        for (int c = pn_First.getValue(); c <= pn_Last.getValue(); ++c) {
            labels.append(TProtonNotation.protonLabel(c, aHIndex));
        }
        return labels;
    }

    public static QString protonLabel(int aNotation, int aHIndex) {
        switch (aNotation) {
            case 0: {
                if (aHIndex == 1) {
                    return new QString("'");
                }
                if (aHIndex == 2) {
                    return new QString("''");
                }
                return new QString("'''");
            }
            case 1: {
                if (aHIndex == 1) {
                    return new QString("a");
                }
                if (aHIndex == 2) {
                    return new QString("b");
                }
                return new QString("c");
            }
            case 2: {
                return aHIndex == 1 ? TProtonNotation.alphaStr() : TProtonNotation.betaStr();
            }
            case 3: {
                return aHIndex == 1 ? new QString("cis") : new QString("trans");
            }
            case 4: {
                return aHIndex == 1 ? new QString("ax") : new QString("eq");
            }
        }
        return TProtonNotation.protonLabel(pn_QUOTES.getValue(), aHIndex);
    }

    public static TProtonNotation strToNotation(QString aNotationStr) {
        if (aNotationStr.isEmpty() || aNotationStr.toString() == "'" || aNotationStr.toString() == "''") {
            return pn_QUOTES;
        }
        if (aNotationStr.toString() == "a" || aNotationStr.toString() == "b") {
            return pn_AB;
        }
        if (aNotationStr.toString() == TProtonNotation.alphaStr().toString() || aNotationStr.toString() == TProtonNotation.betaStr().toString() || aNotationStr.toString() == "alpha" || aNotationStr.toString() == "beta") {
            return pn_ALPHABETA;
        }
        if (aNotationStr.toString() == "cis" || aNotationStr.toString() == "trans") {
            return pn_CISTRANS;
        }
        if (aNotationStr.toString() == "ax" || aNotationStr.toString() == "eq") {
            return pn_AXIALEQUATORIAL;
        }
        return pn_QUOTES;
    }

    public static QList<Integer> sortedNotation(int aFirstNotation) {
        QList<Integer> sorted = new QList<Integer>();
        sorted.append(aFirstNotation);
        for (int c = pn_First.getValue(); c <= pn_Last.getValue(); ++c) {
            if (sorted.contains(c)) continue;
            sorted.append(c);
        }
        return sorted;
    }

    public static QList<QString> allProtonLabel(int aHIndex) {
        QList<QString> labels = new QList<QString>();
        for (int c = pn_First.getValue(); c <= pn_Last.getValue(); ++c) {
            labels.append(TProtonNotation.protonLabel(c, aHIndex));
        }
        return labels;
    }
}

