/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.IQString;
import com.mestrelab.components.shared.ITBracket;
import com.mestrelab.components.shared.ITPolymer;
import com.mestrelab.components.shared.TBracket;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.TDataStream;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TPolymer
implements Serializable,
ITPolymer {
    private int num;
    private QString sgType;
    private QString sgSubType;
    private int sgCompNum;
    private QString sgConn;
    private int sgBrStyle;
    private QString sgSubscript;
    private QList<TBracket> brackets;
    private int sgLabels;
    private QString sgAtomList;
    private QString spAtomList;
    private QString sgBondList;
    private QString sgDataDescription;
    private QString sgDataDisplay;
    private QString sgDataEnd;

    public TPolymer() {
        this.num = 0;
        this.sgType = new QString();
        this.sgSubType = new QString();
        this.sgCompNum = 0;
        this.sgConn = new QString();
        this.sgBrStyle = 0;
        this.sgSubscript = new QString();
        this.brackets = new QList();
        this.sgLabels = 0;
        this.sgAtomList = new QString();
        this.spAtomList = new QString();
        this.sgBondList = new QString();
        this.sgDataDescription = new QString();
        this.sgDataDisplay = new QString();
        this.sgDataEnd = new QString();
    }

    public TPolymer(int aNum) {
        this.num = aNum;
        this.sgType = new QString();
        this.sgSubType = new QString();
        this.sgCompNum = 0;
        this.sgConn = new QString();
        this.sgBrStyle = 0;
        this.sgSubscript = new QString();
        this.brackets = new QList();
        this.sgLabels = 0;
        this.sgAtomList = new QString();
        this.spAtomList = new QString();
        this.sgBondList = new QString();
        this.sgDataDescription = new QString();
        this.sgDataDisplay = new QString();
        this.sgDataEnd = new QString();
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QString getBottomText() {
        if (this.sgType.toString().equals("ANY")) {
            return new QString("anyp");
        }
        if (this.sgType.toString().equals("COP")) {
            if (this.sgSubType.toString().equals("ALT")) {
                return new QString("alt");
            }
            if (this.sgSubType.toString().equals("BLO")) {
                return new QString("blk");
            }
            if (this.sgSubType.toString().equals("RAN")) {
                return new QString("ran");
            }
            return new QString("co");
        }
        if (this.sgType.toString().equals("CRO")) {
            return new QString("xl");
        }
        if (this.sgType.toString().equals("GRA")) {
            return new QString("grf");
        }
        if (this.sgType.toString().equals("MER")) {
            return new QString("mer");
        }
        if (this.sgType.toString().equals("FOR")) {
            return new QString("f");
        }
        if (this.sgType.toString().equals("MIX")) {
            return new QString("mix");
        }
        if (this.sgType.toString().equals("MOD")) {
            return new QString("mod");
        }
        if (this.sgType.toString().equals("MON")) {
            return new QString("mon");
        }
        if (this.sgType.toString().equals("COM")) {
            if (this.sgCompNum != 0) {
                return new QString("c" + this.sgCompNum);
            }
            return new QString("c");
        }
        if (this.sgType.toString().equals("SRU")) {
            if (this.sgSubscript.isEmpty()) {
                return new QString("n");
            }
            return this.sgSubscript;
        }
        if (this.sgType.toString().equals("MUL")) {
            return this.sgSubscript;
        }
        return new QString("");
    }

    public QString getTopText() {
        if (this.sgConn.toString().equals("HH")) {
            return new QString("hh");
        }
        if (this.sgConn.toString().equals("EU")) {
            return new QString("eu");
        }
        return new QString("");
    }

    public QList<Integer> getAtomList(boolean aParentAtoms) {
        QString str = new QString();
        str = aParentAtoms ? this.spAtomList : this.sgAtomList;
        QList<Integer> lst = new QList<Integer>();
        for (int n = 0; n < (str.size() - 2) / 4; ++n) {
            boolean ok = false;
            int num = str.mid(2 + n * 4, 4).toInt();
            if (!ok) continue;
            lst.append(num - 1);
        }
        return lst;
    }

    public QString typeForExport() {
        if (this.sgType.toString().equals("MUL")) {
            return new QString("SRU");
        }
        return this.sgType;
    }

    public void mergeAtomList(QString aList, boolean aParentAtoms) {
        if (aList.isEmpty()) {
            return;
        }
        QString dest = null;
        dest = aParentAtoms ? this.spAtomList : this.sgAtomList;
        if (dest.isEmpty()) {
            dest = aList;
        } else {
            boolean ok1 = false;
            boolean ok2 = false;
            int n1 = dest.mid(0, 2).toInt();
            int n2 = aList.mid(0, 2).toInt();
            if (!ok1 || !ok2) {
                return;
            }
            dest = new QString(new String("" + (n1 + n2)).concat(dest.mid(2).toString()).concat(aList.mid(2).toString()));
        }
        if (aParentAtoms) {
            this.spAtomList = dest;
        } else {
            this.sgAtomList = dest;
        }
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public QString getSgType() {
        return this.sgType;
    }

    public void setSgType(QString sgType) {
        this.sgType = sgType;
    }

    public QString getSgSubType() {
        return this.sgSubType;
    }

    public void setSgSubType(QString sgSubType) {
        this.sgSubType = sgSubType;
    }

    public int getSgCompNum() {
        return this.sgCompNum;
    }

    public void setSgCompNum(int sgCompNum) {
        this.sgCompNum = sgCompNum;
    }

    public QString getSgConn() {
        return this.sgConn;
    }

    public void setSgConn(QString sgConn) {
        this.sgConn = sgConn;
    }

    public int getSgBrStyle() {
        return this.sgBrStyle;
    }

    public void setSgBrStyle(int sgBrStyle) {
        this.sgBrStyle = sgBrStyle;
    }

    public QString getSgSubscript() {
        return this.sgSubscript;
    }

    public void setSgSubscript(QString sgSubscript) {
        this.sgSubscript = sgSubscript;
    }

    public QList<TBracket> getBrackets() {
        return this.brackets;
    }

    public void setBrackets(QList<TBracket> brackets) {
        this.brackets = brackets;
    }

    public int getSgLabels() {
        return this.sgLabels;
    }

    public void setSgLabels(int sgLabels) {
        this.sgLabels = sgLabels;
    }

    public QString getSgAtomList() {
        return this.sgAtomList;
    }

    public void setSgAtomList(QString sgAtomList) {
        this.sgAtomList = sgAtomList;
    }

    public QString getSpAtomList() {
        return this.spAtomList;
    }

    public void setSpAtomList(QString spAtomList) {
        this.spAtomList = spAtomList;
    }

    public QString getSgBondList() {
        return this.sgBondList;
    }

    public void setSgBondList(QString sgBondList) {
        this.sgBondList = sgBondList;
    }

    public QString getSgDataDescription() {
        return this.sgDataDescription;
    }

    public void setSgDataDescription(QString sgDataDescription) {
        this.sgDataDescription = sgDataDescription;
    }

    public QString getSgDataDisplay() {
        return this.sgDataDisplay;
    }

    public void setSgDataDisplay(QString sgDataDisplay) {
        this.sgDataDisplay = sgDataDisplay;
    }

    public QString getSgDataEnd() {
        return this.sgDataEnd;
    }

    public void setSgDataEnd(QString sgDataEnd) {
        this.sgDataEnd = sgDataEnd;
    }

    @Override
    public List<ITBracket> getBracketsAB() {
        return this.brackets.getqList();
    }

    @Override
    public int getNumAB() {
        return this.getNum();
    }

    @Override
    public IQString getSgAtomListAB() {
        return this.getSgAtomList();
    }

    @Override
    public IQString getSgBondListAB() {
        return this.getSgBondList();
    }

    @Override
    public int getSgBrStyleAB() {
        return this.getSgBrStyle();
    }

    @Override
    public int getSgCompNumAB() {
        return this.getSgCompNum();
    }

    @Override
    public IQString getSgConnAB() {
        return this.getSgConn();
    }

    @Override
    public int getSgLabelsAB() {
        return this.getSgLabels();
    }

    @Override
    public IQString getSgSubTypeAB() {
        return this.getSgSubType();
    }

    @Override
    public IQString getSgSubscriptAB() {
        return this.getSgSubscript();
    }

    @Override
    public IQString getSgTypeAB() {
        return this.getSgType();
    }

    @Override
    public IQString getSpAtomListAB() {
        return this.getSpAtomList();
    }

    @Override
    public void setBracketsAB(List<ITBracket> list) {
        this.brackets.clear();
        this.brackets.getqList().addAll(list);
    }

    @Override
    public void setNumAB(int value) {
        this.setNum(value);
    }

    @Override
    public void setSgAtomListAB(IQString value) {
        this.setSgAtomList((QString)value);
    }

    @Override
    public void setSgBondListAB(IQString value) {
        this.setSgBondList((QString)value);
    }

    @Override
    public void setSgBrStyleAB(int value) {
        this.setSgBrStyle(value);
    }

    @Override
    public void setSgCompNumAB(int value) {
        this.setSgCompNum(value);
    }

    @Override
    public void setSgConnAB(IQString value) {
        this.setSgConn((QString)value);
    }

    @Override
    public void setSgLabelsAB(int value) {
        this.setSgLabels(value);
    }

    @Override
    public void setSgSubTypeAB(IQString value) {
        this.setSgSubType((QString)value);
    }

    @Override
    public void setSgSubscriptAB(IQString value) {
        this.setSgSubscript((QString)value);
    }

    @Override
    public void setSgTypeAB(IQString value) {
        this.setSgType((QString)value);
    }

    @Override
    public void setSpAtomListAB(IQString value) {
        this.setSpAtomList((QString)value);
    }

    @Override
    public IQString getSgDataDescriptionAB() {
        return this.getSgDataDescription();
    }

    @Override
    public void setSgDataDescriptionAB(IQString value) {
        this.setSgDataDescription((QString)value);
    }

    @Override
    public IQString getSgDataDisplayAB() {
        return this.getSgDataDisplay();
    }

    @Override
    public void setSgDataDisplayAB(IQString value) {
        this.setSgDataDisplay((QString)value);
    }

    @Override
    public IQString getSgDataEndAB() {
        return this.getSgDataEnd();
    }

    @Override
    public void setSgDataEndAB(IQString value) {
        this.setSgDataEnd((QString)value);
    }
}

