/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TMacroDef;
import com.mestrelab.components.shared.TMacroParser;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMoleculeLabelParser
extends TMacroParser {
    private TMolecule fMolecule;
    private static QMap<QString, TMacroDef> fStaticMacros = new QMap();

    public TMoleculeLabelParser(TMolecule aMol) {
        this.setfMolecule(aMol);
        this.macros();
    }

    public QMap<QString, TMacroDef> macros() {
        if (this.macrosMap.isEmpty()) {
            this.macrosMap.insert(new QString("MF"), new TMacroDef("Molecular Formula", "The molecular formula."));
            this.macrosMap.insert(new QString("AvMass"), new TMacroDef("Average Mass", "The average mass."));
            this.macrosMap.insert(new QString("MonoMass"), new TMacroDef("Monoisotopic Mass", "The monoisotopic mass."));
        }
        return this.macrosMap;
    }

    @Override
    public QString getMacroValue(QString aName, QList<QString> aArgs) {
        if (aName.toString().equals("MF")) {
            return this.fMolecule.molecularFormula();
        }
        if (aName.toString().equals("AvMass")) {
            return new QString("" + this.fMolecule.averageMass());
        }
        if (aName.toString().equals("MonoMass")) {
            return new QString("" + this.fMolecule.monoisotopicMass());
        }
        return null;
    }

    public TMolecule getfMolecule() {
        return this.fMolecule;
    }

    public void setfMolecule(TMolecule fMolecule) {
        this.fMolecule = fMolecule;
    }
}

