/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TAromPattern;
import com.mestrelab.components.shared.TAromaElement;
import com.mestrelab.components.shared.TAromaPattern;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TAtomInfo;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TCouplingInfo;
import com.mestrelab.components.shared.TLabelFileLoader;
import com.mestrelab.components.shared.TLabileProtonGroup;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TNeighbour;
import com.mestrelab.components.shared.TStereoDescriptor;
import com.mestrelab.components.shared.TSubstutuent;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.UtilGeometry;
import java.io.Serializable;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMoleculeAnalyzer
implements Serializable {
    private TMolecule fMolecule;
    private QMap<QString, TCouplingInfo> fCouplingInfoTable;
    private boolean fCheckStereo;
    private boolean fProcessQueryAtoms;
    private static TLabelFileLoader labelFileLoader;

    public TMoleculeAnalyzer() {
    }

    public TMoleculeAnalyzer(TMolecule molecule) {
        this.fMolecule = molecule;
        this.fCouplingInfoTable = new QMap();
        this.fCheckStereo = false;
        this.fProcessQueryAtoms = false;
        labelFileLoader = new TLabelFileLoader();
    }

    public int bondCompareForNumbering(TBond bnd1, TBond bnd2) {
        if (bnd1.cyclic() != bnd2.cyclic()) {
            if (bnd1.cyclic()) {
                return -1;
            }
            return 1;
        }
        if (!bnd1.cyclic() && !bnd2.cyclic() && bnd1.bondType() != bnd2.bondType()) {
            switch (bnd1.bondType()) {
                case btSingle: {
                    if (bnd2.bondType() == TBondType.btTriple) {
                        return -1;
                    }
                    return 1;
                }
                case btDouble: {
                    return -1;
                }
                case btTriple: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    public boolean betterThan(TAtomInfo first, TAtomInfo other, int atomFrom) {
        if (first.getfElementSymbol().toString().equals("H") != other.getfElementSymbol().toString().equals("H")) {
            return !first.getfElementSymbol().toString().equals("H");
        }
        if (first.isfCyclicAtom() != other.isfCyclicAtom()) {
            return first.isfCyclicAtom();
        }
        if (!first.getfElementSymbol().toString().equals(other.getfElementSymbol())) {
            return first.getfElementSymbol().toString().compareTo(other.getfElementSymbol().toString()) > 0;
        }
        if (atomFrom != -1) {
            int bc;
            TBond bnd1 = this.fMolecule.findBond(atomFrom, first.getfAtomIndex());
            TBond bnd2 = this.fMolecule.findBond(atomFrom, other.getfAtomIndex());
            if (bnd1 != null && bnd2 != null && !this.bondsEqual(bnd1, bnd2, true) && (bc = this.bondCompareForNumbering(bnd1, bnd2)) != 0) {
                return bc < 0;
            }
        }
        if (first.getfClassNumber() != other.getfClassNumber()) {
            return first.getfClassNumber() > other.getfClassNumber();
        }
        if (first.getfNH() != other.getfNH()) {
            return first.getfNH() < other.getfNH();
        }
        return first.getfAtomIndex() < other.getfAtomIndex();
    }

    boolean atomsEqual(TAtom aAt1, TAtom aAt2) {
        return aAt1.getfCharge() == aAt2.getfCharge() && aAt1.getfIsotope() == aAt2.getfIsotope() && aAt1.getfValence() == aAt2.getfValence() && aAt1.nHAll() == aAt2.nHAll() && aAt1.elementSymbol().toString().equals(aAt2.elementSymbol().toString());
    }

    boolean bondsEqual(TBond aBond1, TBond aBond2, boolean aForEqual) {
        boolean checkCyclic = aForEqual && aBond1.cyclic() == aBond2.cyclic() || !aForEqual && (!aBond2.cyclic() || aBond1.cyclic());
        boolean checkStereo = aBond1.bondStereo() == aBond2.bondStereo() || !aForEqual;
        return (aBond1.bondType() == aBond2.bondType() || aBond1.aromatic() && aBond2.aromatic()) && checkStereo && checkCyclic;
    }

    boolean isConnected(int aN1, int aN2) {
        return this.fMolecule.findBond(aN1, aN2) != null;
    }

    boolean isGoodRingClosure(TAtom aAt2, QVector<Integer> aUse2, int aN1, int aN2, boolean aForEqual) {
        for (TNeighbour nb : aAt2.getfNeighbours()) {
            int neigh = nb.getfBond().getSecond(aN2);
            if (neigh <= -1 || aUse2.get(neigh) == null || aUse2.get(neigh) <= -1 || this.isConnected(aN1, aUse2.get(neigh)) && (aForEqual || this.bondsEqual(this.fMolecule.findBond(aN1, aUse2.get(neigh)), nb.getfBond(), aForEqual))) continue;
            return false;
        }
        return true;
    }

    public int specialNeighsCount(TAtom aAtom, int nAtom, QVector<Integer> aUse, int aMark) {
        int n = 0;
        int _size = aAtom.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            int neigh = aAtom.getNeighByNum(i, nAtom);
            if (neigh < 0 || aUse.get(neigh) != aMark) continue;
            ++n;
        }
        return n;
    }

    public int unprocessedNeighsCount(TAtom aAtom, int nAtom, QVector<Integer> aUse) {
        return this.specialNeighsCount(aAtom, nAtom, aUse, -1);
    }

    public int skipedNeighsCount(TAtom aAtom, int nAtom, QVector<Integer> aUse) {
        return this.specialNeighsCount(aAtom, nAtom, aUse, -3);
    }

    public int getNextUnprocessedNeigh(TAtom aAtom, int nAtom, int aStartFrom, QVector<Integer> aUse) {
        int _size = aAtom.getfNeighbours().size();
        for (int i = aStartFrom; i < _size; ++i) {
            int neigh = aAtom.getNeighByNum(i, nAtom);
            if (neigh < 0 || aUse.get(neigh) != null && aUse.get(neigh) != -1) continue;
            return i;
        }
        return -1;
    }

    public int getPrevUnprocessedNeigh(TAtom aAtom, int nAtom, int aStartFrom, QVector<Integer> aUse) {
        for (int i = aStartFrom; i >= 0; --i) {
            int neigh = aAtom.getNeighByNum(i, nAtom);
            if (neigh < 0 || aUse.get(neigh) != null && aUse.get(neigh) != -1) continue;
            return i;
        }
        return -1;
    }

    public void markExplicitHydrogens(TMolecule aM, QVector<Integer> aUse) {
        int _size = aM.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = aM.atom(i);
            if (!atm.isHydrogen()) continue;
            aUse.set(i, -2);
        }
    }

    public boolean mEqual(TMolecule aM, QVector<Integer> aUse1, QVector<Integer> aUse2, int aN1, int aN2) {
        TAtom atm2;
        TAtom atm1 = this.fMolecule.atom(aN1);
        if (!this.atomsEqual(atm1, atm2 = aM.atom(aN2))) {
            return false;
        }
        if (!this.isGoodRingClosure(atm2, aUse2, aN1, aN2, true)) {
            return false;
        }
        aUse1.set(aN1, aN2);
        aUse2.set(aN2, aN1);
        int ns1 = this.unprocessedNeighsCount(atm1, aN1, aUse1);
        int ns2 = this.unprocessedNeighsCount(atm2, aN2, aUse2);
        if (ns1 == 0 && ns2 == 0) {
            return true;
        }
        int nSkiped = this.skipedNeighsCount(atm2, aN2, aUse2);
        if (ns2 == 0 && nSkiped != 0) {
            return true;
        }
        if (ns1 != ns2 + nSkiped) {
            return false;
        }
        QVector<Integer> tempUse1 = new QVector(this.fMolecule.atoms().count());
        QVector<Integer> tempUse2 = new QVector(aM.atoms().count());
        int nNotFound = 0;
        int _size = atm1.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            TBond bond1 = atm1.getfNeighbours().at(i).getfBond();
            int neigh1 = atm1.getNeighByNum(i, aN1);
            if (neigh1 < 0 || aUse1.get(neigh1) != null && aUse1.get(neigh1) != -1) continue;
            boolean equalWasFound = false;
            int _size1 = atm2.getfNeighbours().size();
            for (int j = 0; j < _size1; ++j) {
                TBond bond2 = atm2.getfNeighbours().at(j).getfBond();
                int neigh2 = atm2.getNeighByNum(j, aN2);
                if (neigh2 < 0 || aUse2.get(neigh2) != null && aUse2.get(neigh2) != -1 || !this.bondsEqual(bond1, bond2, true) || !this.mEqual(aM, tempUse1 = new QVector<Integer>(aUse1), tempUse2 = new QVector<Integer>(aUse2), neigh1, neigh2)) continue;
                aUse1 = new QVector<Integer>(tempUse1);
                aUse2 = new QVector<Integer>(tempUse2);
                equalWasFound = true;
                break;
            }
            if (equalWasFound || ++nNotFound <= nSkiped) continue;
            return false;
        }
        return true;
    }

    public boolean compareByShells(TMolecule aM, int aIndex1, int aIndex2, int aNShell, boolean aEndReached, boolean aExactSearch, int aStartShell) {
        aNShell = 0;
        aEndReached = false;
        QVector<Integer> aUse1 = new QVector<Integer>(this.fMolecule.atoms().count(), -1);
        QVector<Integer> aUse2 = new QVector<Integer>(aM.atoms().count(), -3);
        this.markExplicitHydrogens(this.fMolecule, aUse1);
        this.markExplicitHydrogens(aM, aUse2);
        QVector<Integer> storeUse1 = aUse1;
        QVector<Integer> storeUse2 = aUse2;
        for (aNShell = aStartShell; aNShell <= 5 && !aEndReached; ++aNShell) {
            boolean containsFlag;
            boolean nextShell = this.markShells(aM, aUse2, aIndex2, aNShell);
            boolean bl = containsFlag = aExactSearch && this.mEqual(aM, aUse1, aUse2, aIndex1, aIndex2) || !aExactSearch && this.mContain(aM, aUse1, aUse2, aIndex1, aIndex2);
            if (!nextShell || !containsFlag) {
                boolean bl2 = aEndReached = !nextShell && containsFlag;
                if (!containsFlag) {
                    --aNShell;
                }
                return aNShell > 0;
            }
            aUse1 = storeUse1;
            aUse2 = storeUse2;
        }
        aNShell = 5;
        return true;
    }

    public boolean equal(TMolecule aM) {
        if (this.fMolecule.heavyAtomsCount() != aM.heavyAtomsCount()) {
            return false;
        }
        QVector<Integer> aUse1 = new QVector<Integer>(this.fMolecule.atoms().count(), -1);
        QVector<Integer> aUse2 = new QVector<Integer>(aM.atoms().count(), -1);
        this.markExplicitHydrogens(this.fMolecule, aUse1);
        this.markExplicitHydrogens(aM, aUse2);
        while (aUse1.contains(-1)) {
            int j = aUse1.indexOf(-1);
            boolean equalFound = false;
            for (int i = 0; i < aM.atoms().count(); ++i) {
                if (aUse2.get(i) != null && aUse2.get(i) != -1) continue;
                if (this.mEqual(aM, aUse1, aUse2, j, i)) {
                    equalFound = true;
                    break;
                }
                aUse2.set(i, -1);
            }
            if (equalFound) continue;
            return false;
        }
        return true;
    }

    public boolean atomsGreater(TAtom aAt1, TAtom aAt2, int aN1) {
        if (aAt2.isRXAtom()) {
            return !aAt1.isHydrogen();
        }
        if (aAt2.isAromaRadical()) {
            return this.fMolecule.isAromaticAtom(aN1);
        }
        if (aAt2.isAlkyl()) {
            return this.isAlkyl(aN1);
        }
        int explHCount = aAt2.nExplicitH();
        if (explHCount > aAt1.nHAll()) {
            return false;
        }
        return aAt1.getfCharge() == aAt2.getfCharge() && aAt1.getfIsotope() == aAt2.getfIsotope() && aAt1.getfValence() == aAt2.getfValence() && aAt1.elementSymbol().toString().equals(aAt2.elementSymbol().toString()) && aAt1.heavyNeighsCount() >= aAt2.heavyNeighsCount() && (aAt1.getTatomData().stereoDescriptor() == aAt2.getTatomData().stereoDescriptor() || !this.fCheckStereo);
    }

    public boolean mContain(TMolecule aSubM, QVector<Integer> aUse1, QVector<Integer> aUse2, int aN1, int aN2) {
        TAtom atm2;
        if (aN2 == -1) {
            return true;
        }
        if (aUse1.get(aN1) != null && aUse1.get(aN1) >= 0 || aUse2.get(aN2) != null && aUse2.get(aN2) >= 0) {
            return aUse1.get(aN1) == aN2 && aUse2.get(aN2) == aN1;
        }
        TAtom atm1 = this.fMolecule.atom(aN1);
        if (!this.atomsGreater(atm1, atm2 = aSubM.atom(aN2), aN1)) {
            return false;
        }
        if (!this.isGoodRingClosure(atm2, aUse2, aN1, aN2, false)) {
            return false;
        }
        aUse1.set(aN1, aN2);
        aUse2.set(aN2, aN1);
        int i = atm1.heavyNeighsCount();
        int j = atm2.heavyNeighsCount();
        int ns1 = this.unprocessedNeighsCount(atm1, aN1, aUse1);
        int ns2 = this.unprocessedNeighsCount(atm2, aN2, aUse2);
        if ((j -= ns2) > 1 && (i -= ns1) < j && this.skipedNeighsCount(atm2, aN2, aUse2) == 0) {
            return false;
        }
        if (ns2 == 0) {
            return true;
        }
        QVector<Integer> check = new QVector<Integer>(atm2.getfNeighbours().size(), -1);
        QVector<Boolean> useNb = new QVector<Boolean>(atm1.getfNeighbours().size(), false);
        QMap<Integer, QVector> tempUse1 = new QMap<Integer, QVector>();
        QMap<Integer, QVector> tempUse2 = new QMap<Integer, QVector>();
        j = this.getNextUnprocessedNeigh(atm2, aN2, 0, aUse2);
        if (j < 0) {
            return false;
        }
        tempUse1.add(j, aUse1);
        tempUse2.add(j, aUse2);
        boolean nextI = false;
        int neigh1 = 0;
        int neigh2 = 0;
        while (j < atm2.getfNeighbours().size()) {
            int k;
            if (!nextI) {
                neigh2 = atm2.getNeighByNum(j, aN2);
                if (neigh2 < 0 || aUse2.get(neigh2) != -1) {
                    ++j;
                    continue;
                }
                i = check.get(j) + 1;
            }
            nextI = false;
            boolean b = true;
            useNb.fill(false);
            for (k = 0; k < atm2.getfNeighbours().size(); ++k) {
                if (check.get(k) <= -1) continue;
                useNb.set(check.get(k), true);
            }
            while (i < atm1.getfNeighbours().size() && b) {
                neigh1 = atm1.getNeighByNum(i, aN1);
                if (!useNb.get(i).booleanValue() && neigh1 >= 0 && (Integer)aUse1.get(neigh1) == -1 && this.bondsEqual(atm1.getfNeighbours().at(i).getfBond(), atm2.getfNeighbours().at(j).getfBond(), false)) {
                    b = false;
                    continue;
                }
                ++i;
            }
            if (!b) {
                aUse1 = (QVector)tempUse1.find(j);
                boolean isOk = this.mContain(aSubM, aUse1, aUse2 = (QVector)tempUse2.find(j), neigh1, neigh2);
                if (isOk) {
                    check.set(j, i);
                    useNb.set(i, true);
                    ++j;
                    j = this.getNextUnprocessedNeigh(atm2, aN2, j, aUse2);
                    if (j < 0) continue;
                    tempUse1.add(j, aUse1);
                    tempUse2.add(j, aUse2);
                    int unusedCount = aUse2.count(-1);
                    if (unusedCount == 0) continue;
                    j = atm2.getfNeighbours().size();
                    continue;
                }
                useNb.set(i, false);
                aUse1 = (QVector)tempUse1.find(j);
                aUse2 = (QVector)tempUse2.find(j);
                ++i;
                nextI = true;
                continue;
            }
            --j;
            if ((j = this.getPrevUnprocessedNeigh(atm2, aN2, j, aUse2)) < 0) {
                aUse1.set(aN1, -1);
                aUse2.set(aN2, -1);
                return false;
            }
            for (k = j + 1; k < atm2.getfNeighbours().size(); ++k) {
                check.set(k, -1);
            }
            aUse1 = (QVector)tempUse1.find(j);
            aUse2 = (QVector)tempUse2.find(j);
        }
        return true;
    }

    public boolean contains(TMolecule aM) {
        if (this.fMolecule.heavyAtomsCount() < aM.heavyAtomsCount()) {
            return false;
        }
        QVector<Integer> aUse1 = new QVector<Integer>(this.fMolecule.atoms().count(), -1);
        QVector<Integer> aUse2 = new QVector<Integer>(aM.atoms().count(), -1);
        this.markExplicitHydrogens(this.fMolecule, aUse1);
        this.markExplicitHydrogens(aM, aUse2);
        QVector<Integer> storeUse1 = new QVector<Integer>(aUse1);
        QVector<Integer> storeUse2 = new QVector<Integer>(aUse2);
        while (aUse2.contains(-1)) {
            int j = aUse2.indexOf(-1);
            boolean found = false;
            for (int i = 0; i < this.fMolecule.atoms().count(); ++i) {
                if (aUse1.get(i) != null && aUse1.get(i) != -1) continue;
                if (this.mContain(aM, aUse1, aUse2, i, j)) {
                    found = true;
                    break;
                }
                aUse1 = new QVector<Integer>(storeUse1);
                aUse2 = new QVector<Integer>(storeUse2);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean markShells(TMolecule aM, QVector<Integer> aUse, int aIndex, int aNShell) {
        QVector<Integer> currAtoms = new QVector<Integer>();
        QVector<Integer> prevAtoms = new QVector<Integer>();
        QVector<Integer> nextAtoms = new QVector<Integer>();
        currAtoms.append(aIndex);
        for (int currShell = 0; currShell <= aNShell; ++currShell) {
            int _size = currAtoms.size();
            for (int i = 0; i < _size; ++i) {
                int nAtom = (Integer)currAtoms.get(i);
                if (aUse.get(nAtom) == -3) {
                    aUse.set(nAtom, -1);
                }
                TAtom atm = aM.atom(nAtom);
                int _sizeAtm = atm.getfNeighbours().size();
                for (int j = 0; j < _sizeAtm; ++j) {
                    int neigh = atm.getNeighByNum(j, nAtom);
                    if (prevAtoms.contains(neigh) || currAtoms.contains(neigh) || nextAtoms.contains(neigh)) continue;
                    nextAtoms.append(neigh);
                }
            }
            if (nextAtoms.isEmpty()) {
                return false;
            }
            prevAtoms = currAtoms;
            currAtoms = nextAtoms;
            nextAtoms.clear();
        }
        return true;
    }

    public boolean contains(TMolecule aM, int aStartAtomIndex, int aStartAtomIndex2) {
        if (this.fMolecule.heavyAtomsCount() < aM.heavyAtomsCount()) {
            return false;
        }
        QVector<Integer> aUse1 = new QVector<Integer>(this.fMolecule.atoms().count(), -1);
        QVector<Integer> aUse2 = new QVector<Integer>(aM.atoms().count(), -1);
        this.markExplicitHydrogens(this.fMolecule, aUse1);
        this.markExplicitHydrogens(aM, aUse2);
        QVector<Integer> storeUse1 = new QVector<Integer>(aUse1);
        QVector<Integer> storeUse2 = new QVector<Integer>(aUse2);
        if (aStartAtomIndex2 > -1) {
            return this.mContain(aM, aUse1, aUse2, aStartAtomIndex, aStartAtomIndex2);
        }
        if (aUse2.contains(-1)) {
            for (int j = 0; j < aM.atoms().count(); ++j) {
                if (aUse2.get(j) != null && aUse2.get(j) != -1) continue;
                if (this.mContain(aM, aUse1, aUse2, aStartAtomIndex, j)) {
                    return true;
                }
                aUse1 = new QVector<Integer>(storeUse1);
                aUse2 = new QVector<Integer>(storeUse2);
            }
            return false;
        }
        return true;
    }

    public boolean detectIsCyclicBond(int n1, int n2) {
        QVector<Integer> list = new QVector<Integer>(this.fMolecule.atoms().size());
        QVector<Integer> list2 = new QVector<Integer>(this.fMolecule.atoms().size());
        QVector<Boolean> track = new QVector<Boolean>(this.fMolecule.atoms().size());
        int nList = 0;
        TAtom atm = this.fMolecule.atom(n1);
        track.set(n1, true);
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            int neigh = atm.getNeighByNum(i, n1);
            if (neigh == n2) continue;
            track.set(neigh, true);
            list.set(++nList - 1, neigh);
        }
        while (nList > 0) {
            int nList2 = 0;
            for (int n = 0; n < nList; ++n) {
                atm = this.fMolecule.atom((Integer)list.get(n));
                int _size2 = atm.getfNeighbours().size();
                for (int i = 0; i < _size2; ++i) {
                    int neigh = atm.getNeighByNum(i, (Integer)list.get(n));
                    if (track.get(neigh) != null) continue;
                    if (neigh == n2) {
                        return true;
                    }
                    track.set(neigh, true);
                    list2.set(++nList2 - 1, neigh);
                }
            }
            list = list2;
            nList = nList2;
        }
        return false;
    }

    public void detectCyclicBonds() {
        int _size = this.fMolecule.getBonds().size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd = this.fMolecule.bond(i);
            bnd.setCyclic(this.detectIsCyclicBond(bnd.atom1(), bnd.atom2()));
        }
    }

    public boolean isCyclicAtom(int nAtom) {
        TAtom atm = this.fMolecule.atom(nAtom);
        if (atm != null) {
            int _size = atm.getfNeighbours().size();
            for (int i = 0; i < _size; ++i) {
                if (!atm.getfNeighbours().at(i).getfBond().cyclic()) continue;
                return true;
            }
        }
        return false;
    }

    public int calculateCN(QVector<Integer> aEC, QVector<Integer> aCN) {
        int _min = -1;
        int _max = -1;
        int _size = aEC.size();
        for (int i = 0; i < _size; ++i) {
            if (aEC.get(i) == null || aEC.get(i) == -1) continue;
            if (_min == -1 || aEC.get(i) < _min) {
                _min = aEC.get(i);
            }
            if (_max != -1 && aEC.get(i) <= _max) continue;
            _max = aEC.get(i);
        }
        int classN = 0;
        int prev = _min - 1;
        while (prev < _max) {
            int i;
            int val = -1;
            int _size2 = aEC.size();
            for (i = 0; i < _size2; ++i) {
                if (aEC.get(i) == -1 || aEC.get(i) <= prev || val != -1 && aEC.get(i) >= val) continue;
                val = aEC.get(i);
            }
            if (val == -1) {
                return 0;
            }
            ++classN;
            _size2 = aEC.size();
            for (i = 0; i < _size2; ++i) {
                if (aEC.get(i) != val) continue;
                aCN.set(i, classN);
            }
            prev = val;
        }
        return classN;
    }

    public int calculateNewEC(int aAtomNumber, QVector<Integer> aEC) {
        int result = aEC.get(aAtomNumber) == null ? -1 : aEC.get(aAtomNumber);
        TAtom atm = this.fMolecule.atom(aAtomNumber);
        if (atm != null) {
            int _size = atm.getfNeighbours().size();
            for (int i = 0; i < _size; ++i) {
                QString element = atm.getfNeighbours().at(i).getfAtom().elementSymbol();
                if (element.toString().equals("H")) continue;
                result += aEC.get(atm.getNeighByNum(i, aAtomNumber)).intValue();
            }
        }
        return result;
    }

    public int maIMAforGivenEC(QVector<Integer> aEC, QVector<Integer> aCN) {
        int NDCN = this.calculateCN(aEC, aCN);
        QVector<Integer> newEC = new QVector<Integer>(this.fMolecule.atoms().size());
        QVector<Integer> newCN = new QVector<Integer>(this.fMolecule.atoms().size());
        while (true) {
            int i;
            newEC.fill(-1);
            int _size = aEC.size();
            for (int i2 = 0; i2 < _size; ++i2) {
                newEC.set(i2, this.calculateNewEC(i2, aEC) + aEC.get(i2));
            }
            newCN.fill(-1);
            int NDNCN = this.calculateCN(newEC, newCN);
            if (NDNCN <= NDCN) {
                return NDCN;
            }
            for (i = 0; i < newEC.count(); ++i) {
                if (i < aEC.count()) {
                    aEC.set(i, newEC.get(i));
                    continue;
                }
                aEC.append(newEC.get(i));
            }
            for (i = 0; i < newCN.count(); ++i) {
                if (i < aEC.count()) {
                    aCN.set(i, newCN.get(i));
                    continue;
                }
                aCN.append(newCN.get(i));
            }
            NDCN = NDNCN;
        }
    }

    public int maIMA(QVector<Integer> aCN) {
        QVector<Integer> aEC = new QVector<Integer>(this.fMolecule.atoms().size(), -1);
        int _size = aCN.size();
        for (int i = 0; i < _size; ++i) {
            aEC.set(i, this.fMolecule.atom(i).heavyNeighsCount());
        }
        return this.maIMAforGivenEC(aEC, aCN);
    }

    public boolean increaseMaxCN(QVector<Integer> aCN) {
        int maxCN = -1;
        int _size = aCN.size();
        for (int i = 0; i < _size; ++i) {
            if (aCN.count(aCN.get(i)) <= 1 || maxCN != -1 && aCN.get(i) <= maxCN) continue;
            maxCN = aCN.get(i);
        }
        if (maxCN == -1) {
            return false;
        }
        boolean wasIncreased = false;
        int _size2 = aCN.size();
        for (int i = 0; i < _size2; ++i) {
            if (aCN.get(i) > maxCN) {
                ++i;
                continue;
            }
            if (aCN.get(i) != maxCN || wasIncreased) continue;
            ++i;
            wasIncreased = true;
        }
        return true;
    }

    public int firstFreeNeighWithMaxCN(int currAtom, QList<TAtomInfo> atomInfoList) {
        TAtom atm = this.fMolecule.atom(currAtom);
        int nextAtom = -1;
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            int ind = atm.getNeighByNum(i, currAtom);
            if (atomInfoList.at(ind).getfAtomNumber() != 0 || nextAtom != -1 && !this.betterThan(atomInfoList.at(ind), atomInfoList.at(nextAtom), currAtom)) continue;
            nextAtom = ind;
        }
        return nextAtom;
    }

    private int getIndexByNumber(int number, QList<TAtomInfo> list) {
        int _size = list.size();
        for (int i = 0; i < _size; ++i) {
            if (list.at(i).getfAtomNumber() != number) continue;
            return list.at(i).getfAtomIndex();
        }
        return -1;
    }

    public int getAtomWithSmallestNumberAndFreeNeigh(int currN, QList<TAtomInfo> atomInfoList) {
        for (int numb = 1; numb <= currN; ++numb) {
            int result = this.getIndexByNumber(numb, atomInfoList);
            TAtom atm = this.fMolecule.atom(result);
            int _size = atm.getfNeighbours().size();
            for (int i = 0; i < _size; ++i) {
                int ind = atm.getNeighByNum(i, result);
                if (atomInfoList.at(ind).getfAtomNumber() == 0) continue;
                return result;
            }
        }
        return -1;
    }

    public int firstFreeAtomWithMaxCN(QList<TAtomInfo> atomInfoList) {
        int bestInd = -1;
        int _size = atomInfoList.size();
        for (int i = 0; i < _size; ++i) {
            TAtomInfo atomInfo = atomInfoList.at(i);
            if (atomInfo.getfAtomNumber() != 0 || bestInd != -1 && !this.betterThan(atomInfo, atomInfoList.at(bestInd), -1)) continue;
            bestInd = i;
        }
        return bestInd;
    }

    public QList<TAtomInfo> fillAtomInfoList(QVector<Integer> aCN) {
        QList<TAtomInfo> atomInfoList = new QList<TAtomInfo>();
        int _size = this.fMolecule.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.fMolecule.atom(i);
            TAtomInfo atomInfo = new TAtomInfo(i, atm.elementSymbol(), aCN.get(i), atm.nHAll(), this.isCyclicAtom(i));
            atomInfoList.append(atomInfo);
        }
        return atomInfoList;
    }

    private QVector<Integer> fillNumberingVector(QList<TAtomInfo> atomInfoList) {
        QVector<Integer> numbering = new QVector<Integer>(atomInfoList.size());
        int _size = numbering.size();
        for (int i = 0; i < _size; ++i) {
            numbering.set(i, atomInfoList.at(i).getfAtomNumber());
        }
        return numbering;
    }

    public QVector<Integer> uniqueNumbering() {
        QVector<Integer> aCN = new QVector<Integer>(this.fMolecule.atoms().size());
        if (this.fMolecule.atoms().size() == 0) {
            return aCN;
        }
        this.maIMA(aCN);
        QList<TAtomInfo> atomInfoList = this.fillAtomInfoList(aCN);
        int currN = 1;
        int currAtom = this.firstFreeAtomWithMaxCN(atomInfoList);
        atomInfoList.at(currAtom).setfAtomNumber(currN);
        while (currN < this.fMolecule.atoms().size()) {
            int nextAtom = this.firstFreeNeighWithMaxCN(currAtom, atomInfoList);
            if (nextAtom == -1) {
                currAtom = this.getAtomWithSmallestNumberAndFreeNeigh(currN, atomInfoList);
                nextAtom = currAtom != -1 ? this.firstFreeNeighWithMaxCN(currAtom, atomInfoList) : this.firstFreeAtomWithMaxCN(atomInfoList);
            }
            if (nextAtom == -1) {
                return this.fillNumberingVector(atomInfoList);
            }
            atomInfoList.at(nextAtom).setfAtomNumber(++currN);
            currAtom = nextAtom;
        }
        return this.fillNumberingVector(atomInfoList);
    }

    public QVector<Integer> getFixedNumbers() {
        QVector<Integer> res = new QVector<Integer>();
        int _size = this.fMolecule.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.fMolecule.atom(i);
            if (!atm.fixedNumber()) continue;
            res.append(atm.getTatomData().number().toInt());
        }
        return res;
    }

    public int getFixedAtomWithNumber(int aNumber) {
        int _size = this.fMolecule.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.fMolecule.atom(i);
            if (!atm.fixedNumber() || atm.getTatomData().number().toInt() != aNumber) continue;
            return i;
        }
        return -1;
    }

    public boolean existFixedAtomBetween(int aNum1, int aNum2) {
        int _size = this.fMolecule.atoms().size();
        for (int i = 0; i < _size; ++i) {
            int num;
            TAtom atm = this.fMolecule.atom(i);
            if (!atm.fixedNumber() || ((num = atm.getTatomData().number().toInt()) <= aNum1 || num >= aNum2) && (num <= aNum2 || num >= aNum1)) continue;
            return true;
        }
        return false;
    }

    public QString correctNumber(int aIndex, QVector<Integer> aCN, boolean aProtons) {
        boolean isH2;
        int i;
        TAtom atm = this.fMolecule.atom(aIndex);
        int heavyAtom = -1;
        int letter = 97;
        if (atm.isHydrogen()) {
            int neigh = atm.getNeighByNum(0, aIndex);
            if (neigh >= 0 && !this.fMolecule.atom(neigh).isHydrogen()) {
                heavyAtom = neigh;
                TAtom neighAtom = this.fMolecule.atom(neigh);
                for (i = 1; i <= neighAtom.nExplicitH(); ++i) {
                    int indH = neighAtom.getExplicitHIndex(neigh, i);
                    if (indH < 0 || indH >= aIndex) continue;
                    letter = (char)(letter + 1);
                }
            } else if (neigh >= 0 && aIndex > neigh) {
                letter = (char)(letter + 1);
            }
        }
        if (heavyAtom < 0) {
            heavyAtom = aIndex;
        }
        int num = 0;
        boolean bl = isH2 = atm.isHydrogen() && heavyAtom == aIndex;
        num = isH2 ? 1 : (aProtons ? this.fMolecule.atom(heavyAtom).getTatomData().number().toInt() : aCN.get(heavyAtom).intValue());
        if (!isH2 && !aProtons) {
            for (i = 0; i < aCN.size(); ++i) {
                if (aCN.get(i) >= aCN.get(heavyAtom) || !this.fMolecule.atom(i).isHydrogen() || this.fMolecule.atom(i).fixedNumber() || this.existFixedAtomBetween(aCN.get(i), aCN.get(heavyAtom))) continue;
                --num;
            }
        }
        if (atm.isHydrogen()) {
            return new QString("" + num);
        }
        return new QString("" + num);
    }

    public void setUniqueNumbering(boolean aProtons) {
        this.detectCyclicBonds();
        QVector<Integer> aCN = this.uniqueNumbering();
        QVector<Integer> fixedNumbers = this.getFixedNumbers();
        int lowerLimit = 0;
        if (aProtons) {
            ++lowerLimit;
        }
        for (int protonFlag = lowerLimit; protonFlag <= 1; ++protonFlag) {
            int _size = aCN.size();
            for (int i = 0; i < _size; ++i) {
                TAtom atm = this.fMolecule.atom(i);
                if (protonFlag == 0 && atm.isHydrogen() || protonFlag != 0 && !atm.isHydrogen()) continue;
                QString correctN = this.correctNumber(i, aCN, protonFlag != 0);
                if (atm.fixedNumber()) continue;
                if (!fixedNumbers.contains(aCN.get(i)) || protonFlag != 0) {
                    atm.getTatomData().setNumber(correctN);
                    continue;
                }
                int fInd = this.getFixedAtomWithNumber(aCN.get(i));
                while (fInd > -1 && fixedNumbers.contains(aCN.get(fInd))) {
                    fInd = this.getFixedAtomWithNumber(aCN.get(fInd));
                }
                if (fInd <= -1) continue;
                atm.getTatomData().setNumber(this.correctNumber(fInd, aCN, protonFlag != 0));
            }
        }
    }

    public boolean isNitrogenKetonTautomer(TBond aBnd) {
        if (aBnd.bondType() != TBondType.btSingle || !aBnd.cyclic()) {
            return false;
        }
        TAtom atm1 = this.fMolecule.atom(aBnd.atom1());
        TAtom atm2 = this.fMolecule.atom(aBnd.atom2());
        if (atm1 == null || atm2 == null) {
            return false;
        }
        TAtom carbonAtom = null;
        TAtom heteroAtom = null;
        if (atm1.isCarbon()) {
            carbonAtom = atm1;
        }
        if (atm2.isCarbon()) {
            carbonAtom = atm2;
        }
        if (atm1.isNitrogen() && atm1.nH() == 1) {
            heteroAtom = atm1;
        }
        if (atm2.isNitrogen() && atm2.nH() == 1) {
            heteroAtom = atm2;
        }
        if (carbonAtom == null || heteroAtom == null) {
            return false;
        }
        boolean ketonFlag = false;
        int _size = carbonAtom.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            TNeighbour nb = carbonAtom.getfNeighbours().at(i);
            if (nb.getfBond().cyclic() || nb.getfBond().bondType() != TBondType.btDouble || !nb.getfAtom().isSulfur() && !nb.getfAtom().isOxygen()) continue;
            ketonFlag = true;
            break;
        }
        return ketonFlag;
    }

    public boolean existAromaticPath(int atomFirst, int atomFrom, int atomTo, int aStep, boolean aDouble, boolean aOneException, QVector<Boolean> aUsed, boolean aCheckCyclic) {
        boolean nextDouble;
        TBond bnd = this.fMolecule.findBond(atomFrom, atomTo);
        if (bnd == null || aCheckCyclic && !bnd.cyclic()) {
            return false;
        }
        boolean ketonFlag = false;
        if (aDouble && bnd.bondType() == TBondType.btSingle && !bnd.aromatic()) {
            ketonFlag = this.isNitrogenKetonTautomer(bnd);
        }
        if (aDouble && bnd.bondType() != TBondType.btDouble && (bnd.bondType() != TBondType.btSingle || !bnd.aromatic() && !ketonFlag) && (bnd.bondType() != TBondType.btSingle || aOneException) || !aDouble && bnd.bondType() != TBondType.btSingle) {
            return false;
        }
        boolean bl = nextDouble = !aDouble;
        if (aDouble && bnd.bondType() == TBondType.btSingle && !bnd.aromatic() && !ketonFlag) {
            aOneException = true;
            nextDouble = true;
        }
        if (aStep == 5 && atomTo == atomFirst) {
            bnd.setAromatic(true);
            return true;
        }
        if (aStep == 6) {
            if (atomTo == atomFirst && !aOneException) {
                bnd.setAromatic(true);
                return true;
            }
            return false;
        }
        TAtom atm = this.fMolecule.atom(atomTo);
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            int neigh = atm.getNeighByNum(i, atomTo);
            if (aUsed.get(neigh) != null && aUsed.get(neigh).booleanValue() && (neigh != atomFirst || aStep != 5 && aStep != 4)) continue;
            QVector<Boolean> newUsed = aUsed;
            newUsed.set(neigh, true);
            boolean storeOneException = aOneException;
            if (this.existAromaticPath(atomFirst, atomTo, neigh, aStep + 1, nextDouble, aOneException, newUsed, aCheckCyclic)) {
                bnd.setAromatic(true);
                aUsed = newUsed;
                return true;
            }
            aOneException = storeOneException;
        }
        return false;
    }

    public void detectAromaticAtoms() {
        this.detectCyclicBonds();
        QVector<Boolean> aUsedBonds = new QVector<Boolean>(this.fMolecule.bonds().size());
        boolean foundNew = true;
        block0: while (foundNew) {
            int i;
            foundNew = false;
            int _size = this.fMolecule.bonds().size();
            for (i = 0; i < _size; ++i) {
                aUsedBonds.set(i, !this.fMolecule.bond(i).cyclic() || this.fMolecule.bond(i).aromatic());
            }
            _size = this.fMolecule.bonds().size();
            for (i = 0; i < _size; ++i) {
                TBond bnd;
                if (aUsedBonds.get(i) != null && ((Boolean)aUsedBonds.get(i)).booleanValue() || (bnd = this.fMolecule.bonds().at(i)).aromatic()) continue;
                QVector<Boolean> used = new QVector<Boolean>(this.fMolecule.atoms().size());
                used.set(bnd.atom1(), true);
                used.set(bnd.atom2(), true);
                boolean oneException = false;
                if (!this.existAromaticPath(bnd.atom1(), bnd.atom1(), bnd.atom2(), 1, bnd.bondType() == TBondType.btDouble, oneException, used, true)) continue;
                foundNew = true;
                continue block0;
            }
        }
    }

    public QList<Integer> findAromaRing(int aN1, int aN2, boolean aAromaDetected) {
        QList<Integer> resList = new QList<Integer>();
        TBond bnd = this.fMolecule.findBond(aN1, aN2);
        if (bnd == null) {
            return resList;
        }
        QVector<Boolean> used = new QVector<Boolean>(this.fMolecule.atoms().size());
        used.set(bnd.atom1(), true);
        used.set(bnd.atom2(), true);
        boolean oneException = false;
        if (this.existAromaticPath(bnd.atom1(), bnd.atom1(), bnd.atom2(), 1, bnd.bondType() == TBondType.btDouble, oneException, used, aAromaDetected)) {
            for (int i = 0; i < used.size(); ++i) {
                if (used.get(i) == null || !used.get(i).booleanValue()) continue;
                resList.append(i);
            }
            if (resList.size() != 6) {
                resList.clear();
            }
        }
        return resList;
    }

    public boolean isAromaticAtom(int aIndex) {
        if (!this.isCyclicAtom(aIndex)) {
            return false;
        }
        TAtom atm = this.fMolecule.atom(aIndex);
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            if (!atm.getfNeighbours().at(i).getfBond().aromatic()) continue;
            return true;
        }
        return false;
    }

    public QList<Integer> aromaticAtoms() {
        QList<Integer> res = new QList<Integer>();
        int _size = this.fMolecule.atoms().size();
        for (int i = 0; i < _size; ++i) {
            if (!this.isAromaticAtom(i)) continue;
            res.append(i);
        }
        Collections.sort(res.arrayList());
        return res;
    }

    public boolean isSymmetricalAtoms(int aN1, int aN2) {
        if (this.fMolecule.atoms().size() == 0 || aN1 < 0 || aN1 >= this.fMolecule.atoms().size() || aN2 < 0 || aN2 >= this.fMolecule.atoms().size()) {
            return false;
        }
        QVector<Integer> aUse1 = new QVector<Integer>(this.fMolecule.atoms().size(), -1);
        this.markExplicitHydrogens(this.fMolecule, aUse1);
        QVector<Integer> aUse2 = new QVector<Integer>(aUse1);
        return this.mEqual(this.fMolecule, aUse1, aUse2, aN1, aN2);
    }

    public QList<Integer> symmetricalAtoms(int aIndex) {
        QList<Integer> res = new QList<Integer>();
        int _size = this.fMolecule.atoms().size();
        for (int i = 0; i < _size; ++i) {
            if (i == aIndex || !this.isSymmetricalAtoms(i, aIndex)) continue;
            res.append(i);
        }
        Collections.sort(res.arrayList());
        return res;
    }

    public QString aromaticPattern() {
        this.detectAromaticAtoms();
        QList<Integer> aromaList = this.aromaticAtoms();
        if (aromaList.size() != 6) {
            return new QString("");
        }
        if (this.fMolecule.elementCount(new QByteArray(new QString("F"))) > 0) {
            return new QString("");
        }
        QString res = new QString("");
        TAtom curr = this.fMolecule.atom(aromaList.at(0));
        TAtom prev = null;
        int num = 0;
        block0: for (int i = 0; i < 6; ++i) {
            TBond bnd;
            int j;
            int nAcyclic = 0;
            int nCyclic = 0;
            int nHetero = 0;
            int nAroma = 0;
            int _size = curr.getfNeighbours().size();
            for (j = 0; j < _size; ++j) {
                bnd = curr.getfNeighbours().at(j).getfBond();
                if (bnd.aromatic()) {
                    ++nAroma;
                    continue;
                }
                if (bnd.cyclic()) {
                    ++nCyclic;
                    continue;
                }
                if (curr.getfNeighbours().at(j).getfAtom().isHydrogen()) continue;
                ++nAcyclic;
            }
            if (!curr.isCarbon()) {
                ++nHetero;
            }
            if (nAroma == 2 && nAcyclic + nHetero + nCyclic == 1) {
                if (num == 0) {
                    num = 1;
                }
                res.append("" + num);
            } else if (nAroma != 2 || nAcyclic + nHetero + nCyclic > 1) {
                return new QString("");
            }
            if (num != 0) {
                ++num;
            }
            _size = curr.getfNeighbours().size();
            for (j = 0; j < _size; ++j) {
                bnd = curr.getfNeighbours().at(j).getfBond();
                TAtom next = curr.getfNeighbours().at(j).getfAtom();
                if (!bnd.aromatic() || prev != null && prev.equals(next)) continue;
                prev = curr;
                curr = next;
                continue block0;
            }
        }
        return res;
    }

    public TAromPattern detectAromaticPatternSubstitution() {
        QString pat = this.aromaticPattern();
        if (pat.toString().equals("1")) {
            return TAromPattern.aromPat_MonoSubs;
        }
        if (pat.toString().equals("12") || pat.toString().equals("16")) {
            return TAromPattern.aromPat_OrtoDiSubs;
        }
        if (pat.toString().equals("13") || pat.toString().equals("15")) {
            return TAromPattern.aromPat_MetaDiSubs;
        }
        if (pat.toString().equals("14")) {
            return TAromPattern.aromPat_ParaDiSubs;
        }
        if (pat.toString().equals("123") || pat.toString().equals("156") || pat.toString().equals("126")) {
            return TAromPattern.aromPat_123TriSubs;
        }
        if (pat.toString().equals("124") || pat.toString().equals("146") || pat.toString().equals("125") || pat.toString().equals("136") || pat.toString().equals("134") || pat.toString().equals("145")) {
            return TAromPattern.aromPat_124TriSubs;
        }
        if (pat.toString().equals("1245") || pat.toString().equals("1346")) {
            return TAromPattern.aromPat_1245TetraSubs;
        }
        if (pat.toString().equals("1234") || pat.toString().equals("1456") || pat.toString().equals("1236") || pat.toString().equals("1256")) {
            return TAromPattern.aromPat_1234TetraSubs;
        }
        return TAromPattern.aromPat_Unknown;
    }

    public boolean isCF3Group(int atomInd) {
        TAtom atom = this.fMolecule.atom(atomInd);
        if (atom == null || !atom.isCarbon()) {
            return false;
        }
        int _size = atom.getfNeighbours().size();
        if (_size != 4) {
            return false;
        }
        int nF = 0;
        for (int j = 0; j < _size; ++j) {
            TAtom neigh = atom.getfNeighbours().at(j).getfAtom();
            if (neigh.getfElement() == null || !neigh.getfElement().getfElementSymbol().toString().equals("F")) continue;
            ++nF;
        }
        return nF == 3;
    }

    public QList<QList<Integer>> detectAromaSystems() {
        QList<QList<Integer>> res = new QList<QList<Integer>>();
        this.detectAromaticAtoms();
        QList<Integer> aromaList = this.aromaticAtoms();
        if (aromaList.isEmpty()) {
            return res;
        }
        while (!aromaList.isEmpty()) {
            int _size;
            QList<Integer> currSystem = new QList<Integer>();
            currSystem.append(aromaList.at(0));
            aromaList.removeAt(0);
            do {
                _size = currSystem.size();
                for (int i = 0; i < _size; ++i) {
                    int currInd = (Integer)currSystem.at(i);
                    TAtom atm = this.fMolecule.atom(currInd);
                    for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                        int nextInd;
                        TBond bnd = atm.getfNeighbours().at(j).getfBond();
                        if (!bnd.aromatic() || currSystem.contains(nextInd = bnd.getSecond(currInd))) continue;
                        currSystem.append(nextInd);
                        aromaList.removeOne(nextInd);
                    }
                }
            } while (_size != currSystem.size() && !aromaList.isEmpty());
            res.append(currSystem);
        }
        return res;
    }

    public QList<TAromaElement> collectAromaElements(QList<Integer> aromaList) {
        QList<TAromaElement> res = new QList<TAromaElement>();
        if (aromaList.size() != 6) {
            return res;
        }
        int ind = aromaList.at(0);
        TAtom curr = this.fMolecule.atom(ind);
        TAtom prev = null;
        int countN = 0;
        for (int i = 0; i < 6; ++i) {
            int nAcyclic = 0;
            int nCyclic = 0;
            int nHetero = 0;
            int nAroma = 0;
            int _size = curr.getfNeighbours().size();
            for (int j = 0; j < _size; ++j) {
                TBond bnd = curr.getfNeighbours().at(j).getfBond();
                if (bnd.aromatic()) {
                    ++nAroma;
                    continue;
                }
                if (bnd.cyclic()) {
                    ++nCyclic;
                    continue;
                }
                if (curr.getfNeighbours().at(j).getfAtom().isHydrogen()) continue;
                ++nAcyclic;
            }
            if (curr.isNitrogen()) {
                ++countN;
                ++nHetero;
            } else if (!curr.isCarbon()) {
                return new QList<TAromaElement>();
            }
            TAromaElement arEl = new TAromaElement(ind, curr.elementSymbol(), TSubstutuent.sub_Other);
            if (nAroma != 2 || nAcyclic + nHetero + nCyclic > 1) {
                return new QList<TAromaElement>();
            }
            int nextInd = -1;
            if (curr.nHAll() != 0) {
                arEl.setSubstituent(TSubstutuent.sub_H);
            }
            int _size2 = curr.getfNeighbours().size();
            for (int j = 0; j < _size2; ++j) {
                TBond bnd = curr.getfNeighbours().at(j).getfBond();
                TAtom next = curr.getfNeighbours().at(j).getfAtom();
                if (bnd.aromatic() && (prev == null || !prev.equals(next)) && nextInd < 0) {
                    nextInd = bnd.getSecond(ind);
                    continue;
                }
                if (bnd.aromatic()) continue;
                int subIndex = bnd.getSecond(ind);
                TAtom neigh = this.fMolecule.atom(subIndex);
                if (neigh.isCarbon() && neigh.nHAll() != 0) {
                    switch (neigh.nHAll()) {
                        case 1: {
                            arEl.setSubstituent(TSubstutuent.sub_CH);
                            break;
                        }
                        case 2: {
                            arEl.setSubstituent(TSubstutuent.sub_CH2);
                            break;
                        }
                        case 3: {
                            arEl.setSubstituent(TSubstutuent.sub_CH3);
                        }
                    }
                } else if (neigh.elementSymbol().toString().equals("P")) {
                    arEl.setSubstituent(TSubstutuent.sub_P);
                } else if (neigh.elementSymbol().toString().equals("F")) {
                    arEl.setSubstituent(TSubstutuent.sub_F);
                } else if (this.isCF3Group(subIndex)) {
                    arEl.setSubstituent(TSubstutuent.sub_CF3);
                }
                arEl.setSubstituentIndex(subIndex);
            }
            ind = nextInd;
            prev = curr;
            curr = this.fMolecule.atom(nextInd);
            res.append(arEl);
        }
        if (countN > 2) {
            res.clear();
        }
        return res;
    }

    public QList<TCouplingInfo> detectAromaPattern() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void fillTableEntry(QString aSub1, QString aSub2, double aValue, double aError, int aJDist, int aStep, boolean aSymmetrical) throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean loadCouplingInfoTable() throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean existPath(int atomFrom, int atomTo, int aLength, boolean aAroma, QVector<Integer> aBondTypes) throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean isAromaticCarbonWithH(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null) {
            return false;
        }
        return this.isAromaticAtom(aIndex) && atm.isCarbon() && atm.nHAll() == 1;
    }

    public boolean isCarbonWithH(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null) {
            return false;
        }
        return !this.isAromaticAtom(aIndex) && atm.isCarbon() && atm.nHAll() > 0;
    }

    public void getProtonIndex(int aIndex, int aHIndex, int aResAtom, int aResH) {
        aResAtom = -1;
        aResH = -1;
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null) {
            return;
        }
        if (aHIndex <= atm.nH()) {
            aResAtom = aIndex;
            aResH = aHIndex;
        } else {
            aResAtom = atm.getExplicitHIndex(aIndex, aHIndex - atm.nH());
            aResH = 1;
        }
    }

    public void detectAromaJ5Couplings(QList<TCouplingInfo> aCouplings) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void detectAcyclicJ5Couplings(QList<TCouplingInfo> aCouplings) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void detectJ4FHCouplings(QList<TCouplingInfo> aCouplings) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void detectJ5FHCouplings(QList<TCouplingInfo> aCouplings) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void appendCoupling(QList<TCouplingInfo> aList, TCouplingInfo aItem) {
        boolean found = false;
        for (int i = 0; i < aList.size(); ++i) {
            TCouplingInfo item1 = aList.at(i);
            if ((item1.getAtom1() != aItem.getAtom1() || item1.getAtom2() != aItem.getAtom2()) && (item1.getAtom1() != aItem.getAtom2() || item1.getAtom2() != aItem.getAtom1())) continue;
            found = true;
            break;
        }
        if (!found) {
            aList.append(aItem);
        }
    }

    public QList<TCouplingInfo> detectCouplings(TAromaPattern pattern) throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean containsBroadLinePattern() throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean isAlkyl(int aIndex) {
        TAtom atm = this.fMolecule.atom(aIndex);
        if (atm == null || !atm.isCarbon()) {
            return false;
        }
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            TNeighbour nb = atm.getfNeighbours().at(i);
            if (nb.getfBond().bondType() == TBondType.btSingle) continue;
            return false;
        }
        return true;
    }

    public TLabileProtonGroup IntToLPG(int aParam) throws Exception {
        throw new Exception("Method not implemented");
    }

    public TLabileProtonGroup getLabileProtonGroupIndex(int aIndex) throws Exception {
        throw new Exception("Method not implemented");
    }

    public int detectCoherences(QVector<Integer> aCohs) {
        QVector<Integer> res = new QVector<Integer>(this.fMolecule.atoms().size(), -1);
        int partCount = 0;
        while (res.contains(-1)) {
            int firstAtom = res.indexOf(-1);
            QVector<Integer> currAtoms = new QVector<Integer>();
            currAtoms.append(firstAtom);
            res.set(firstAtom, ++partCount);
            while (currAtoms.size() > 0) {
                QVector<Integer> nextAtoms = new QVector<Integer>();
                for (int i = 0; i < currAtoms.size(); ++i) {
                    int currAtom = currAtoms.get(i) == null ? -1 : (Integer)currAtoms.get(i);
                    TAtom atm = this.fMolecule.atom(currAtom);
                    int _size = atm.getfNeighbours().size();
                    for (int j = 0; j < _size; ++j) {
                        int neigh = atm.getNeighByNum(j, currAtom);
                        if (res.get(neigh) != -1) continue;
                        nextAtoms.append(neigh);
                        res.set(neigh, partCount);
                    }
                }
                currAtoms = nextAtoms;
            }
        }
        for (int i = 0; i < res.count(); ++i) {
            aCohs.append(res.get(i));
        }
        return partCount;
    }

    public QList<TMolecule> extractCoherences() {
        QList<TMolecule> res = new QList<TMolecule>();
        if (this.fMolecule == null) {
            return res;
        }
        QVector<Integer> cohs = new QVector<Integer>();
        int partsCount = this.detectCoherences(cohs);
        if (partsCount == 1) {
            res.append(this.fMolecule);
            return res;
        }
        for (int i = 1; i <= partsCount; ++i) {
            TMolecule mol = new TMolecule(this.fMolecule, cohs, i);
            res.append(mol);
        }
        return res;
    }

    public TMolecule neutralize(boolean aOk) {
        aOk = false;
        TMolecule res = null;
        if (this.fMolecule == null) {
            return res;
        }
        int plus = 0;
        int minus = 0;
        int common = 0;
        QList<Integer> result = this.fMolecule.calcCommonCharge(plus, minus);
        common = result.at(2);
        minus = result.at(1);
        plus = result.at(0);
        if (plus == 0 || minus == 0 || common != 0) {
            return res;
        }
        QList<TMolecule> list = this.extractCoherences();
        if (list.size() < 2) {
            return res;
        }
        TMolecule cation = null;
        TMolecule anion = null;
        for (int i = 0; i < list.size(); ++i) {
            TMolecule comp = list.at(i);
            result = comp.calcCommonCharge(plus, minus);
            common = result.at(2);
            minus = result.at(1);
            plus = result.at(0);
            if (common > 0) {
                if (cation == null || cation.equals(comp)) {
                    cation = comp;
                    continue;
                }
                return res;
            }
            if (common < 0) {
                if (anion == null || anion.equals(comp)) {
                    anion = comp;
                    continue;
                }
                return res;
            }
            return res;
        }
        if (cation == null || anion == null) {
            return res;
        }
        aOk = true;
        if (cation.heavyAtomsCount() > anion.heavyAtomsCount()) {
            cation.removeCharge();
            return cation;
        }
        anion.removeCharge();
        return anion;
    }

    public QVector<Integer> getNextSphere(QVector<Integer> aPrev, QVector<Integer> aCurr) {
        return this.getNextSphere(aPrev, aCurr, false);
    }

    public QVector<Integer> getNextSphere(QVector<Integer> aPrev, QVector<Integer> aCurr, boolean aCheckComplete) {
        QVector<Integer> res = new QVector<Integer>();
        if (aCurr.isEmpty()) {
            return res;
        }
        for (int i = 0; i < aCurr.size(); ++i) {
            int currAtom = aCurr.get(i);
            TAtom atm = this.fMolecule.atom(currAtom);
            boolean findNext = false;
            int _size = atm.getfNeighbours().size();
            for (int j = 0; j < _size; ++j) {
                int neigh = atm.getNeighByNum(j, currAtom);
                if (aPrev.contains(neigh) || aCurr.contains(neigh) || res.contains(neigh) && !aCheckComplete) continue;
                res.append(neigh);
                findNext = true;
            }
            if (!aCheckComplete || findNext) continue;
            res.clear();
            break;
        }
        return res;
    }

    public boolean inOneLigand(int aPrev, int aCurr, int aDest) {
        if (aDest == aPrev) {
            return false;
        }
        if (aDest == aCurr) {
            return true;
        }
        QVector<Integer> prev = new QVector<Integer>();
        QVector<Object> curr = new QVector<Integer>();
        QVector<Object> next = new QVector();
        prev.append(aPrev);
        curr.append(aCurr);
        while (!curr.isEmpty()) {
            next = this.getNextSphere(prev, curr);
            if (next.contains(aDest)) {
                return true;
            }
            prev = curr;
            curr = next;
        }
        return false;
    }

    public int belongs3Ring(int aIndex) {
        if (!this.isCyclicAtom(aIndex)) {
            return 0;
        }
        TAtom atm = this.fMolecule.atom(aIndex);
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd1 = atm.getfNeighbours().at(i).getfBond();
            TAtom atm1 = atm.getfNeighbours().at(i).getfAtom();
            int neigh1 = bnd1.getSecond(aIndex);
            if (!this.isCyclicAtom(neigh1) || bnd1.bondType() != TBondType.btSingle) continue;
            int _size2 = atm1.getfNeighbours().size();
            for (int j = 0; j < _size2; ++j) {
                boolean r2;
                TBond bnd3;
                TBond bnd2 = atm1.getfNeighbours().at(j).getfBond();
                TAtom atm2 = atm1.getfNeighbours().at(j).getfAtom();
                int neigh2 = bnd2.getSecond(neigh1);
                if (neigh2 == aIndex || !this.isCyclicAtom(neigh2) || bnd2.bondType() != TBondType.btSingle || (bnd3 = this.fMolecule.findBond(neigh2, aIndex)) == null || bnd3.bondType() != TBondType.btSingle) continue;
                boolean r1 = !atm1.isOxygen() && !atm1.isSulfur() && !atm1.isNitrogen();
                boolean bl = r2 = !atm2.isOxygen() && !atm2.isSulfur() && !atm2.isNitrogen();
                if (r1 && r2) {
                    return 1;
                }
                if (r1 && atm2.isOxygen() || r2 && atm1.isOxygen()) {
                    return 2;
                }
                if (r1 && atm2.isSulfur() || r2 && atm1.isSulfur()) {
                    return 3;
                }
                if ((!r1 || !atm2.isNitrogen()) && (!r2 || !atm1.isNitrogen())) continue;
                return 4;
            }
        }
        return 0;
    }

    private int belongs4Ring(int aIndex) {
        if (!this.isCyclicAtom(aIndex)) {
            return 0;
        }
        TAtom atm = this.fMolecule.atom(aIndex);
        int _size = atm.getfNeighbours().size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd1 = atm.getfNeighbours().at(i).getfBond();
            TAtom atm1 = atm.getfNeighbours().at(i).getfAtom();
            int neigh1 = bnd1.getSecond(aIndex);
            if (!this.isCyclicAtom(neigh1) || bnd1.bondType() != TBondType.btSingle) continue;
            int _sizeAtom1 = atm1.getfNeighbours().size();
            for (int j = 0; j < _sizeAtom1; ++j) {
                TBond bnd2 = atm1.getfNeighbours().at(j).getfBond();
                TAtom atm2 = atm1.getfNeighbours().at(j).getfAtom();
                int neigh2 = bnd2.getSecond(neigh1);
                if (neigh2 == aIndex || !this.isCyclicAtom(neigh2) || bnd2.bondType() != TBondType.btSingle) continue;
                int _sizeAtom2 = atm2.getfNeighbours().size();
                for (int k = 0; k < _sizeAtom2; ++k) {
                    TBond bnd4;
                    TBond bnd3 = atm2.getfNeighbours().at(k).getfBond();
                    TAtom atm3 = atm2.getfNeighbours().at(k).getfAtom();
                    int neigh3 = bnd3.getSecond(neigh2);
                    if (neigh3 == aIndex || neigh3 == neigh1 || !this.isCyclicAtom(neigh3) || bnd3.bondType() != TBondType.btSingle || (bnd4 = this.fMolecule.findBond(neigh3, aIndex)) == null || bnd4.bondType() != TBondType.btSingle) continue;
                    if (atm1.isCarbon() && atm2.isCarbon() && atm3.isCarbon()) {
                        return 1;
                    }
                    if (atm1.isOxygen() && atm2.isCarbon() && atm3.isCarbon() || atm1.isCarbon() && atm2.isCarbon() && atm3.isOxygen()) {
                        return 2;
                    }
                    if (!atm1.isCarbon() || !atm2.isOxygen() || !atm3.isCarbon()) continue;
                    return 3;
                }
            }
        }
        return 0;
    }

    public int getGeminalJ2CouplingsIndex(int aIndex) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void fillGeminalJ2CouplingsValue(int aParam, double aValue, double aError) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void detectGeminalJ2Couplings(QList<TCouplingInfo> aCouplings) throws Exception {
        throw new Exception("Method not implemented");
    }

    public TStereoDescriptor calcCisTrans(int aIndex1, int aIndex2, int aNeigh1, int aNeigh2) {
        double sign1 = this.getBondSign(aIndex1, aIndex2, aNeigh1, true);
        double sign2 = this.getBondSign(aIndex2, aIndex1, aNeigh2, false);
        if (sign1 > 0.0 && sign2 > 0.0 || sign1 < 0.0 && sign2 < 0.0) {
            return TStereoDescriptor.sd_ZBond;
        }
        if (sign1 > 0.0 && sign2 < 0.0 || sign1 < 0.0 && sign2 > 0.0) {
            return TStereoDescriptor.sd_EBond;
        }
        return TStereoDescriptor.sd_None;
    }

    public double getBondSign(int aIndex1, int aIndex2, int aNeighIndex, boolean aFirstAtom) {
        double cosA;
        TAtom atm1 = this.fMolecule.atom(aIndex1);
        TAtom atm2 = this.fMolecule.atom(aIndex2);
        TAtom atm3 = this.fMolecule.atom(aNeighIndex);
        if (atm1 == null || atm2 == null || atm3 == null) {
            return 0.0;
        }
        double atom1X = (Double)atm1.x();
        double atom1Y = (Double)atm1.y();
        double atom2X = (Double)atm2.x();
        double atom2Y = (Double)atm2.y();
        double neighX = (Double)atm3.x();
        double neighY = (Double)atm3.y();
        if (atom1X == atom2X && atom1Y == atom2Y || atom1X == neighX && atom1Y == neighY) {
            cosA = 1.0;
        } else {
            double vx1 = atom2X - atom1X;
            double vx2 = neighX - atom1X;
            double vy1 = atom2Y - atom1Y;
            double vy2 = neighY - atom1Y;
            cosA = (vx1 * vx2 + vy1 * vy2) / (Math.sqrt(vx1 * vx1 + vy1 * vy1) * Math.sqrt(vx2 * vx2 + vy2 * vy2));
        }
        if (cosA < Math.cos(0.9444444444444444 * UtilGeometry.pi) || cosA > Math.cos(0.4444444444444444 * UtilGeometry.pi)) {
            return 0.0;
        }
        if (aFirstAtom) {
            return (atom1X - neighX) * (atom2Y - atom1Y) - (atom1Y - neighY) * (atom2X - atom1X);
        }
        return (atom1X - atom2X) * (neighY - atom1Y) - (atom1Y - atom2Y) * (neighX - atom1X);
    }

    public static QString getMolFormulaByLabel(QString aLabel) {
        return labelFileLoader.getFormula(aLabel);
    }

    public boolean isfCheckStereo() {
        return this.fCheckStereo;
    }

    public void setfCheckStereo(boolean fCheckStereo) {
        this.fCheckStereo = fCheckStereo;
    }

    public boolean isfProcessQueryAtoms() {
        return this.fProcessQueryAtoms;
    }

    public void setfProcessQueryAtoms(boolean fProcessQueryAtoms) {
        this.fProcessQueryAtoms = fProcessQueryAtoms;
    }
}

