/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.IMoleculeTO;
import com.mestrelab.components.shared.IMoleculeTOFactory;
import com.mestrelab.components.shared.ITAtom;
import com.mestrelab.components.shared.ITAtomData;
import com.mestrelab.components.shared.ITBond;
import com.mestrelab.components.shared.ITBondData;
import com.mestrelab.components.shared.ITBracket;
import com.mestrelab.components.shared.ITIsotope;
import com.mestrelab.components.shared.ITPolymer;
import com.mestrelab.components.shared.TAromPattern;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TAtomData;
import com.mestrelab.components.shared.TAtomIndex;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondData;
import com.mestrelab.components.shared.TBondStereo;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TBondsOrder;
import com.mestrelab.components.shared.TBracket;
import com.mestrelab.components.shared.TDefaultsIni;
import com.mestrelab.components.shared.TElement;
import com.mestrelab.components.shared.TMoleculeAnalyzer;
import com.mestrelab.components.shared.TMoleculeConformer;
import com.mestrelab.components.shared.TNeighbour;
import com.mestrelab.components.shared.TPeriodicTable;
import com.mestrelab.components.shared.TPolymer;
import com.mestrelab.components.shared.TStereoAnalyzer;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QDateTime;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygon;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.qt.QVariant;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.ParserVO;
import com.mestrelab.components.shared.util.StoreLoad;
import com.mestrelab.components.shared.util.TDataStream;
import com.mestrelab.components.shared.util.TSharedData;
import com.mestrelab.components.shared.util.TVariantData;
import com.mestrelab.components.shared.util.UtilGeometry;
import com.mestrelab.components.shared.util.UtilMolFormula;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMolecule
extends TVariantData<QString, QVariant>
implements Serializable,
IMoleculeTO {
    public static QString cFileName = new QString("filename");
    public static QString cNumber = new QString("mol#");
    public static QString cComment = new QString("comment");
    public static QString cName = new QString("name");
    public static QString cSDDataName = new QString("SDFData");
    public static QString cConformers = new QString("Conformers");
    public static QString cTimestamp = new QString("timestamp");
    public static QString cOrigin = new QString("origin");
    public static QString cSaveNumberingToMolfilesKey = new QString("Molecule/SaveNumbering");
    public static QString cLabel = new QString("label");
    public static QString cAliases = new QString("aliases");
    public static QString cColor = new QString("color");
    public static QString cAtomNumberValidator = new QString("^$|^(\\d|\\$([a-z])+|[a-zA-Z_'])*");
    public static QString cDuplicatedChar = new QString("#");
    public static boolean fStoreMolfileFlag = true;
    private QList<TAtom> fAtoms;
    private QList<TBond> fBonds;
    private QByteArray<QString> fOriginalMolfile;
    private QList<TPolymer> fPolymers;
    private int fMaxFixedNum;
    private TSharedData tSharedData = null;
    private TVariantData<QString, QString> tVariantData = new TVariantData();

    public TMolecule() {
        this.tSharedData = new TSharedData();
        this.fAtoms = new QList();
        this.fBonds = new QList();
        this.fOriginalMolfile = new QByteArray();
        this.fPolymers = new QList();
        this.init();
    }

    public TMolecule(QUuid aId, int aAtomsCount) {
        this();
        this.tSharedData = new TSharedData(aId);
        this.init(aAtomsCount);
    }

    public TMolecule(TMolecule aMol) {
        this();
        StoreLoad<TMolecule> load = new StoreLoad<TMolecule>();
        load.copy(aMol, this);
    }

    public TMolecule(int aAtomsCount) {
        this();
        this.init(aAtomsCount);
    }

    public TMolecule(int aAtomsCount, boolean aPhenyl) {
        this();
        this.init(aAtomsCount, new QString("C"), true);
        if (aPhenyl && aAtomsCount == 6) {
            this.changeBondMultiplicity(0, 1);
            this.changeBondMultiplicity(2, 3);
            this.changeBondMultiplicity(4, 5);
        }
        this.checknH();
    }

    public TMolecule(TMolecule aMol, QVector<Integer> aExtractVector, int aExtractValue) {
        this();
        int i;
        this.init();
        if (aMol.atoms().size() != aExtractVector.size()) {
            return;
        }
        int num = 0;
        for (i = 0; i < aExtractVector.size(); ++i) {
            if (aExtractVector.get(i) == null || aExtractVector.get(i) != aExtractValue) continue;
            TAtom atm = new TAtom(aMol.atom(i));
            atm.getfNeighbours().clear();
            this.checkValence(atm, false);
            atm.getTatomData().setNumber(new QString("" + ++num));
            this.addAtom(atm);
        }
        for (i = 0; i < aExtractVector.size(); ++i) {
            if (aExtractVector.get(i) != aExtractValue) continue;
            for (int j = i + 1; j < aExtractVector.size(); ++j) {
                TBond bnd;
                if (aExtractVector.get(j) != aExtractValue || (bnd = aMol.findBond(i, j)) == null) continue;
                int num1 = aExtractVector.mid(0, i + 1).count(aExtractValue) - 1;
                int num2 = aExtractVector.mid(0, j + 1).count(aExtractValue) - 1;
                TBond newBond = new TBond(num1, num2, bnd.bondType(), bnd.bondStereo());
                this.addBond(newBond, true, false);
            }
        }
    }

    public void init() {
        this.init(0, new QString(""), false);
    }

    public void init(int aAtomsCount) {
        this.init(aAtomsCount, new QString(""), false);
    }

    public void init(int aAtomsCount, QString aSymbol, boolean aMakeBonds) {
        this.setTimestamp(new QDateTime());
        this.setOrigin(new QString("Mnova"));
        this.fMaxFixedNum = 0;
        if (aAtomsCount == 0) {
            return;
        }
        double alpha = UtilGeometry.piDouble / (double)aAtomsCount;
        double r = (double)aAtomsCount / 6.0;
        for (int i = 0; i < aAtomsCount; ++i) {
            TAtom atom = new TAtom();
            atom.setX(r * Math.sin((double)i * alpha));
            atom.setY(r * Math.cos((double)i * alpha));
            atom.setZ(0.0);
            atom.getTatomData().setNumber(new QString("" + (i + 1)));
            if (!aSymbol.isEmpty()) {
                this.setToElement(atom, aSymbol);
            }
            this.addAtom(atom);
            if (!aMakeBonds || i <= 0) continue;
            TBond bnd = new TBond(i - 1, i, TBondType.btSingle, TBondStereo.bsNone);
            this.addBond(bnd);
            if (i != aAtomsCount - 1) continue;
            bnd = new TBond(0, i, TBondType.btSingle, TBondStereo.bsNone);
            this.addBond(bnd);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TMolecule other = (TMolecule)obj;
        if (this.tVariantData.data(new QString("PCT")) != null || other.tVariantData.data(new QString("PCT")) != null || this.tVariantData.data(new QString("SSPopulation")) != null || other.tVariantData.data(new QString("SSPopulation")) != null) {
            return false;
        }
        return false;
    }

    public QRectF getBound() {
        QRectF bound = new QRectF();
        if (this.fAtoms.count() > 0) {
            TAtom atom0 = this.fAtoms.at(0);
            bound.setCoords((Double)atom0.x(), (Double)atom0.y(), (Double)atom0.x(), (Double)atom0.y());
            for (int i = 1; i < this.fAtoms.count(); ++i) {
                TAtom atom1 = this.fAtoms.at(i);
                QRectF rect = new QRectF();
                rect.setCoords((Double)atom0.x(), (Double)atom0.y(), (Double)atom1.x(), (Double)atom1.y());
                bound = bound.unite(rect);
                atom0 = atom1;
            }
        } else {
            bound.setCoords(0.0, 0.0, 1.0, 1.0);
        }
        bound = bound.normalized();
        if (bound.width() == 0.0 || bound.height() == 0.0) {
            QPoint<Double> center = bound.center();
            if (bound.width() == 0.0) {
                bound.setWidth(1.0);
            }
            if (bound.height() == 0.0) {
                bound.setHeight(1.0);
            }
            bound.moveCenter(center);
        }
        bound.setCoords(bound.left(), bound.bottom(), bound.right(), bound.top());
        return bound;
    }

    public int addAtom(TAtom aAtom) {
        this.fAtoms.append(aAtom);
        return this.fAtoms.size() - 1;
    }

    public void removeAtom(int atomInd) {
        if (atomInd < 0 || atomInd >= this.fAtoms.size()) {
            return;
        }
        TAtom atm = this.atom(atomInd);
        int _size = this.bonds().size();
        for (int i = _size - 1; i >= 0; --i) {
            TBond bnd = this.bond(i);
            if (bnd.atom1() == atomInd || bnd.atom2() == atomInd) {
                this.fBonds.removeAt(i);
                continue;
            }
            if (bnd.atom1() > atomInd) {
                bnd.setAtom1(bnd.atom1() - 1);
            }
            if (bnd.atom2() <= atomInd) continue;
            bnd.setAtom2(bnd.atom2() - 1);
        }
        int _size2 = this.atoms().size();
        for (int i = 0; i < _size2; ++i) {
            TAtom at1 = this.atom(i);
            if (at1 == atm) continue;
            this.removeNeigh(i, atomInd, true);
        }
        if (atm.fixedNumber() && atm.getTatomData().number().toInt() > this.fMaxFixedNum) {
            this.fMaxFixedNum = atm.getTatomData().number().toInt();
        }
        this.fAtoms.removeAt(atomInd);
    }

    public void removeNeigh(int atom1, int atom2, boolean doCheckNH) {
        TAtom atm = this.atom(atom1);
        if (atm != null) {
            for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                TNeighbour nb = atm.getfNeighbours().at(j);
                if (!nb.getfAtom().equals(this.atom(atom2))) continue;
                atm.getfNeighbours().removeAt(j);
                if (!doCheckNH) break;
                this.checkValence(atm);
                break;
            }
        }
    }

    public void removeBond(int atom1, int atom2) {
        int _size = this.fBonds.size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd = this.bond(i);
            if ((bnd.atom1() != atom1 || bnd.atom2() != atom2) && (bnd.atom2() != atom1 || bnd.atom1() != atom2)) continue;
            this.fBonds.removeAt(i);
            break;
        }
        this.removeNeigh(atom1, atom2, true);
        this.removeNeigh(atom2, atom1, true);
    }

    public void mergeAtoms(int toDel, int toStay) {
        TAtom atomDel = this.atom(toDel);
        TAtom atomStay = this.atom(toStay);
        for (int j = 0; j < atomDel.getfNeighbours().size(); ++j) {
            TNeighbour nb = atomDel.getfNeighbours().at(j);
            if (nb.getfAtom().equals(atomStay) || this.findBond(nb.getfBond().getSecond(toDel), toStay) != null) continue;
            TBond bnd = new TBond(nb.getfBond());
            if (bnd.atom1() == toDel) {
                bnd.setAtom1(toStay);
            }
            if (bnd.atom2() == toDel) {
                bnd.setAtom2(toStay);
            }
            this.addBond(bnd);
        }
        this.removeAtom(toDel);
    }

    public void changeBondType(int atom1, int atom2, int aParam) {
        TBond bnd = this.findBond(atom1, atom2);
        if (bnd == null || bnd.bondType() == TBondType.btAromatic) {
            return;
        }
        if (aParam == 2 || aParam == 8) {
            if (bnd.bondStereo() != TBondStereo.bsNone) {
                bnd.setBondStereo(TBondStereo.bsNone);
            } else {
                this.changeBondMultiplicity(atom1, atom2);
            }
        } else if (aParam <= -1 && aParam >= -3) {
            TBondType bt = TBondType.btSingle;
            if (aParam == -2) {
                bt = TBondType.btDouble;
            } else if (aParam == -3) {
                bt = TBondType.btTriple;
            }
            if (bnd.bondType() != bt) {
                if (bnd.bondStereo().getValue() != TBondStereo.bsNone.getValue()) {
                    bnd.setBondStereo(TBondStereo.bsNone);
                }
                bnd.setBondType(bt);
                this.checkValence(this.atom(atom1));
                this.checkValence(this.atom(atom2));
            }
        } else {
            if (bnd.bondType() != TBondType.btSingle) {
                bnd.setBondType(TBondType.btSingle);
                this.checkValence(this.atom(atom1));
                this.checkValence(this.atom(atom2));
            }
            if (aParam == 3) {
                bnd.setBondStereo(TBondStereo.bsUp);
            } else if (aParam == 4) {
                bnd.setBondStereo(TBondStereo.bsDown);
            }
        }
    }

    public boolean changeBondMultiplicity(int atom1, int atom2) {
        int _size = this.fBonds.size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd = this.bond(i);
            if ((bnd.atom1() != atom1 || bnd.atom2() != atom2) && (bnd.atom2() != atom1 || bnd.atom1() != atom2)) continue;
            TBondType bt = bnd.bondType();
            if (bt != TBondType.btTriple && !this.atomValenceExceeded(atom1) && !this.atomValenceExceeded(atom2)) {
                if (bt == TBondType.btSingle) {
                    bt = TBondType.btDouble;
                } else if (bt == TBondType.btDouble) {
                    bt = TBondType.btTriple;
                }
            } else if (bt == TBondType.btDouble || bt == TBondType.btTriple) {
                bt = TBondType.btSingle;
            }
            if (bt == bnd.bondType()) break;
            bnd.setBondType(bt);
            this.checkValence(this.atom(atom1));
            this.checkValence(this.atom(atom2));
            return true;
        }
        return false;
    }

    public void checkValence(TAtom aAtom) {
        this.checkValence(aAtom, true);
    }

    public void checkValence(TAtom aAtom, boolean aDoCorrectCharge) {
        if (aDoCorrectCharge) {
            aAtom.correctCharge();
        }
        aAtom.setfValence(this.findValence(aAtom));
        aAtom.checknH();
    }

    public void checknH() {
        for (int i = 0; i < this.atoms().size(); ++i) {
            TAtom atm = this.atom(i);
            atm.checknH();
        }
    }

    public boolean invalidValence(TAtom aAtom) {
        return this.findValence(aAtom) == -1 && !aAtom.getfElement().getfElementValences().toString().equals("");
    }

    public boolean atomValenceExceeded(int aIndex) {
        TAtom atm = this.atom(aIndex);
        if (atm == null) {
            return false;
        }
        if (atm.nH() > 0) {
            return false;
        }
        QList<Integer> valences = atm.stableValences();
        if (valences.size() == 0) {
            return false;
        }
        return atm.getfValence() >= valences.at(valences.size() - 1);
    }

    public void setToElement(TAtom aAtom, QString aName) {
        aAtom.setElementSymbol(aName);
        this.checkValence(aAtom);
    }

    public void setToCarbon(TAtom aAtom) {
        this.setToElement(aAtom, new QString("C"));
    }

    public int getNextNumber() {
        if (this.atoms().isEmpty()) {
            return 1;
        }
        int max = this.fMaxFixedNum;
        for (int i = 0; i < this.atoms().size(); ++i) {
            if (this.atoms().at(i).getTatomData().number().toInt() <= max) continue;
            max = this.atoms().at(i).getTatomData().number().toInt();
        }
        return max + 1;
    }

    public void addNewAtomTo(int aToAtom, QPoint<Double> aNewAtomCoord, TBondStereo aBondStereo) {
        this.addNewAtomTo(aToAtom, aNewAtomCoord, aBondStereo, new QString(""));
    }

    public void addNewAtomTo(int aToAtom, QPoint<Double> aNewAtomCoord, TBondStereo aBondStereo, QString aName) {
        TAtom atm = this.atom(aToAtom);
        TAtom atomNew = new TAtom();
        atomNew.setX(aNewAtomCoord.x());
        atomNew.setY(aNewAtomCoord.y());
        atomNew.setZ(0.0);
        atomNew.getTatomData().setNumber(new QString("" + this.getNextNumber()));
        this.addAtom(atomNew);
        TBond bnd = new TBond(aToAtom, this.atoms().size() - 1, TBondType.btSingle, aBondStereo);
        this.addBond(bnd);
        this.checkValence(atm);
        TAtom atm2 = this.atom(bnd.atom2());
        if (aName.isEmpty()) {
            this.setToCarbon(atm2);
        } else {
            this.setToElement(atm2, aName);
        }
    }

    public void addBond(TBond aBond) {
        this.addBond(aBond, false, true);
    }

    public void addBond(TBond aBond, boolean aDoCheckNH) {
        this.addBond(aBond, aDoCheckNH, true);
    }

    public void addBond(TBond aBond, boolean aDoCheckNH, boolean aDoCorrectCharge) {
        this.fBonds.append(aBond);
        TBond bond = this.fBonds.last();
        this.setAtomsNeighs(bond);
        if (aDoCheckNH) {
            TAtom atm2;
            TAtom atm1 = this.atom(bond.atom1());
            if (atm1 != null) {
                this.checkValence(atm1, aDoCorrectCharge);
            }
            if ((atm2 = this.atom(bond.atom2())) != null) {
                this.checkValence(atm2, aDoCorrectCharge);
            }
        }
    }

    public void setAtomsNeighs(TBond bond) {
        TNeighbour neighbour = new TNeighbour();
        neighbour.setfAtom(this.fAtoms.at(bond.atom2()));
        neighbour.setfBond(bond);
        this.fAtoms.at(bond.atom1()).getfNeighbours().append(neighbour);
        neighbour = new TNeighbour();
        neighbour.setfAtom(this.fAtoms.at(bond.atom1()));
        neighbour.setfBond(bond);
        this.fAtoms.at(bond.atom2()).getfNeighbours().append(neighbour);
    }

    public void fillAtomsNeighs() {
        int _size = this.bonds().size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd = this.bond(i);
            this.setAtomsNeighs(bnd);
        }
    }

    public int findValence(TAtom aAtom) {
        int minValence = -1;
        if (aAtom.getfElement().getfElementValences().toString().equals("")) {
            return minValence;
        }
        QList<Integer> valences = aAtom.stableValences();
        int neigh = aAtom.getConnCount(false);
        int charge = aAtom.getfCharge();
        if (charge != 0) {
            neigh = charge > 0 ? (neigh -= Math.abs(charge)) : (neigh += Math.abs(charge));
        }
        for (int i = 0; i < valences.size(); ++i) {
            if (valences.at(i) - neigh < 0) continue;
            minValence = valences.at(i);
            break;
        }
        return minValence;
    }

    @Override
    public void clear() {
        this.fAtoms.clear();
        this.fBonds.clear();
        this.fOriginalMolfile.clear();
        this.fPolymers.clear();
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public TAtom atom(int aIndex) {
        if (0 <= aIndex && aIndex < this.fAtoms.count()) {
            return this.fAtoms.at(aIndex);
        }
        return null;
    }

    public TBond bond(int aIndex) {
        if (0 <= aIndex && aIndex < this.fBonds.count()) {
            return this.fBonds.at(aIndex);
        }
        return null;
    }

    public int atomIndex(TAtom aAtom) {
        if (aAtom != null) {
            return this.fAtoms.indexOf(aAtom);
        }
        return -1;
    }

    public int bondIndex(TBond bond) {
        if (bond != null) {
            return this.fBonds.indexOf(bond);
        }
        return -1;
    }

    public QVector<TAtom> getAtoms() {
        QVector<TAtom> result = new QVector<TAtom>(this.fAtoms);
        return result;
    }

    public QVector<TBond> getBonds() {
        QVector<TBond> result = new QVector<TBond>(this.fBonds);
        return result;
    }

    public QByteArray getMolfile(boolean aUseUniqueNumbering) throws Exception {
        throw new Exception("method  not implemented");
    }

    public int maxANAtom(TAtom aAtom) {
        QList<Integer> aiNeighbour = this.atomIndexNeighbours(aAtom);
        if (!aiNeighbour.isEmpty()) {
            return aiNeighbour.last();
        }
        return this.atomIndex(aAtom);
    }

    public QList<Integer> atomIndexNeighbours(TAtom aAtom) {
        QList<Integer> aiNeighbour = new QList<Integer>();
        for (int i = 0; i < aAtom.getfNeighbours().count(); ++i) {
            TAtom atom = aAtom.getfNeighbours().at(i).getfAtom();
            if (atom == null) continue;
            int ai = this.atomIndex(atom);
            aiNeighbour.append(ai);
        }
        Collections.sort(aiNeighbour.arrayList());
        return aiNeighbour;
    }

    public QList<Integer> atomTerminalNeighbours(TAtom aAtom) {
        QList<Integer> aiNeighbour = new QList<Integer>();
        for (int i = 0; i < aAtom.getfNeighbours().count(); ++i) {
            TAtom atom = aAtom.getfNeighbours().at(i).getfAtom();
            if (atom == null || atom.getfNeighbours().size() != 1) continue;
            aiNeighbour.append(this.atomIndex(atom));
        }
        Collections.sort(aiNeighbour.arrayList());
        return aiNeighbour;
    }

    public boolean isSCClockwise(TAtom aAtom) {
        boolean implicitH = false;
        QList<Integer> neighbours = this.atomIndexNeighbours(aAtom);
        if (aAtom.nH() > 0) {
            implicitH = true;
        }
        if (!implicitH && aAtom.getfValence() == 4) {
            neighbours.removeLast();
        }
        QPolygon triangle = new QPolygon();
        triangle.add(this.atom(neighbours.first()));
        triangle.add(this.atom(neighbours.at(1)));
        triangle.add(this.atom(neighbours.last()));
        boolean clockwise = false;
        int sign = this.determinant(triangle);
        if (sign > 0) {
            clockwise = false;
        } else if (sign < 0) {
            clockwise = true;
        }
        if (implicitH) {
            return !clockwise;
        }
        return clockwise;
    }

    public int determinant(QPolygon aTriangle) {
        double x1 = (Double)aTriangle.at(0).x();
        double x2 = (Double)aTriangle.at(1).x();
        double x3 = (Double)aTriangle.at(2).x();
        double y1 = (Double)aTriangle.at(0).y();
        double y2 = (Double)aTriangle.at(1).y();
        double y3 = (Double)aTriangle.at(2).y();
        return (int)Math.round(x1 * y2 + x2 * y3 + y1 * x3 - x3 * y2 - y3 * x1 - y1 * x2);
    }

    public int bsAtom2(TAtom aAtom) {
        int index2 = this.atomIndex(aAtom);
        QList<Integer> aiNeighbour = this.atomIndexNeighbours(aAtom);
        if (aiNeighbour.isEmpty()) {
            return index2;
        }
        for (int ai = 0; ai < aiNeighbour.count(); ++ai) {
            if (this.atom(aiNeighbour.at(ai)).getfNeighbours().count() != 1) continue;
            return aiNeighbour.at(ai);
        }
        return index2;
    }

    public double maxCoords(QList<TAtom> aAtomList) {
        double max = 0.0;
        for (int i = 0; i < aAtomList.size(); ++i) {
            TAtom atom = aAtomList.at(i);
            if (Math.abs((Double)atom.x()) > Math.abs(max)) {
                max = (Double)atom.x();
            }
            if (Math.abs((Double)atom.y()) > Math.abs(max)) {
                max = (Double)atom.y();
            }
            if (!(Math.abs(atom.z()) > Math.abs(max))) continue;
            max = atom.z();
        }
        max = max != 0.0 ? max : 1.0;
        return Math.abs(max);
    }

    public int elementCount(QByteArray aElement) {
        return this.elementCount(aElement, false);
    }

    public int elementCount(QByteArray aElement, boolean aCheckHydrogenIsotopes) {
        int count = 0;
        if (aCheckHydrogenIsotopes && !"H".equals(new String(aElement.toString())) && !"D".equals(new String(aElement.toString())) && !"T".equals(new String(aElement.toString()))) {
            aCheckHydrogenIsotopes = false;
        }
        for (int i = 0; i < this.fAtoms.size(); ++i) {
            TAtom atom = this.fAtoms.at(i);
            if (aCheckHydrogenIsotopes && "H".equals(new String(aElement.toString())) && "H".equals(atom.elementSymbol().toString()) && atom.getfIsotope() != 0) continue;
            if (aCheckHydrogenIsotopes && "H".equals(atom.elementSymbol().toString()) && ("D".equals(new String(aElement.toString())) && atom.getfIsotope() == 2 || "T".equals(new String(aElement.toString())) && atom.getfIsotope() == 3)) {
                ++count;
                continue;
            }
            if (new String(aElement.toString()).equals(atom.elementSymbol().toString())) {
                ++count;
                continue;
            }
            if (!"H".equals(new String(aElement.toString()))) continue;
            count += atom.nH();
        }
        return count;
    }

    public QMap<QString, Integer> collectElementsMap() {
        QMap<QString, Integer> res = new QMap<QString, Integer>();
        int protons = this.elementCount(new QByteArray(new QString("H")), true);
        if (protons > 0) {
            res.add(new QString("H"), protons);
        }
        if ((protons = this.elementCount(new QByteArray(new QString("D")), true)) > 0) {
            res.add(new QString("D"), protons);
        }
        if ((protons = this.elementCount(new QByteArray(new QString("T")), true)) > 0) {
            res.add(new QString("T"), protons);
        }
        for (TAtom atom : this.fAtoms) {
            QString symbol = atom.elementSymbol();
            if (symbol.isEmpty() || symbol.toString().equals("H") || symbol.toString().equals("D") || symbol.toString().equals("T")) continue;
            if (atom.getfElement() != null && !atom.getfElement().getfElementName().equals(TPeriodicTable.getInstance().nullElement().getfElementName())) {
                if (atom.getfIsotope() > 0) {
                    QString key;
                    res.add(key, res.find(key = new QString(symbol + "-" + atom.getfIsotope())) != null ? res.find(key) + 1 : 1);
                    continue;
                }
                res.add(symbol, res.find(symbol) != null ? res.find(symbol) + 1 : 1);
                continue;
            }
            QString repl = TMoleculeAnalyzer.getMolFormulaByLabel(symbol);
            if (!repl.isEmpty()) {
                symbol = repl;
            }
            QMap<QString, Integer> curr = new QMap<QString, Integer>();
            ParserVO vo = UtilMolFormula.parse(symbol, curr);
            curr = vo.fElements;
            if (!vo.result) {
                res.add(symbol, res.find(symbol) != null ? res.find(symbol) + 1 : 1);
                continue;
            }
            for (QString el : curr.keys()) {
                res.add(el, curr.find(el) + (res.find(el) != null ? res.find(el) : 0));
            }
        }
        return res;
    }

    public void appendElement(QString aDest, QString aElement) {
        int pos = aElement.indexOf("-");
        if (pos > 0) {
            QString el = aElement;
            aDest.append("^" + el.remove(0, pos + 1).toString() + "^" + el.left(pos).toString());
        } else {
            aDest.append(aElement);
        }
    }

    public QString molecularFormula() {
        QList<QString> elements = new QList<QString>();
        QMap<QString, Integer> elementMap = this.collectElementsMap();
        for (QString l : elementMap.keys()) {
            elements.append(l);
        }
        Collections.sort(elements.arrayList(), new QString());
        QString partC = new QString();
        QString partH = new QString();
        QString partD = new QString();
        QString partT = new QString();
        QString formula = new QString();
        for (int i = 0; i < elements.count(); ++i) {
            QString symbol = (QString)elements.at(i);
            int count = elementMap.find(symbol);
            if ("H".equals(symbol.toString())) {
                this.appendElement(partH, symbol);
                if (count <= 1) continue;
                partH.append(new QString("" + count));
                continue;
            }
            if ("D".equals(symbol.toString())) {
                this.appendElement(partD, symbol);
                if (count <= 1) continue;
                partD.append(new QString("" + count));
                continue;
            }
            if ("T".equals(symbol.toString())) {
                this.appendElement(partT, symbol);
                if (count <= 1) continue;
                partT.append(new QString("" + count));
                continue;
            }
            if ("C".equals(symbol.toString()) || symbol.startsWith("C-")) {
                this.appendElement(partC, symbol);
                if (count <= 1) continue;
                partC.append(new QString("" + count));
                continue;
            }
            this.appendElement(formula, symbol);
            if (count <= 1) continue;
            formula.append(new QString("" + count));
        }
        return partC.append(partH.toString()).append(partD.toString()).append(partT.toString()).append(formula.toString());
    }

    public double mass(boolean aAverage) {
        double weight = 0.0;
        for (TAtom atom : this.fAtoms) {
            QString symbol = atom.elementSymbol();
            if (atom.getfElement() != null && atom.getfElement().getfElementName().equals(TPeriodicTable.getInstance().nullElement().getfElementName()) && !atom.getfAlias().isEmpty()) {
                QString repl = TMoleculeAnalyzer.getMolFormulaByLabel(symbol);
                if (!repl.isEmpty()) {
                    symbol = repl;
                }
                weight += UtilMolFormula.molecularMass(symbol, aAverage);
                continue;
            }
            if ("H".equals(symbol.toString())) continue;
            weight += atom.mass(aAverage);
        }
        int protons = this.elementCount(new QByteArray(new QString("H")), true);
        int dCount = this.elementCount(new QByteArray(new QString("D")), true);
        int tCount = this.elementCount(new QByteArray(new QString("T")), true);
        weight = aAverage ? (weight += (double)protons * TPeriodicTable.getInstance().operatorElementSymbol(new QString("H")).getfAverageMass() + (double)dCount * TPeriodicTable.getInstance().operatorElementSymbol(new QString("D")).getfAverageMass() + (double)tCount * TPeriodicTable.getInstance().operatorElementSymbol(new QString("T")).getfAverageMass()) : (weight += (double)protons * TPeriodicTable.getInstance().operatorElementSymbol(new QString("H")).getfMonoisotopicMass() + (double)dCount * TPeriodicTable.getInstance().operatorElementSymbol(new QString("D")).getfMonoisotopicMass() + (double)tCount * TPeriodicTable.getInstance().operatorElementSymbol(new QString("T")).getfMonoisotopicMass());
        return weight;
    }

    public double averageMass() {
        return this.mass(true);
    }

    public double monoisotopicMass() {
        return this.mass(false);
    }

    public QByteArray elementSymbol(TAtomIndex aAtomIndex) {
        TAtom atm = this.atom(aAtomIndex.atomIndex());
        if (atm != null) {
            switch (aAtomIndex.hIndex()) {
                case 0: {
                    return new QByteArray(atm.getfElement().getfElementSymbol());
                }
            }
            if (atm.nH() >= aAtomIndex.hIndex()) {
                return new QByteArray(new QString("H"));
            }
        }
        return new QByteArray();
    }

    public Object SDData() throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean hasSDData() {
        return this.data(cSDDataName) != null;
    }

    public QString SDTagValue(QString aTagName) throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean equal(TMolecule aM) {
        if (this.data(new QString("PCT")) != null || aM.data(new QString("PCT")) != null || this.data(new QString("SSPopulation")) != null || aM.data(new QString("SSPopulation")) != null) {
            return false;
        }
        this.detectAromaticAtoms();
        aM.detectAromaticAtoms();
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.equal(aM);
    }

    public void setUniqueNumbering() {
        this.setUniqueNumbering(false);
    }

    public void setUniqueNumbering(boolean aProtons) {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        ma.setUniqueNumbering(aProtons);
    }

    public QList<TAtom> atoms() {
        return this.fAtoms;
    }

    public QList<TBond> bonds() {
        return this.fBonds;
    }

    public void sortBonds() {
        TBondsOrder bondsOrder = new TBondsOrder(this);
        Collections.sort(this.fBonds.arrayList(), bondsOrder);
    }

    public TBond findBond(int atom1, int atom2) {
        int _size = this.fBonds.size();
        for (int i = 0; i < _size; ++i) {
            TBond bnd = this.bond(i);
            if ((bnd.atom1() != atom1 || bnd.atom2() != atom2) && (bnd.atom2() != atom1 || bnd.atom1() != atom2)) continue;
            return bnd;
        }
        return null;
    }

    public double meanBondLength() {
        double length = 0.0;
        int bCount = 0;
        TAtom atom1 = null;
        TAtom atom2 = null;
        for (int i = 0; i < this.fBonds.count(); ++i) {
            atom1 = this.atom(this.fBonds.at(i).atom1());
            atom2 = this.atom(this.fBonds.at(i).atom2());
            if (atom1 == null || atom2 == null) continue;
            length += atom1.distance(atom2);
            ++bCount;
        }
        return length / (double)bCount;
    }

    public double minBondLength() {
        double minLength = Double.MAX_VALUE;
        double length = 0.0;
        TAtom atom1 = null;
        TAtom atom2 = null;
        for (int i = 0; i < this.fBonds.count(); ++i) {
            atom1 = this.atom(this.fBonds.at(i).atom1());
            atom2 = this.atom(this.fBonds.at(i).atom2());
            if (atom1 == null || atom2 == null || !((length = atom1.distance(atom2)) < minLength)) continue;
            minLength = length;
        }
        return minLength;
    }

    public int heteroatomsWithHCount() {
        int cnt = 0;
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            if (atm.isCarbon() || atm.isHydrogen() || atm.nHAll() <= 0) continue;
            ++cnt;
        }
        return cnt;
    }

    public int totalHCount() {
        int cnt = 0;
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            if (atm.isHydrogen()) continue;
            cnt += atm.nHAll();
        }
        return cnt;
    }

    public int heavyAtomsCount() {
        int cnt = 0;
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            if (atm.isHydrogen()) continue;
            ++cnt;
        }
        return cnt;
    }

    public void expandSimpleAliases() {
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            if (!atm.expandSimpleAlias()) continue;
            atm.setfValence(this.findValence(atm));
        }
    }

    public void detectAromaticAtoms() {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        ma.detectAromaticAtoms();
    }

    public QList<Integer> findAromaRing(int aN1, int aN2, boolean aAromaDetected) {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.findAromaRing(aN1, aN2, aAromaDetected);
    }

    public boolean isAromaticAtom(int aIndex) {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.isAromaticAtom(aIndex);
    }

    public QList<Integer> aromaticAtoms() {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.aromaticAtoms();
    }

    public boolean isSymmetricalAtoms(int aN1, int aN2) {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.isSymmetricalAtoms(aN1, aN2);
    }

    public QList<Integer> symmetricalAtoms(int aIndex) {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.symmetricalAtoms(aIndex);
    }

    public TAromPattern detectAromaticPatternSubstitution() {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.detectAromaticPatternSubstitution();
    }

    public TPolymer getPolymer(int aNum) {
        for (int i = 0; i < this.fPolymers.size(); ++i) {
            if (this.fPolymers.at(i).getNum() != aNum) continue;
            return this.fPolymers.at(i);
        }
        this.fPolymers.append(new TPolymer(aNum));
        return this.fPolymers.at(this.fPolymers.size() - 1);
    }

    public int polymerCount() {
        return this.fPolymers.size();
    }

    public void mergeMultiPolymers() {
        int nPolymers = this.polymerCount();
        for (int polyNum = 1; polyNum <= nPolymers; ++polyNum) {
            int j;
            TPolymer poly = this.getPolymer(polyNum);
            if (!poly.getSgType().toString().equals("MUL") || poly.getSpAtomList().isEmpty()) continue;
            QList<Integer> gAtoms = poly.getAtomList(false);
            QList<Integer> pAtoms = poly.getAtomList(true);
            QList<Integer> dAtoms = new QList<Integer>(gAtoms);
            for (int j2 = 0; j2 < pAtoms.size(); ++j2) {
                dAtoms.removeAll(pAtoms.at(j2));
            }
            int _size = this.fBonds.size();
            for (j = _size - 1; j >= 0; --j) {
                TBond bnd = this.bond(j);
                if (!dAtoms.contains(bnd.atom1()) && !dAtoms.contains(bnd.atom2())) continue;
                if (!gAtoms.contains(bnd.atom1()) || !gAtoms.contains(bnd.atom2())) {
                    int eNum;
                    int dNum;
                    if (dAtoms.contains(bnd.atom1())) {
                        dNum = bnd.atom1();
                        eNum = bnd.atom2();
                    } else {
                        dNum = bnd.atom2();
                        eNum = bnd.atom1();
                    }
                    int pNum = -1;
                    for (int k = 0; k < pAtoms.size(); ++k) {
                        if (this.atom(dNum).x() != this.atom(pAtoms.at(k)).x() || this.atom(dNum).y() != this.atom(pAtoms.at(k)).y()) continue;
                        pNum = pAtoms.at(k);
                        break;
                    }
                    if (pNum < 0) continue;
                    TBond newBond = new TBond(pNum, eNum, bnd.bondType(), bnd.bondStereo());
                    this.addBond(newBond);
                }
                this.removeNeigh(bnd.atom1(), bnd.atom2(), false);
                this.removeNeigh(bnd.atom2(), bnd.atom1(), false);
                this.fBonds.removeAt(j);
            }
            _size = this.fAtoms.size();
            for (j = _size - 1; j >= 0; --j) {
                if (!dAtoms.contains(j)) continue;
                this.fAtoms.removeAt(j);
            }
            poly.setSgAtomList(poly.getSpAtomList());
            poly.setSpAtomList(new QString(""));
            if (!poly.getSgConn().isEmpty()) continue;
            poly.setSgConn(new QString("HT"));
        }
    }

    public void setStereoNotations() {
        int nPolymers = this.polymerCount();
        for (int polyNum = 1; polyNum <= nPolymers; ++polyNum) {
            int bIndex;
            TBond bnd;
            QList<Integer> lst;
            TPolymer poly = this.getPolymer(polyNum);
            if (!poly.getSgType().equals(new QString("DAT")) || poly.getSgAtomList().isEmpty() && poly.getSgBondList().isEmpty()) continue;
            if (!poly.getSgAtomList().isEmpty() && (lst = poly.getAtomList(false)).size() == 1) {
                int aIndex = lst.at(0);
                this.atom(aIndex).setStereoNotation(poly.getSgDataEnd());
            }
            if (poly.getSgBondList().isEmpty() || poly.getSgBondList().mid(0, 3).toInt() != 1 || (bnd = this.bond(bIndex = poly.getSgBondList().mid(3, 3).toInt() - 1)) == null) continue;
            bnd.setStereoNotation(poly.getSgDataEnd());
        }
    }

    public void addChargedNO() {
        block0: for (int i = 0; i < this.atoms().size(); ++i) {
            TAtom atmN = this.atom(i);
            if (!atmN.elementSymbol().toString().equals("N") || atmN.getfValence() != 5 || atmN.getfCharge() != 0) continue;
            for (int j = 0; j < atmN.getfNeighbours().size(); ++j) {
                TNeighbour nb = atmN.getfNeighbours().at(j);
                TAtom atmO = nb.getfAtom();
                TBond bnd = nb.getfBond();
                if (!atmO.elementSymbol().equals("O") || bnd.bondType() != TBondType.btDouble) continue;
                bnd.setBondType(TBondType.btSingle);
                atmO.setfCharge(-1);
                atmN.setfCharge(1);
                atmN.setfValence(3);
                continue block0;
            }
        }
    }

    public void setConformerList(QList<TMoleculeConformer> aList) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QList<TMoleculeConformer> conformerList() throws Exception {
        throw new Exception("Method not implemented");
    }

    public boolean hasConformers() throws Exception {
        throw new Exception("Method not implemented");
    }

    public QByteArray conformerHash() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void setTimestamp(QDateTime aTimestamp) {
        this.tVariantData.setData(cTimestamp, aTimestamp.toString("MMddyyhhmm"));
    }

    public QDateTime timestamp() {
        QString timestamp = this.tVariantData.data(cTimestamp);
        QDateTime date = new QDateTime();
        if (timestamp != null) {
            return QDateTime.fromString(timestamp, "MMddyyhhmm");
        }
        return date;
    }

    public void setComment(QString aComment) {
        QString molfileComment = aComment;
        molfileComment.replace("\r", "");
        molfileComment.replace("\n", "");
        this.tVariantData.setData(cComment, molfileComment);
    }

    public QString comment(boolean aMolfileLenLimit) {
        QString comment = this.tVariantData.data(cComment);
        if (comment != null) {
            if (!aMolfileLenLimit) {
                return comment;
            }
            return comment.left(80);
        }
        return new QString();
    }

    public void setName(QString aName) {
        QString molfileName = aName;
        molfileName.replace("\r", "");
        molfileName.replace("\n", "");
        this.tVariantData.setData(cName, molfileName);
    }

    public QString name(boolean aMolfileLenLimit) {
        QString name = this.tVariantData.data(cName);
        if (name != null) {
            if (!aMolfileLenLimit) {
                return name;
            }
            return name.left(80);
        }
        return new QString();
    }

    public void setOrigin(QString aOrigin) {
        QString molfileOrigin = aOrigin.trimmed();
        molfileOrigin.replace("\r", "");
        molfileOrigin.replace("\n", "");
        this.tVariantData.setData(cOrigin, molfileOrigin);
    }

    public QString origin(boolean aMolfileLenLimit) {
        QString origin = this.tVariantData.data(cOrigin);
        if (origin != null) {
            if (!aMolfileLenLimit) {
                return origin;
            }
            return origin.left(80);
        }
        return new QString();
    }

    public void setLabel(QString aLabel) {
        this.tVariantData.setData(cLabel, aLabel);
    }

    public QString label() {
        QString aLabel = this.tVariantData.data(cLabel);
        if (aLabel != null) {
            return aLabel;
        }
        return new QString();
    }

    public void setAliases(QList<QString> aList) {
        QString aliasResult = new QString();
        for (QString alias : aList) {
            aliasResult.append(alias.append(new QString(" ")));
        }
        this.tVariantData.setData(cAliases, aliasResult);
    }

    public QList<QString> aliases() {
        QString aliases = this.tVariantData.data(cAliases);
        QList<QString> result = new QList<QString>();
        if (aliases != null) {
            for (String alias : aliases.toString().split(" ")) {
                result.append(new QString(alias));
            }
        }
        return result;
    }

    public void setColor(QColor aColor) {
        this.tVariantData.setData(cColor, new QString(aColor.getHexValue()));
    }

    public QColor color() {
        QString color = this.tVariantData.data(cColor);
        if (color != null) {
            return new QColor(color.toString());
        }
        return new QColor();
    }

    public QString fileName() {
        QString filename = this.tVariantData.data(cFileName);
        if (filename != null) {
            return filename;
        }
        return null;
    }

    public boolean numberingDiffersFromIndexes() {
        for (int i = 0; i < this.atoms().size(); ++i) {
            TAtom atm = this.atom(i);
            if (atm.getTatomData().number().toString().equals("" + (i + 1))) continue;
            return true;
        }
        return false;
    }

    public static boolean saveNumberingToMolfiles() {
        TDefaultsIni settings = TDefaultsIni.getInstance();
        return settings.value(cSaveNumberingToMolfilesKey, new QString("true")).toBool();
    }

    public void setSaveNumberingToMolfiles(boolean aSave) {
        TDefaultsIni settings = TDefaultsIni.getInstance();
        settings.setValue(cSaveNumberingToMolfilesKey, new QString(Boolean.toString(aSave)));
    }

    public boolean containsAromaticAtoms() {
        this.detectAromaticAtoms();
        for (int i = 0; i < this.atoms().size(); ++i) {
            if (!this.isAromaticAtom(i)) continue;
            return true;
        }
        return false;
    }

    public boolean containsDoubleOrAromaBond() {
        for (int i = 0; i < this.bonds().size(); ++i) {
            TBond bnd = this.bond(i);
            if (bnd.bondType() != TBondType.btDouble && bnd.bondType() != TBondType.btAromatic) continue;
            return true;
        }
        return false;
    }

    public boolean containsCarbonyl() {
        for (int i = 0; i < this.bonds().size(); ++i) {
            TBond bnd = this.bond(i);
            if (bnd.bondType() != TBondType.btDouble) continue;
            TAtom atm1 = this.atom(bnd.atom1());
            TAtom atm2 = this.atom(bnd.atom2());
            if ((!atm1.isCarbon() || !atm2.isOxygen()) && (!atm2.isCarbon() || !atm1.isOxygen())) continue;
            return true;
        }
        return false;
    }

    public boolean containsWildcardAtoms() {
        for (int i = 0; i < this.atoms().size(); ++i) {
            if (this.atom(i) == null || !this.atom(i).isWildcardAtom()) continue;
            return true;
        }
        return false;
    }

    public boolean isLabileProton(int aIndex) {
        TAtom atm = this.atom(aIndex);
        if (atm == null) {
            return false;
        }
        if (atm.isHeteroAtom() && atm.nHAll() > 0) {
            return true;
        }
        int neigh = -1;
        return atm.isHydrogen() && (neigh = atm.getNeighByNum(0, aIndex)) >= 0 && this.atom(neigh).isHeteroAtom();
    }

    public void addFragment(TMolecule aMol) {
        int i;
        if (aMol.atoms().isEmpty()) {
            return;
        }
        QMap<Integer, Integer> oldToNew = new QMap<Integer, Integer>();
        int ind = this.atoms().size();
        for (i = 0; i < aMol.atoms().size(); ++i) {
            TAtom atm = aMol.atom(i);
            atm.getfNeighbours().clear();
            this.addAtom(atm);
            oldToNew.add(i, ind);
            ++ind;
        }
        for (i = 0; i < aMol.bonds().size(); ++i) {
            TBond oldBond = aMol.bond(i);
            TBond newBond = new TBond((Integer)oldToNew.find(oldBond.atom1()), (Integer)oldToNew.find(oldBond.atom2()), oldBond.bondType(), oldBond.bondStereo());
            this.addBond(newBond);
        }
    }

    public QList<Integer> duplicatedNumbers(QString aAtomNumber) {
        QList<Integer> result = new QList<Integer>();
        QString numberStart = aAtomNumber;
        numberStart.remove(cDuplicatedChar);
        QByteArray atomNumber = new QByteArray(numberStart);
        for (int ai = 0; ai < this.atoms().count(); ++ai) {
            QString number = new QString(new String(this.atom(ai).getTatomData().number().toString()));
            if (!new QByteArray(number = number.remove(cDuplicatedChar)).equals(atomNumber)) continue;
            result.append(ai);
        }
        Collections.sort(result.arrayList());
        return result;
    }

    public boolean containsNitrogen() {
        return this.elementCount(new QByteArray(new QString("N"))) > 0;
    }

    public boolean containsAdjacentNitrogens() {
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            if (!atm.isNitrogen()) continue;
            for (int j = 0; j < atm.getfNeighbours().size(); ++j) {
                TNeighbour nb = atm.getfNeighbours().at(j);
                if (!nb.getfAtom().isNitrogen()) continue;
                return true;
            }
        }
        return false;
    }

    public void stereoProc() {
        TStereoAnalyzer sa = new TStereoAnalyzer(this);
        sa.stereoProc();
    }

    public boolean isEnhancedCH2GroupFast(int aIndex) {
        TAtom atm = this.atom(aIndex);
        return atm != null && atm.isCarbon() && (atm.nHAll() == 2 || atm.nCH3() == 2);
    }

    public int isEnhancedCH2Group(int aIndex) {
        TStereoAnalyzer sa = new TStereoAnalyzer(this);
        return sa.isEnhancedCH2Group(aIndex);
    }

    public QMap<Integer, Integer> diasterotopicAtoms() {
        QMap<Integer, Integer> retHash = new QMap<Integer, Integer>();
        TStereoAnalyzer sa = new TStereoAnalyzer(this);
        int dist = 0;
        int atCount = this.atoms().size();
        for (int i = 0; i < atCount; ++i) {
            if (sa.isDiastereotopic(i, dist)) {
                retHash.insert(i, dist);
            }
            dist = 0;
        }
        return retHash;
    }

    public boolean isDiastereotopic(int aCH2, int aDist) {
        TStereoAnalyzer sa = new TStereoAnalyzer(this);
        return sa.isDiastereotopic(aCH2, aDist);
    }

    public boolean mContains(TMolecule aSubMol, boolean aCheckStereo) {
        this.detectAromaticAtoms();
        aSubMol.detectAromaticAtoms();
        if (aCheckStereo) {
            this.stereoProc();
            aSubMol.stereoProc();
        }
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        ma.setfCheckStereo(aCheckStereo);
        return ma.contains(aSubMol);
    }

    public boolean containsBroadLinePattern() throws Exception {
        throw new Exception("Method not implemented");
    }

    public QList<Integer> calcCommonCharge(int aPlus, int aMinus) {
        QList<Integer> result = new QList<Integer>();
        int Plus = 0;
        int Minus = 0;
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            int ch = atm.getfCharge();
            if (ch > 0) {
                Plus += ch;
                continue;
            }
            if (ch >= 0) continue;
            Minus += ch;
        }
        result.append(Plus);
        result.append(Minus);
        result.append(Plus + Minus);
        return result;
    }

    public void removeCharge() {
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            if (atm.getfCharge() <= 0) continue;
            atm.setfCharge(0);
            this.checkValence(atm, false);
        }
    }

    public TMolecule neutralize(boolean aOk) {
        TMoleculeAnalyzer ma = new TMoleculeAnalyzer(this);
        return ma.neutralize(aOk);
    }

    public QList<QString> storeNumbers() {
        QList<QString> res = new QList<QString>();
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            res.append(atm.getTatomData().number());
        }
        return res;
    }

    public void restoreNumbers(QList<QString> aNumbers) {
        int _size = this.atoms().size();
        for (int i = 0; i < _size; ++i) {
            TAtom atm = this.atom(i);
            atm.getTatomData().setNumber(new QString(aNumbers.at(i).toString()));
        }
    }

    public void addRemoveHush(QString aNumb, boolean aDoAdd, int aIndex) {
        QList<Integer> duplicatedAtoms = this.duplicatedNumbers(aNumb);
        if (duplicatedAtoms.isEmpty()) {
            return;
        }
        QString oldNumber = this.atom(aIndex).getTatomData().number();
        for (int i = 0; i < duplicatedAtoms.size(); ++i) {
            int ai = duplicatedAtoms.at(i);
            TAtom atm = this.atom(ai);
            QString newNumber = new QString(aNumb.toString());
            if (aDoAdd) {
                int charsToAdd = i + 1;
                QString add = new QString();
                for (int c = 0; c < charsToAdd; ++c) {
                    add.append(cDuplicatedChar);
                }
                newNumber.append(add);
            } else {
                QString currNumber = this.atom(ai).getTatomData().number();
                if (currNumber.size() > oldNumber.size()) {
                    currNumber.chop(1);
                }
                newNumber.clear();
                newNumber.append(currNumber);
            }
            atm.getTatomData().setNumber(newNumber);
        }
    }

    public void setNumber(int aIndex, QString aNumb) {
        TAtom atm = this.atom(aIndex);
        if (atm == null) {
            return;
        }
        QString oldNumb = atm.getTatomData().number();
        if (oldNumb.equals(aNumb)) {
            return;
        }
        this.addRemoveHush(oldNumb, false, aIndex);
        this.addRemoveHush(aNumb, true, aIndex);
        atm.getTatomData().setNumber(aNumb);
    }

    public boolean isMnovaGeneratedSDFTag(QString aName) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QByteArray<QString> getfOriginalMolfile() {
        return this.fOriginalMolfile;
    }

    public void setfOriginalMolfile(QByteArray<QString> fOriginalMolfile) {
        this.fOriginalMolfile = fOriginalMolfile;
    }

    public QList<TPolymer> getfPolymers() {
        return this.fPolymers;
    }

    public void setfPolymers(QList<TPolymer> fPolymers) {
        this.fPolymers = fPolymers;
    }

    public QUuid id() {
        return this.tSharedData.id();
    }

    @Override
    public List<ITAtom> getfAtomsAB() {
        return this.fAtoms.getqList();
    }

    @Override
    public List<ITBond> getfBondsAB() {
        return this.fBonds.getqList();
    }

    @Override
    public void setfAtomsAB(List<ITAtom> fAtoms) {
        this.fAtoms.clear();
        for (ITAtom atom : fAtoms) {
            this.fAtoms.append((TAtom)atom);
        }
    }

    @Override
    public void setfBondsAB(List<ITBond> fBonds) {
        this.fBonds.clear();
        for (ITBond bond : fBonds) {
            this.fBonds.append((TBond)bond);
        }
    }

    @Override
    public List<ITPolymer> getfPolymersAB() {
        return this.getfPolymers().getqList();
    }

    @Override
    public void setfPolymersAB(List<ITPolymer> fPolymers) {
        this.fPolymers.clear();
        for (ITPolymer polymer : fPolymers) {
            this.fPolymers.append((TPolymer)polymer);
        }
    }

    public IMoleculeTO moleculeTOJson(IMoleculeTOFactory factory, TMolecule molecule) {
        IMoleculeTO molTO = (IMoleculeTO)factory.molecule().as();
        molTO.setfAtomsAB(new ArrayList<ITAtom>());
        molTO.setfBondsAB(new ArrayList<ITBond>());
        molTO.setfPolymersAB(new ArrayList<ITPolymer>());
        for (ITAtom iTAtom : molecule.atoms()) {
            ITAtom iTAtom2 = (ITAtom)factory.atom(iTAtom).as();
            if (iTAtom.getfElementAB().getfIsotopesAB() != null) {
                for (ITIsotope i : iTAtom.getfElementAB().getfIsotopesAB().getfArrayAB()) {
                    iTAtom2.getfElementAB().getfIsotopesAB().getfArrayAB().add((ITIsotope)factory.isotope(i).as());
                }
            }
            iTAtom2.setTatomDataAB((ITAtomData)factory.atomData(iTAtom.getTatomDataAB()).as());
            molTO.getfAtomsAB().add(iTAtom2);
        }
        for (ITBond iTBond : molecule.bonds()) {
            ITBond iTBond2 = (ITBond)factory.bond(iTBond).as();
            iTBond2.setTbondDataAB((ITBondData)factory.bondData(iTBond.getTbondDataAB()).as());
            molTO.getfBondsAB().add(iTBond2);
        }
        int i = 0;
        for (ITPolymer iTPolymer : molecule.getfPolymers()) {
            ITPolymer itPolymer = (ITPolymer)factory.polymer(iTPolymer).as();
            molTO.getfPolymersAB().add(itPolymer);
            for (ITBracket iTBracket : molecule.getfPolymers().at(i).getBrackets()) {
                ITBracket iTBracket2 = (ITBracket)factory.bracket(iTBracket).as();
            }
            ++i;
        }
        if (molecule.tVariantData.keys() != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (QString key : molecule.tVariantData.keys()) {
                hashMap.put(key.toString(), molecule.tVariantData.data(key).toString());
            }
            molTO.setTvariantDataAB(hashMap);
        }
        return molTO;
    }

    public TMolecule jsonTOMolecule(IMoleculeTOFactory factory, IMoleculeTO molecule) {
        Map<String, String> dataMap;
        TMolecule mol = new TMolecule();
        for (ITAtom itAtom : molecule.getfAtomsAB()) {
            TAtom atomMol = new TAtom();
            if (itAtom.getfAliasAB() != null) {
                atomMol.setAlias(new QString(itAtom.getfAliasAB().getqString()));
            }
            atomMol.setfCharge(itAtom.getfChargeAB());
            if (itAtom.getfElementAB() != null) {
                TElement element = new TElement();
                element.setfAtomicNumber(itAtom.getfElementAB().getfAtomicNumberAB());
                element.setfAverageMass(itAtom.getfElementAB().getfAverageMassAB());
                element.setfElementName(new QString(itAtom.getfElementAB().getfElementNameAB().getqString()));
                element.setfElementSymbol(new QString(itAtom.getfElementAB().getfElementSymbolAB().getqString()));
                element.setfElementValences(new QString(itAtom.getfElementAB().getfElementValencesAB().getqString()));
                element.setfMonoisotopicMass(itAtom.getfElementAB().getfMonoisotopicMassAB());
                element.setfIsotopes(TPeriodicTable.getInstance().operatorAtomicNumber(element.getfAtomicNumber()).getfIsotopes());
                atomMol.setfElement(element);
            }
            atomMol.setfIsotope(itAtom.getfIsotopeAB());
            atomMol.setFnH(itAtom.getFnHAB());
            atomMol.setfValence(itAtom.getfValenceAB());
            if (itAtom.getTatomDataAB() != null) {
                TAtomData atomDataMol = new TAtomData();
                dataMap = itAtom.getTatomDataAB().getfDataMapAB();
                for (String key : dataMap.keySet()) {
                    atomDataMol.setData(new QString(key), new QString(dataMap.get(key)));
                }
                atomMol.setTatomData(atomDataMol);
            }
            atomMol.setX(itAtom.getxp());
            atomMol.setY(itAtom.getxy());
            atomMol.setZ(itAtom.getxz());
            mol.addAtom(atomMol);
        }
        for (ITBond bond : molecule.getfBondsAB()) {
            TBond bondMol = new TBond(bond.getfAtom1AB(), bond.getfAtom2AB(), bond.getfBondTypeAB(), bond.getfBondStereoAB());
            if (bond.getTbondDataAB() != null) {
                TBondData bondDataMol = new TBondData();
                dataMap = bond.getTbondDataAB().getfDataMapAB();
                for (String key : dataMap.keySet()) {
                    bondDataMol.setData(new QString(key), new QString(dataMap.get(key)));
                }
                bondMol.setTbondData(bondDataMol);
            }
            mol.addBond(bondMol);
        }
        for (ITPolymer polymer : molecule.getfPolymersAB()) {
            TPolymer polymerMol = new TPolymer();
            polymerMol.setNum(polymer.getNumAB());
            polymerMol.setSgAtomList(new QString(polymer.getSgAtomListAB().getqString()));
            polymerMol.setSgBondList(new QString(polymer.getSgBondListAB().getqString()));
            polymerMol.setSgBrStyle(polymer.getSgBrStyleAB());
            polymerMol.setSgCompNum(polymer.getSgCompNumAB());
            polymerMol.setSgConn(new QString(polymer.getSgConnAB().getqString()));
            polymerMol.setSgLabels(polymer.getSgLabelsAB());
            polymerMol.setSgSubscript(new QString(polymer.getSgSubscriptAB().getqString()));
            polymerMol.setSgSubType(new QString(polymer.getSgSubTypeAB().getqString()));
            polymerMol.setSgType(new QString(polymer.getSgTypeAB().getqString()));
            polymerMol.setSpAtomList(new QString(polymer.getSpAtomListAB().getqString()));
            polymerMol.setSgDataDescription(new QString(polymer.getSgDataDescriptionAB().getqString()));
            polymerMol.setSgDataDisplay(new QString(polymer.getSgDataDisplayAB().getqString()));
            polymerMol.setSgDataEnd(new QString(polymer.getSgDataEndAB().getqString()));
            mol.getfPolymers().append(polymerMol);
            for (ITBracket bracket : polymer.getBracketsAB()) {
                TBracket bracketMol = new TBracket(new QRectF(bracket.getxp(), bracket.getyp(), bracket.getw(), bracket.geth()), bracket.getBracketTypeAB(), new QString(bracket.getTopTextAB().getqString()), new QString(bracket.getBottomTextAB().getqString()));
                mol.getfPolymers().last().getBrackets().append(bracketMol);
            }
        }
        if (!molecule.getTvariantDataAB().isEmpty()) {
            mol.tVariantData.clear();
            for (String key : molecule.getTvariantDataAB().keySet()) {
                mol.tVariantData.setData(new QString(key), new QString(molecule.getTvariantDataAB().get(key)));
            }
        }
        return mol;
    }

    @Override
    public Map<String, String> getTvariantDataAB() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (QString key : this.tVariantData.keys()) {
            result.put(key.toString(), this.tVariantData.data(key).toString());
        }
        return result;
    }

    @Override
    public void setTvariantDataAB(Map<String, String> tvariantData) {
        QMap data = this.getfDataMap();
        data.clear();
        for (String key : tvariantData.keySet()) {
            data.add(new QString(key), new QString(tvariantData.get(key)));
        }
    }

    public TVariantData<QString, QString> gettVariantData() {
        return this.tVariantData;
    }

    public void settVariantData(TVariantData<QString, QString> tVariantData) {
        this.tVariantData = tVariantData;
    }
}

