/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TMacroDef;
import com.mestrelab.components.shared.TMacroParmDef;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QRegExp;
import com.mestrelab.components.shared.qt.QString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TMacroParser {
    private String cMacroRx = new String("[\\{$]([\\w\\-]+)(, *(:?(:?\"[^\"]*\")|(:?[\\w\\-\\.]*)) *)*[\\}$]");
    private String cMacroParmRx = new String(", *(:?(:?\"([^\"]*)\")|([\\w\\-\\.]*)) *");
    QMap<QString, TMacroDef> macrosMap = new QMap();

    public QString parse(QString aExpr) {
        QString strParsed = new QString(aExpr.toString());
        QRegExp rxMacro = new QRegExp(this.cMacroRx);
        QRegExp rxMacroParm = new QRegExp(this.cMacroParmRx);
        int pos = 0;
        pos = rxMacro.indexIn(aExpr, pos);
        while (pos != -1) {
            String subString = rxMacro.cap(0);
            String name = rxMacro.cap(1);
            QList<QString> args = new QList<QString>();
            int i = 0;
            QString sub = new QString(subString);
            i = rxMacroParm.indexIn(sub, i);
            while (i != -1) {
                args.append(new QString(rxMacroParm.cap(1)));
                i += rxMacroParm.matchedLength();
                i = rxMacroParm.indexIn(sub, i);
            }
            QString val = this.getMacroValue(new QString(name), args);
            strParsed.replace(sub.toString(), val.toString());
            pos += rxMacro.matchedLength();
            pos = rxMacro.indexIn(aExpr, pos);
        }
        return strParsed;
    }

    public abstract QString getMacroValue(QString var1, QList<QString> var2);

    public QString parse(QString aExpr, int aMacroPos) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QString getIntegerValue(QList<QString> aArgs, int aValue) {
        int base = 10;
        if (aArgs.size() > 0) {
            base = this.argToInt(aArgs.at(0), base);
        }
        return new QString("" + new QString("" + aValue).toInt(base));
    }

    public QString getDoubleValue(QList<QString> aArgs, double aValue) {
        char fmt = 'g';
        int prec = 6;
        if (aArgs.size() > 0) {
            prec = this.argToInt(aArgs.at(0), prec);
            if (aArgs.count() > 1) {
                fmt = this.argToChar(aArgs.at(1), fmt);
            }
        }
        return new QString("" + aValue);
    }

    public QString getElidedStringValue(QList<QString> aArgs, QString aValue) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QString getPathValue(QList<QString> aArgs, QString aValue) throws Exception {
        throw new Exception("Method not implemented");
    }

    public int argToInt(QString aArg, int aDefValue) {
        int val = aArg.toInt();
        if (val != Integer.MIN_VALUE) {
            return val;
        }
        return aDefValue;
    }

    public double argToDouble(QString aArg, double aDefValue) {
        boolean ok = false;
        try {
            return aArg.toDouble();
        }
        catch (Exception exception) {
            return aDefValue;
        }
    }

    public char argToChar(QString aArg, char aDefValue) {
        if (aArg.size() == 1) {
            return aArg.toString().charAt(0);
        }
        return aDefValue;
    }

    public boolean argToBool(QString aArg, boolean aDefValue) {
        if (aArg.size() == 1) {
            char c = aArg.toLower().toString().charAt(0);
            switch (c) {
                case '1': 
                case 't': 
                case 'y': {
                    return true;
                }
                case '0': 
                case 'f': 
                case 'n': {
                    return false;
                }
            }
        } else if (aArg.size() > 1) {
            QString lowArg = new QString(aArg.toLower().toString());
            if (lowArg.toString().equals("true") || lowArg.toString().equals("yes")) {
                return true;
            }
            if (lowArg.toString().equals("false") || lowArg.toString().equals("no")) {
                return false;
            }
        }
        return aDefValue;
    }

    public QList<TMacroParmDef> integerParms() {
        QList<TMacroParmDef> ret = new QList<TMacroParmDef>();
        ret.append(new TMacroParmDef("Base", "The integral number base"));
        return ret;
    }

    public QList<TMacroParmDef> doubleParms() {
        QList<TMacroParmDef> ret = new QList<TMacroParmDef>();
        ret.append(new TMacroParmDef("Precision", "The decimal precision"));
        ret.append(new TMacroParmDef("Format", "The real number format (avail formats: 'f','e','g')"));
        return ret;
    }

    public QList<TMacroParmDef> elidedStringParms() {
        QList<TMacroParmDef> ret = new QList<TMacroParmDef>();
        ret.append(new TMacroParmDef("Max Length", "The maximun number of characters"));
        ret.append(new TMacroParmDef("Position", "The '...' position ('n': none, 'l': left, 'r': right, 'm': middle"));
        return ret;
    }

    public QList<TMacroParmDef> pathParms() {
        QList<TMacroParmDef> ret = new QList<TMacroParmDef>();
        ret.append(new TMacroParmDef("Level", "The path level. -1: All, 0: filename, 1: filename and 1st directory..."));
        ret.append(this.elidedStringParms());
        return ret;
    }
}

