/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TCodeElementsOrder;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TNeighbour;
import com.mestrelab.components.shared.TStereoAnalyzer;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVector;
import java.io.Serializable;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCodeElement
implements Serializable {
    private static int maxSphereNum = 15;
    private QString fName;
    private QList<TCodeElement> fSubCodes;
    private QVector<Integer> fWasThere;
    private boolean fDoNextStep;
    private int fCurr;
    private int fPrev;
    private int fDeepth;
    private boolean fUnique;
    private boolean fIsPhantomH;
    private TMolecule fMolecule;
    private TCodeElement fParent;

    public TCodeElement() {
        this.fName = new QString("");
        this.fCurr = 0;
        this.fPrev = 0;
        this.fMolecule = null;
        this.fDeepth = 0;
        this.fDoNextStep = true;
        this.fWasThere = new QVector();
        this.fSubCodes = new QList();
        this.fParent = null;
        this.fUnique = false;
        this.fIsPhantomH = false;
    }

    public TCodeElement(QString aName, int aPrev, int aCurr, TMolecule aMolecule) {
        this.fName = aName;
        this.fCurr = aCurr;
        this.fPrev = aPrev;
        this.fMolecule = aMolecule;
        this.fDeepth = 0;
        this.fDoNextStep = true;
        this.fWasThere = new QVector<Integer>(aMolecule.atoms().size(), 0);
        this.fSubCodes = new QList();
        this.fParent = null;
        this.fUnique = false;
        this.fIsPhantomH = false;
    }

    public boolean canDoNextStep() {
        return this.fDoNextStep && this.fDeepth < maxSphereNum;
    }

    public boolean uniqueSubcodes() {
        if (this.fSubCodes.empty()) {
            return false;
        }
        for (int i = 0; i < this.fSubCodes.size(); ++i) {
            TCodeElement subCode = this.fSubCodes.at(i);
            if (subCode.isfUnique()) continue;
            return false;
        }
        return true;
    }

    public boolean needNextStage() {
        if (this.fSubCodes.empty()) {
            return false;
        }
        for (int i = 0; i < this.fSubCodes.size(); ++i) {
            TCodeElement subCode = this.fSubCodes.at(i);
            if (subCode.isfUnique() || !subCode.canDoNextStep()) continue;
            return true;
        }
        return false;
    }

    public void checkUniqueSubcodes(int aStage) {
        if (this.fSubCodes.empty()) {
            return;
        }
        for (int i = 0; i < this.fSubCodes.size(); ++i) {
            TCodeElement subCode = this.fSubCodes.at(i);
            if (subCode.isfUnique()) continue;
            TCodeElement prevCode = null;
            if (i > 0) {
                prevCode = this.fSubCodes.at(i - 1);
            }
            if (prevCode != null && prevCode.isfUnique()) {
                prevCode = null;
            }
            TCodeElement nextCode = null;
            if (i < this.fSubCodes.size() - 1) {
                nextCode = this.fSubCodes.at(i + 1);
            }
            if (nextCode != null && nextCode.isfUnique()) {
                nextCode = null;
            }
            if (prevCode != null && TStereoAnalyzer.compare(subCode, prevCode, aStage) == 0 || nextCode != null && TStereoAnalyzer.compare(subCode, nextCode, aStage) == 0) continue;
            subCode.setfUnique(true);
        }
    }

    public void buildSubCodes() {
        int i;
        if (!this.fSubCodes.isEmpty()) {
            return;
        }
        TAtom prevAtom = this.fMolecule.atom(this.fPrev);
        TAtom currAtom = this.fMolecule.atom(this.fCurr);
        if (prevAtom == null || currAtom == null) {
            return;
        }
        TBond bnd = this.fMolecule.findBond(this.fPrev, this.fCurr);
        if (bnd == null) {
            return;
        }
        if (bnd.bondType() == TBondType.btDouble) {
            this.addSubPhantom(prevAtom.elementSymbol(), this.fCurr, 0);
        } else if (bnd.bondType() == TBondType.btTriple) {
            this.addSubPhantom(prevAtom.elementSymbol(), this.fCurr, 0);
            this.addSubPhantom(prevAtom.elementSymbol(), this.fCurr, 0);
        }
        for (i = 0; i < currAtom.nH(); ++i) {
            this.addSubH();
        }
        for (i = 0; i < currAtom.getfNeighbours().size(); ++i) {
            TAtom nextAtom;
            TNeighbour nb = currAtom.getfNeighbours().at(i);
            int nextIndex = nb.getfBond().getSecond(this.fCurr);
            if (nextIndex == this.fPrev || (nextAtom = this.fMolecule.atom(nextIndex)) == null) continue;
            if (nb.getfBond().bondType() == TBondType.btDouble) {
                this.addSubPhantom(nextAtom.elementSymbol(), this.fCurr, 0);
            } else if (nb.getfBond().bondType() == TBondType.btTriple) {
                this.addSubPhantom(nextAtom.elementSymbol(), this.fCurr, 0);
                this.addSubPhantom(nextAtom.elementSymbol(), this.fCurr, 0);
            }
            if (this.fWasThere.get(nextIndex) != null && this.fWasThere.get(nextIndex) != 0) {
                this.addSubPhantom(nextAtom.elementSymbol(), this.fCurr, this.fWasThere.get(nextIndex));
                continue;
            }
            TCodeElement subCode = new TCodeElement(nextAtom.elementSymbol(), this.fCurr, nextIndex, this.fMolecule);
            subCode.setfWasThere(this.fWasThere);
            subCode.getfWasThere().set(nextIndex, this.fDeepth + 2);
            this.addSubCode(subCode);
        }
        this.sortSubCodes(0);
    }

    public void buildNextLevel() {
        if (this.fSubCodes.empty()) {
            return;
        }
        for (int i = 0; i < this.fSubCodes.size(); ++i) {
            TCodeElement subCode = this.fSubCodes.at(i);
            if (subCode.isfUnique() || !subCode.canDoNextStep()) continue;
            subCode.buildSubCodes();
        }
    }

    public void buildAndSortSubcodes() {
        this.sortSubCodes(0);
        this.checkUniqueSubcodes(0);
        if (this.uniqueSubcodes()) {
            return;
        }
        if (this.needNextStage()) {
            this.buildNextLevel();
            this.sortSubCodes(1);
            this.checkUniqueSubcodes(1);
            if (this.uniqueSubcodes()) {
                return;
            }
        }
        this.sortSubCodes(2);
        this.checkUniqueSubcodes(2);
        if (this.uniqueSubcodes()) {
            return;
        }
    }

    public void sortSubCodes(int aStage) {
        TCodeElementsOrder codeElementsOrder = new TCodeElementsOrder(aStage);
        Collections.sort(this.fSubCodes.arrayList(), codeElementsOrder);
    }

    public boolean isH() {
        return this.fName.equals(new QString("H"));
    }

    public void addSubCode(TCodeElement subCode) {
        if (!subCode.isfDoNextStep() && subCode.isH()) {
            if (subCode.getfDeepth() != 0) {
                subCode.setfDeepth(subCode.getfWasThere().get(subCode.getfPrev()));
            }
        } else {
            subCode.setfDeepth(this.fDeepth + 1);
        }
        if (subCode.isH()) {
            subCode.setfDoNextStep(false);
        }
        subCode.setfParent(this);
        this.fSubCodes.append(subCode);
    }

    public void addSubPhantom(QString aName, int aPrev, int aDeepth) {
        TCodeElement subCode = new TCodeElement(aName, aPrev, -1, this.fMolecule);
        subCode.setfDoNextStep(false);
        subCode.setfDeepth(aDeepth);
        if (subCode.isH()) {
            subCode.setfIsPhantomH(true);
        }
        this.addSubCode(subCode);
    }

    public void addSubH() {
        this.addSubPhantom(new QString("H"), this.fCurr, 0);
    }

    public static int getMaxSphereNum() {
        return maxSphereNum;
    }

    public static void setMaxSphereNum(int maxSphereNum) {
        TCodeElement.maxSphereNum = maxSphereNum;
    }

    public QString getfName() {
        return this.fName;
    }

    public void setfName(QString fName) {
        this.fName = fName;
    }

    public QList<TCodeElement> getfSubCodes() {
        return this.fSubCodes;
    }

    public void setfSubCodes(QList<TCodeElement> fSubCodes) {
        this.fSubCodes = fSubCodes;
    }

    public QVector<Integer> getfWasThere() {
        return this.fWasThere;
    }

    public void setfWasThere(QVector<Integer> fWasThere) {
        this.fWasThere = fWasThere;
    }

    public boolean isfDoNextStep() {
        return this.fDoNextStep;
    }

    public void setfDoNextStep(boolean fDoNextStep) {
        this.fDoNextStep = fDoNextStep;
    }

    public int getfCurr() {
        return this.fCurr;
    }

    public void setfCurr(int fCurr) {
        this.fCurr = fCurr;
    }

    public int getfPrev() {
        return this.fPrev;
    }

    public void setfPrev(int fPrev) {
        this.fPrev = fPrev;
    }

    public int getfDeepth() {
        return this.fDeepth;
    }

    public void setfDeepth(int fDeepth) {
        this.fDeepth = fDeepth;
    }

    public boolean isfUnique() {
        return this.fUnique;
    }

    public void setfUnique(boolean fUnique) {
        this.fUnique = fUnique;
    }

    public boolean isfIsPhantomH() {
        return this.fIsPhantomH;
    }

    public void setfIsPhantomH(boolean fIsPhantomH) {
        this.fIsPhantomH = fIsPhantomH;
    }

    public TMolecule getfMolecule() {
        return this.fMolecule;
    }

    public void setfMolecule(TMolecule fMolecule) {
        this.fMolecule = fMolecule;
    }

    public TCodeElement getfParent() {
        return this.fParent;
    }

    public void setfParent(TCodeElement fParent) {
        this.fParent = fParent;
    }
}

