/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.ITBond;
import com.mestrelab.components.shared.ITBondData;
import com.mestrelab.components.shared.TBondData;
import com.mestrelab.components.shared.TBondStereo;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVariant;
import com.mestrelab.components.shared.util.TDataStream;
import java.io.Serializable;

public class TBond
implements Serializable,
ITBond {
    private int fAtom1;
    private int fAtom2;
    private boolean fCyclic;
    private boolean fAromatic;
    TBondType fBondType;
    TBondStereo fBondStereo;
    TBondData TbondData;

    public TBondData getTbondData() {
        return this.TbondData;
    }

    public void setTbondData(TBondData tbondData) {
        this.TbondData = tbondData;
    }

    public TBond() {
    }

    public TBond(int aAtom1, int aAtom2, TBondType aBondType, TBondStereo aBondStereo) {
        this.fAtom1 = aAtom1;
        this.fAtom2 = aAtom2;
        this.fBondType = aBondType;
        this.fBondStereo = aBondStereo;
        this.fCyclic = false;
        this.fAromatic = false;
        this.TbondData = new TBondData();
    }

    public TBond(TBond bond) {
        this.fAtom1 = bond.fAtom1;
        this.fAtom2 = bond.fAtom2;
        this.fBondType = bond.fBondType;
        this.fBondStereo = bond.fBondStereo;
        this.fCyclic = bond.fCyclic;
        this.fAromatic = bond.fAromatic;
        if (bond.getTbondData() != null) {
            this.TbondData = new TBondData();
            for (QString key : bond.getTbondData().keys()) {
                this.TbondData.setData(key, bond.getTbondData().value(key));
            }
        }
    }

    public TBond(int atomTo, int res) {
        this(atomTo, res, TBondType.btSingle, TBondStereo.bsNone);
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void setBondType(TBondType aType) {
        this.fBondType = aType;
    }

    public TBondType bondType() {
        return this.fBondType;
    }

    public void setBondStereo(TBondStereo aStereo) {
        this.fBondStereo = aStereo;
    }

    public TBondStereo bondStereo() {
        return this.fBondStereo;
    }

    public void setAtom1(int aAtom) {
        this.fAtom1 = aAtom;
    }

    public int atom1() {
        return this.fAtom1;
    }

    public void setAtom2(int aAtom) {
        this.fAtom2 = aAtom;
    }

    public int atom2() {
        return this.fAtom2;
    }

    public void setCyclic(boolean aCyclic) {
        this.fCyclic = aCyclic;
    }

    public boolean cyclic() {
        return this.fCyclic;
    }

    public int getSecond(int n) {
        if (this.fAtom1 == n) {
            return this.fAtom2;
        }
        return this.fAtom1;
    }

    public void setAromatic(boolean aAromatic) {
        this.fAromatic = aAromatic;
    }

    public boolean aromatic() {
        return this.fAromatic || this.fBondType == TBondType.btAromatic;
    }

    public QString stereoNotation() {
        if (this.TbondData.data(new QString("STEREO_NOTATION")) != null) {
            return new QString(((QVariant)this.TbondData.data(new QString("STEREO_NOTATION"))).toString());
        }
        return new QString();
    }

    public void setStereoNotation(QString aStereoNotation) {
        this.TbondData.setData(new QString("STEREO_NOTATION"), aStereoNotation);
    }

    public boolean getfAromaticAB() {
        return this.aromatic();
    }

    public int getfAtom1AB() {
        return this.fAtom1;
    }

    public int getfAtom2AB() {
        return this.fAtom2;
    }

    public TBondStereo getfBondStereoAB() {
        return this.bondStereo();
    }

    public TBondType getfBondTypeAB() {
        return this.bondType();
    }

    public boolean getfCyclicAB() {
        return this.fCyclic;
    }

    public void setfAromaticAB(boolean value) {
        this.fAromatic = value;
    }

    public void setfAtom1AB(int atom1) {
        this.fAtom1 = atom1;
    }

    public void setfAtom2AB(int atom2) {
        this.fAtom2 = atom2;
    }

    public void setfBondStereoAB(TBondStereo type) {
        this.fBondStereo = type;
    }

    public void setfBondTypeAB(TBondType type) {
        this.fBondType = type;
    }

    public void setfCyclicAB(boolean value) {
        this.fCyclic = value;
    }

    public ITBondData getTbondDataAB() {
        return this.getTbondData();
    }

    public void setTbondDataAB(ITBondData tbondData) {
        this.TbondData.setfDataMapAB(tbondData.getfDataMapAB());
    }
}

