/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TAtomIndex;
import com.mestrelab.components.shared.TQListProxyTemplate;
import com.mestrelab.components.shared.qt.QList;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAtomIndexList
extends TQListProxyTemplate<TAtomIndex>
implements Serializable {
    public TAtomIndexList() {
    }

    public TAtomIndexList(QList<TAtomIndex> aList) {
        super(aList);
    }

    public boolean containsAtomNumber(int aAtomNumber) {
        Iterator it = this.begin();
        while (it.hasNext()) {
            TAtomIndex el = (TAtomIndex)it.next();
            if (el.atomIndex() != aAtomNumber) continue;
            return true;
        }
        return false;
    }

    public boolean containsHIndex(int aHIndex) {
        Iterator it = this.begin();
        char zeroBase = TAtomIndex.zeroBaseHIndex((char)aHIndex);
        while (it.hasNext()) {
            TAtomIndex el = (TAtomIndex)it.next();
            if (el.hIndex() != zeroBase) continue;
            return true;
        }
        return false;
    }

    public void removeAtomNumber(int aAtomNumber) {
        Iterator it = this.begin();
        int i = 0;
        while (it.hasNext()) {
            TAtomIndex el = (TAtomIndex)it.next();
            if (el.atomIndex() == aAtomNumber) {
                this.erase(i);
            }
            ++i;
        }
    }

    public QList<Integer> atomList() {
        QList<Integer> atList = new QList<Integer>();
        Iterator it = this.begin();
        while (it.hasNext()) {
            TAtomIndex el = (TAtomIndex)it.next();
            if (atList.contains(el.atomIndex())) continue;
            atList.append(el.atomIndex());
        }
        return atList;
    }
}

