/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TProtonNotation;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.TDataStream;
import java.io.Serializable;

public class TAtomIndex
implements Serializable {
    public static char cHeavyHIndex = (char)96;
    private int fAtomIndex;
    private char fHIndex;

    public TAtomIndex() {
        this.fAtomIndex = 0;
        this.fHIndex = TAtomIndex.zeroBaseHIndex(cHeavyHIndex);
    }

    public TAtomIndex(TAtomIndex aAtomIndex) {
        this.fAtomIndex = aAtomIndex.getfAtomIndex();
        this.fHIndex = aAtomIndex.getfHIndex();
    }

    public TAtomIndex(TAtomIndex aAtomIndex, char aHIndex) {
        this.fAtomIndex = aAtomIndex.getfAtomIndex();
        this.fHIndex = TAtomIndex.zeroBaseHIndex(aHIndex);
    }

    public static char zeroBaseHIndex(char aHIndex) {
        if (aHIndex >= cHeavyHIndex) {
            return (char)(aHIndex - cHeavyHIndex);
        }
        return aHIndex;
    }

    public static char aBaseHIndex(char aHIndex) {
        if (aHIndex >= cHeavyHIndex) {
            return aHIndex;
        }
        return (char)(cHeavyHIndex + aHIndex);
    }

    public boolean equals(TAtomIndex obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TAtomIndex other = obj;
        if (this.fAtomIndex != other.fAtomIndex) {
            return false;
        }
        return this.fHIndex == other.fHIndex;
    }

    public int getfAtomIndex() {
        return this.fAtomIndex;
    }

    public void setfAtomIndex(int fAtomIndex) {
        this.fAtomIndex = fAtomIndex;
    }

    public char getfHIndex() {
        return this.fHIndex;
    }

    public void setfHIndex(char fHIndex) {
        this.fHIndex = fHIndex;
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public QString toStr(boolean aUseHIndex, QString aAtomNumber, int aNotation) {
        QString result = aAtomNumber;
        if (result.size() == 0) {
            result = new QString(String.valueOf(this.fAtomIndex + 1));
        }
        if (aUseHIndex && TAtomIndex.zeroBaseHIndex(this.fHIndex) != this.fHIndex) {
            result = result.append(TProtonNotation.protonLabel(aNotation, this.fHIndex));
        }
        return new QString(result.toString());
    }

    public int atomIndex() {
        return this.fAtomIndex;
    }

    public int hIndex() {
        return this.fHIndex;
    }
}

