/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.ITAtomData;
import com.mestrelab.components.shared.TAssignmentStability;
import com.mestrelab.components.shared.TStereoDescriptor;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVariant;
import com.mestrelab.components.shared.util.TVariantData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAtomData
extends TVariantData<QString, QVariant>
implements Serializable,
ITAtomData {
    public static QString cLabelMacro = new QString("Label Macro");
    public static QString cNumber = new QString("Number");
    public static QString cColor = new QString("Color");
    public static QString cHighlightColor = new QString("Highlight Color");
    public static QString cAnnotations = new QString("Annotation");
    public static QString cCustomData = new QString("Custom");
    public static QString cProtonNotation = new QString("Proton Notation");
    public static QString cAssignmentQuality = new QString("Assignment Quality");
    public static QString cAssignmentStability = new QString("Assignment Stability");
    public static QString cStereoDescriptor = new QString("Stereo Descriptor");
    public static QString cAtomLabel = new QString("Name");
    public static QString cAtomCharge = new QString("Charge");
    public static QString cAtomIsotope = new QString("Isotope");
    public static QString cAtomAdditionalLabel = new QString("Label");

    public QString annotation() {
        QString text = (QString)this.data(cAnnotations);
        if (text != null) {
            return text;
        }
        return new QString("");
    }

    public double assignmentQuality() {
        Integer quality;
        Integer n = quality = this.data(cAssignmentQuality) != null ? new Integer(((QString)this.data(cAssignmentQuality)).toString()) : null;
        if (quality != null) {
            return quality.doubleValue();
        }
        return 2.0;
    }

    public TAssignmentStability assignmentStability() {
        TAssignmentStability iStability;
        Integer stability;
        Integer n = stability = this.data(cAssignmentQuality) != null ? new Integer(((QString)this.data(cAssignmentQuality)).toString()) : null;
        if (stability != null && (iStability = TAssignmentStability.find(stability)).getValue() >= TAssignmentStability.sFrom.getValue() && iStability.getValue() <= TAssignmentStability.sTo.getValue()) {
            return iStability;
        }
        return TAssignmentStability.sUnknown;
    }

    public QColor color() {
        QString color = (QString)this.data(cColor);
        if (color != null) {
            return new QColor(color.toString());
        }
        return new QColor();
    }

    public QMap<QString, QVariant> customData() {
        QMap custom = (QMap)this.data(cCustomData);
        if (custom != null) {
            return custom;
        }
        return new QMap<QString, QVariant>();
    }

    public QColor highlightColor() {
        QString color = (QString)this.data(cHighlightColor);
        if (color != null) {
            return new QColor(color.toString());
        }
        return new QColor();
    }

    public QString labelMacro() {
        QString label = (QString)this.data(cLabelMacro);
        if (label != null) {
            return label;
        }
        return new QString();
    }

    public QString number() {
        QString num = (QString)this.data(cNumber);
        if (num != null) {
            return num;
        }
        return new QString("");
    }

    public int protonNotation() {
        Integer protonNotation;
        Integer n = protonNotation = this.data(cProtonNotation) != null ? new Integer(((QString)this.data(cProtonNotation)).toString()) : null;
        if (protonNotation != null) {
            return protonNotation;
        }
        return 0;
    }

    public void setAnnotation(QString aText) {
        this.setData(cAnnotations, aText);
    }

    public void setAssignmentQuality(Double aQuality) {
        this.setData(cAssignmentQuality, new QString(aQuality.toString()));
    }

    public void setAssignmentStability(TAssignmentStability aStability) {
        this.setData(cAssignmentQuality, new QString("" + aStability.getValue()));
    }

    public void setColor(QColor aColor) {
        this.setData(cColor, new QString(aColor.getHexValue()));
    }

    public void setCustomData(QMap aCustomData) {
        this.setData(cCustomData, aCustomData);
    }

    public void setHighlightColor(QColor aColor) {
        this.setData(cHighlightColor, new QString(aColor.getHexValue()));
    }

    public void setLabelMatcro(QString aMacro) {
        this.setData(cLabelMacro, aMacro);
    }

    public void setNumberAsInt(Integer aNumber) {
        this.setData(cNumber, new QString(String.valueOf(aNumber)));
    }

    public void setNumber(QString aNumber) {
        this.setData(cNumber, aNumber);
    }

    public void setProtonNotation(int aNotation) {
        this.setData(cProtonNotation, new QString("" + aNotation));
    }

    public void setStereoDescriptor(TStereoDescriptor aStereoDescriptor) {
        this.setData(cStereoDescriptor, new QString("" + aStereoDescriptor.getValue()));
    }

    public TStereoDescriptor stereoDescriptor() {
        Integer descr;
        Integer n = descr = this.data(cStereoDescriptor) != null ? new Integer(((QString)this.data(cStereoDescriptor)).toString()) : null;
        if (descr != null) {
            return TStereoDescriptor.find(descr);
        }
        return TStereoDescriptor.sd_None;
    }

    public QString stereoDescriptorStr() {
        TStereoDescriptor descr = this.stereoDescriptor();
        switch (descr) {
            case sd_SAtom: {
                return new QString("{S}");
            }
            case sd_RAtom: {
                return new QString("{R}");
            }
            case sd_EBond: {
                return new QString("{E}");
            }
            case sd_ZBond: {
                return new QString("{Z}");
            }
        }
        return new QString("");
    }

    public boolean fixedNumber() {
        return ((QString)this.data(new QString("FIXED_NUMBERING"))).toBool();
    }

    public void setFixedNumber(boolean aFixedNumber) {
        this.setData(new QString("FIXED_NUMBERING"), new QString(new Boolean(aFixedNumber).toString()));
    }

    public QString stereoNotation() {
        if (this.data(new QString("STEREO_NOTATION")) != null) {
            return new QString(((QVariant)this.data(new QString("STEREO_NOTATION"))).toString());
        }
        return new QString();
    }

    public void setStereoNotation(QString aStereoNotation) {
        this.setData(new QString("STEREO_NOTATION"), aStereoNotation);
    }

    public QString tooltip() {
        QList<QString> tTip = new QList<QString>();
        QString annot = this.annotation();
        if (!annot.isEmpty()) {
            tTip.append(annot);
        }
        QMap<QString, QVariant> customMap = this.customData();
        QList<QString> keys = customMap.keys();
        for (int i = 0; i < keys.size(); ++i) {
            tTip.append(new QString(keys.at(i) + ": " + customMap.find(keys.at(i))));
        }
        return tTip.join("<br>");
    }

    public static QString getcLabelMacro() {
        return cLabelMacro;
    }

    public static void setcLabelMacro(QString cLabelMacro) {
        TAtomData.cLabelMacro = cLabelMacro;
    }

    public static QString getcNumber() {
        return cNumber;
    }

    public static void setcNumber(QString cNumber) {
        TAtomData.cNumber = cNumber;
    }

    public static QString getcColor() {
        return cColor;
    }

    public static void setcColor(QString cColor) {
        TAtomData.cColor = cColor;
    }

    public static QString getcHighlightColor() {
        return cHighlightColor;
    }

    public static void setcHighlightColor(QString cHighlightColor) {
        TAtomData.cHighlightColor = cHighlightColor;
    }

    public static QString getcAnnotations() {
        return cAnnotations;
    }

    public static void setcAnnotations(QString cAnnotations) {
        TAtomData.cAnnotations = cAnnotations;
    }

    public static QString getcCustomData() {
        return cCustomData;
    }

    public static void setcCustomData(QString cCustomData) {
        TAtomData.cCustomData = cCustomData;
    }

    public static QString getcProtonNotation() {
        return cProtonNotation;
    }

    public static void setcProtonNotation(QString cProtonNotation) {
        TAtomData.cProtonNotation = cProtonNotation;
    }

    public static QString getcAssignmentQuality() {
        return cAssignmentQuality;
    }

    public static void setcAssignmentQuality(QString cAssignmentQuality) {
        TAtomData.cAssignmentQuality = cAssignmentQuality;
    }

    public static QString getcAssignmentStability() {
        return cAssignmentStability;
    }

    public static void setcAssignmentStability(QString cAssignmentStability) {
        TAtomData.cAssignmentStability = cAssignmentStability;
    }

    public static QString getcStereoDescriptor() {
        return cStereoDescriptor;
    }

    public static void setcStereoDescriptor(QString cStereoDescriptor) {
        TAtomData.cStereoDescriptor = cStereoDescriptor;
    }

    public static QString getcAtomLabel() {
        return cAtomLabel;
    }

    public static void setcAtomLabel(QString cAtomLabel) {
        TAtomData.cAtomLabel = cAtomLabel;
    }

    public static QString getcAtomCharge() {
        return cAtomCharge;
    }

    public static void setcAtomCharge(QString cAtomCharge) {
        TAtomData.cAtomCharge = cAtomCharge;
    }

    public static QString getcAtomIsotope() {
        return cAtomIsotope;
    }

    public static void setcAtomIsotope(QString cAtomIsotope) {
        TAtomData.cAtomIsotope = cAtomIsotope;
    }

    @Override
    public Map<String, String> getfDataMapAB() {
        HashMap<String, String> result = new HashMap<String, String>();
        QMap data = this.getfDataMap();
        for (QString key : data.keys()) {
            result.put(key.toString(), ((QVariant)data.find(key)).toString());
        }
        return result;
    }

    @Override
    public void setfDataMapAB(Map<String, String> map) {
        QMap data = this.getfDataMap();
        data.clear();
        for (String key : map.keySet()) {
            data.add(new QString(key), new QString(map.get(key)));
        }
    }
}

