/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.IQString;
import com.mestrelab.components.shared.ITAtom;
import com.mestrelab.components.shared.ITAtomData;
import com.mestrelab.components.shared.ITElement;
import com.mestrelab.components.shared.TAtomData;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TElement;
import com.mestrelab.components.shared.TIsotope;
import com.mestrelab.components.shared.TNeighbour;
import com.mestrelab.components.shared.TPeriodicTable;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVariant;
import com.mestrelab.components.shared.util.SimpleAliasVO;
import com.mestrelab.components.shared.util.T3DPointF;
import com.mestrelab.components.shared.util.TDataStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAtom
extends T3DPointF
implements Serializable,
ITAtom {
    private int fCharge;
    private int fIsotope;
    private int fValence;
    private int fnH;
    private QString fAlias;
    private TElement fElement;
    private QList<TNeighbour> fNeighbours;
    private TAtomData TatomData;

    public TAtomData getTatomData() {
        return this.TatomData;
    }

    public void setTatomData(TAtomData tatomData) {
        this.TatomData = tatomData;
    }

    public TAtom() {
        super(0.0, 0.0);
        this.fCharge = 0;
        this.fIsotope = 0;
        this.fValence = 0;
        this.fnH = -1;
        this.fElement = TPeriodicTable.getInstance().nullElement();
        this.fAlias = new QString("");
        this.TatomData = new TAtomData();
        this.fNeighbours = new QList();
    }

    public TAtom(TAtom atom) {
        super(new Double((Double)atom.x()), new Double((Double)atom.y()));
        this.fCharge = atom.getfCharge();
        this.fIsotope = atom.getfIsotope();
        this.fValence = atom.getfValence();
        this.fnH = atom.getFnH();
        this.fNeighbours = new QList();
        this.fElement = new TElement(atom.getfElement().getfAtomicNumber(), atom.getfElement().getfElementName().toString(), atom.getfElement().getfElementSymbol().toString(), atom.getfElement().getfElementValences().toString(), atom.getfElement().getfAverageMass(), atom.getfElement().getfMonoisotopicMass(), TPeriodicTable.getInstance().operatorAtomicNumber(atom.getfElement().getfAtomicNumber()).getfIsotopes());
        this.fAlias = new QString(atom.getfAlias().toString());
        if (atom.getTatomData() != null) {
            this.TatomData = new TAtomData();
            this.TatomData.setAnnotation(atom.getTatomData().annotation());
            this.TatomData.setAssignmentQuality(atom.getTatomData().assignmentQuality());
            this.TatomData.setAssignmentStability(atom.getTatomData().assignmentStability());
            this.TatomData.setColor(atom.getTatomData().color());
            this.TatomData.setCustomData(atom.getTatomData().customData());
            for (QString key : atom.getTatomData().keys()) {
                this.TatomData.setData(key, atom.getTatomData().value(key));
            }
            this.TatomData.setHighlightColor(atom.getTatomData().highlightColor());
            this.TatomData.setLabelMatcro(atom.getTatomData().labelMacro());
            this.TatomData.setNumber(new QString(atom.getTatomData().number().toString()));
            this.TatomData.setProtonNotation(atom.getTatomData().protonNotation());
        }
    }

    public void clear() {
        this.getTatomData().clear();
        this.fnH = -1;
    }

    public void store(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public void load(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public int getConnCount(boolean aCheckAromaBonds) {
        int numAromaBonds = 0;
        int neigh = 0;
        for (TNeighbour nb : this.fNeighbours) {
            TBond bond = nb.getfBond();
            if (bond.bondType() == TBondType.btSingle) {
                ++neigh;
            }
            if (bond.bondType() == TBondType.btDouble) {
                neigh += 2;
            }
            if (bond.bondType() == TBondType.btTriple) {
                neigh += 3;
                continue;
            }
            if (bond.bondType() != TBondType.btAromatic) continue;
            ++numAromaBonds;
        }
        if (aCheckAromaBonds && numAromaBonds != 0) {
            neigh += numAromaBonds + 1;
        }
        return neigh;
    }

    public void correctCharge() {
        QList<Integer> valences = this.stableValences();
        if (valences.isEmpty() || this.isHydrogen() || this.isCarbon()) {
            return;
        }
        int neigh = this.getConnCount(false);
        if (neigh < valences.at(0)) {
            return;
        }
        if (this.getfCharge() == 1 && valences.contains(neigh)) {
            this.setfCharge(0);
        } else if (this.getfCharge() == 0 && !valences.contains(neigh) && valences.contains(neigh - 1)) {
            this.setfCharge(1);
        }
    }

    public int nH() {
        if (this.fnH != -1) {
            return this.fnH;
        }
        int numH = this.getfValence();
        if (numH == -1) {
            return 0;
        }
        numH -= this.getConnCount(true);
        int charge = this.getfCharge();
        if (charge > 0) {
            numH = this.isCarbon() || this.isHydrogen() ? (numH -= charge) : (numH += charge);
        }
        if (charge < 0) {
            numH += charge;
        }
        this.fnH = numH;
        return numH;
    }

    public int checknH() {
        this.fnH = -1;
        return this.nH();
    }

    public int nHAll() {
        int numH = this.nH();
        for (TNeighbour nb : this.fNeighbours) {
            TAtom atom = nb.getfAtom();
            if (!atom.isHydrogen()) continue;
            ++numH;
        }
        return numH;
    }

    public int nExplicitH() {
        return this.nHAll() - this.nH();
    }

    public int nCH3() {
        int num = 0;
        for (int i = 0; i < this.fNeighbours.count(); ++i) {
            TAtom atom = this.fNeighbours.at(i).getfAtom();
            if (!atom.isCH3()) continue;
            ++num;
        }
        return num;
    }

    public QList<TAtom> ch3Neighbours() {
        QList<TAtom> ch3s = new QList<TAtom>();
        for (TNeighbour nb : this.fNeighbours) {
            TAtom atom = nb.getfAtom();
            if (atom == null || !atom.isCH3()) continue;
            ch3s.append(atom);
        }
        return ch3s;
    }

    public QString text() {
        if (!this.fAlias.isEmpty()) {
            return this.fAlias;
        }
        QString symbol = this.getfElement().getfElementSymbol();
        int nProtons = this.nH();
        QString atomText = symbol;
        if (nProtons > 0) {
            if (!atomText.toString().equals("H")) {
                atomText = new QString(symbol.toString() + "H");
            } else {
                ++nProtons;
            }
        }
        if (nProtons > 1) {
            atomText = atomText.append("" + nProtons);
        }
        return atomText;
    }

    public QString elementSymbol() {
        if (this.fElement != null && !this.fElement.getfElementName().equals(TPeriodicTable.getInstance().nullElement().getfElementName())) {
            return this.fElement.getfElementSymbol();
        }
        if (!this.fAlias.isEmpty()) {
            return this.fAlias;
        }
        return TPeriodicTable.getInstance().nullElement().getfElementSymbol();
    }

    public void setElementSymbol(QString aSymbol) {
        QString symb = aSymbol;
        if (!symb.isEmpty()) {
            symb = new QString(symb.toString().substring(0, 1).toUpperCase() + symb.toString().substring(1).toLowerCase());
        }
        this.fElement = TPeriodicTable.getInstance().operatorElementSymbol(symb);
        this.fAlias = this.fElement.equals(TPeriodicTable.getInstance().nullElement()) ? aSymbol : new QString("");
    }

    public void setAlias(QString aAlias) {
        this.fElement = TPeriodicTable.getInstance().nullElement();
        this.fAlias = aAlias.trimmed();
    }

    public QList<Integer> stableValences() {
        QList<Integer> result = new QList<Integer>();
        byte[] chars = this.fElement.getfElementValences().getChars();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            result.append(Integer.parseInt("" + (chars[i] - 48)));
        }
        return result;
    }

    public T3DPointF normalizedCoords(double aMaxValue) {
        T3DPointF newPoint = new T3DPointF();
        newPoint.setX((Double)this.x() * 100.0 / aMaxValue);
        newPoint.setY((Double)this.y() * 100.0 / aMaxValue);
        newPoint.setZ(this.z() * 100.0 / aMaxValue);
        return newPoint;
    }

    public boolean isCarbon() {
        return this.getfElement() != null && this.getfElement().getfElementSymbol().toString().equals("C");
    }

    public boolean isHydrogen() {
        return this.getfElement() != null && this.getfElement().getfElementSymbol().toString().equals("H");
    }

    public boolean isNitrogen() {
        return this.getfElement() != null && this.getfElement().getfElementSymbol().toString().equals("N");
    }

    public boolean isOxygen() {
        return this.getfElement() != null && this.getfElement().getfElementSymbol().toString().equals("O");
    }

    public boolean isSulfur() {
        return this.getfElement() != null && this.getfElement().getfElementSymbol().toString().equals("S");
    }

    public boolean isFluorine() {
        return this.getfElement() != null && this.getfElement().getfElementSymbol().toString().equals("F");
    }

    public boolean isWildcardAtom() {
        QString s = this.elementSymbol();
        return s.toString().equals("X") || s.toString().equals("R") || s.toString().equals("*") || s.toString().equals("A") || s.toString().equals("Q") || s.toString().equals("?");
    }

    public boolean isRXAtom() {
        QString s = this.elementSymbol();
        return s.toString().equals("X") || s.toString().equals("R");
    }

    public boolean isAromaRadical() {
        return this.fAlias.toString().equals("Aryl");
    }

    public boolean isAlkyl() {
        return this.fAlias.toString().equals("Alkyl");
    }

    public boolean isHeteroAtom() {
        return !this.isCarbon() && !this.isHydrogen() && !this.isWildcardAtom();
    }

    public static boolean isValidIsotope(TElement aEl, int aIsotope) {
        if (aEl.equals(TPeriodicTable.getInstance().nullElement()) || aEl.getfIsotopes().getfCount() == 0 || aIsotope <= 0 || aIsotope > 300) {
            return false;
        }
        for (int i = 0; i < aEl.getfIsotopes().getfCount(); ++i) {
            TIsotope it = aEl.getfIsotopes().getfArray()[i];
            if (it.getfMassNumber() != aIsotope) continue;
            return true;
        }
        return false;
    }

    public double mass(boolean aAverage) {
        if (this.fElement == null) {
            return 0.0;
        }
        if (this.fIsotope != 0 && this.fElement.getfIsotopes().getfCount() > 0) {
            for (int i = 0; i < this.fElement.getfIsotopes().getfCount(); ++i) {
                TIsotope it = this.fElement.getfIsotopes().getfArray()[i];
                if (it.getfMassNumber() != this.fIsotope) continue;
                return it.getfMass();
            }
        }
        if (aAverage) {
            return this.fElement.getfAverageMass();
        }
        return this.fElement.getfMonoisotopicMass();
    }

    public static SimpleAliasVO staticExpandSimpleAlias(QString aAlias, QString s, int nh, int chrg, int iso) {
        TElement el;
        int li;
        SimpleAliasVO result = new SimpleAliasVO();
        result.setResult(false);
        result.setChrg(chrg);
        result.setIso(iso);
        result.setNh(nh);
        result.setS(s);
        if (aAlias.isEmpty() || aAlias.size() > 9) {
            return result;
        }
        result.setS(aAlias);
        result.setNh(0);
        int ind = result.getS().getqString().indexOf("H");
        byte[] chars = result.getS().getChars();
        if (ind >= 0) {
            result.setNh(1);
            int lh = 1;
            if (ind < result.getS().size() - 1 && Character.isDigit((char)chars[ind + 1])) {
                result.setNh(Integer.parseInt("" + (chars[ind + 1] - 48)));
                ++lh;
            }
            result.setS(result.getS().remove(ind, lh));
        }
        result.setChrg(0);
        ind = result.getS().indexOf("+");
        if (ind >= 0) {
            result.setChrg(1);
        } else {
            ind = result.getS().indexOf("-");
            if (ind >= 0) {
                result.setChrg(-1);
            }
        }
        if (chrg != 0) {
            int lch = 1;
            if (ind > 0 && Character.isDigit((char)chars[ind - 1])) {
                result.setChrg(Integer.parseInt("" + (chars[ind - 1] - 48)));
                --ind;
                ++lch;
            }
            result.setS(result.getS().remove(ind, lch));
        }
        QString si = new QString();
        for (li = 0; li < result.getS().size() && Character.isDigit((char)chars[li]); ++li) {
            si = si.append(new String("" + chars[li]));
        }
        result.setIso(si.toInt() == Integer.MIN_VALUE ? 0 : si.toInt());
        if (li != 0) {
            result.setS(result.getS().remove(0, li));
        }
        if (result.getS().toString().equals(".")) {
            result.setS(new QString("C"));
        }
        if (!result.getS().isEmpty()) {
            result.getS().toUpperFirstLeter();
        }
        if ((el = TPeriodicTable.getInstance().operatorElementSymbol(result.getS())) == TPeriodicTable.getInstance().nullElement()) {
            return result;
        }
        result.setResult(true);
        if (el.getfIsotopes() != null && el.getfIsotopes().getfCount() != 0 && !TAtom.isValidIsotope(el, iso)) {
            return result;
        }
        return result;
    }

    public boolean expandSimpleAlias() {
        QString s = new QString();
        int nh = 0;
        int chrg = 0;
        int iso = 0;
        SimpleAliasVO vo = TAtom.staticExpandSimpleAlias(this.fAlias, s, nh, chrg, iso);
        if (vo.isResult()) {
            this.setfCharge(vo.getChrg());
            this.setElementSymbol(vo.getS());
            this.fnH = vo.getNh();
            this.fIsotope = vo.getIso();
            this.fAlias = new QString("");
            return true;
        }
        return false;
    }

    public int getNeighByNum(int aNeighNum, int aAtomIndex) {
        if (aNeighNum >= 0 && aNeighNum < this.fNeighbours.size()) {
            return this.fNeighbours.at(aNeighNum).getfBond().getSecond(aAtomIndex);
        }
        return -1;
    }

    public int heavyNeighsCount() {
        int n = 0;
        int _size = this.fNeighbours.size();
        for (int i = 0; i < _size; ++i) {
            QString element = this.fNeighbours.at(i).getfAtom().getfElement().getfElementSymbol();
            if (element.toString().equals("H")) continue;
            ++n;
        }
        return n;
    }

    public int getNeighByName(int aAtomIndex, int aHIndex, String aName) {
        for (int i = 0; i < this.fNeighbours.size(); ++i) {
            if (!this.fNeighbours.at(i).getfAtom().getfElement().getfElementSymbol().toString().equals(aName) || --aHIndex != 0) continue;
            return this.getNeighByNum(i, aAtomIndex);
        }
        return -1;
    }

    public int getExplicitHIndex(int aAtomIndex, int aHIndex) {
        return this.getNeighByName(aAtomIndex, aHIndex, "H");
    }

    public boolean checkForLabileProton() {
        return this.nHAll() > 0 && (this.isOxygen() || this.isNitrogen() || this.isSulfur());
    }

    public boolean fixedNumber() {
        return this.TatomData.getfDataMap().contains(new QString("FIXED_NUMBERING"));
    }

    public void setFixedNumber(boolean aFixedNumber) {
        this.TatomData.setData(new QString("FIXED_NUMBERING"), new QString(new Boolean(aFixedNumber).toString()));
    }

    public QString stereoNotation() {
        if (this.TatomData.getfDataMap().find(new QString("STEREO_NOTATION")) != null) {
            return new QString(((QVariant)this.TatomData.getfDataMap().find(new QString("STEREO_NOTATION"))).toString());
        }
        return new QString();
    }

    public void setStereoNotation(QString aStereoNotation) {
        this.TatomData.setData(new QString("STEREO_NOTATION"), aStereoNotation);
    }

    public boolean isCH2() {
        return this.nH() == 2 && this.isCarbon();
    }

    public boolean isCH3() {
        return this.nH() == 3 && this.isCarbon();
    }

    public int getfCharge() {
        return this.fCharge;
    }

    public void setfCharge(int fCharge) {
        this.fCharge = fCharge;
    }

    public int getfIsotope() {
        return this.fIsotope;
    }

    public void setfIsotope(int fIsotope) {
        this.fIsotope = fIsotope;
    }

    public int getfValence() {
        return this.fValence;
    }

    public void setfValence(int fValence) {
        this.fValence = fValence;
    }

    public int getFnH() {
        return this.fnH;
    }

    public void setFnH(int fnH) {
        this.fnH = fnH;
    }

    public QString getfAlias() {
        return this.fAlias;
    }

    public void setfAlias(QString fAlias) {
        this.fAlias = fAlias;
    }

    public TElement getfElement() {
        return this.fElement;
    }

    public void setfElement(TElement fElement) {
        this.fElement = fElement;
    }

    public QList<TNeighbour> getfNeighbours() {
        return this.fNeighbours;
    }

    public void setfNeighbours(QList<TNeighbour> fNeighbours) {
        this.fNeighbours = fNeighbours;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.TatomData == null ? 0 : this.TatomData.hashCode());
        result = 31 * result + (this.fAlias == null ? 0 : this.fAlias.hashCode());
        result = 31 * result + this.fCharge;
        result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
        result = 31 * result + this.fIsotope;
        result = 31 * result + (this.fNeighbours == null ? 0 : this.fNeighbours.hashCode());
        result = 31 * result + this.fValence;
        result = 31 * result + this.fnH;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TAtom other = (TAtom)obj;
        if (this.TatomData == null ? other.TatomData != null : !this.TatomData.equals(other.TatomData)) {
            return false;
        }
        if (this.fAlias == null ? other.fAlias != null : !this.fAlias.equals(other.fAlias)) {
            return false;
        }
        if (this.fCharge != other.fCharge) {
            return false;
        }
        if (this.fElement == null ? other.fElement != null : !this.fElement.equals(other.fElement)) {
            return false;
        }
        if (this.fIsotope != other.fIsotope) {
            return false;
        }
        if (this.fNeighbours == null ? other.fNeighbours != null : !this.fNeighbours.equals(other.fNeighbours)) {
            return false;
        }
        if (this.fValence != other.fValence) {
            return false;
        }
        return this.fnH == other.fnH;
    }

    @Override
    public int getFnHAB() {
        return this.getFnH();
    }

    @Override
    public IQString getfAliasAB() {
        return this.fAlias;
    }

    @Override
    public int getfChargeAB() {
        return this.getfCharge();
    }

    @Override
    public int getfIsotopeAB() {
        return this.getfIsotope();
    }

    @Override
    public int getfValenceAB() {
        return this.getfValence();
    }

    @Override
    public void setFnHAB(int fnH) {
        this.fnH = fnH;
    }

    @Override
    public void setfAliasAB(IQString fAlias) {
        this.fAlias = (QString)fAlias;
    }

    @Override
    public void setfChargeAB(int fCharge) {
        this.fCharge = fCharge;
    }

    @Override
    public void setfIsotopeAB(int fIsotope) {
        this.fIsotope = fIsotope;
    }

    @Override
    public void setfValenceAB(int fValence) {
        this.fValence = fValence;
    }

    @Override
    public ITElement getfElementAB() {
        return this.getfElement();
    }

    @Override
    public void setfElementAB(ITElement el) {
        this.fElement = (TElement)el;
    }

    @Override
    public ITAtomData getTatomDataAB() {
        return this.getTatomData();
    }

    @Override
    public void setTatomDataAB(ITAtomData tatomData) {
        this.TatomData.setfDataMapAB(tatomData.getfDataMapAB());
    }

    @Override
    public double getxp() {
        return (Double)this.x();
    }

    @Override
    public double getxy() {
        return (Double)this.y();
    }

    @Override
    public double getxz() {
        return this.z();
    }

    @Override
    public void setxp(double value) {
        this.setX(value);
    }

    @Override
    public void setxy(double value) {
        this.setY(value);
    }

    @Override
    public void setxz(double value) {
        this.setZ(value);
    }
}

