/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.shared;

import com.mestrelab.components.shared.TAromaElement;
import com.mestrelab.components.shared.TPatternType;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QString;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAromaPattern
implements Serializable {
    private QList<TAromaElement> fElements;
    private TPatternType fType;

    public TAromaPattern() {
    }

    public TAromaPattern(QList<TAromaElement> aElements) {
        this.fElements = aElements;
        this.fType = TPatternType.pt_None;
    }

    public TPatternType type() {
        return this.fType;
    }

    public void setType(TPatternType aType) {
        this.fType = aType;
    }

    public void detectType() {
        int n2 = -1;
        int n1 = -1;
        for (int i = 0; i < this.fElements.size(); ++i) {
            TAromaElement el = this.fElements.at(i);
            if (!el.getfElementSymbol().equals("N")) continue;
            if (n1 < 0) {
                n1 = i;
                continue;
            }
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            return;
        }
        if (n1 < 0 && n2 < 0) {
            this.setType(TPatternType.pt_Benzene);
        } else if (n2 < 0) {
            this.setType(TPatternType.pt_Pyridine);
        } else if (n2 - n1 == 2 || n2 - n1 == 4) {
            this.setType(TPatternType.pt_Pyrimidine);
        } else {
            return;
        }
        while (this.fType == TPatternType.pt_Pyridine && !this.fElements.at(0).getfElementSymbol().equals("N") || this.fType == TPatternType.pt_Pyrimidine && (!this.fElements.at(0).getfElementSymbol().equals("N") || !this.fElements.at(2).getfElementSymbol().equals("N"))) {
            this.fElements.move(0, this.fElements.size() - 1);
        }
    }

    public QString makePatternString() {
        switch (this.fType) {
            case pt_Benzene: {
                return new QString("benzene");
            }
            case pt_Pyridine: {
                return new QString("pyridine");
            }
            case pt_Pyrimidine: {
                return new QString("pyrimidine");
            }
        }
        return new QString("");
    }

    public QString makeDebugString() {
        QString res = this.makePatternString();
        if (!res.isEmpty()) {
            res.append(":");
            for (int i = 0; i < this.fElements.size(); ++i) {
                res.append(this.fElements.at(i).makeSubstituentString().toString());
            }
        }
        return res;
    }
}

