/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.server;

import com.mestrelab.components.server.ImportExportServiceImpl;
import com.mestrelab.components.shared.qt.QUuid;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaveFileServlet
extends HttpServlet {
    private final HashMap<String, String> data = new HashMap();
    private Logger logger = Logger.getLogger(SaveFileServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uuid = request.getParameter("id");
        if (uuid != null) {
            String molfile = this.data.remove(uuid.trim());
            molfile = molfile != null ? molfile : "";
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"molfile.mol\"");
            ServletOutputStream out = response.getOutputStream();
            out.write(molfile.getBytes("UTF-8"));
            out.flush();
            out.close();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImportExportServiceImpl service = (ImportExportServiceImpl)this.getServletContext().getAttribute("service");
        this.logger.info("service is null:" + (service == null));
        String moleculeJSON = request.getParameter("moleculeJSON");
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        if (moleculeJSON != null && !moleculeJSON.isEmpty()) {
            String molFile = service.exportMolfile(moleculeJSON);
            QUuid uuid = new QUuid();
            this.data.put(uuid.getId(), molFile);
            out.write(uuid.getId().getBytes());
        }
        out.flush();
        out.close();
    }
}

