/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import com.mestrelab.components.client.ImportExportService;
import com.mestrelab.components.server.Utils_MolfileServer;
import com.mestrelab.components.shared.IMoleculeTO;
import com.mestrelab.components.shared.IMoleculeTOFactory;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QString;
import java.util.logging.Logger;

public class ImportExportServiceImpl
extends RemoteServiceServlet
implements ImportExportService {
    private Logger logger = Logger.getLogger(ImportExportServiceImpl.class.getName());
    private IMoleculeTOFactory factory = (IMoleculeTOFactory)AutoBeanFactorySource.create(IMoleculeTOFactory.class);
    private QByteArray<QString> aMolContent = new QByteArray();
    private static Boolean validLicense;
    private static String errorLicense;

    public String exportMolfile(String moleculeJson) {
        String result = new String("");
        if (moleculeJson != null && !moleculeJson.isEmpty()) {
            try {
                result = this.exportJsonToMolfile(moleculeJson, result);
            }
            catch (Exception e) {
                this.logger.severe(e.getLocalizedMessage());
            }
        }
        return validLicense == false ? errorLicense : result;
    }

    private String exportJsonToMolfile(String moleculeJson, String result) {
        QByteArray aMolContent;
        IMoleculeTO moleculeTO = (IMoleculeTO)AutoBeanCodex.decode((AutoBeanFactory)this.factory, IMoleculeTO.class, (String)moleculeJson).as();
        TMolecule molecule = new TMolecule();
        if ((molecule = molecule.jsonTOMolecule(this.factory, moleculeTO)) != null && molecule.atoms().size() > 0 && !(aMolContent = Utils_MolfileServer.writeUnique(molecule)).isEmpty()) {
            result = aMolContent.toString();
        }
        return result;
    }

    public String importMolfile(String molfile) {
        String json = new String("");
        if (molfile != null && !molfile.isEmpty()) {
            try {
                while (json.equals("")) {
                    json = this.importMolfileToJson(molfile);
                }
            }
            catch (Exception e) {
                this.logger.severe(e.getLocalizedMessage());
            }
        }
        return validLicense == false ? errorLicense : json;
    }

    private String importMolfileToJson(String molfile) throws Exception {
        this.aMolContent.clear();
        this.aMolContent.append(new QString(molfile));
        TMolecule molecule = null;
        molecule = Utils_MolfileServer.read(this.aMolContent, false);
        if (molecule != null) {
            IMoleculeTO moleculeTO = molecule.moleculeTOJson(this.factory, molecule);
            AutoBean autoBean = this.factory.create(IMoleculeTO.class, moleculeTO);
            return AutoBeanCodex.encode((AutoBean)autoBean).getPayload();
        }
        throw new Exception("error importMolfileToJson");
    }

    public static void setValidLicense(Boolean isValid, String text) {
        validLicense = isValid;
        errorLicense = text;
    }
}

