/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.server;

import com.mestrelab.components.server.ImportExportServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FileUploadServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImportExportServiceImpl service = (ImportExportServiceImpl)this.getServletContext().getAttribute("service");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        response.setContentType("text/html");
        PrintWriter outPut = response.getWriter();
        try {
            List items = upload.parseRequest(request);
            if (items.size() > 0) {
                int len;
                FileItem item = (FileItem)items.get(0);
                String name = item.getName();
                InputStream stream = item.getInputStream();
                String format = "none";
                int index = name.lastIndexOf(".");
                if (index > 0) {
                    format = name.substring(index + 1);
                    format = format.toLowerCase();
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((len = stream.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, len);
                }
                int maxFileSize = 0xA00000;
                if (out.size() > maxFileSize) {
                    outPut.print("{Error uploading file}");
                    throw new RuntimeException("File is > than " + maxFileSize);
                }
                String content = new String(out.toByteArray());
                if (content != null && !content.isEmpty() && format.equals("mol")) {
                    outPut.print(service.importMolfile(content));
                } else if (!(content != null && !content.isEmpty() && format.equals("cdx") || content != null && !content.isEmpty() && format.equals("sk2"))) {
                    outPut.print("{}");
                }
            }
        }
        catch (Exception e) {
            outPut.print("{Error uploading file}");
            throw new RuntimeException(e);
        }
        outPut.flush();
        outPut.close();
    }
}

