/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.server;

import com.mestrelab.components.server.ImportExportServiceImpl;
import com.mestrelab.components.server.Utils;
import com.mestrelab.license.TLicenseValidator;
import com.mestrelab.license.util.Constants;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ConfigListener
implements ServletContextListener {
    private String errorLicense = TLicenseValidator.errorString((Constants.TLicenseError)Constants.TLicenseError.E_LIC_OK);
    private Boolean validLicense = false;
    private Logger logger = Logger.getLogger(ConfigListener.class.getName());

    public void contextDestroyed(ServletContextEvent event) {
        event.getServletContext().removeAttribute("service");
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.logger.info("Initializing contextInitialized");
            ImportExportServiceImpl service = new ImportExportServiceImpl();
            if (!this.validLicense.booleanValue()) {
                this.logger.info("looking for property 'moleditor.embedded' in context-param");
                ServletContext c = event.getServletContext();
                String validLicenseAsString = c.getInitParameter("moleditor.embedded");
                if (validLicenseAsString != null) {
                    this.validLicense = Boolean.valueOf(validLicenseAsString);
                    this.logger.info("found moleditor.embedded parameter:" + this.validLicense);
                }
            }
            if (!this.validLicense.booleanValue()) {
                this.checkLicense(event);
                this.logger.info("CheckLicense in ConfigurationProperties:" + this.validLicense);
            }
            ImportExportServiceImpl.setValidLicense(this.validLicense, this.errorLicense);
            event.getServletContext().setAttribute("service", (Object)service);
            if (service != null) {
                String moleculeJson = service.importMolfile("\n\r  Test   12181213202D\n\r\n\r  7  8  0  0  0  0  0  0  0  0999 V2000\n\r   -0.0000   57.7350    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r   50.0000   28.8675    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r   50.0000  -28.8675    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r    0.0000  -57.7350    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r  -50.0000  -28.8675    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r  -50.0000   28.8675    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r  100.0000   -0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n\r  2  3  1  0  0  0  0\n\r  2  7  1  0  0  0  0\n\r  3  4  2  0  0  0  0\n\r  7  3  1  0  0  0  0\n\r  1  2  2  0  0  0  0\n\r  1  6  1  0  0  0  0\n\r  5  6  2  0  0  0  0\n\r  4  5  1  0  0  0  0\n\rM  ZZC   1 4\n\rM  ZZC   2 1\n\rM  ZZC   3 2\n\rM  ZZC   4 7\n\rM  ZZC   5 6\n\rM  ZZC   6 5\n\rM  ZZC   7 3\n\rM  END");
                if (moleculeJson == null || moleculeJson.isEmpty()) {
                    throw new Exception("import molfile is null");
                }
                String molfile = service.exportMolfile(moleculeJson);
                if (molfile == null || molfile.isEmpty()) {
                    throw new Exception("export molfile is null");
                }
                this.logger.info("export :" + molfile);
            }
            this.logger.info("Added service ImportExport to config:" + (service != null));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void checkLicense(ServletContextEvent event) {
        if (Utils.embedded.booleanValue()) {
            this.validLicense = Utils.embedded;
            this.errorLicense = "";
            return;
        }
        if (event.getServletContext() != null && event.getServletContext().getInitParameter("license.path") != null) {
            String licPath = event.getServletContext().getRealPath(event.getServletContext().getInitParameter("license.path"));
            TLicenseValidator validator = new TLicenseValidator(licPath);
            this.validLicense = validator.validateProduct(Utils.PRODUCT_ID, Utils.PRODUCT_VERSION, Utils.PRODUCT_NAME, Utils.PRODUCT_RELEASE_DATE, true);
            if (!this.validLicense.booleanValue()) {
                this.errorLicense = validator.errorString(Utils.PRODUCT_ID);
                this.logger.severe(this.errorLicense.concat(". HostID:").concat(validator.getHostId()));
            }
        }
    }
}

