/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.widget;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.ButtonBase;
import com.google.gwt.user.client.ui.DirectionalTextHelper;
import com.google.gwt.user.client.ui.HasDirectionalSafeHtml;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasWordWrap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBox
extends ButtonBase
implements HasName,
HasValue<Boolean>,
HasWordWrap,
HasDirectionalSafeHtml,
HasDirectionEstimator,
IsEditor<LeafValueEditor<Boolean>> {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = DirectionalTextHelper.DEFAULT_DIRECTION_ESTIMATOR;
    final DirectionalTextHelper directionalTextHelper;
    InputElement inputElem;
    LabelElement labelElem;
    private LeafValueEditor<Boolean> editor;
    private boolean valueChangeHandlerInitialized;

    public CheckBox() {
        this(DOM.createInputCheck());
        this.setStyleName("gwt-CheckBox");
    }

    public CheckBox(SafeHtml label) {
        this(label.asString(), true);
    }

    public CheckBox(SafeHtml label, HasDirection.Direction dir) {
        this();
        this.setHTML(label, dir);
    }

    public CheckBox(SafeHtml label, DirectionEstimator directionEstimator) {
        this();
        this.setDirectionEstimator(directionEstimator);
        this.setHTML(label.asString());
    }

    public CheckBox(String label) {
        this();
        this.setText(label);
    }

    public CheckBox(String label, HasDirection.Direction dir) {
        this();
        this.setText(label, dir);
    }

    public CheckBox(String label, DirectionEstimator directionEstimator) {
        this();
        this.setDirectionEstimator(directionEstimator);
        this.setText(label);
    }

    public CheckBox(String label, boolean asHTML) {
        this();
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    protected CheckBox(com.google.gwt.user.client.Element elem) {
        super((Element)DOM.createSpan());
        this.inputElem = InputElement.as((Element)elem);
        this.labelElem = Document.get().createLabelElement();
        this.inputElem.addClassName("pull-left");
        this.labelElem.addClassName("span2 pull-left");
        this.getElement().appendChild((Node)this.inputElem);
        this.getElement().appendChild((Node)this.labelElem);
        String uid = DOM.createUniqueId();
        this.inputElem.setPropertyString("id", uid);
        this.labelElem.setHtmlFor(uid);
        this.directionalTextHelper = new DirectionalTextHelper((Element)this.labelElem, true);
        this.setTabIndex(0);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.ensureDomEventHandlers();
            this.valueChangeHandlerInitialized = true;
        }
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public LeafValueEditor<Boolean> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of((TakesValue)this);
        }
        return this.editor;
    }

    public DirectionEstimator getDirectionEstimator() {
        return this.directionalTextHelper.getDirectionEstimator();
    }

    public String getFormValue() {
        return this.inputElem.getValue();
    }

    public String getHTML() {
        return this.directionalTextHelper.getTextOrHtml(true);
    }

    public String getName() {
        return this.inputElem.getName();
    }

    public int getTabIndex() {
        return this.inputElem.getTabIndex();
    }

    public String getText() {
        return this.directionalTextHelper.getTextOrHtml(false);
    }

    public HasDirection.Direction getTextDirection() {
        return this.directionalTextHelper.getTextDirection();
    }

    public Boolean getValue() {
        if (this.isAttached()) {
            return this.inputElem.isChecked();
        }
        return this.inputElem.isDefaultChecked();
    }

    public boolean getWordWrap() {
        return !Style.WhiteSpace.NOWRAP.getCssName().equals(this.getElement().getStyle().getWhiteSpace());
    }

    @Deprecated
    public boolean isChecked() {
        return this.getValue() == true;
    }

    public boolean isEnabled() {
        return !this.inputElem.isDisabled();
    }

    public void setAccessKey(char key) {
        this.inputElem.setAccessKey("" + key);
    }

    @Deprecated
    public void setChecked(boolean checked) {
        this.setValue(checked);
    }

    public void setDirectionEstimator(boolean enabled) {
        this.directionalTextHelper.setDirectionEstimator(enabled);
    }

    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
    }

    public void setEnabled(boolean enabled) {
        this.inputElem.setDisabled(!enabled);
        if (enabled) {
            this.removeStyleDependentName("disabled");
        } else {
            this.addStyleDependentName("disabled");
        }
    }

    public void setFocus(boolean focused) {
        if (focused) {
            this.inputElem.focus();
        } else {
            this.inputElem.blur();
        }
    }

    public void setFormValue(String value) {
        this.inputElem.setAttribute("value", value);
    }

    public void setHTML(SafeHtml html, HasDirection.Direction dir) {
        this.directionalTextHelper.setTextOrHtml(html.asString(), dir, true);
    }

    public void setHTML(String html) {
        this.directionalTextHelper.setTextOrHtml(html, true);
    }

    public void setName(String name) {
        this.inputElem.setName(name);
    }

    public void setTabIndex(int index) {
        if (this.inputElem != null) {
            this.inputElem.setTabIndex(index);
        }
    }

    public void setText(String text) {
        this.directionalTextHelper.setTextOrHtml(text, false);
    }

    public void setText(String text, HasDirection.Direction dir) {
        this.directionalTextHelper.setTextOrHtml(text, dir, false);
    }

    public void setValue(Boolean value) {
        this.setValue(value, false);
    }

    public void setValue(Boolean value, boolean fireEvents) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        Boolean oldValue = this.getValue();
        this.inputElem.setChecked(value.booleanValue());
        this.inputElem.setDefaultChecked(value.booleanValue());
        if (value.equals(oldValue)) {
            return;
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setWhiteSpace(wrap ? Style.WhiteSpace.NORMAL : Style.WhiteSpace.NOWRAP);
    }

    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            Event.sinkEvents((Element)this.inputElem, (int)(eventBitsToAdd | Event.getEventsSunk((Element)this.inputElem)));
        } else {
            super.sinkEvents(eventBitsToAdd);
        }
    }

    protected void ensureDomEventHandlers() {
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ValueChangeEvent.fire((HasValueChangeHandlers)CheckBox.this, (Object)CheckBox.this.getValue());
            }
        });
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        CheckBox.ensureDebugId((Element)this.labelElem, (String)baseID, (String)"label");
        CheckBox.ensureDebugId((Element)this.inputElem, (String)baseID, (String)"input");
        this.labelElem.setHtmlFor(this.inputElem.getId());
    }

    protected void onLoad() {
        this.setEventListener((Element)this.inputElem, (EventListener)this);
    }

    protected void onUnload() {
        this.setEventListener((Element)this.asOld((Element)this.inputElem), null);
        this.setValue(this.getValue());
    }

    protected void replaceInputElement(com.google.gwt.user.client.Element elem) {
        InputElement newInputElem = InputElement.as((Element)elem);
        int tabIndex = this.getTabIndex();
        boolean checked = this.getValue();
        boolean enabled = this.isEnabled();
        String formValue = this.getFormValue();
        String uid = this.inputElem.getId();
        String accessKey = this.inputElem.getAccessKey();
        int sunkEvents = Event.getEventsSunk((Element)this.inputElem);
        this.setEventListener((Element)this.asOld((Element)this.inputElem), null);
        this.getElement().replaceChild((Node)newInputElem, (Node)this.inputElem);
        Event.sinkEvents((Element)elem, (int)Event.getEventsSunk((Element)this.inputElem));
        Event.sinkEvents((Element)this.inputElem, (int)0);
        this.inputElem = newInputElem;
        Event.sinkEvents((Element)this.inputElem, (int)sunkEvents);
        this.inputElem.setId(uid);
        if (!"".equals(accessKey)) {
            this.inputElem.setAccessKey(accessKey);
        }
        this.setTabIndex(tabIndex);
        this.setValue(checked);
        this.setEnabled(enabled);
        this.setFormValue(formValue);
        if (this.isAttached()) {
            this.setEventListener((Element)this.asOld((Element)this.inputElem), (EventListener)this);
        }
    }

    private com.google.gwt.user.client.Element asOld(Element elem) {
        com.google.gwt.user.client.Element oldSchool = (com.google.gwt.user.client.Element)elem.cast();
        return oldSchool;
    }

    private void setEventListener(Element e, EventListener listener) {
        DOM.setEventListener((com.google.gwt.user.client.Element)this.asOld(e), (EventListener)listener);
    }
}

