/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.util;

import com.google.gwt.i18n.client.NumberFormat;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondStereo;
import com.mestrelab.components.shared.TBondType;
import com.mestrelab.components.shared.TBracket;
import com.mestrelab.components.shared.TBracketType;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TPeriodicTable;
import com.mestrelab.components.shared.TPolymer;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QDateTime;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QRegExp;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.util.T3DPointF;
import com.mestrelab.components.shared.util.UtilsString;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils_Molfile
implements Serializable {
    public static int cHeaderBlock = 3;
    public static int cCountsLine = 1;
    public static QString cSDFileSeparator = new QString("$$$$");
    public static QString cVersion = new QString("V2000");
    public static QString cSDFTagRegExp = new QString(">([^\\n]*)<([^\\n]+)>([^\\n]*)\\n{$1}");
    public static QString sdf_SGType = new QString("M  STY");
    public static QString sdf_SGSubType = new QString("M  SST");
    public static QString sdf_SGCompNum = new QString("M  SNC");
    public static QString sdf_SGLabels = new QString("M  SLB");
    public static QString sdf_SGConn = new QString("M  SCN");
    public static QString sdf_SGAtomList = new QString("M  SAL");
    public static QString sdf_SPAtomList = new QString("M  SPA");
    public static QString sdf_SGBondList = new QString("M  SBL");
    public static QString sdf_SGBrackets = new QString("M  SDI");
    public static QString sdf_SGSubscript = new QString("M  SMT");
    public static QString sdf_SGBrStyle = new QString("M  SBT");
    public static QString sdf_SGDataDescription = new QString("M  SDT");
    public static QString sdf_SGDataDisplay = new QString("M  SDD");
    public static QString sdf_SGDataEnd = new QString("M  SED");
    public static QString sdf_ACDNumbering = new QString("M  ZZC");

    public static QByteArray writeUnique(TMolecule aMolecule) {
        TMolecule newMol = new TMolecule(aMolecule);
        boolean doStore = TMolecule.saveNumberingToMolfiles();
        QList<QString> numbers = new QList();
        if (doStore) {
            numbers = newMol.storeNumbers();
        }
        newMol.setUniqueNumbering();
        newMol.sortBonds();
        if (doStore) {
            newMol.restoreNumbers(numbers);
        }
        return Utils_Molfile.write(newMol);
    }

    public static QString prependSymbols(QString aString, int aSize) {
        return Utils_Molfile.prependSymbols(aString, aSize, ' ');
    }

    public static QString prependSymbols(QString aString, int aSize, char aSymbol) {
        if (aString.size() >= aSize) {
            return aString;
        }
        QString str = new QString();
        str.fill(aSymbol, aSize - aString.size());
        return aString.prepend(str);
    }

    public static QString appendSymbols(QString aString, int aSize) {
        return Utils_Molfile.appendSymbols(aString, aSize, ' ');
    }

    public static QString appendSymbols(QString aString, int aSize, char aSymbol) {
        if (aString.size() >= aSize) {
            return aString;
        }
        QString str = new QString();
        str.fill(aSymbol, aSize - aString.size());
        return aString.append(str);
    }

    private static String format(Number number) {
        return NumberFormat.getFormat((String)"####0.0000").format(number.doubleValue());
    }

    public static QByteArray write(TMolecule aMolecule) {
        int nPolymers;
        int nCompleteLines;
        int ai;
        QByteArray molfile = new QByteArray();
        int nAtoms = aMolecule.atoms().size();
        int nBonds = aMolecule.bonds().size();
        QString newLine = new QString("\r\n");
        QString emptyBlocks = new QString();
        QString headerBlock = new QString("");
        QDateTime timestamp = aMolecule.timestamp();
        if (timestamp.isNull()) {
            timestamp = new QDateTime();
        }
        headerBlock.append(aMolecule.name(true).toString() + newLine.toString());
        headerBlock.append("  " + aMolecule.origin(true).leftJustified(8, ' ') + timestamp.toString("MMddyyhhmm") + "2D" + newLine);
        headerBlock.append(aMolecule.comment(true).toString() + newLine.toString());
        QString countsLine = new QString();
        int nBlocks = 10;
        int sizeBlock = 3;
        for (int b = 0; b < nBlocks - 2; ++b) {
            QString emptyBlock = new QString("0");
            emptyBlocks.append(Utils_Molfile.prependSymbols(emptyBlock, sizeBlock));
        }
        countsLine.append(Utils_Molfile.prependSymbols(new QString("" + nAtoms), sizeBlock));
        countsLine.append(Utils_Molfile.prependSymbols(new QString("" + nBonds), sizeBlock));
        countsLine.append(emptyBlocks);
        countsLine.append("999 V2000" + newLine);
        QString atomBlock = new QString("");
        emptyBlocks.clear();
        for (int b = 0; b < 6; ++b) {
            QString emptyBlock = new QString("0");
            emptyBlocks.append(Utils_Molfile.prependSymbols(emptyBlock, sizeBlock));
        }
        int posSizeBlock = 10;
        int decimals = 4;
        QString atomLine = new QString();
        int nCharges = 0;
        int nIsotopes = 0;
        QString chargeLine = new QString();
        QString isotopeLine = new QString();
        QList<QString> rgp = new QList<QString>();
        QList<QString> allAls = new QList<QString>();
        QList<Integer> specialAliases = new QList<Integer>();
        double refValue = aMolecule.maxCoords(aMolecule.atoms());
        for (int ai2 = 0; ai2 < nAtoms; ++ai2) {
            int intValence;
            atomLine.clear();
            T3DPointF pointAi = aMolecule.atom(ai2);
            if (aMolecule.getfOriginalMolfile().isEmpty()) {
                pointAi = aMolecule.atom(ai2).normalizedCoords(refValue);
            }
            QString posX = new QString(Utils_Molfile.format((Number)pointAi.x()));
            QString posY = new QString(Utils_Molfile.format((Number)pointAi.y()));
            QString posZ = new QString(Utils_Molfile.format(pointAi.z()));
            QString symbol = new QString(aMolecule.atom(ai2).elementSymbol().toString());
            if (symbol.equals("?")) {
                symbol = new QString("*");
            }
            if (aMolecule.atom(ai2).getfElement().getfElementName().equals(TPeriodicTable.getInstance().nullElement().getfElementName())) {
                QRegExp listRegExp = new QRegExp("(NOT)?\\[(.*)\\]");
                if (listRegExp.exactMatch(symbol)) {
                    symbol = new QString("L");
                    String[] list = listRegExp.cap(2).split(",");
                    QString als = new QString("M  ALS ");
                    als = als.arg(ai2 + 1, 3, ' ').arg(list.length, 3, ' ').append(" ").arg(listRegExp.cap(1).isEmpty() ? "T" : "F", 1, ' ');
                    for (int i = 0; i < list.length; ++i) {
                        QString elem = new QString(list[i]);
                        if (TPeriodicTable.getInstance().operatorElementSymbol(elem) == TPeriodicTable.getInstance().nullElement()) {
                            symbol = new QString("C");
                            break;
                        }
                        als = als.arg(elem.toString(), -4, ' ');
                    }
                    if (symbol.equals(new QString("L"))) {
                        allAls.append(als);
                        specialAliases.append(ai2);
                    }
                } else if (symbol.size() > 1 && symbol.toString().charAt(0) == 'R') {
                    boolean ok = false;
                    int rIndex = Integer.parseInt(symbol.mid(1).toString());
                    if (ok && rIndex >= 1 && rIndex <= 32) {
                        symbol = new QString("R#");
                        specialAliases.append(ai2);
                        rgp.append(new QString(" ").arg(ai2 + 1, 3, ' ').append(" ").arg(rIndex, 3, ' '));
                    } else {
                        symbol = new QString("C");
                    }
                } else {
                    symbol = new QString("C");
                }
            }
            if ((intValence = aMolecule.atom(ai2).getfValence()) == -1) {
                intValence = 0;
            }
            if (aMolecule.atom(ai2).stableValences().contains(intValence)) {
                intValence = 0;
            }
            QString valence = new QString("" + intValence);
            int charge = aMolecule.atom(ai2).getfCharge();
            QString atomNumber = new QString("" + (ai2 + 1));
            QString chargeAtomLine = new QString();
            if (charge != 0) {
                ++nCharges;
                chargeAtomLine.append(Utils_Molfile.prependSymbols(atomNumber, sizeBlock));
                chargeAtomLine.append(" ");
                chargeAtomLine.append(Utils_Molfile.prependSymbols(new QString("" + charge), sizeBlock));
                chargeLine.append(chargeAtomLine + " ");
                chargeAtomLine.clear();
            }
            int isotope = aMolecule.atom(ai2).getfIsotope();
            QString isotopeAtomLine = new QString();
            if (isotope != 0) {
                ++nIsotopes;
                isotopeAtomLine.append(Utils_Molfile.prependSymbols(atomNumber, sizeBlock));
                isotopeAtomLine.append(" ");
                isotopeAtomLine.append(Utils_Molfile.prependSymbols(new QString("" + isotope), sizeBlock));
                isotopeLine.append(isotopeAtomLine + " ");
                isotopeAtomLine.clear();
            }
            atomLine.append(Utils_Molfile.prependSymbols(posX, posSizeBlock));
            atomLine.append(Utils_Molfile.prependSymbols(posY, posSizeBlock));
            atomLine.append(Utils_Molfile.prependSymbols(posZ, posSizeBlock));
            atomLine.append(" ");
            atomLine.append(Utils_Molfile.appendSymbols(symbol, sizeBlock));
            atomLine.append(" 0");
            atomLine.append("  0");
            atomLine.append("  0");
            atomLine.append("  0");
            atomLine.append("  0");
            atomLine.append(Utils_Molfile.prependSymbols(valence, sizeBlock));
            atomLine.append(emptyBlocks);
            atomBlock.append(atomLine.toString() + newLine.toString());
        }
        QString bondBlock = new QString();
        nBlocks = 7;
        emptyBlocks.clear();
        for (int b = 0; b < nBlocks - 4; ++b) {
            QString emptyBlock = new QString("0");
            emptyBlocks.append(Utils_Molfile.prependSymbols(emptyBlock, sizeBlock));
        }
        QString bondLine = new QString();
        for (int bi = 0; bi < nBonds; ++bi) {
            bondLine.clear();
            QString atom1 = new QString("" + (aMolecule.bond(bi).atom1() + 1));
            QString atom2 = new QString("" + (aMolecule.bond(bi).atom2() + 1));
            QString bondType = new QString("" + aMolecule.bond(bi).bondType().getValue());
            QString bondStereo = new QString("" + aMolecule.bond(bi).bondStereo().getValue());
            bondLine.append(Utils_Molfile.prependSymbols(atom1, sizeBlock));
            bondLine.append(Utils_Molfile.prependSymbols(atom2, sizeBlock));
            bondLine.append(Utils_Molfile.prependSymbols(bondType, sizeBlock));
            bondLine.append(Utils_Molfile.prependSymbols(bondStereo, sizeBlock));
            bondLine.append(emptyBlocks);
            bondBlock.append(bondLine.toString() + newLine.toString());
        }
        QString propBlock = new QString();
        for (ai = 0; ai < nAtoms; ++ai) {
            QString alias;
            if (specialAliases.contains(ai) || (alias = aMolecule.atom(ai).getfAlias()).isEmpty()) continue;
            QString aliasLine = new QString("A  ");
            aliasLine.append(Utils_Molfile.prependSymbols(new QString("" + (ai + 1)), sizeBlock));
            aliasLine.append(newLine);
            aliasLine.append(alias);
            propBlock.append(aliasLine.toString() + newLine.toString());
        }
        if (nCharges != 0) {
            nCompleteLines = nCharges / 8;
            for (int i = 0; i < nCompleteLines; ++i) {
                QString chargeProp = new QString("M  CHG" + Utils_Molfile.prependSymbols(new QString("8"), sizeBlock).toString() + " ");
                chargeProp.append(chargeLine.mid(i * 8 * 2 * (sizeBlock + 1), 16 * (sizeBlock + 1)));
                chargeProp = chargeProp.mid(0, chargeProp.size() - 1);
                propBlock.append(chargeProp.toString() + newLine.toString());
            }
            QString chargeProp = new QString("M  CHG" + Utils_Molfile.prependSymbols(new QString("" + (nCharges - nCompleteLines * 8)), sizeBlock) + " ");
            chargeProp.append(chargeLine.mid(nCompleteLines * 8 * 2 * (sizeBlock + 1), 16 * (sizeBlock + 1)));
            chargeProp = chargeProp.mid(0, chargeProp.size() - 1);
            propBlock.append(chargeProp.toString() + newLine.toString());
        }
        if (nIsotopes != 0) {
            nCompleteLines = nIsotopes / 8;
            for (int i = 0; i < nCompleteLines; ++i) {
                QString isotopeProp = new QString("M  ISO" + Utils_Molfile.prependSymbols(new QString("8"), sizeBlock) + " ");
                isotopeProp.append(isotopeLine.mid(i * 8 * 2 * (sizeBlock + 1), 16 * (sizeBlock + 1)));
                isotopeProp = isotopeProp.mid(0, isotopeProp.size() - 1);
                propBlock.append(isotopeProp.toString() + newLine.toString());
            }
            QString isotopeProp = new QString("M  ISO" + Utils_Molfile.prependSymbols(new QString("" + (nIsotopes - nCompleteLines * 8)), sizeBlock) + " ");
            isotopeProp.append(isotopeLine.mid(nCompleteLines * 8 * 2 * (sizeBlock + 1), 16 * (sizeBlock + 1)));
            isotopeProp = isotopeProp.mid(0, isotopeProp.size() - 1);
            propBlock.append(isotopeProp.toString() + newLine.toString());
        }
        if (!allAls.isEmpty()) {
            propBlock.append(allAls.join(newLine.toString()) + newLine.toString());
        }
        if (!rgp.isEmpty()) {
            int _size = rgp.size();
            for (int i = 0; i < _size; ++i) {
                if (i % 8 == 0) {
                    propBlock.append(new QString("M  RGP").arg(Math.min(8, _size - i), 3, ' '));
                }
                propBlock.append((QString)rgp.at(i));
                if (i % 8 != 7 && i != _size - 1) continue;
                propBlock.append(newLine);
            }
        }
        if (TMolecule.saveNumberingToMolfiles() && aMolecule.numberingDiffersFromIndexes()) {
            for (ai = 0; ai < nAtoms; ++ai) {
                QString num = aMolecule.atom(ai).getTatomData().number();
                if (num.toString().equals("")) continue;
                propBlock.append(new QString(sdf_ACDNumbering.toString() + Utils_Molfile.prependSymbols(new QString("" + (ai + 1)), sizeBlock + 1).toString() + " " + num.toString() + newLine.toString()));
            }
        }
        if ((nPolymers = aMolecule.polymerCount()) != 0) {
            TPolymer poly;
            int pNum;
            QString sType = new QString("");
            int nType = 0;
            QString sSubType = new QString("");
            int nSubType = 0;
            QString sCompNum = new QString("");
            int nCompNum = 0;
            QString sLabels = new QString("");
            int nLabels = 0;
            QString sConn = new QString("");
            int nConn = 0;
            QString sBrStyle = new QString("");
            int nBrStyle = 0;
            for (pNum = 1; pNum <= nPolymers; ++pNum) {
                poly = aMolecule.getPolymer(pNum);
                if (!poly.getSgType().isEmpty()) {
                    ++nType;
                    sType.append(" " + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock).toString() + Utils_Molfile.prependSymbols(poly.typeForExport(), sizeBlock + 1).toString());
                }
                if (!poly.getSgSubType().isEmpty()) {
                    ++nSubType;
                    sSubType.append(" " + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock).toString() + Utils_Molfile.prependSymbols(poly.getSgSubType(), sizeBlock + 1).toString());
                }
                if (poly.getSgCompNum() != 0) {
                    ++nCompNum;
                    sCompNum.append(" " + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock).toString() + Utils_Molfile.prependSymbols(new QString("" + poly.getSgCompNum()), sizeBlock + 1).toString());
                }
                if (poly.getSgLabels() != 0) {
                    ++nLabels;
                    sLabels.append(" " + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock).toString() + Utils_Molfile.prependSymbols(new QString("" + poly.getSgLabels()), sizeBlock + 1).toString());
                }
                if (!poly.getSgConn().isEmpty()) {
                    ++nConn;
                    sConn.append(" " + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock).toString() + Utils_Molfile.prependSymbols(new QString(poly.getSgConn().toString() + " "), sizeBlock + 1).toString());
                }
                if (poly.getSgBrStyle() == 0) continue;
                ++nBrStyle;
                sBrStyle.append(" " + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock).toString() + Utils_Molfile.prependSymbols(new QString("" + poly.getSgBrStyle()), sizeBlock + 1).toString());
            }
            if (nType != 0) {
                propBlock.append(sdf_SGType + Utils_Molfile.prependSymbols(new QString("" + nType), sizeBlock).toString() + sType + newLine);
            }
            if (nSubType != 0) {
                propBlock.append(sdf_SGSubType + Utils_Molfile.prependSymbols(new QString("" + nSubType), sizeBlock).toString() + sSubType + newLine);
            }
            if (nCompNum != 0) {
                propBlock.append(sdf_SGCompNum + Utils_Molfile.prependSymbols(new QString("" + nCompNum), sizeBlock).toString() + sCompNum + newLine);
            }
            if (nLabels != 0) {
                propBlock.append(sdf_SGLabels + Utils_Molfile.prependSymbols(new QString("" + nLabels), sizeBlock).toString() + sLabels + newLine);
            }
            if (nConn != 0) {
                propBlock.append(sdf_SGConn + Utils_Molfile.prependSymbols(new QString("" + nConn), sizeBlock).toString() + sConn + newLine);
            }
            if (nBrStyle != 0) {
                propBlock.append(sdf_SGBrStyle + Utils_Molfile.prependSymbols(new QString("" + nBrStyle), sizeBlock).toString() + sBrStyle + newLine);
            }
            for (pNum = 1; pNum <= nPolymers; ++pNum) {
                poly = aMolecule.getPolymer(pNum);
                if (!poly.getSgAtomList().isEmpty()) {
                    propBlock.append(sdf_SGAtomList + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSgAtomList() + newLine.toString());
                }
                if (!poly.getSpAtomList().isEmpty()) {
                    propBlock.append(sdf_SPAtomList + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSpAtomList() + newLine.toString());
                }
                if (!poly.getSgBondList().isEmpty()) {
                    propBlock.append(sdf_SGBondList + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSgBondList() + newLine.toString());
                }
                for (int i = 0; i < poly.getBrackets().size(); ++i) {
                    TBracket bracket = poly.getBrackets().at(i);
                    propBlock.append(sdf_SGBrackets + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + Utils_Molfile.prependSymbols(new QString("4"), sizeBlock).toString() + Utils_Molfile.prependSymbols(new QString("" + bracket.getRect().topLeft().x()), 10).toString() + Utils_Molfile.prependSymbols(new QString("" + bracket.getRect().topLeft().y()), 10).toString() + Utils_Molfile.prependSymbols(new QString("" + bracket.getRect().bottomRight().x()), 10).toString() + Utils_Molfile.prependSymbols(new QString("" + bracket.getRect().bottomRight().y()), 10).toString() + newLine.toString());
                }
                if (!poly.getSgSubscript().isEmpty()) {
                    propBlock.append(sdf_SGSubscript + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSgSubscript().toString() + newLine.toString());
                }
                if (!poly.getSgDataDescription().isEmpty()) {
                    propBlock.append(sdf_SGDataDescription + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSgDataDescription().toString() + newLine.toString());
                }
                if (!poly.getSgDataDisplay().isEmpty()) {
                    propBlock.append(sdf_SGDataDisplay + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSgDataDisplay().toString() + newLine.toString());
                }
                if (poly.getSgDataEnd().isEmpty()) continue;
                propBlock.append(sdf_SGDataEnd + Utils_Molfile.prependSymbols(new QString("" + pNum), sizeBlock + 1).toString() + " " + poly.getSgDataEnd().toString() + newLine.toString());
            }
        }
        propBlock.append("M  END" + newLine.toString());
        molfile.append(headerBlock);
        molfile.append(countsLine);
        molfile.append(atomBlock);
        molfile.append(bondBlock);
        molfile.append(propBlock);
        return molfile;
    }

    private static QMap<Integer, Integer> insertMap(QMap<Integer, Integer> aMap, QString aLine) {
        QMap<Integer, Integer> result = aMap;
        for (int e = 0; e < aLine.mid(6, 3).toInt(); ++e) {
            result.add(aLine.mid(10 + 8 * e, 3).toInt(), aLine.mid(14 + 8 * e, 3).toInt());
        }
        return result;
    }

    private static boolean searchCountLine(QList<QString> aList) {
        int currHeaderBlock;
        boolean ok = false;
        for (currHeaderBlock = cHeaderBlock; !ok && currHeaderBlock < aList.size(); ++currHeaderBlock) {
            QString str = aList.at(currHeaderBlock);
            int startWithInt = Integer.MIN_VALUE;
            boolean endWithVersion = false;
            if (str.size() >= 33) {
                startWithInt = str.mid(0, 3).toInt();
                QString version = str.mid(34, 6).trimmed().toUpper();
                endWithVersion = version.isEmpty() || version == cVersion || str.trimmed().endsWith(cVersion);
            }
            if (startWithInt == Integer.MIN_VALUE || !endWithVersion) continue;
            ok = true;
            break;
        }
        if (!ok) {
            return false;
        }
        int nAtoms = aList.at(currHeaderBlock).mid(0, 3).toInt();
        int nBonds = aList.at(currHeaderBlock).mid(3, 3).toInt();
        if (nAtoms == Integer.MIN_VALUE || nBonds == Integer.MIN_VALUE || currHeaderBlock + nAtoms + nBonds > aList.size()) {
            return false;
        }
        if (currHeaderBlock > cHeaderBlock) {
            for (int i = 0; i < currHeaderBlock - cHeaderBlock; ++i) {
                aList.removeAt(0);
            }
        }
        return true;
    }

    public static boolean equalMolFiles(QByteArray<QString> aMolContent1, QByteArray<QString> aMolContent2) {
        if (aMolContent1.isEmpty() || aMolContent2.isEmpty()) {
            return false;
        }
        QByteArray molContent1 = new QByteArray(UtilsString.normalizedEOL_RN(new QString(new String(aMolContent1.toString()))));
        QList<QString> molList1 = molContent1.split("\r\n");
        QByteArray molContent2 = new QByteArray(UtilsString.normalizedEOL_RN(new QString(new String(aMolContent2.toString()))));
        QList<QString> molList2 = molContent2.split("\r\n");
        if (molList1.size() != molList2.size()) {
            return false;
        }
        for (int i = cHeaderBlock; i < molList1.size(); ++i) {
            if (molList1.at(i) == molList2.at(i)) continue;
            return false;
        }
        return true;
    }

    public static TMolecule read(QByteArray<QString> aMolContent, boolean aImportMnovaSDData) {
        QString str;
        int k;
        int firstAtomLine;
        TMolecule molecule = new TMolecule();
        if (aMolContent.isEmpty()) {
            return null;
        }
        QByteArray<QString> molContent = new QByteArray<QString>(UtilsString.normalizedEOL_RN(new QString(aMolContent.toString())));
        QList<QString> molList = molContent.split("\r\n");
        if (molList.size() < cHeaderBlock + 1) {
            return null;
        }
        if (!Utils_Molfile.searchCountLine(molList)) {
            return null;
        }
        QString line = molList.at(cHeaderBlock);
        int nAtoms = line.mid(0, 3).toInt();
        int nBonds = line.mid(3, 3).toInt();
        int firstEntry = firstAtomLine = cHeaderBlock + cCountsLine;
        for (int k2 = firstAtomLine; k2 < molList.size(); ++k2) {
            QString str2 = molList.at(k2);
            if (!str2.startsWith("M") && !str2.startsWith("A") && !str2.startsWith("V") && !str2.startsWith("G") && !str2.startsWith("S") && !str2.startsWith(cSDFileSeparator)) continue;
            firstEntry = k2;
            break;
        }
        if (firstEntry < firstAtomLine + nAtoms + nBonds) {
            return null;
        }
        molecule.setName(molList.at(0));
        line = molList.at(1);
        QDateTime timestamp = QDateTime.fromString(line.mid(10, 10), "MMddyyhhmm");
        if (!timestamp.isNull()) {
            molecule.setTimestamp(timestamp);
        }
        molecule.setOrigin(line.mid(2, 8));
        molecule.setComment(molList.at(2));
        molecule.setfOriginalMolfile(molContent);
        QMap<Integer, Integer> charges = new QMap<Integer, Integer>();
        QMap<Integer, Integer> isotopes = new QMap<Integer, Integer>();
        QMap<Integer, QString> labels = new QMap<Integer, QString>();
        QMap<Integer, QString> numbering = new QMap<Integer, QString>();
        for (k = molList.indexOf(molList.at(firstAtomLine + nAtoms + nBonds)); k < molList.size() && !(str = molList.at(k)).left(6).toString().equals("M  END"); ++k) {
            int pNum;
            TPolymer poly;
            int size;
            int atomIndex;
            if (str.left(6).toString().equals("S  SKP")) {
                k += str.mid(6, 3).toInt();
                continue;
            }
            if (str.left(6).toString().equals("M  CHG")) {
                charges = Utils_Molfile.insertMap(charges, str);
                continue;
            }
            if (str.left(6).toString().equals("M  ISO")) {
                isotopes = Utils_Molfile.insertMap(isotopes, str);
                continue;
            }
            if (str.left(6).toString().equals("M  ALS")) {
                int size2;
                atomIndex = str.mid(7, 3).toInt();
                if (atomIndex == Integer.MIN_VALUE || (size2 = str.mid(10, 3).toInt()) == Integer.MIN_VALUE || size2 <= 0 || size2 > 16) continue;
                QString list = new QString("[");
                for (int li = 0; li < size2; ++li) {
                    list.append(str.mid(16 + li * 4, 4).trimmed());
                    if (li >= size2 - 1) continue;
                    list.append(",");
                }
                list.append("]");
                if (str.mid(14, 1).toString().equals("F")) {
                    list = new QString("NOT" + list.toString());
                }
                labels.add(atomIndex, list);
                continue;
            }
            if (str.left(6).toString().equals("M  RGP")) {
                int rIndex;
                int atomIndex2;
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0 || size > 16) continue;
                for (int li = 0; li < size && (atomIndex2 = str.mid(10 + li * 8, 3).toInt()) != Integer.MIN_VALUE && (rIndex = str.mid(14 + li * 8, 3).toInt()) != Integer.MIN_VALUE; ++li) {
                    labels.add(atomIndex2, new QString("R" + rIndex));
                }
                continue;
            }
            if (str.left(3).toString().equals("A  ") && molList.at(k) != molList.last()) {
                atomIndex = str.mid(3, 3).toInt();
                if (atomIndex == Integer.MIN_VALUE) continue;
                labels.add(atomIndex, molList.at(k + 1));
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGType.toString())) {
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0) continue;
                for (int li = 0; li < size; ++li) {
                    int pNum2 = str.mid(10 + li * 8, 3).toInt();
                    QString sgS = str.mid(14 + li * 8, 3).toUpper();
                    if (pNum2 == Integer.MIN_VALUE) continue;
                    poly = molecule.getPolymer(pNum2);
                    poly.setSgType(sgS);
                }
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGSubType.toString())) {
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0) continue;
                for (int li = 0; li < size; ++li) {
                    int pNum3 = str.mid(10 + li * 8, 3).toInt();
                    QString sgS = str.mid(14 + li * 8, 3).toUpper();
                    if (pNum3 == Integer.MIN_VALUE) continue;
                    poly = molecule.getPolymer(pNum3);
                    poly.setSgSubType(sgS);
                }
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGCompNum.toString())) {
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0) continue;
                for (int li = 0; li < size; ++li) {
                    int pNum4 = str.mid(10 + li * 8, 3).toInt();
                    int sgV = str.mid(14 + li * 8, 3).toInt();
                    if (sgV == Integer.MIN_VALUE || pNum4 == Integer.MIN_VALUE) continue;
                    poly = molecule.getPolymer(pNum4);
                    poly.setSgCompNum(sgV);
                }
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGConn.toString())) {
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0) continue;
                for (int li = 0; li < size; ++li) {
                    int pNum5 = str.mid(10 + li * 8, 3).toInt();
                    QString sgS = str.mid(14 + li * 8, 3).toUpper().trimmed();
                    if (pNum5 == Integer.MIN_VALUE) continue;
                    poly = molecule.getPolymer(pNum5);
                    poly.setSgConn(sgS);
                }
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGBrStyle.toString())) {
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0) continue;
                for (int li = 0; li < size; ++li) {
                    int pNum6 = str.mid(10 + li * 8, 3).toInt();
                    int sgV = str.mid(14 + li * 8, 3).toInt();
                    if (sgV == Integer.MIN_VALUE || pNum6 == Integer.MIN_VALUE) continue;
                    poly = molecule.getPolymer(pNum6);
                    poly.setSgBrStyle(sgV);
                }
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGSubscript.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly2 = molecule.getPolymer(pNum);
                poly2.setSgSubscript(str.mid(11));
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGBrackets.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly3 = molecule.getPolymer(pNum);
                QRectF rect = new QRectF(new QPoint<Double>(str.mid(13, 10).toFloat(), str.mid(23, 10).toFloat()), new QPoint<Double>(str.mid(33, 10).toFloat(), str.mid(43, 10).toFloat()));
                TBracket bracket = new TBracket(rect, TBracketType.btBrackets);
                poly3.getBrackets().append(bracket);
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGLabels.toString())) {
                size = str.mid(6, 3).toInt();
                if (size == Integer.MIN_VALUE || size <= 0) continue;
                for (int li = 0; li < size; ++li) {
                    int pNum7 = str.mid(10 + li * 8, 3).toInt();
                    int sgV = str.mid(14 + li * 8, 3).toInt();
                    if (sgV == Integer.MIN_VALUE || pNum7 == Integer.MIN_VALUE) continue;
                    poly = molecule.getPolymer(pNum7);
                    poly.setSgLabels(sgV);
                }
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGAtomList.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly4 = molecule.getPolymer(pNum);
                poly4.mergeAtomList(str.mid(11), false);
                continue;
            }
            if (str.left(6).toString().equals(sdf_SPAtomList.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly5 = molecule.getPolymer(pNum);
                poly5.mergeAtomList(str.mid(11), false);
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGBondList.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly6 = molecule.getPolymer(pNum);
                poly6.setSgBondList(str.mid(11));
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGDataDescription.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly7 = molecule.getPolymer(pNum);
                poly7.setSgDataDescription(str.mid(11));
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGDataDisplay.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly8 = molecule.getPolymer(pNum);
                poly8.setSgDataDisplay(str.mid(11));
                continue;
            }
            if (str.left(6).toString().equals(sdf_SGDataEnd.toString())) {
                pNum = str.mid(6, 4).toInt();
                if (pNum == Integer.MIN_VALUE) continue;
                TPolymer poly9 = molecule.getPolymer(pNum);
                poly9.setSgDataEnd(str.mid(11));
                continue;
            }
            if (!str.left(6).toString().equals(sdf_ACDNumbering.toString()) || (atomIndex = str.mid(7, 4).toInt()) == Integer.MIN_VALUE) continue;
            numbering.add(atomIndex - 1, str.mid(11).trimmed());
        }
        for (k = 0; k < nAtoms; ++k) {
            TAtom myAtom = new TAtom();
            line = molList.at(k + firstAtomLine);
            double x = line.mid(0, 10).toDouble();
            double y = line.mid(10, 10).toDouble();
            double z = line.mid(20, 10).toDouble();
            QString symbol = line.mid(31, 3).trimmed();
            myAtom.setX(x);
            myAtom.setY(y);
            myAtom.setZ(z);
            myAtom.setElementSymbol(symbol);
            if (!charges.isEmpty() && charges.contains(k + 1)) {
                myAtom.setfCharge(charges.find(k + 1));
            }
            if (!isotopes.isEmpty() && isotopes.contains(k + 1)) {
                myAtom.setfIsotope(isotopes.find(k + 1));
            } else {
                myAtom.setfIsotope(0);
            }
            if (!labels.isEmpty() && labels.contains(k + 1)) {
                myAtom.setAlias((QString)labels.find(k + 1));
            }
            QByteArray num = new QByteArray();
            num.append(numbering.find(k) != null ? (QString)numbering.find(k) : new QString(""));
            if (!num.toString().equals("")) {
                myAtom.getTatomData().setNumber(new QString(num.toString()));
            } else {
                myAtom.getTatomData().setNumberAsInt(k + 1);
            }
            molecule.addAtom(myAtom);
        }
        for (int j = 0; j < nBonds; ++j) {
            line = molList.at(j + firstAtomLine + nAtoms);
            int indexAtom1 = line.mid(0, 3).toInt() - 1;
            int indexAtom2 = line.mid(3, 3).toInt() - 1;
            TBondType bondType = TBondType.getType(line.mid(6, 3).toInt());
            TBondStereo bondStereo = TBondStereo.getType(line.mid(9, 3).toInt());
            TBond bond = new TBond(indexAtom1, indexAtom2, bondType, bondStereo);
            molecule.addBond(bond);
        }
        for (int k3 = 0; k3 < nAtoms; ++k3) {
            line = molList.at(k3 + firstAtomLine);
            int molfileValence = line.mid(48, 3).toInt();
            if (molfileValence != 0) {
                if (molfileValence == 15) {
                    molecule.atoms().at(k3).setfValence(0);
                    continue;
                }
                molecule.atoms().at(k3).setfValence(molfileValence);
                continue;
            }
            int minValence = molecule.findValence(molecule.atoms().at(k3));
            molecule.atoms().at(k3).setfValence(minValence);
        }
        molecule.expandSimpleAliases();
        molecule.mergeMultiPolymers();
        molecule.setStereoNotations();
        molecule.addChargedNO();
        return molecule;
    }
}

