/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor.command;

import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TEditorMode;
import com.mestrelab.components.client.moleditor.command.TCmdEditMolecule;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCmdMergeAtoms
extends TCmdEditMolecule {
    private int fAtom1;
    private int fAtom2;
    private QPoint<Double> fPos;
    private QVector<QPoint<Double>> fStoreAtomCoords;

    public TCmdMergeAtoms(QList<TCanvasItem> selectedMolecules, QList<TCanvasItem> allMolecules, TCanvasMolecule hLMol, int atm1, int atm2, QPoint<Double> pos, QVector<QPoint<Double>> storeAtomCoords, TEditorMode fCurrMode) {
        super(TCmdEditMolecule.TCmdType.Move, selectedMolecules, selectedMolecules, hLMol, fCurrMode);
        this.fAtom1 = atm1;
        this.fAtom2 = atm2;
        this.fPos = pos;
        this.fStoreAtomCoords = storeAtomCoords;
    }

    @Override
    public void action(TCanvasMolecule aMol) {
        boolean leaveFirstAtom = !aMol.atom(this.fAtom1).isCarbon() && aMol.atom(this.fAtom2).isCarbon();
        QPoint<Double> pos = this.fPos;
        QPoint<Double> res = new QPoint<Double>(aMol.x() - aMol.canvasDx(), aMol.y() - aMol.canvasDy());
        pos.setX(pos.x() - res.x());
        pos.setY(pos.y() - res.y());
        aMol.mergeAtoms(this.fAtom1, this.fAtom2, leaveFirstAtom, pos);
    }

    @Override
    public void undoAction(TCanvasMolecule aMol) {
        aMol.setAtomCoords(this.fStoreAtomCoords);
    }
}

