/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor.command;

import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TEditorMode;
import com.mestrelab.components.client.moleditor.command.TCanvasItemsCommand;
import com.mestrelab.components.shared.TBondStereo;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCmdEditMolecule
extends TCanvasItemsCommand {
    private TMolecule fMol;
    private QVector<QPoint<Double>> fAtomCoords;
    private boolean fWasShared;
    private QList<TCanvasItem> fWholeItemsList;
    private TCanvasMolecule fItem;
    TEditorMode fCurrMode;
    private double fX;
    private double fY;
    private double fDx;
    private double fDy;

    public TCmdEditMolecule(TCmdType aType, QList<TCanvasItem> aList, QList<TCanvasItem> aWholeItemsList, TCanvasMolecule aItem, TEditorMode aCurrMode) {
        super(TCmdEditMolecule.getDescription(aType), aList);
        this.fItem = aItem;
        this.fCurrMode = aCurrMode;
        this.fAtomCoords = aItem.getAtomCoords();
        this.fMol = new TMolecule();
        this.fWasShared = false;
        this.fWholeItemsList = aWholeItemsList;
        this.fX = aItem.x();
        this.fY = aItem.y();
        this.fDx = aItem.canvasDx();
        this.fDy = aItem.canvasDy();
        TMolecule mol = aItem.getMolecule();
    }

    public abstract void action(TCanvasMolecule var1);

    public abstract void undoAction(TCanvasMolecule var1);

    @Override
    public void doCommand(TCanvasItem aItem, int aIndex) {
        TCanvasMolecule mol = (TCanvasMolecule)aItem;
        this.action(mol);
        mol.afterChangingMolecule();
    }

    @Override
    public boolean isCompatible(TCanvasItem aItem) {
        return aItem.equals(this.fItem);
    }

    @Override
    public void undoCommand(TCanvasItem aItem, int aIndex) {
        TCanvasMolecule mol = (TCanvasMolecule)aItem;
        mol.setAtomCoords(this.fAtomCoords);
        mol.setX(this.fX);
        mol.setY(this.fY);
        mol.setCanvasDx(this.fDx);
        mol.setCanvasDy(this.fDy);
        this.undoAction(mol);
        mol.afterChangingMolecule();
    }

    public TBondStereo getBondStereo() {
        TBondStereo stereo = TBondStereo.bsNone;
        if (this.fCurrMode == TEditorMode.em_Up) {
            stereo = TBondStereo.bsUp;
        } else if (this.fCurrMode == TEditorMode.em_Down) {
            stereo = TBondStereo.bsDown;
        }
        return stereo;
    }

    public static QString getDescription(TCmdType aType) {
        switch (aType) {
            case ChangeBond: {
                return new QString("Change Bond");
            }
            case Delete: {
                return new QString("Delete");
            }
            case Move: {
                return new QString("Move");
            }
            case Add: {
                return new QString("Add");
            }
            case ChangeAtomLabel: {
                return new QString("Change Atom");
            }
            case EditHydrogens: {
                return new QString("Add/Remove Explicit Hydrogens");
            }
            case NormalizeNumbering: {
                return new QString("Normalize Numbering");
            }
            case FixNumbering: {
                return new QString("Fix Numbering");
            }
        }
        return new QString("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TCmdType {
        ChangeBond,
        Delete,
        Move,
        Add,
        ChangeAtomLabel,
        ChangeBondLabel,
        EditHydrogens,
        NormalizeNumbering,
        FixNumbering;

    }
}

