/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor.command;

import com.mestrelab.components.client.moleditor.IFrameworkServices;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.command.TCanvasItemsCommand;
import com.mestrelab.components.client.moleditor.command.TCmdType;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCmdCreateItem
extends TCanvasItemsCommand {
    private TCmdType fType;
    private boolean fAddChild;
    private boolean fSetAsSelected;
    private IFrameworkServices fFrameworkServices;
    private QList<QtCanvas> fCanvases;
    private QMap<TCanvasItem, QtCanvas> fPageCreators;

    public TCmdCreateItem(TCmdType aType, QList<TCanvasItem> aItemList, IFrameworkServices aFrameworkServices, boolean aAddChild) {
        super(TCmdCreateItem.getDescription(aType), aItemList);
        this.fFrameworkServices = aFrameworkServices;
        this.fType = aType;
        this.fAddChild = aAddChild;
        this.fSetAsSelected = false;
        this.fCanvases = new QList();
        this.fPageCreators = new QMap();
        for (TCanvasItem item : aItemList) {
            if (item != null) {
                this.fCanvases.append(item.setup_canvas() != null ? new QtCanvas(item.setup_canvas().getPainter()) : new QtCanvas(item.canvas().getPainter()));
                continue;
            }
            this.fCanvases.append(new QtCanvas(null));
        }
    }

    public static QString getDescription(TCmdType aType) {
        QString result;
        switch (aType) {
            case CreateItem: {
                result = new QString("Create Item");
                break;
            }
            case DeleteItem: {
                result = new QString("Delete Item");
                break;
            }
            case CutItem: {
                result = new QString("Cut Item");
                break;
            }
            case CopyItem: {
                result = new QString("Copy Item");
                break;
            }
            case PasteItem: {
                result = new QString("Paste Item");
                break;
            }
            case ImportItem: {
                result = new QString("Import Item");
                break;
            }
            default: {
                result = new QString("");
            }
        }
        return result;
    }

    public boolean isCreating() {
        return this.fType == TCmdType.CreateItem || this.fType == TCmdType.PasteItem || this.fType == TCmdType.CopyItem || this.fType == TCmdType.ImportItem;
    }

    @Override
    public void doCmd() {
        super.doCmd();
        if (!this.isCreating()) {
            this.updateCanvases(this.fCanvases);
        }
        if (this.fType == TCmdType.CreateItem && this.fSetAsSelected) {
            this.fFrameworkServices.setSelection(this.items);
        }
    }

    @Override
    public void undoCmd() {
        super.undoCmd();
        if (this.isCreating()) {
            this.updateCanvases(this.fCanvases);
        }
    }

    @Override
    public void doCommand(TCanvasItem aItem, int aIndex) {
        if (this.isCreating()) {
            if (aItem != null) {
                aItem.resetKiller();
            }
            this.setCanvas(aItem, this.fCanvases.at(aIndex));
            if (this.fType == TCmdType.CreateItem && this.fCanvases.at(aIndex) != null && this.fAddChild && this.fCanvases.at(aIndex).addChild(aItem)) {
                // empty if block
            }
        } else {
            this.setCanvas(aItem, null);
            if (aItem != null) {
                aItem.setKiller(this.id());
            }
        }
    }

    @Override
    public void undoCommand(TCanvasItem aItem, int aIndex) {
        if (this.isCreating()) {
            this.setCanvas(aItem, null);
            if (aItem != null) {
                aItem.setKiller(this.id());
            }
        } else {
            if (aItem != null) {
                aItem.resetKiller();
            }
            this.setCanvas(aItem, this.fCanvases.at(aIndex));
        }
    }

    @Override
    public boolean isCompatible(TCanvasItem aItem) {
        return true;
    }

    public void setCanvas(TCanvasItem aItem, QtCanvas aCanvas) {
        if (aItem != null && !aItem.canvas().equals(aCanvas)) {
            if (this.isCreating() && aCanvas != null && aCanvas.addToDocument() && !this.fPageCreators.contains(aItem)) {
                this.fPageCreators.insert(aItem, aCanvas);
            }
            QtCanvas oldCanvas = aItem.canvas();
            aItem.setCanvas(aCanvas);
            if (this.isCreating()) {
                if (aCanvas == null && oldCanvas != null && this.fPageCreators.contains(aItem)) {
                    oldCanvas.deleteFromDocument();
                }
                if (aItem.selected()) {
                    this.fFrameworkServices.setSelection(new QList<TCanvasItem>());
                }
            } else {
                QList<QUuid> linkedItems = aItem.links(new QUuid());
                if (linkedItems.count() != 0) {
                    QList<TCanvasItem> allItems = this.fFrameworkServices.allDocumentItems();
                    for (TCanvasItem lnkItem : allItems) {
                        if (!linkedItems.contains(lnkItem.linkId())) continue;
                        this.fFrameworkServices.updateItem(lnkItem, true);
                    }
                }
            }
            this.fFrameworkServices.updateSelectionEventFilter();
        }
    }

    private void needSetZ(boolean aSetZ, QList<TCanvasItem> items) {
        for (TCanvasItem i : items) {
            i.needSetZ(aSetZ);
        }
    }

    public void setupZ() {
        if (this.fType == TCmdType.DeleteItem) {
            this.needSetZ(false, this.items);
        }
    }

    public void setAsSelected(boolean b) {
        this.fSetAsSelected = b;
    }
}

