/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor.command;

import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TEditorMode;
import com.mestrelab.components.client.moleditor.command.TCmdEditMolecule;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCmdAddAtom
extends TCmdEditMolecule {
    private int fAtom1;
    private QPoint<Double> fPos;
    private boolean fCorrectXY;

    public TCmdAddAtom(QList<TCanvasItem> selectedMolecules, QList<TCanvasItem> allMolecules, TCanvasMolecule hLMol, int atm1, QPoint<Double> newAtomPos, boolean b, TEditorMode mode) {
        super(TCmdEditMolecule.TCmdType.Add, selectedMolecules, allMolecules, hLMol, mode);
        this.fAtom1 = atm1;
        this.fPos = newAtomPos;
        this.fCorrectXY = b;
    }

    @Override
    public void action(TCanvasMolecule aMol) {
        QPoint<Double> pos = this.fPos;
        if (this.fCorrectXY) {
            QPoint<Double> res = new QPoint<Double>(aMol.x() - aMol.canvasDx(), aMol.y() - aMol.canvasDy());
            pos.setX(pos.x() - res.x());
            pos.setY(pos.y() - res.y());
        }
        if (this.fCurrMode != TEditorMode.em_DrawChain) {
            aMol.getMolecule().addNewAtomTo(this.fAtom1, aMol.fSizeToMolecule(true).map(pos), this.getBondStereo());
            aMol.addAtomCoord(pos);
        } else {
            QList<QPoint<Double>> points = aMol.calcChainCoords(aMol.getAtomCoord(this.fAtom1), pos);
            if (points.size() > 0) {
                int prevAtom = this.fAtom1;
                QPoint<Double> coord = aMol.fSizeToMolecule(true).map(pos);
                for (int i = 0; i < points.size(); ++i) {
                    aMol.getMolecule().addNewAtomTo(prevAtom, coord, this.getBondStereo());
                    aMol.addAtomCoord(points.at(i));
                    prevAtom = aMol.getMolecule().atoms().size() - 1;
                }
            }
        }
    }

    @Override
    public void undoAction(TCanvasMolecule aMol) {
    }
}

