/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor.command;

import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.command.TCommand;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QSet;
import com.mestrelab.components.shared.qt.QString;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCanvasItemsCommand
extends TCommand {
    protected QString description;
    protected QList<TCanvasItem> items;

    public TCanvasItemsCommand(QString aDescription, QList<TCanvasItem> aList) {
        this.description = aDescription;
        this.items = aList;
        Collections.sort(this.items.arrayList());
    }

    @Override
    public void doCmd() {
        for (int i = 0; i < this.items.count(); ++i) {
            TCanvasItem item = this.items.at(i);
            if (!this.isCompatible(item)) continue;
            this.doCommand(item, i);
        }
        this.updateCanvases();
    }

    @Override
    public void undoCmd() {
        for (int i = 0; i < this.items.count(); ++i) {
            TCanvasItem item = this.items.at(i);
            if (!this.isCompatible(item)) continue;
            this.undoCommand(item, i);
        }
        this.updateCanvases();
    }

    public abstract void doCommand(TCanvasItem var1, int var2);

    public abstract void undoCommand(TCanvasItem var1, int var2);

    public abstract boolean isCompatible(TCanvasItem var1);

    private QList<QtCanvas> getCanvases(QList<TCanvasItem> items) {
        QList<QtCanvas> result = new QList<QtCanvas>();
        for (TCanvasItem item : items) {
            if (item == null) continue;
            result.append(item.canvas());
        }
        return result;
    }

    public void updateCanvases() {
        this.updateCanvases(this.getCanvases(this.items));
    }

    public void updateCanvases(QList<QtCanvas> aCanvases) {
        QSet<QtCanvas> updated = new QSet<QtCanvas>();
        for (QtCanvas canvas : aCanvases) {
            if (canvas == null || updated.contains(canvas)) continue;
            canvas.update();
            updated.append(canvas);
        }
    }
}

