/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.jsonp.client.JsonpRequestBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.mestrelab.components.client.PanelMolEditor;
import com.mestrelab.components.client.util.Utils_Molfile;
import com.mestrelab.components.shared.event.ModalLeftEvent;
import com.mestrelab.components.shared.qt.QByteArray;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.tools.opsin.IResponseVO;
import com.mestrelab.components.shared.tools.opsin.IResponseVOList;
import com.mestrelab.components.shared.tools.opsin.MyFactoryResponseVO;
import com.mestrelab.components.shared.util.StringHEX;
import com.mestrelab.components.shared.util.UrlServices;

public class WOpsinDialog {
    private PopupPanel dialog = new PopupPanel(false, true);
    private TextBox iupac;
    private Button btnCerrar;
    private Button btnApply;
    private PanelMolEditor molEditor;

    public WOpsinDialog(PanelMolEditor mainWnd) {
        this.molEditor = mainWnd;
        this.dialog.setPopupPosition(mainWnd.getAbsoluteLeft() + 20, mainWnd.getAbsoluteTop() + 20);
        this.dialog.hide();
        this.iupac = new TextBox();
        this.iupac.addStyleName("span2");
        this.initialization();
    }

    public void initialization() {
        if (this.dialog != null) {
            VerticalPanel window = new VerticalPanel();
            window.setSpacing(10);
            this.dialog.add((Widget)window);
            HorizontalPanel hPanel = new HorizontalPanel();
            hPanel.setSpacing(5);
            window.add((Widget)hPanel);
            CaptionPanel tablePanel = new CaptionPanel("IUPAC Service");
            FlexTable table = new FlexTable();
            tablePanel.add((Widget)table);
            table.getCellFormatter().setAlignment(0, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
            table.setHTML(1, 0, "IUPAC Nomenclature: ");
            table.setWidget(1, 1, (Widget)this.iupac);
            hPanel.add((Widget)tablePanel);
            HorizontalPanel buttonsPanel = new HorizontalPanel();
            buttonsPanel.setSpacing(5);
            window.add((Widget)buttonsPanel);
            window.setCellHorizontalAlignment((Widget)buttonsPanel, HorizontalPanel.ALIGN_RIGHT);
            this.btnCerrar = new Button("Close");
            this.btnApply = new Button("Search");
            buttonsPanel.add((Widget)this.btnApply);
            buttonsPanel.add((Widget)this.btnCerrar);
            this.btnCerrar.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    WOpsinDialog.this.dialog.hide();
                    WOpsinDialog.this.molEditor.getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)WOpsinDialog.this.btnCerrar));
                }
            });
            this.btnApply.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    WOpsinDialog.this.saveForm();
                    WOpsinDialog.this.dialog.hide();
                    WOpsinDialog.this.molEditor.getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)WOpsinDialog.this.btnApply));
                }
            });
        }
    }

    void saveForm() {
        JsonpRequestBuilder jsonp = new JsonpRequestBuilder();
        if (this.iupac.getText() != null | this.iupac.getText().equals("")) {
            String name = this.iupac.getText();
            String url = new String(StringHEX.unhexlate(UrlServices.getOpsinService())) + name + "&format=molfile";
            jsonp.requestObject(url, (AsyncCallback)new AsyncCallback<JavaScriptObject>(){

                public void onFailure(Throwable arg0) {
                    Window.alert((String)("Error ocurred" + arg0.getMessage()));
                }

                public void onSuccess(JavaScriptObject results) {
                    String json = new JSONArray(results).toString();
                    WOpsinDialog.this.parseJsonOpsin(json);
                }
            });
        }
    }

    private void parseJsonOpsin(String json) {
        try {
            MyFactoryResponseVO myFactoryRespon = (MyFactoryResponseVO)GWT.create(MyFactoryResponseVO.class);
            AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)myFactoryRespon, IResponseVOList.class, (String)("{\"responseVO\": " + json + "}"));
            IResponseVOList list = (IResponseVOList)bean.as();
            for (IResponseVO response : list.getResponseVO()) {
                if (response.getTypeError() == -1) {
                    Window.alert((String)response.getMessage());
                    continue;
                }
                QByteArray<QString> aMolContent = new QByteArray<QString>();
                aMolContent.append(new QString(response.getMessage()));
                this.molEditor.setMolfile(Utils_Molfile.read(aMolContent, false));
            }
        }
        catch (Exception e) {
            Window.alert((String)e.getMessage());
        }
    }

    public void exec() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    public PopupPanel getDialog() {
        return this.dialog;
    }
}

