/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.IFrameworkServices;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TCanvasMoleculeSettings;
import com.mestrelab.components.client.moleditor.TMoleculePluginGui;
import com.mestrelab.components.client.moleditor.WPropertiesWidget;
import com.mestrelab.components.client.moleditor.command.TCmdMoleculeProperties;
import com.mestrelab.components.client.widget.CheckBox;
import com.mestrelab.components.client.widget.ListBoxColor;
import com.mestrelab.components.shared.event.DefaultSettingsEvent;
import com.mestrelab.components.shared.event.ModalLeftEvent;
import com.mestrelab.components.shared.event.RestoreSettingsEvent;

public class WMoleculePropertiesWidget
extends WPropertiesWidget {
    private TCanvasMolecule molecule = null;
    private TMoleculePluginGui moleculePluginGui = null;
    private PopupPanel dialog;
    private CheckBox allCarbons;
    private CheckBox terminalsCarbons;
    private CheckBox allOthers;
    private CheckBox showNumber;
    private CheckBox rotate;
    private CheckBox showMoleculeLabel;
    private TextBox formatLabel;
    private TextBox formatLabelMolecule;
    private TextBox fixedLength;
    private TextBox hashSpacing;
    private TextBox boldWidth;
    private TextBox bondSpacing;
    private TextBox marginWidth;
    private TextBox lineWidth;
    private TextBox fontSizeLabel;
    private TextBox fontSizeAtom;
    private TextBox fontSizeMoleculeLabel;
    private ListBoxColor colorLabel;
    private ListBoxColor colorBond;
    private ListBoxColor colorAtom;
    private ListBoxColor colorLabelMolecule;
    private TCanvasMoleculeSettings newSettings;
    protected IFrameworkServices fFramework;

    public WMoleculePropertiesWidget(TMoleculePluginGui tMoleculePluginGui) {
        this.moleculePluginGui = tMoleculePluginGui;
        this.molecule = tMoleculePluginGui.activeMolecule();
        this.newSettings = new TCanvasMoleculeSettings(this.molecule.getSettings());
        this.dialog = new PopupPanel(false, true);
        this.dialog.setPopupPosition(tMoleculePluginGui.getfFramework().mainWnd().getAbsoluteLeft(), tMoleculePluginGui.getfFramework().mainWnd().getAbsoluteTop());
        this.dialog.hide();
        this.allCarbons = new CheckBox("All");
        this.terminalsCarbons = new CheckBox("Terminals");
        this.allOthers = new CheckBox("All");
        this.formatLabel = new TextBox();
        this.formatLabel.addStyleName("span2");
        this.formatLabelMolecule = new TextBox();
        this.formatLabelMolecule.addStyleName("span2");
        this.colorLabel = new ListBoxColor();
        this.colorLabel.addStyleName("span2");
        this.colorLabelMolecule = new ListBoxColor();
        this.colorLabelMolecule.addStyleName("span2");
        this.showNumber = new CheckBox("Show Label");
        this.showMoleculeLabel = new CheckBox("Show Label");
        this.rotate = new CheckBox("Rotate with Molecule");
        this.rotate.setVisible(false);
        this.colorBond = new ListBoxColor();
        this.colorBond.addStyleName("span2");
        this.colorAtom = new ListBoxColor();
        this.colorAtom.addStyleName("span2");
        this.fixedLength = new TextBox();
        this.fixedLength.addStyleName("span2");
        this.hashSpacing = new TextBox();
        this.hashSpacing.addStyleName("span2");
        this.boldWidth = new TextBox();
        this.boldWidth.addStyleName("span2");
        this.bondSpacing = new TextBox();
        this.bondSpacing.addStyleName("span2");
        this.marginWidth = new TextBox();
        this.marginWidth.addStyleName("span2");
        this.lineWidth = new TextBox();
        this.lineWidth.addStyleName("span2");
        this.fontSizeAtom = new TextBox();
        this.fontSizeAtom.addStyleName("span2");
        this.fontSizeLabel = new TextBox();
        this.fontSizeLabel.addStyleName("span2");
        this.fontSizeMoleculeLabel = new TextBox();
        this.fontSizeMoleculeLabel.addStyleName("span2");
        this.fFramework = tMoleculePluginGui.getfFramework();
        this.initialization();
    }

    public void initialization() {
        if (this.dialog != null) {
            VerticalPanel window = new VerticalPanel();
            window.setSpacing(10);
            this.dialog.add((Widget)window);
            this.fillData((Panel)window);
            HorizontalPanel buttonsGrid = new HorizontalPanel();
            window.add((Widget)buttonsGrid);
            HorizontalPanel buttonDefaultPanel = new HorizontalPanel();
            buttonDefaultPanel.setSpacing(5);
            buttonsGrid.add((Widget)buttonDefaultPanel);
            buttonDefaultPanel.setCellHorizontalAlignment((Widget)buttonDefaultPanel, HorizontalPanel.ALIGN_LEFT);
            final Button defaultSet = new Button("Set Default");
            final Button restore = new Button("Restore");
            buttonDefaultPanel.add((Widget)defaultSet);
            buttonDefaultPanel.add((Widget)restore);
            buttonDefaultPanel.setVisible(this.newSettings.fStoreSettings);
            HorizontalPanel buttonPanel = new HorizontalPanel();
            buttonPanel.setSpacing(5);
            buttonsGrid.add((Widget)buttonPanel);
            buttonPanel.setCellHorizontalAlignment((Widget)buttonPanel, HorizontalPanel.ALIGN_RIGHT);
            final Button close = new Button("Close");
            final Button apply = new Button("Apply");
            buttonPanel.add((Widget)apply);
            buttonPanel.add((Widget)close);
            buttonsGrid.setCellHorizontalAlignment((Widget)buttonDefaultPanel, HorizontalPanel.ALIGN_LEFT);
            buttonsGrid.setCellHorizontalAlignment((Widget)buttonPanel, HorizontalPanel.ALIGN_RIGHT);
            buttonsGrid.setWidth("100%");
            close.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WMoleculePropertiesWidget.this.dialog.hide();
                    WMoleculePropertiesWidget.this.moleculePluginGui.getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)close));
                }
            });
            apply.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WMoleculePropertiesWidget.this.saveForm();
                    TCmdMoleculeProperties cmd = new TCmdMoleculeProperties(WMoleculePropertiesWidget.this.getMolecule(), WMoleculePropertiesWidget.this.newSettings);
                    WMoleculePropertiesWidget.this.fFramework.doCommand(cmd);
                    WMoleculePropertiesWidget.this.dialog.hide();
                    WMoleculePropertiesWidget.this.moleculePluginGui.getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)apply));
                }
            });
            defaultSet.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WMoleculePropertiesWidget.this.saveForm();
                    TCmdMoleculeProperties cmd = new TCmdMoleculeProperties(WMoleculePropertiesWidget.this.getMolecule(), WMoleculePropertiesWidget.this.newSettings);
                    WMoleculePropertiesWidget.this.fFramework.doCommand(cmd);
                    WMoleculePropertiesWidget.this.dialog.hide();
                    WMoleculePropertiesWidget.this.moleculePluginGui.getEventBus().fireEvent((GwtEvent)new DefaultSettingsEvent((Widget)defaultSet, WMoleculePropertiesWidget.this.newSettings.toJson()));
                    WMoleculePropertiesWidget.this.moleculePluginGui.getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)defaultSet));
                }
            });
            restore.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WMoleculePropertiesWidget.this.dialog.hide();
                    WMoleculePropertiesWidget.this.moleculePluginGui.getEventBus().fireEvent((GwtEvent)new RestoreSettingsEvent((Widget)restore));
                    WMoleculePropertiesWidget.this.moleculePluginGui.getEventBus().fireEvent((GwtEvent)new ModalLeftEvent((Widget)restore));
                }
            });
        }
    }

    void fillData(Panel window) {
        CaptionPanel atoms = new CaptionPanel("Atoms");
        NumberFormat formatted = NumberFormat.getFormat((String)"0.00");
        CaptionPanel bonds = new CaptionPanel("Bonds");
        VerticalPanel bondContainer = new VerticalPanel();
        bonds.add((Widget)bondContainer);
        CaptionPanel molecule = new CaptionPanel("Molecule");
        HorizontalPanel moleculeContainer = new HorizontalPanel();
        HorizontalPanel moleculeSettingPanel = new HorizontalPanel();
        VerticalPanel moleculeSettingPanelInternal = new VerticalPanel();
        moleculeSettingPanel.add((Widget)moleculeSettingPanelInternal);
        HorizontalPanel scaleSettingPanel = new HorizontalPanel();
        VerticalPanel scaleSettingPanelInternal = new VerticalPanel();
        scaleSettingPanel.add((Widget)scaleSettingPanelInternal);
        VerticalPanel atomsContainerExternal = new VerticalPanel();
        HorizontalPanel atomsContainer = new HorizontalPanel();
        atomsContainerExternal.add((Widget)atomsContainer);
        CaptionPanel atoms_Symbols = new CaptionPanel("Symbols");
        VerticalPanel atomSymbolContainer = new VerticalPanel();
        atoms_Symbols.add((Widget)atomSymbolContainer);
        CaptionPanel atoms_Label = new CaptionPanel("Label");
        VerticalPanel atomLabelContainer = new VerticalPanel();
        atoms_Label.add((Widget)atomLabelContainer);
        moleculeContainer.add((Widget)moleculeSettingPanel);
        moleculeContainer.add((Widget)scaleSettingPanel);
        molecule.add((Widget)moleculeContainer);
        atomsContainer.add((Widget)atoms_Symbols);
        atomsContainer.add((Widget)atoms_Label);
        atoms.add((Widget)atomsContainerExternal);
        TabPanel tabs = new TabPanel();
        tabs.add((Widget)atoms, "Atoms");
        tabs.add((Widget)bonds, "Bonds");
        tabs.add((Widget)molecule, "Molecule");
        tabs.selectTab(0);
        window.add((Widget)tabs);
        HorizontalPanel line = new HorizontalPanel();
        line.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        Label label = new Label("Show Carbons:");
        label.setWidth("100px");
        this.allCarbons.setValue(this.molecule.getSettings().fShowAllC);
        line.add((Widget)label);
        line.add((Widget)this.allCarbons);
        atomSymbolContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("");
        line.add((Widget)label);
        label.setWidth("100px");
        this.terminalsCarbons.setValue(this.molecule.getSettings().fShowTermC);
        line.add((Widget)this.terminalsCarbons);
        atomSymbolContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Show Others:");
        label.setWidth("100px");
        this.allOthers.setValue(this.molecule.getSettings().fShowOthers);
        line.add((Widget)label);
        line.add((Widget)this.allOthers);
        atomSymbolContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Color:");
        label.setWidth("100px");
        this.colorAtom.select(this.molecule.getSettings().fAtomFontColor.getHexValue());
        line.add((Widget)label);
        line.add((Widget)this.colorAtom);
        atomSymbolContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Font size:");
        label.setWidth("100px");
        this.fontSizeAtom.setValue((Object)String.valueOf(this.molecule.getSettings().fAtomFont.getPointSize()));
        line.add((Widget)label);
        line.add((Widget)this.fontSizeAtom);
        atomSymbolContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        this.showNumber.setValue(this.molecule.getSettings().fShowNumbers);
        line.add((Widget)this.showNumber);
        atomLabelContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Format:");
        label.setWidth("100px");
        this.formatLabel.setValue((Object)this.molecule.getSettings().fLabelMacro.toString());
        line.add((Widget)label);
        line.add((Widget)this.formatLabel);
        atomLabelContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Color:");
        label.setWidth("100px");
        this.colorLabel.select(this.molecule.getSettings().fNumberFontColor.getHexValue());
        line.add((Widget)label);
        line.add((Widget)this.colorLabel);
        atomLabelContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Font size:");
        label.setWidth("100px");
        this.fontSizeLabel.setValue((Object)String.valueOf(this.molecule.getSettings().fNumberFont.getPointSize()));
        line.add((Widget)label);
        line.add((Widget)this.fontSizeLabel);
        atomLabelContainer.add((Widget)line);
        this.rotate.setValue(this.molecule.getSettings().fRotateTextWithMol);
        atomsContainerExternal.add((Widget)this.rotate);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        line.setSpacing(5);
        label = new Label("Color:");
        label.setWidth("100px");
        this.colorBond.select(this.molecule.getSettings().fBondPen.brush().getHexValue());
        line.add((Widget)label);
        line.add((Widget)this.colorBond);
        bondContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        line.setSpacing(5);
        label = new Label("Fixed Length:");
        label.setWidth("100px");
        this.fixedLength.setValue((Object)formatted.format(this.molecule.getSettings().fAverageBondSize));
        line.add((Widget)label);
        line.add((Widget)this.fixedLength);
        label = new Label("Hash Spacing:");
        label.setWidth("100px");
        this.hashSpacing.setValue((Object)formatted.format(this.molecule.getSettings().fHashSpacing));
        line.add((Widget)label);
        line.add((Widget)this.hashSpacing);
        bondContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        line.setSpacing(5);
        label = new Label("Bold Width:");
        label.setWidth("100px");
        this.boldWidth.setValue((Object)formatted.format(this.molecule.getSettings().fBoldWidth));
        line.add((Widget)label);
        line.add((Widget)this.boldWidth);
        label = new Label("Bond Spacing:");
        label.setWidth("100px");
        this.bondSpacing.setValue((Object)formatted.format(this.molecule.getSettings().fBondSpacing));
        line.add((Widget)label);
        line.add((Widget)this.bondSpacing);
        bondContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        line.setSpacing(5);
        label = new Label("Margin Width:");
        label.setWidth("100px");
        this.marginWidth.setValue((Object)formatted.format(this.molecule.getSettings().fMarginWidth));
        line.add((Widget)label);
        line.add((Widget)this.marginWidth);
        label = new Label("Line Width:");
        label.setWidth("100px");
        this.lineWidth.setValue((Object)formatted.format(this.molecule.getSettings().fBondPen.getWidth()));
        line.add((Widget)label);
        line.add((Widget)this.lineWidth);
        bondContainer.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        this.showMoleculeLabel.setValue(this.molecule.getSettings().fShowMoleculeLabel);
        line.add((Widget)this.showMoleculeLabel);
        moleculeSettingPanelInternal.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Format:");
        label.setWidth("100px");
        this.formatLabelMolecule.setValue((Object)this.molecule.getSettings().fMoleculeLabelMacro.toString());
        line.add((Widget)label);
        line.add((Widget)this.formatLabelMolecule);
        moleculeSettingPanelInternal.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Color:");
        label.setWidth("100px");
        this.colorLabelMolecule.select(this.molecule.getSettings().fMoleculeLabelFontColor.getHexValue());
        line.add((Widget)label);
        line.add((Widget)this.colorLabelMolecule);
        moleculeSettingPanelInternal.add((Widget)line);
        line = new HorizontalPanel();
        line.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        label = new Label("Font Size:");
        label.setWidth("100px");
        this.fontSizeMoleculeLabel.setValue((Object)String.valueOf(this.molecule.getSettings().fMoleculeLabelFont.getPointSize()));
        line.add((Widget)label);
        line.add((Widget)this.fontSizeMoleculeLabel);
        moleculeSettingPanelInternal.add((Widget)line);
        HorizontalPanel horPanel = new HorizontalPanel();
        horPanel.setVerticalAlignment(VerticalPanel.ALIGN_MIDDLE);
        Label labelFactor = new Label("Scale Factor:");
        Label valueFactor = new Label();
        horPanel.add((Widget)labelFactor);
        horPanel.add((Widget)valueFactor);
        if (this.molecule != null) {
            valueFactor.setText(formatted.format(this.molecule.fScaleFactor));
        }
        scaleSettingPanelInternal.add((Widget)horPanel);
    }

    void saveForm() {
        NumberFormat formatted = NumberFormat.getFormat((String)"0.00");
        this.newSettings.fShowAllC = this.allCarbons.getValue();
        this.newSettings.fShowTermC = this.terminalsCarbons.getValue();
        this.newSettings.fShowOthers = this.allOthers.getValue();
        this.newSettings.fLabelMacro.clear();
        if (!this.formatLabel.getValue().isEmpty()) {
            this.newSettings.fLabelMacro.append(this.formatLabel.getValue().trim());
        }
        if (!this.colorLabel.getValue(this.colorLabel.getSelectedIndex()).isEmpty()) {
            this.newSettings.fNumberFontColor.setColor(CssColor.make((String)this.colorLabel.getValue(this.colorLabel.getSelectedIndex())).toString());
        }
        this.newSettings.fShowNumbers = this.showNumber.getValue();
        this.newSettings.fRotateTextWithMol = this.rotate.getValue();
        if (!this.colorAtom.getValue(this.colorAtom.getSelectedIndex()).isEmpty()) {
            this.newSettings.fAtomFontColor.setColor(CssColor.make((String)this.colorAtom.getValue(this.colorAtom.getSelectedIndex())).toString());
        }
        if (!this.fontSizeAtom.getValue().isEmpty()) {
            this.newSettings.fAtomFont.setPointSizeF(formatted.parse(this.fontSizeAtom.getValue()));
        }
        if (!this.fontSizeLabel.getValue().isEmpty()) {
            this.newSettings.fNumberFont.setPointSizeF(formatted.parse(this.fontSizeLabel.getValue()));
        }
        if (!this.colorBond.getValue(this.colorBond.getSelectedIndex()).isEmpty()) {
            this.newSettings.fBondPen.brush().setColor(CssColor.make((String)this.colorBond.getValue(this.colorBond.getSelectedIndex())).toString());
        }
        if (!this.fixedLength.getValue().isEmpty()) {
            this.newSettings.fAverageBondSize = formatted.parse(this.fixedLength.getValue());
        }
        if (!this.hashSpacing.getValue().isEmpty()) {
            this.newSettings.fHashSpacing = formatted.parse(this.hashSpacing.getValue());
        }
        if (!this.boldWidth.getValue().isEmpty()) {
            this.newSettings.fBoldWidth = formatted.parse(this.boldWidth.getValue());
        }
        if (!this.bondSpacing.getValue().isEmpty()) {
            this.newSettings.fBondSpacing = formatted.parse(this.bondSpacing.getValue());
        }
        if (!this.marginWidth.getValue().isEmpty()) {
            this.newSettings.fMarginWidth = formatted.parse(this.marginWidth.getValue());
        }
        if (!this.lineWidth.getValue().isEmpty()) {
            this.newSettings.fBondPen.setWidth(formatted.parse(this.lineWidth.getValue()));
        }
        this.newSettings.fMoleculeLabelMacro.clear();
        if (!this.formatLabelMolecule.getValue().isEmpty()) {
            this.newSettings.fMoleculeLabelMacro.append(this.formatLabelMolecule.getValue().trim());
        }
        if (!this.colorLabelMolecule.getValue(this.colorLabelMolecule.getSelectedIndex()).isEmpty()) {
            this.newSettings.fMoleculeLabelFontColor.setColor(CssColor.make((String)this.colorLabelMolecule.getValue(this.colorLabelMolecule.getSelectedIndex())).toString());
        }
        if (!this.fontSizeMoleculeLabel.getValue().isEmpty()) {
            this.newSettings.fMoleculeLabelFont.setPointSizeF(formatted.parse(this.fontSizeMoleculeLabel.getValue()));
        }
        this.newSettings.fShowMoleculeLabel = this.showMoleculeLabel.getValue();
    }

    public void exec() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    public TCanvasMolecule getMolecule() {
        return this.molecule;
    }

    public PopupPanel getDialog() {
        return this.dialog;
    }
}

