/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.WPropertiesWidget;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TBondData;
import com.mestrelab.components.shared.event.ModalLeftEvent;
import com.mestrelab.components.shared.qt.QString;

public class WBondDataDialog
extends WPropertiesWidget {
    private PopupPanel dialog = new PopupPanel(false, true);
    private TCanvasMolecule fMolecule;
    private int bondIndex = -1;
    private TextBox additionalLabel;
    private HandlerManager eventBus;

    public WBondDataDialog(TCanvasMolecule aCanvasMolecule, int aBondIndex, Widget mainWnd) {
        this.dialog.setPopupPosition(mainWnd.getAbsoluteLeft(), mainWnd.getAbsoluteTop());
        this.dialog.hide();
        this.fMolecule = aCanvasMolecule;
        this.bondIndex = aBondIndex;
        this.additionalLabel = new TextBox();
        this.initialization();
    }

    public void initialization() {
        if (this.dialog != null) {
            VerticalPanel window = new VerticalPanel();
            window.setSpacing(10);
            this.dialog.add((Widget)window);
            this.fillData((Panel)window);
            HorizontalPanel buttonPanel = new HorizontalPanel();
            buttonPanel.setSpacing(5);
            window.add((Widget)buttonPanel);
            window.setCellHorizontalAlignment((Widget)buttonPanel, HorizontalPanel.ALIGN_RIGHT);
            final Button close = new Button("Close");
            final Button apply = new Button("Apply");
            buttonPanel.add((Widget)apply);
            buttonPanel.add((Widget)close);
            close.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WBondDataDialog.this.dialog.hide();
                    WBondDataDialog.this.eventBus.fireEvent((GwtEvent)new ModalLeftEvent((Widget)close));
                }
            });
            apply.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WBondDataDialog.this.saveForm();
                    WBondDataDialog.this.getMolecule().afterChangingMolecule();
                    WBondDataDialog.this.dialog.hide();
                    WBondDataDialog.this.eventBus.fireEvent((GwtEvent)new ModalLeftEvent((Widget)apply));
                }
            });
        }
    }

    Widget fillData(Panel window) {
        CaptionPanel tablePanel = new CaptionPanel("Properties");
        FlexTable table = new FlexTable();
        tablePanel.add((Widget)table);
        TBond bond = this.fMolecule.bond(this.bondIndex);
        TBondData bondData = bond.getTbondData();
        table.setHTML(0, 0, "<strong>Property</strong>");
        table.setHTML(0, 1, "<strong>Value</strong>");
        table.getCellFormatter().setAlignment(0, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        table.setText(1, 0, TBondData.cBondLabel.toString());
        QString labelAdditionName = bondData.stereoNotation();
        if (labelAdditionName != null) {
            this.additionalLabel.setValue((Object)labelAdditionName.toString());
        }
        table.setWidget(1, 1, (Widget)this.additionalLabel);
        table.getCellFormatter().setAlignment(9, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        window.add((Widget)tablePanel);
        return tablePanel;
    }

    void saveForm() {
        TBond bond = this.fMolecule.bond(this.bondIndex);
        TBondData bondData = bond.getTbondData();
        bondData.setStereoNotation(new QString("").append(this.additionalLabel.getValue()));
    }

    public void exec() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    public TCanvasMolecule getMolecule() {
        return this.fMolecule;
    }

    public void setEventBus(HandlerManager eventBusP) {
        this.eventBus = eventBusP;
    }

    public PopupPanel getDialog() {
        return this.dialog;
    }
}

