/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.WPropertiesWidget;
import com.mestrelab.components.client.widget.ListBoxColor;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TAtomData;
import com.mestrelab.components.shared.TAtomLabelInfo;
import com.mestrelab.components.shared.event.ModalLeftEvent;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QVariant;

public class WAtomDataDialog
extends WPropertiesWidget {
    private PopupPanel dialog = new PopupPanel(false, true);
    private TCanvasMolecule molecule;
    private int atomIndex = -1;
    private TextBox macro;
    private TextBox annotation;
    private ListBoxColor color;
    private ListBoxColor highlightcolor;
    private TextBox labelTextbox;
    private TextBox charge;
    private TextBox isotope;
    private TextBox additionalLabel;
    private HandlerManager eventBus;

    public WAtomDataDialog(TCanvasMolecule aCanvasMolecule, int aAtomIndex, Widget mainWnd) {
        this.dialog.setPopupPosition(mainWnd.getAbsoluteLeft(), mainWnd.getAbsoluteTop());
        this.dialog.hide();
        this.molecule = aCanvasMolecule;
        this.atomIndex = aAtomIndex;
        this.macro = new TextBox();
        this.macro.addStyleName("span2");
        this.annotation = new TextBox();
        this.annotation.addStyleName("span2");
        this.color = new ListBoxColor();
        this.color.addStyleName("span2");
        this.highlightcolor = new ListBoxColor();
        this.highlightcolor.addStyleName("span2");
        this.labelTextbox = new TextBox();
        this.charge = new TextBox();
        this.isotope = new TextBox();
        this.additionalLabel = new TextBox();
        this.initialization();
    }

    public void initialization() {
        if (this.dialog != null) {
            VerticalPanel window = new VerticalPanel();
            window.setSpacing(10);
            this.dialog.add((Widget)window);
            HorizontalPanel horPanel = new HorizontalPanel();
            Label labelSymbol = new Label("Symbol:");
            Label valueSymbol = new Label();
            horPanel.add((Widget)labelSymbol);
            horPanel.add((Widget)valueSymbol);
            window.add((Widget)horPanel);
            if (this.molecule != null && this.atomIndex != -1) {
                valueSymbol.setText(this.molecule.atom(this.atomIndex).elementSymbol().toString());
            }
            horPanel = new HorizontalPanel();
            Label labelAtomIndex = new Label("Atom Index:");
            Label valueAtomIndex = new Label();
            horPanel.add((Widget)labelAtomIndex);
            horPanel.add((Widget)valueAtomIndex);
            window.add((Widget)horPanel);
            if (this.molecule != null && this.atomIndex != -1) {
                valueAtomIndex.setText(String.valueOf(this.atomIndex + 1));
            }
            this.fillData((Panel)window);
            HorizontalPanel buttonPanel = new HorizontalPanel();
            buttonPanel.setSpacing(5);
            window.add((Widget)buttonPanel);
            window.setCellHorizontalAlignment((Widget)buttonPanel, HorizontalPanel.ALIGN_RIGHT);
            final Button close = new Button("Close");
            final Button apply = new Button("Apply");
            buttonPanel.add((Widget)apply);
            buttonPanel.add((Widget)close);
            close.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WAtomDataDialog.this.dialog.hide();
                    WAtomDataDialog.this.eventBus.fireEvent((GwtEvent)new ModalLeftEvent((Widget)close));
                }
            });
            apply.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WAtomDataDialog.this.saveForm();
                    WAtomDataDialog.this.getMolecule().afterChangingMolecule();
                    WAtomDataDialog.this.dialog.hide();
                    WAtomDataDialog.this.eventBus.fireEvent((GwtEvent)new ModalLeftEvent((Widget)apply));
                }
            });
        }
    }

    Widget fillData(Panel window) {
        QString labelName;
        QString labelAdditionName;
        String labelCharge;
        String labelIsotope;
        CaptionPanel tablePanel = new CaptionPanel("Properties");
        FlexTable table = new FlexTable();
        tablePanel.add((Widget)table);
        TAtom atom = this.molecule.atom(this.atomIndex);
        TAtomData atomData = atom.getTatomData();
        table.setHTML(0, 0, "<strong>Property</strong>");
        table.setHTML(0, 1, "<strong>Value</strong>");
        table.getCellFormatter().setAlignment(0, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        table.setText(1, 0, TAtomData.cNumber.toString());
        table.setText(2, 0, TAtomData.cLabelMacro.toString());
        table.setText(3, 0, TAtomData.cAnnotations.toString());
        table.setText(4, 0, TAtomData.cColor.toString());
        table.setText(5, 0, TAtomData.cHighlightColor.toString());
        table.setText(6, 0, TAtomData.cAtomLabel.toString());
        table.setText(7, 0, TAtomData.cAtomCharge.toString());
        table.setText(8, 0, TAtomData.cAtomIsotope.toString());
        table.setText(9, 0, TAtomData.cAtomAdditionalLabel.toString());
        table.setText(1, 1, ((QVariant)atomData.value(TAtomData.cNumber, new QString(""))).toString());
        table.getCellFormatter().setAlignment(1, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        QString label = atomData.labelMacro();
        if (label.isEmpty()) {
            label.append(this.molecule.getSettings().fLabelMacro);
        }
        this.macro.setValue((Object)label.toString());
        table.setWidget(2, 1, (Widget)this.macro);
        this.annotation.setValue((Object)atomData.annotation().toString());
        if (atomData.color() != null) {
            this.color.select(atomData.color().getHexValue());
        }
        if (atomData.highlightColor() != null) {
            this.highlightcolor.select(atomData.highlightColor().getHexValue());
        }
        if (!(labelIsotope = String.valueOf(atom.getfIsotope())).isEmpty()) {
            this.isotope.setValue((Object)labelIsotope);
        }
        if (!(labelCharge = String.valueOf(atom.getfCharge())).isEmpty()) {
            this.charge.setValue((Object)labelCharge);
        }
        if ((labelAdditionName = atomData.stereoNotation()) != null) {
            this.additionalLabel.setValue((Object)labelAdditionName.toString());
        }
        if ((labelName = atom.elementSymbol()) != null) {
            this.labelTextbox.setValue((Object)labelName.toString());
        }
        table.setWidget(3, 1, (Widget)this.annotation);
        table.setWidget(4, 1, (Widget)this.color);
        table.setWidget(5, 1, (Widget)this.highlightcolor);
        table.setWidget(6, 1, (Widget)this.labelTextbox);
        table.getCellFormatter().setAlignment(6, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        table.setWidget(7, 1, (Widget)this.charge);
        table.getCellFormatter().setAlignment(7, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        table.setWidget(8, 1, (Widget)this.isotope);
        table.getCellFormatter().setAlignment(8, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        table.setWidget(9, 1, (Widget)this.additionalLabel);
        table.getCellFormatter().setAlignment(9, 1, HorizontalPanel.ALIGN_CENTER, VerticalPanel.ALIGN_MIDDLE);
        window.add((Widget)tablePanel);
        return tablePanel;
    }

    void saveForm() {
        TAtom atom = this.molecule.atom(this.atomIndex);
        TAtomData atomData = atom.getTatomData();
        atomData.setAnnotation(new QString("").append(this.annotation.getValue()));
        atomData.setLabelMatcro(new QString("").append(this.macro.getValue()));
        atomData.setColor(new QColor(CssColor.make((String)this.color.getValue(this.color.getSelectedIndex())).toString()));
        atomData.setHighlightColor(new QColor(CssColor.make((String)this.highlightcolor.getValue(this.highlightcolor.getSelectedIndex())).toString()));
        int valueIsotope = -1;
        int valueCharge = -10;
        try {
            valueIsotope = Integer.valueOf(this.isotope.getValue());
        }
        catch (Exception e) {
            valueIsotope = -1;
        }
        try {
            valueCharge = Integer.valueOf(this.charge.getValue());
        }
        catch (Exception e) {
            valueCharge = -10;
        }
        if (-8 <= valueCharge && valueCharge <= 8) {
            atom.setfCharge(valueCharge);
        } else {
            atom.setfCharge(0);
        }
        if (TAtom.isValidIsotope(atom.getfElement(), valueIsotope)) {
            atom.setfIsotope(valueIsotope);
        } else {
            atom.setfIsotope(0);
        }
        QString label = new QString("").append(this.labelTextbox.getValue().equals("") ? "C" : this.labelTextbox.getValue());
        atomData.setStereoNotation(new QString("").append(this.additionalLabel.getValue()));
        this.molecule.changeAtomLabel(new TAtomLabelInfo(this.atomIndex, label, atom.getfCharge(), atom.getTatomData().number(), atom.getfIsotope(), atom.stereoNotation()));
    }

    public void exec() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    public TCanvasMolecule getMolecule() {
        return this.molecule;
    }

    public void setEventBus(HandlerManager eventBusP) {
        this.eventBus = eventBusP;
    }

    public PopupPanel getDialog() {
        return this.dialog;
    }
}

