/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.QPen;
import com.mestrelab.components.client.moleditor.Qt;
import com.mestrelab.components.client.moleditor.TCanvasCompound;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TMoleculePluginGui;
import com.mestrelab.components.client.moleditor.TMoleculeSelectionHelper;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.event.AtomEnteredEvent;
import com.mestrelab.components.shared.event.AtomLeftEvent;
import com.mestrelab.components.shared.event.AtomSelectionChangedEvent;
import com.mestrelab.components.shared.event.BondEnteredEvent;
import com.mestrelab.components.shared.event.BondLeftEvent;
import com.mestrelab.components.shared.event.CompoundEnteredEvent;
import com.mestrelab.components.shared.event.CompoundLeftEvent;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QLineF;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMatrix;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.UtilGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMoleculeTrackingHandler {
    public static int cNoIndex = -1;
    private TCanvasItem fHLMol;
    private int fHLAtom;
    private int fHLBond;
    private QRectF fHLAtomRect;
    private QPolygonF fHLBondPoly;
    public QRectF fOldHLAtomRect;
    public QPolygonF fOldHLBondPoly;
    private QMatrix fRotMatrix;
    private QList<Integer> fSelectedAtoms;
    private QUuid fSelectedDataId;
    private QUuid fSelectedMolId;
    private boolean fDoHighlightBonds;
    private TMoleculeSelectionHelper fSelectionHelper;
    private HandlerManager eventBus;
    private QRectF fHLCompoundRect;
    private QRectF fOldHLCompoundRect;
    private QVector<QPoint<Double>> fLassoPoints;
    private boolean fSelectedCompound;

    public TMoleculeTrackingHandler(TMoleculePluginGui tMoleculePluginGui) {
        this.fHLMol = tMoleculePluginGui.activeMolecule();
        this.eventBus = tMoleculePluginGui.getEventBus();
        this.fHLAtom = cNoIndex;
        this.fHLBond = cNoIndex;
        this.fHLAtomRect = new QRectF();
        this.fHLBondPoly = new QPolygonF();
        this.fOldHLAtomRect = new QRectF();
        this.fOldHLBondPoly = new QPolygonF();
        this.fRotMatrix = new QMatrix();
        this.fSelectionHelper = null;
        this.fDoHighlightBonds = true;
        this.fHLCompoundRect = new QRectF();
        this.fLassoPoints = new QVector();
        this.fSelectedAtoms = new QList();
        this.fOldHLCompoundRect = new QRectF();
    }

    public void setItem(TCanvasItem aCanvasMol) {
        if (aCanvasMol != null && this.fHLMol != null && !this.fHLMol.equals(aCanvasMol)) {
            this.noHL();
        }
        this.fHLMol = aCanvasMol;
        if (this.fHLMol == null) {
            this.clearHLAtom();
            this.clearHLBond();
            this.clearHLCompound();
        } else {
            this.fRotMatrix = this.fHLMol.getRotationMatrix();
        }
    }

    public void drawHLMolecule(QPainter aPainter) {
        if (this.fHLMol == null) {
            return;
        }
        aPainter.save();
        aPainter.setPen(Qt.red.getQColor());
        if (this.fHLMol.rtti() == TRtti.TRtti_Molecule) {
            if (this.fHLAtom > cNoIndex) {
                if (this.isRotatingTextWithMol(this.fHLMol)) {
                    aPainter.save();
                    aPainter.setMatrix(this.fRotMatrix, true);
                    aPainter.drawRect(this.fHLAtomRect.toRect());
                    aPainter.restore();
                } else {
                    aPainter.drawRect(this.fHLAtomRect.toRect());
                }
            } else if (this.fDoHighlightBonds && this.fHLBond > cNoIndex) {
                aPainter.drawPolygon(this.fHLBondPoly.toPolygon());
            }
        }
        aPainter.restore();
    }

    public void selectAtom(int aAtom) {
        if (this.fSelectedCompound) {
            this.fSelectedCompound = false;
            this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, aAtom, false));
        }
        if ((this.fSelectedDataId != this.fHLMol.dataId() || this.fSelectionHelper != null && !this.fSelectionHelper.persistentAtomSelection()) && !this.fSelectedAtoms.isEmpty()) {
            this.fSelectedAtoms.clear();
            this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, -1, false));
        }
        this.fSelectedDataId = this.fHLMol.dataId();
        this.fSelectedAtoms.append(aAtom);
        this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, aAtom, true));
    }

    public void toggleAtomSelection(int aAtom) {
        if (this.fSelectionHelper != null && !this.fSelectionHelper.allowMultipleAtomSelection() || !this.fHLMol.dataId().equals(this.fSelectedDataId)) {
            this.selectAtom(aAtom);
        } else {
            if (this.fSelectionHelper != null && this.fSelectionHelper.allowMultipleAtomSelection() && this.fSelectedAtoms.count() > 0) {
                int firstSelAtom = this.fSelectedAtoms.at(0);
                TAtom firstAtom = ((TCanvasMolecule)this.fHLMol).getMolecule().atom(firstSelAtom);
                if (firstAtom != null && (firstAtom.isCH2() && !((TCanvasMolecule)this.fHLMol).getMolecule().atom(aAtom).isCH2() || firstAtom.isCH3() && !((TCanvasMolecule)this.fHLMol).getMolecule().atom(aAtom).isCH3() || firstAtom.isHydrogen() && !((TCanvasMolecule)this.fHLMol).getMolecule().atom(aAtom).isHydrogen())) {
                    return;
                }
            }
            if (this.fSelectedAtoms.contains(aAtom)) {
                this.fSelectedAtoms.removeAll(aAtom);
                this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, aAtom, false));
                if (this.fSelectedAtoms.isEmpty()) {
                    this.fSelectedDataId = new QUuid();
                }
            } else {
                this.fSelectedAtoms.append(aAtom);
                this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, aAtom, true));
            }
        }
    }

    public void clearSelection() {
        if (this.fSelectedAtoms.count() > 0) {
            this.fSelectedAtoms.clear();
            this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, -1, false));
            this.fSelectedDataId = new QUuid();
        }
        if (this.fSelectedCompound) {
            this.fSelectedCompound = false;
            this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, -1, false));
            this.fSelectedDataId = new QUuid();
        }
    }

    public void setHelper(TMoleculeSelectionHelper aHelper) throws Exception {
        throw new Exception("method not implemented");
    }

    public void selectMolId(QUuid aMolId) {
        if (this.fSelectedMolId != aMolId) {
            this.clearSelection();
            this.fSelectedMolId = aMolId;
        }
    }

    public void drawSelectionAtomRect(TCanvasItem aSelectedMol, QPainter aPainter) {
        if (aSelectedMol != null && aSelectedMol.rtti() != TRtti.TRtti_Molecule) {
            return;
        }
        TCanvasMolecule selectedMol = (TCanvasMolecule)aSelectedMol;
        if (this.fSelectedAtoms.isEmpty() || selectedMol == null) {
            return;
        }
        QColor selColor = Qt.darkRed.getQColor();
        QPen selPen = new QPen();
        selPen.setColor(selColor);
        aPainter.save();
        aPainter.setPen(selPen);
        selColor.setAlphaF(0.4);
        aPainter.setBrush(selColor);
        if (this.isRotatingTextWithMol(selectedMol)) {
            aPainter.setMatrix(selectedMol.getRotationMatrix(), true);
        }
        for (int i = 0; i < this.fSelectedAtoms.size(); ++i) {
            int atomIndex = this.fSelectedAtoms.at(i);
            TAtom atom = selectedMol.getMolecule().atom(atomIndex);
            if (atom == null) continue;
            aPainter.drawRect(selectedMol.calcAtomRectSelection(atomIndex, selectedMol.fSizeToFSize(false).map(selectedMol.getAtomCoord(atomIndex))));
        }
        aPainter.restore();
    }

    public QPolygonF calcHLPolyBond(QLineF aLineBond) {
        if (this.fHLMol == null || this.fHLMol.rtti() != TRtti.TRtti_Molecule) {
            return new QPolygonF();
        }
        TCanvasMolecule hlMol = (TCanvasMolecule)this.fHLMol;
        QLineF shortLine = new QLineF(aLineBond);
        QPolygonF polBond = new QPolygonF();
        double pw = hlMol.atomFont().pointSizeF() / 2;
        double x1 = shortLine.p1().x();
        double x2 = shortLine.p2().x();
        double y1 = shortLine.p1().y();
        double y2 = shortLine.p2().y();
        double angle = Math.atan2(x2 - x1, -(y2 - y1));
        QMatrix rot = UtilGeometry.rotate(new QPoint<Double>(x1, y1), angle);
        polBond.add(new QPoint<Double>(x1 - pw, y1 + pw));
        polBond.add(new QPoint<Double>(x1 + pw, y1 + pw));
        polBond.add(new QPoint<Double>(x1 + pw, y1 - shortLine.length() - pw));
        polBond.add(new QPoint<Double>(x1 - pw, y1 - shortLine.length() - pw));
        polBond = rot.map(polBond);
        return polBond;
    }

    public QRectF enlarge(QRectF aRect, double aMargin) {
        return aRect.adjusted(-aMargin, -aMargin, aMargin, aMargin);
    }

    public QUuid getHLMolId() {
        if ((TCanvasMolecule)this.fHLMol != null && ((TCanvasMolecule)this.fHLMol).getMolecule().atoms().size() == 0) {
            return new QUuid("");
        }
        QUuid molId = this.fHLMol != null ? this.fHLMol.itemId() : new QUuid("");
        return molId;
    }

    public boolean setHLAreas(QPoint<Double> aPos) {
        if (this.fHLMol == null) {
            return false;
        }
        QUuid molId = this.getHLMolId();
        if (this.fHLMol.rtti() != TRtti.TRtti_Molecule) {
            QRectF rect = this.isHLCompoundArea(aPos);
            if (!rect.isEmpty()) {
                if (rect != this.fHLCompoundRect) {
                    this.fHLCompoundRect = rect;
                    this.eventBus.fireEvent((GwtEvent)new CompoundEnteredEvent(molId, -1, this.fHLCompoundRect));
                    this.fOldHLCompoundRect = this.fHLCompoundRect;
                    return true;
                }
                return true;
            }
            this.fHLCompoundRect = new QRectF();
            return false;
        }
        QRectF rect = this.isHLAtomArea(aPos);
        if (!rect.isEmpty()) {
            if (!rect.equals(this.fHLAtomRect)) {
                this.fHLAtomRect = new QRectF(rect);
                if (this.isRotatingTextWithMol(this.fHLMol)) {
                    this.eventBus.fireEvent((GwtEvent)new AtomEnteredEvent(molId, this.fHLAtom, this.fRotMatrix.mapRect(this.fHLAtomRect)));
                } else {
                    this.eventBus.fireEvent((GwtEvent)new AtomEnteredEvent(molId, this.fHLAtom, this.fHLAtomRect));
                }
                this.fOldHLAtomRect = new QRectF(this.fHLAtomRect);
                this.fOldHLBondPoly.clear();
                this.clearHLBond();
                this.eventBus.fireEvent((GwtEvent)new BondLeftEvent(molId, this.fHLBond, this.fOldHLBondPoly));
                return true;
            }
            return true;
        }
        this.fHLAtomRect.setCoords(0.0, 0.0, 0.0, 0.0);
        if (this.fDoHighlightBonds) {
            QPolygonF poly = this.isHLBondArea(aPos);
            if (!poly.isEmpty()) {
                if (!poly.equals(this.fHLBondPoly)) {
                    int i;
                    this.fHLBondPoly = new QPolygonF(poly.count());
                    for (i = 0; i < poly.count(); ++i) {
                        this.fHLBondPoly.set(i, poly.at(i));
                    }
                    this.eventBus.fireEvent((GwtEvent)new BondEnteredEvent(molId, this.fHLBond, this.fHLBondPoly));
                    this.fOldHLBondPoly.clear();
                    for (i = 0; i < this.fHLBondPoly.count(); ++i) {
                        this.fOldHLBondPoly.add(this.fHLBondPoly.at(i));
                    }
                    this.fOldHLAtomRect.setCoords(0.0, 0.0, 0.0, 0.0);
                    this.clearHLAtom();
                    if (this.isRotatingTextWithMol(this.fHLMol)) {
                        this.eventBus.fireEvent((GwtEvent)new AtomLeftEvent(this.getHLMolId(), this.fHLAtom, this.fRotMatrix.mapRect(this.fOldHLAtomRect)));
                    } else {
                        this.eventBus.fireEvent((GwtEvent)new AtomLeftEvent(this.getHLMolId(), this.fHLAtom, this.fOldHLAtomRect));
                    }
                    return true;
                }
                return true;
            }
            this.fHLBondPoly.clear();
        }
        return false;
    }

    public QRectF isHLAtomArea(QPoint<Double> aPos) {
        if (this.fHLMol == null || this.fHLMol.rtti() != TRtti.TRtti_Molecule) {
            return new QRectF();
        }
        TCanvasMolecule hlMol = (TCanvasMolecule)this.fHLMol;
        QPoint<Double> atomPos = new QPoint();
        QRectF atomRect = new QRectF();
        TAtom atom = null;
        for (int ai = 0; ai < hlMol.getMolecule().atoms().count(); ++ai) {
            atom = hlMol.atom(ai);
            if (atom != null && this.fSelectionHelper != null && !this.fSelectionHelper.isValid(atom) || !hlMol.atomRectContains(atomRect = hlMol.calcAtomRectSelection(ai, atomPos = hlMol.fSizeToFSize(false).map(hlMol.getAtomCoord(ai))), aPos)) continue;
            atomRect = this.enlarge(atomRect, hlMol.marginWidth());
            this.fHLAtom = ai;
            return atomRect;
        }
        this.fHLAtom = cNoIndex;
        return new QRectF();
    }

    public QPolygonF isHLBondArea(QPoint<Double> aPos) {
        if (!this.fDoHighlightBonds) {
            this.fHLBond = cNoIndex;
            return new QPolygonF();
        }
        if (this.fHLMol == null || this.fHLMol.rtti() != TRtti.TRtti_Molecule) {
            return new QPolygonF();
        }
        TCanvasMolecule hlMol = (TCanvasMolecule)this.fHLMol;
        QMatrix m = hlMol.fSizeToFSize(true);
        for (int k = 0; k < hlMol.getMolecule().bonds().size(); ++k) {
            QPoint<Double> interPoint;
            TBond myBond = hlMol.bond(k);
            QLineF lineBond = new QLineF(m.map(hlMol.getAtomCoord(myBond.atom1())), m.map(hlMol.getAtomCoord(myBond.atom2())));
            QLineF lineFromMouse = UtilGeometry.normalLineStartingAtPos(lineBond, aPos);
            if (lineFromMouse.intersect(lineBond, interPoint = new QPoint<Double>()) != QLineF.IntersectType.BoundedIntersection || !(lineFromMouse.length() < (double)hlMol.atomFont().pointSizeF())) continue;
            QPolygonF poly = this.calcHLPolyBond(lineBond);
            this.fHLBond = k;
            return poly;
        }
        this.fHLBond = cNoIndex;
        return new QPolygonF();
    }

    public void noHL() {
        if (!this.fOldHLAtomRect.isEmpty()) {
            this.fOldHLAtomRect.setCoords(0.0, 0.0, 0.0, 0.0);
            if (this.fHLMol != null && this.isRotatingTextWithMol(this.fHLMol)) {
                this.eventBus.fireEvent((GwtEvent)new AtomLeftEvent(this.getHLMolId(), this.fHLAtom, this.fRotMatrix.mapRect(this.fOldHLAtomRect)));
            } else {
                this.eventBus.fireEvent((GwtEvent)new AtomLeftEvent(this.getHLMolId(), this.fHLAtom, this.fOldHLAtomRect));
            }
        }
        if (!this.fOldHLBondPoly.isEmpty()) {
            this.fOldHLBondPoly.clear();
            this.eventBus.fireEvent((GwtEvent)new BondLeftEvent(this.getHLMolId(), this.fHLBond, this.fOldHLBondPoly));
        }
        this.fRotMatrix = new QMatrix();
        if (!this.fOldHLCompoundRect.isEmpty()) {
            this.eventBus.fireEvent((GwtEvent)new CompoundLeftEvent(this.getHLMolId(), -1, this.fOldHLCompoundRect));
            this.fOldHLCompoundRect = new QRectF();
        }
    }

    public QRectF calcHLAtomRect(TCanvasItem aMol, int aAtomIndex) {
        if (aMol == null || aMol.rtti() != TRtti.TRtti_Molecule) {
            return new QRectF();
        }
        TCanvasMolecule molItem = (TCanvasMolecule)aMol;
        TAtom atom = molItem.atom(aAtomIndex);
        if (atom == null) {
            return new QRectF();
        }
        QPoint<Double> atomPos = molItem.fSizeToFSize(false).map(molItem.getAtomCoord(aAtomIndex));
        QRectF atomRect = molItem.calcAtomRectSelection(aAtomIndex, atomPos);
        atomRect = this.enlarge(atomRect, molItem.marginWidth());
        return atomRect;
    }

    public QRectF oldHLAtomRect() {
        return this.fRotMatrix.mapRect(this.fOldHLAtomRect);
    }

    public void clearHLAtom() {
        this.fHLAtom = cNoIndex;
        this.fHLAtomRect.setCoords(0.0, 0.0, 0.0, 0.0);
    }

    public void clearHLBond() {
        this.fHLBond = cNoIndex;
        this.fHLBondPoly.clear();
    }

    public QRectF isHLCompoundArea(QPoint<Double> aPos) {
        if (this.fHLMol != null && this.fHLMol.rtti() == TRtti.TRtti_Compound) {
            QPoint<Double> noRotatedPos = this.fHLMol.getRotationMatrix().inverted().map(aPos);
            QRectF bRect = ((TCanvasCompound)this.fHLMol).getHLRect();
            if (bRect.contains(noRotatedPos)) {
                return bRect;
            }
        }
        return new QRectF();
    }

    public boolean isRotatingTextWithMol(TCanvasItem aItem) {
        if (aItem == null) {
            return false;
        }
        if (aItem.rtti() == TRtti.TRtti_Compound) {
            return true;
        }
        return ((TCanvasMolecule)aItem).isRotatingTextWithMol();
    }

    public void drawHLCompound(TCanvasItem item, QPainter aPainter) {
        if (this.fHLMol == null) {
            return;
        }
        if (this.fHLCompoundRect.isEmpty()) {
            return;
        }
        aPainter.save();
        aPainter.setPen(Qt.red.getQColor());
        if (this.fHLMol.rtti() == TRtti.TRtti_Compound) {
            aPainter.setMatrix(item.getRotationMatrix(), true);
            QRectF rect = ((TCanvasCompound)item).getHLRect();
            aPainter.drawRect(rect);
        }
        aPainter.restore();
    }

    public void clearHLCompound() {
        this.fHLCompoundRect = new QRectF();
    }

    public void selectCompound() {
        if (this.fSelectedDataId != this.fHLMol.dataId()) {
            if (this.fSelectedAtoms.count() > 0) {
                this.fSelectedAtoms.clear();
                this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, -1, false));
            }
            this.fSelectedCompound = false;
            this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, -1, false));
        }
        this.fSelectedDataId = this.fHLMol.dataId();
        this.fSelectedCompound = true;
        this.eventBus.fireEvent((GwtEvent)new AtomSelectionChangedEvent(this.fSelectedDataId, 1, false));
    }

    public void drawSelectionCompoundRect(TCanvasItem aSelectedMol, QPainter aPainter) {
        if (aSelectedMol != null && aSelectedMol.rtti() != TRtti.TRtti_Compound) {
            return;
        }
        TCanvasCompound selectedMol = (TCanvasCompound)aSelectedMol;
        if (selectedMol == null) {
            return;
        }
        QColor selColor = Qt.darkRed.getQColor();
        QPen selPen = new QPen();
        selPen.setColor(selColor);
        aPainter.save();
        aPainter.setPen(selPen);
        selColor.setAlphaF(0.4);
        aPainter.setBrush(selColor);
        if (this.isRotatingTextWithMol(selectedMol)) {
            aPainter.setMatrix(selectedMol.getRotationMatrix(), true);
        }
        aPainter.drawRect(selectedMol.getSelectionRect());
        aPainter.restore();
    }

    public QRectF calcHLCompoundRect(TCanvasItem aMol) {
        if (aMol == null || aMol.rtti() != TRtti.TRtti_Compound) {
            return new QRectF();
        }
        return ((TCanvasCompound)aMol).getHLRect();
    }

    public void clearLasso() {
        this.fLassoPoints.clear();
    }

    public void addPointToLasso(QPoint<Double> aPos) {
        this.fLassoPoints.append(new QPoint<Double>(aPos.getXp(), aPos.getYp()));
    }

    public QList<Integer> selectedAtoms() {
        return this.fSelectedAtoms;
    }

    public int HLAtom() {
        return this.fHLAtom;
    }

    public int HLBond() {
        return this.fHLBond;
    }

    public QRectF HLAtomRect() {
        return this.fHLAtomRect;
    }

    public QPolygonF oldHLBondPoly() {
        return this.fOldHLBondPoly;
    }

    public QUuid selectedDataId() {
        return this.fSelectedDataId;
    }

    public QUuid selectedMolId() {
        return this.fSelectedMolId;
    }

    public QPolygonF oldHLCompoundRect() {
        return new QPolygonF(this.fOldHLCompoundRect);
    }

    public QVector<QPoint<Double>> lassoPoints() {
        return this.fLassoPoints;
    }

    public boolean isCompoundSelected() {
        return this.fSelectedCompound;
    }
}

