/*
 * Decompiled with CFR 0.152.
 */
package com.mestrelab.components.client.moleditor;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Widget;
import com.mestrelab.components.client.moleditor.ConstsCommon;
import com.mestrelab.components.client.moleditor.IFrameworkServices;
import com.mestrelab.components.client.moleditor.QEvent;
import com.mestrelab.components.client.moleditor.QHelpEvent;
import com.mestrelab.components.client.moleditor.QIcon;
import com.mestrelab.components.client.moleditor.QKeyEvent;
import com.mestrelab.components.client.moleditor.QMimeData;
import com.mestrelab.components.client.moleditor.QMouseEvent;
import com.mestrelab.components.client.moleditor.QPainter;
import com.mestrelab.components.client.moleditor.QPen;
import com.mestrelab.components.client.moleditor.QWheelEvent;
import com.mestrelab.components.client.moleditor.Qt;
import com.mestrelab.components.client.moleditor.QtBrushStyle;
import com.mestrelab.components.client.moleditor.QtCanvas;
import com.mestrelab.components.client.moleditor.QtPenStyle;
import com.mestrelab.components.client.moleditor.TAtomDataHandler;
import com.mestrelab.components.client.moleditor.TCanvasCompound;
import com.mestrelab.components.client.moleditor.TCanvasItem;
import com.mestrelab.components.client.moleditor.TCanvasMolecule;
import com.mestrelab.components.client.moleditor.TChangeAtomType;
import com.mestrelab.components.client.moleditor.TCommonSettings;
import com.mestrelab.components.client.moleditor.TEditorMode;
import com.mestrelab.components.client.moleditor.TMoleculeHotArea;
import com.mestrelab.components.client.moleditor.TMoleculePlugin;
import com.mestrelab.components.client.moleditor.TMoleculePluginDockWidgetFactory;
import com.mestrelab.components.client.moleditor.TMoleculeSelectionHelper;
import com.mestrelab.components.client.moleditor.TMoleculeTableFactory;
import com.mestrelab.components.client.moleditor.TMoleculeTrackingHandler;
import com.mestrelab.components.client.moleditor.TRtti;
import com.mestrelab.components.client.moleditor.TTemplateType;
import com.mestrelab.components.client.moleditor.TUpdateItem;
import com.mestrelab.components.client.moleditor.Types_Framework_TModeFlag;
import com.mestrelab.components.client.moleditor.WAtomDataDialog;
import com.mestrelab.components.client.moleditor.WBondDataDialog;
import com.mestrelab.components.client.moleditor.WMoleculePropertiesWidget;
import com.mestrelab.components.client.moleditor.WPropertiesWidget;
import com.mestrelab.components.client.moleditor.command.TCmdAddAtom;
import com.mestrelab.components.client.moleditor.command.TCmdAddBond;
import com.mestrelab.components.client.moleditor.command.TCmdAddTemplate;
import com.mestrelab.components.client.moleditor.command.TCmdChangeAtomLabel;
import com.mestrelab.components.client.moleditor.command.TCmdChangeBondType;
import com.mestrelab.components.client.moleditor.command.TCmdCreateItem;
import com.mestrelab.components.client.moleditor.command.TCmdDeleteAtoms;
import com.mestrelab.components.client.moleditor.command.TCmdEditExplicitHydrogens;
import com.mestrelab.components.client.moleditor.command.TCmdEditMolecule;
import com.mestrelab.components.client.moleditor.command.TCmdFixNumbering;
import com.mestrelab.components.client.moleditor.command.TCmdMergeAtoms;
import com.mestrelab.components.client.moleditor.command.TCmdMoveAtoms;
import com.mestrelab.components.client.moleditor.command.TCmdNormalizeNumbering;
import com.mestrelab.components.client.moleditor.command.TCmdType;
import com.mestrelab.components.shared.QT_FillRule;
import com.mestrelab.components.shared.TAtom;
import com.mestrelab.components.shared.TAtomIndex;
import com.mestrelab.components.shared.TAtomLabelInfo;
import com.mestrelab.components.shared.TBond;
import com.mestrelab.components.shared.TElement;
import com.mestrelab.components.shared.TMolecule;
import com.mestrelab.components.shared.TPeriodicTable;
import com.mestrelab.components.shared.event.Atom3DEnteredEvent;
import com.mestrelab.components.shared.event.AtomEnteredEvent;
import com.mestrelab.components.shared.event.AtomLeftEvent;
import com.mestrelab.components.shared.event.AtomSelectionChangedEvent;
import com.mestrelab.components.shared.event.BondEnteredEvent;
import com.mestrelab.components.shared.event.BondLeftEvent;
import com.mestrelab.components.shared.event.CompoundEnteredEvent;
import com.mestrelab.components.shared.event.CompoundLeftEvent;
import com.mestrelab.components.shared.event.ModalEnteredEvent;
import com.mestrelab.components.shared.handler.atom.Atom3DEnteredHandler;
import com.mestrelab.components.shared.handler.atom.AtomEnteredHandler;
import com.mestrelab.components.shared.handler.atom.AtomLeftHandler;
import com.mestrelab.components.shared.handler.atom.AtomSelectionChangedHandler;
import com.mestrelab.components.shared.handler.bond.BondEnteredHandler;
import com.mestrelab.components.shared.handler.bond.BondLeftHandler;
import com.mestrelab.components.shared.qt.QColor;
import com.mestrelab.components.shared.qt.QCursor;
import com.mestrelab.components.shared.qt.QList;
import com.mestrelab.components.shared.qt.QMap;
import com.mestrelab.components.shared.qt.QMatrix;
import com.mestrelab.components.shared.qt.QPixmap;
import com.mestrelab.components.shared.qt.QPoint;
import com.mestrelab.components.shared.qt.QPolygonF;
import com.mestrelab.components.shared.qt.QRectF;
import com.mestrelab.components.shared.qt.QSet;
import com.mestrelab.components.shared.qt.QString;
import com.mestrelab.components.shared.qt.QUuid;
import com.mestrelab.components.shared.qt.QVector;
import com.mestrelab.components.shared.util.SimpleAliasVO;
import com.mestrelab.components.shared.util.TDataStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMoleculePluginGui
extends TMoleculePlugin
implements AtomEnteredHandler,
AtomLeftHandler,
BondEnteredHandler,
BondLeftHandler,
AtomSelectionChangedHandler,
Atom3DEnteredHandler {
    public static final QUuid cMoleculeMoveID = new QUuid("{8304E575-3517-4cab-9C3A-257A1363D23B}");
    public static final QUuid cMoleculeDrawID = new QUuid("{CE9A2AD3-47F9-48f4-A652-C2F581E3F643}");
    public static final QUuid cMoleculeUpID = new QUuid("{8B78E279-7DAE-4714-966B-7A168001E4EF}");
    public static final QUuid cMoleculeDownID = new QUuid("{D0A47338-E9FC-4eec-8778-B708DAEF4F5F}");
    public static final QUuid cMoleculeDeleteID = new QUuid("{8CD720A7-EEDE-489b-A3EA-1894239CD78B}");
    public static final QUuid cMoleculeTemplateBenzeneID = new QUuid("{80470057-008E-4420-AD96-02C32C1A0AA4}");
    public static final QUuid cMoleculeTemplateRing3ID = new QUuid("{6284D141-2EF7-41db-BE10-B5579B118E02}");
    public static final QUuid cMoleculeTemplateRing4ID = new QUuid("{29C9ABB9-9614-4905-99FE-1E19A3CAD8CF}");
    public static final QUuid cMoleculeTemplateRing5ID = new QUuid("{3665BFD5-2708-43b1-A535-ABB270FBDB8D}");
    public static final QUuid cMoleculeTemplateRing6ID = new QUuid("{07342C56-4ECA-442e-A230-C069595935F5}");
    public static final QUuid cMoleculeTemplateRing7ID = new QUuid("{DEDB18B6-8FD1-4baf-847B-AC8ECE3F4212}");
    public static final QUuid cMoleculeTemplateRing8ID = new QUuid("{6E95E787-AD32-4cb2-AE7E-45939E2F4A39}");
    public static final QUuid cMoleculeAtomChargePlusID = new QUuid("{35055822-7C05-466e-AD66-B57F84FBE2B2}");
    public static final QUuid cMoleculeAtomChargeMinusID = new QUuid("{40FAF8EB-34FB-49d7-AA77-284BB879E0FA}");
    public static final QUuid cMoleculeDrawChainID = new QUuid("{D318AEB3-9EE1-41f6-8C2E-9026A476F7BA}");
    public static final QUuid cMoleculeEditExplicitHydrogensID = new QUuid("{F85E2F14-9B08-433e-A97A-1B6B7EB52A44}");
    public static final QUuid cMoleculeNormalizeNumberingID = new QUuid("{93DAF004-BA73-4591-BF36-598025D92E24}");
    public static final QUuid cMoleculeNormalizeProtonsNumberingID = new QUuid("{B0318910-7EF7-4167-902B-6125DE7EF2C0}");
    public static final QUuid cMoleculeFixNumberingID = new QUuid("{BE273756-3065-4459-809F-1DFADD80566E}");
    private QCursor fDrawCursor;
    private QCursor fDeleteCursor;
    private QCursor fDrawChainCursor;
    private QCursor fTemplateCursor;
    private QCursor fBondUpCursor;
    private QCursor fBondDownCursor;
    private QCursor fChargeUpCursor;
    private QCursor fChargeDownCursor;
    private QPoint<Double> fLastMousePos;
    private QMap<QUuid, QSet<Integer>> fOutHLAtoms;
    private QRectF fOutHLArea;
    private TMoleculeTrackingHandler fTrackingHandler;
    private TMoleculeTableFactory fMoleculeTableFactory;
    private TMoleculePluginDockWidgetFactory fDockWidgetFactory;
    private boolean fInTempMode = false;
    private QMap<QString, QString> fToggleActionToMacro;
    private boolean inDragMode = false;
    private boolean inDrawMode = false;
    private boolean inLassoMode = false;
    private boolean fHoldSelection = false;
    private TEditorMode fCurrMode;
    private TTemplateType fCurrTemplate;
    private TChangeAtomType fCurrChangeAtomMode;
    private QString fEditAtomLabel;
    private QString fEditAtomTime;
    private QString fStoreEditAtomNumber;
    private int fEditAtomIndex = -1;
    private QList<Integer> fGrabbedShortcutIDs = new QList();
    private HandlerManager eventBus;

    public TMoleculePluginGui(HandlerManager evenBus) {
        this.fDrawCursor = new QCursor(new QPixmap(":/cursors/em-draw-cursor.png"), 0, 0);
        this.fDeleteCursor = new QCursor(new QPixmap(":/cursors/em-delete-cursor.png"), 0, 0);
        this.fDrawChainCursor = new QCursor(new QPixmap(":/cursors/em-drawchain-cursor.png"), 0, 0);
        this.fTemplateCursor = new QCursor(new QPixmap(":/cursors/em-template-cursor.png"), 0, 0);
        this.fBondUpCursor = new QCursor(new QPixmap(":/cursors/em-bond-up-cursor.png"), 0, 0);
        this.fBondDownCursor = new QCursor(new QPixmap(":/cursors/em-bond-down-cursor.png"), 0, 0);
        this.fChargeUpCursor = new QCursor(new QPixmap(":/cursors/em-charge-up-cursor.png"), 0, 0);
        this.fChargeDownCursor = new QCursor(new QPixmap(":/cursors/em-charge-down-cursor.png"), 0, 0);
        this.fMoleculeTableFactory = new TMoleculeTableFactory();
        this.fToggleActionToMacro = new QMap();
        this.fCurrMode = TEditorMode.em_None;
        this.fEditAtomLabel = new QString();
        this.fEditAtomTime = new QString();
        this.fStoreEditAtomNumber = new QString();
        this.fOutHLAtoms = new QMap();
        this.fLastMousePos = new QPoint<Double>(0.0, 0.0);
        this.eventBus = evenBus;
    }

    @Override
    public void registered(IFrameworkServices aIEvtFilterSrvs) {
        super.registered(aIEvtFilterSrvs);
        this.fMoleculeTableFactory = new TMoleculeTableFactory(this);
        this.fFramework.addDockWidgetFactory(this.fMoleculeTableFactory);
        this.fDockWidgetFactory = new TMoleculePluginDockWidgetFactory(this);
        this.fFramework.addDockWidgetFactory(this.fDockWidgetFactory);
        this.fTrackingHandler = new TMoleculeTrackingHandler(this);
        this.eventBus.addHandler(AtomEnteredEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(AtomLeftEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(BondEnteredEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(BondLeftEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(CompoundEnteredEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(CompoundLeftEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(AtomSelectionChangedEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(Atom3DEnteredEvent.TYPE, (EventHandler)this);
        this.fToggleActionToMacro.insert(new QString("moleculeShowNumber"), new QString("atomNum"));
        this.fToggleActionToMacro.insert(new QString("moleculeShowAnnotation"), new QString("annotation"));
        this.fToggleActionToMacro.insert(new QString("moleculeShowStereo"), new QString("stereo"));
        Timer timer = new Timer(){

            public void run() {
                if (TMoleculePluginGui.this.fFramework.canvasView().canvas().getPainter().getFocus().booleanValue()) {
                    TMoleculePluginGui.this.activeItem(TRtti.TRtti_Molecule).invalidate();
                    TMoleculePluginGui.this.activeItem(TRtti.TRtti_Molecule).recalcCoords();
                    TMoleculePluginGui.this.activeItem(TRtti.TRtti_Molecule).update();
                    TMoleculePluginGui.this.drawTracking(TMoleculePluginGui.this.fFramework.canvasView().canvas().getPainter());
                }
            }
        };
        timer.scheduleRepeating(33);
    }

    public void init() {
    }

    public void doAction(QString actName) {
        if (actName.toString().equals("moleculeEditAtomData")) {
            this.onEditAtomData(this.activeMolecule(), this.fTrackingHandler.HLAtom());
        } else if (actName.toString().equals("moleculeEditBondData")) {
            this.onEditBondData(this.activeMolecule(), this.fTrackingHandler.HLBond());
        } else if (actName.toString().equals("moleculeMove")) {
            this.setEditorMode(TEditorMode.em_Move);
            this.setFrameworkMode(cMoleculeMoveID);
        } else if (actName.toString().equals("moleculeDraw")) {
            this.setEditorMode(TEditorMode.em_Draw);
            this.setFrameworkMode(cMoleculeDrawID);
        } else if (actName.toString().equals("moleculeUp")) {
            this.setEditorMode(TEditorMode.em_Up);
            this.setFrameworkMode(cMoleculeUpID);
        } else if (actName.toString().equals("moleculeDown")) {
            this.setEditorMode(TEditorMode.em_Down);
            this.setFrameworkMode(cMoleculeDownID);
        } else if (actName.toString().equals("moleculeDelete")) {
            this.setEditorMode(TEditorMode.em_Delete);
            this.setFrameworkMode(cMoleculeDeleteID);
        } else if (actName.toString().equals("moleculeTemplateBenzene")) {
            this.setTemplate(TTemplateType.tt_Benzene);
            this.setFrameworkMode(cMoleculeTemplateBenzeneID);
        } else if (actName.toString().equals("moleculeTemplateRing3")) {
            this.setTemplate(TTemplateType.tt_Ring3);
            this.setFrameworkMode(cMoleculeTemplateRing3ID);
        } else if (actName.toString().equals("moleculeTemplateRing4")) {
            this.setTemplate(TTemplateType.tt_Ring4);
            this.setFrameworkMode(cMoleculeTemplateRing4ID);
        } else if (actName.toString().equals("moleculeTemplateRing5")) {
            this.setTemplate(TTemplateType.tt_Ring5);
            this.setFrameworkMode(cMoleculeTemplateRing5ID);
        } else if (actName.toString().equals("moleculeTemplateRing6")) {
            this.setTemplate(TTemplateType.tt_Ring6);
            this.setFrameworkMode(cMoleculeTemplateRing6ID);
        } else if (actName.toString().equals("moleculeTemplateRing7")) {
            this.setTemplate(TTemplateType.tt_Ring7);
            this.setFrameworkMode(cMoleculeTemplateRing7ID);
        } else if (actName.toString().equals("moleculeTemplateRing8")) {
            this.setTemplate(TTemplateType.tt_Ring8);
            this.setFrameworkMode(cMoleculeTemplateRing8ID);
        } else if (actName.toString().equals("moleculeAtomChargePlus")) {
            this.setChangeAtomMode(TChangeAtomType.cat_ChargePlus);
            this.setFrameworkMode(cMoleculeAtomChargePlusID);
        } else if (actName.toString().equals("moleculeAtomChargeMinus")) {
            this.setChangeAtomMode(TChangeAtomType.cat_ChargeMinus);
            this.setFrameworkMode(cMoleculeAtomChargeMinusID);
        } else if (actName.toString().equals("moleculeDrawChain")) {
            this.setEditorMode(TEditorMode.em_DrawChain);
            this.setFrameworkMode(cMoleculeDrawChainID);
        } else if (actName.toString().equals("moleculeAddExplicitHydrogens") || actName.toString().equals("moleculeRemoveExplicitHydrogens")) {
            this.onEditExplicitHydrogens(this.activeMolecule(), actName.toString().equals("moleculeAddExplicitHydrogens"));
            this.setFrameworkMode(new QUuid());
            this.setEditorMode(TEditorMode.em_None);
        } else if (actName.toString().equals("moleculeNormalizeNumbering")) {
            this.onNormalizeNumbering(this.activeMolecule(), false);
            this.setFrameworkMode(new QUuid());
            this.setEditorMode(TEditorMode.em_None);
        } else if (actName.toString().equals("moleculeNormalizeProtonsNumbering")) {
            this.onNormalizeNumbering(this.activeMolecule(), true);
            this.setFrameworkMode(new QUuid());
            this.setEditorMode(TEditorMode.em_None);
        } else if (actName.toString().equals("moleculeFixNumbering")) {
            this.setFrameworkMode(cMoleculeFixNumberingID);
            this.setEditorMode(TEditorMode.em_FixNumbering);
        } else if (this.fToggleActionToMacro.contains(actName)) {
            this.onToggleMacroAction(this.fToggleActionToMacro.find(actName));
        } else if (actName.toString().equals("undo")) {
            this.undo();
        } else if (actName.toString().equals("redo")) {
            this.redo();
        } else if (actName.toString().equals("zoomIn")) {
            QRectF bound = this.activeMolecule().boundingRect();
            QRectF areaMolecule = new QRectF(this.activeMolecule().fDx, this.activeMolecule().fDy, bound.width(), bound.height());
            QPoint<Double> center = new QPoint<Double>((double)this.activeMolecule().canvas().getPainter().getWidth() * 0.5, (double)this.activeMolecule().canvas().getPainter().getHeight() * 0.5);
            areaMolecule.moveCenter(center);
            areaMolecule.adjust(-bound.width() * 0.1, -bound.height() * 0.1, bound.width() * 0.1, bound.height() * 0.1);
            this.activeMolecule().setBoundingRect(areaMolecule);
            this.activeMolecule().invalidate();
            this.activeMolecule().update();
        } else if (actName.toString().equals("zoomOut")) {
            QRectF bound = this.activeMolecule().boundingRect();
            QRectF areaMolecule = new QRectF(this.activeMolecule().fDx, this.activeMolecule().fDy, bound.width(), bound.height());
            QPoint<Double> center = new QPoint<Double>((double)this.activeMolecule().canvas().getPainter().getWidth() * 0.5, (double)this.activeMolecule().canvas().getPainter().getHeight() * 0.5);
            areaMolecule.moveCenter(center);
            areaMolecule.adjust(bound.width() * 0.1, bound.height() * 0.1, -bound.width() * 0.1, -bound.height() * 0.1);
            this.activeMolecule().setBoundingRect(areaMolecule);
            this.activeMolecule().invalidate();
            this.activeMolecule().update();
        } else if (actName.toString().equals("zoomFull")) {
            QRectF areaMolecule = new QRectF(0.0, 0.0, this.activeMolecule().canvas().getPainter().getWidth(), this.activeMolecule().canvas().getPainter().getHeight());
            areaMolecule.adjust(areaMolecule.width() * 0.1, areaMolecule.height() * 0.1, -areaMolecule.width() * 0.1, -areaMolecule.height() * 0.1);
            this.activeMolecule().setBoundingRect(areaMolecule);
            this.activeMolecule().invalidate();
            this.activeMolecule().update();
        } else if (actName.toString().equals("new")) {
            this.activeMolecule().clear();
            this.resetMemory();
            this.activeMolecule().canvas().setCenter(this.activeMolecule().getSettings());
            this.activeMolecule().invalidate();
            this.activeMolecule().update();
        } else if (actName.toString().equals("moleculeProperties")) {
            WMoleculePropertiesWidget widget = this.getPropertiesWidget(0);
            this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)widget.getDialog()));
            widget.exec();
        }
    }

    public void updateActions(QList<TUpdateItem> aList) {
        TCanvasMolecule cnvMolecule = this.activeMolecule();
        this.updateAction("moleculeEditAtomData", false, true, aList);
        this.updateAction("moleculeMove", this.fCurrMode == TEditorMode.em_Move, true, aList);
        this.updateAction("moleculeDraw", this.fCurrMode == TEditorMode.em_Draw, true, aList);
        this.updateAction("moleculeUp", this.fCurrMode == TEditorMode.em_Up, true, aList);
        this.updateAction("moleculeDown", this.fCurrMode == TEditorMode.em_Down, true, aList);
        this.updateAction("moleculeDelete", this.fCurrMode == TEditorMode.em_Delete, true, aList);
        this.updateAction("moleculeTemplateBenzene", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Benzene, true, aList);
        this.updateAction("moleculeTemplateRing3", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Ring3, true, aList);
        this.updateAction("moleculeTemplateRing4", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Ring4, true, aList);
        this.updateAction("moleculeTemplateRing5", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Ring5, true, aList);
        this.updateAction("moleculeTemplateRing6", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Ring6, true, aList);
        this.updateAction("moleculeTemplateRing7", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Ring7, true, aList);
        this.updateAction("moleculeTemplateRing8", this.fCurrMode == TEditorMode.em_Template && this.fCurrTemplate == TTemplateType.tt_Ring8, true, aList);
        this.updateAction("moleculeAtomChargePlus", this.fCurrMode == TEditorMode.em_ChangeAtomLabel && this.fCurrChangeAtomMode == TChangeAtomType.cat_ChargePlus, true, aList);
        this.updateAction("moleculeAtomChargeMinus", this.fCurrMode == TEditorMode.em_ChangeAtomLabel && this.fCurrChangeAtomMode == TChangeAtomType.cat_ChargeMinus, true, aList);
        this.updateAction("moleculeDrawChain", this.fCurrMode == TEditorMode.em_DrawChain, true, aList);
        this.updateAction("moleculeAddExplicitHydrogens", false, cnvMolecule != null, aList);
        this.updateAction("moleculeRemoveExplicitHydrogens", false, cnvMolecule != null, aList);
        this.updateAction("moleculeNormalizeNumbering", false, cnvMolecule != null, aList);
        this.updateAction("moleculeNormalizeProtonsNumbering", false, cnvMolecule != null, aList);
        this.updateAction("moleculeFixNumbering", this.fCurrMode == TEditorMode.em_FixNumbering, cnvMolecule != null, aList);
        this.fMoleculeTableFactory.updateActions();
    }

    public boolean invalidate(QString aInvalidator) throws Exception {
        throw new Exception("method not implemented");
    }

    public void updateToggleMacroActions(TCanvasMolecule aMolecule) throws Exception {
        throw new Exception("method not implemented");
    }

    public QString getContextMenu(QPoint<Integer> aPos) {
        QPolygonF pol;
        QPoint cnvPos = this.wndToCanvas(aPos);
        TMoleculeHotArea curHotArea = this.currentHotArea(cnvPos);
        TCanvasMolecule cnvMolecule = this.activeMolecule();
        if (curHotArea != null) {
            switch (curHotArea.type()) {
                case 0: {
                    return new QString("atomContextMenu");
                }
            }
        }
        if ((pol = this.fTrackingHandler.oldHLBondPoly()).containsPoint(cnvPos, QT_FillRule.OddEvenFill)) {
            return new QString("bondContextMenu");
        }
        return new QString("moleculeContextMenu");
    }

    public void doComboBoxEvent(QString name, int type, QString text) throws Exception {
        throw new Exception("method not implemented");
    }

    public void doEditBoxEvent(QString name, QString text) throws Exception {
        throw new Exception("method not implemented");
    }

    public void doColorPickerEvent(QString name, QColor color) throws Exception {
        throw new Exception("method not implemented");
    }

    public int paste(QMimeData aData, QtCanvas aCanvas) throws Exception {
        throw new Exception("method not implemented");
    }

    public void pasteMetaData(TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public boolean wantPaste(QMimeData aData) throws Exception {
        throw new Exception("method not implemented");
    }

    public boolean copyMetaData(QList<TCanvasItem> aList, TDataStream aStream) throws Exception {
        throw new Exception("method not implemented");
    }

    public boolean wantCopy(QList<TCanvasItem> aList) throws Exception {
        throw new Exception("method not implemented");
    }

    private TMoleculeHotArea findMoleculeHotArea(QList<TMoleculeHotArea> areas, QPoint<Double> aCanvasPos) {
        for (TMoleculeHotArea area : areas) {
            if (!area.rect().contains(aCanvasPos)) continue;
            return area;
        }
        return null;
    }

    public TMoleculeHotArea currentHotArea(QPoint<Double> aCanvasPos) {
        TCanvasMolecule actMolecule = this.activeMolecule();
        if (actMolecule != null) {
            QList<TMoleculeHotArea> hAreas = actMolecule.hotAreas();
            TMoleculeHotArea hAIt = this.findMoleculeHotArea(hAreas, aCanvasPos);
            return hAIt;
        }
        return null;
    }

    public void onEditAtomData(TCanvasMolecule aCanvasMolecule, int aAtomIndex) {
        if (aCanvasMolecule == null || aAtomIndex < 0) {
            return;
        }
        WAtomDataDialog diag = new WAtomDataDialog(aCanvasMolecule, aAtomIndex, this.fFramework.mainWnd());
        this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)diag.getDialog()));
        diag.exec();
        diag.setEventBus(this.eventBus);
    }

    public void onEditBondData(TCanvasMolecule aCanvasMolecule, int aBondIndex) {
        if (aCanvasMolecule == null || aBondIndex < 0) {
            return;
        }
        WBondDataDialog diag = new WBondDataDialog(aCanvasMolecule, aBondIndex, this.fFramework.mainWnd());
        this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)diag.getDialog()));
        diag.exec();
        diag.setEventBus(this.eventBus);
    }

    public boolean eventFilter(QEvent aEvent) {
        boolean result = false;
        return result;
    }

    @Override
    public boolean eventToolTip(QHelpEvent aEvent) {
        TAtom a;
        QString tTip;
        boolean result = false;
        QPoint pos = this.fFramework.map(aEvent.pos(), IFrameworkServices.TMapMode.MAP_DOCWND, IFrameworkServices.TMapMode.MAP_CANVAS);
        TMoleculeHotArea hA = this.currentHotArea(pos);
        if (hA != null && !(tTip = (a = this.molecule(hA.moleculeId()).atom(hA.index())).getTatomData().tooltip()).isEmpty()) {
            result = true;
        }
        return result;
    }

    public void setFrameworkMode(QUuid aModeId, boolean isExclusive) {
        this.setFrameworkMode(aModeId, isExclusive, true, false);
    }

    public void setFrameworkMode(QUuid aModeId) {
        this.setFrameworkMode(aModeId, true, true, false);
    }

    public void setFrameworkMode(QUuid aModeId, boolean isExclusive, boolean isCheckable, boolean isTemporal) {
        Types_Framework_TModeFlag flags = Types_Framework_TModeFlag.mf_None;
        if (isCheckable) {
            flags = Types_Framework_TModeFlag.getType(flags.getValue() | Types_Framework_TModeFlag.mf_Checkable.getValue());
        }
        if (isTemporal) {
            flags = Types_Framework_TModeFlag.getType(flags.getValue() | Types_Framework_TModeFlag.mf_Temporal.getValue());
        }
        if (isExclusive) {
            flags = Types_Framework_TModeFlag.getType(flags.getValue() | Types_Framework_TModeFlag.mf_Exclusive.getValue());
        }
        this.fFramework.setMode(aModeId, this.fBaseUuid, flags);
    }

    public boolean isTemplateID(QUuid aMode) {
        return aMode.equals(cMoleculeTemplateBenzeneID) || aMode.equals(cMoleculeTemplateRing3ID) || aMode.equals(cMoleculeTemplateRing4ID) || aMode.equals(cMoleculeTemplateRing5ID) || aMode.equals(cMoleculeTemplateRing6ID) || aMode.equals(cMoleculeTemplateRing7ID) || aMode.equals(cMoleculeTemplateRing8ID);
    }

    public boolean isChangeAtomID(QUuid aMode) {
        return aMode.equals(cMoleculeAtomChargePlusID) || aMode.equals(cMoleculeAtomChargeMinusID);
    }

    public boolean isEditorModeID(QUuid aMode) {
        return aMode.equals(cMoleculeMoveID) || aMode.equals(cMoleculeDrawID) || aMode.equals(cMoleculeUpID) || aMode.equals(cMoleculeDownID) || aMode.equals(cMoleculeDeleteID) || this.isTemplateID(aMode) || this.isChangeAtomID(aMode) || aMode.equals(cMoleculeDrawChainID) || aMode.equals(cMoleculeEditExplicitHydrogensID) || aMode.equals(cMoleculeNormalizeNumberingID) || aMode.equals(cMoleculeNormalizeProtonsNumberingID) || aMode.equals(cMoleculeFixNumberingID);
    }

    public void onFrameworkModeChanged(QUuid aMode, QUuid uuid, Types_Framework_TModeFlag aFlags) {
        boolean bl = this.fInTempMode = (aFlags.getValue() & Types_Framework_TModeFlag.mf_Temporal.getValue()) != 0;
        if (!this.fInTempMode && !aMode.equals(ConstsCommon.assignmentModeID)) {
            this.clearMoleculeSelections();
        }
        if (!this.isEditorModeID(aMode)) {
            this.setEditorMode(TEditorMode.em_None);
        }
    }

    public QIcon getOptionsIcon() throws Exception {
        throw new Exception("method not implemented");
    }

    public WPropertiesWidget getOptionsWidget() throws Exception {
        throw new Exception("method not implemented");
    }

    public void optionsChanged(TCommonSettings aSettings) throws Exception {
        throw new Exception("method not implemented");
    }

    @Override
    public boolean eventMouseMove(QMouseEvent aEvent) {
        boolean doUpdateFramework = false;
        QPoint pos = this.fFramework.map(aEvent.pos(), IFrameworkServices.TMapMode.MAP_DOCWND, IFrameworkServices.TMapMode.MAP_CANVAS);
        if (this.fFramework.currentMode().equals(ConstsCommon.assignmentModeID) && !this.fTrackingHandler.selectedAtoms().isEmpty()) {
            this.highlightAtom(null, -1, new QRectF());
            doUpdateFramework = true;
        }
        QPoint<Double> storeLastMousePos = new QPoint<Double>(this.fLastMousePos.x(), this.fLastMousePos.y());
        this.fLastMousePos.setX((Double)pos.x());
        this.fLastMousePos.setY((Double)pos.y());
        TCanvasMolecule HLMol = this.pointedCanvasMoleculeHolder(pos);
        if (HLMol != null && HLMol.rtti() == TRtti.TRtti_Molecule) {
            TCanvasMolecule HLCanvasMol = HLMol;
            if (this.inDrawMode && HLCanvasMol.selectedAtoms().isEmpty()) {
                HLCanvasMol = this.getFirstMoleculeWithSelectedAtom();
            }
            if ((this.inDragMode || this.inDrawMode) && HLCanvasMol != null && !HLCanvasMol.selectedAtoms().isEmpty()) {
                HLCanvasMol.increaseCanvasSize(pos);
                if (this.inDragMode) {
                    int _size = HLCanvasMol.selectedAtoms().size();
                    for (int i = 0; i < _size; ++i) {
                        int aIndex = HLCanvasMol.selectedAtoms().get(i);
                        QPoint<Double> atomPoint = HLCanvasMol.getAtomCoord(aIndex);
                        QPoint<Double> aux = new QPoint<Double>(atomPoint.x(), atomPoint.y());
                        aux.setX(aux.x() + (Double)pos.x() - storeLastMousePos.x());
                        aux.setY(aux.y() + (Double)pos.y() - storeLastMousePos.y());
                        HLCanvasMol.setAtomCoord(aIndex, aux);
                    }
                } else if (this.inDrawMode) {
                    HLCanvasMol.setCursorPosition(pos);
                    HLCanvasMol.setDrawChain(this.fCurrMode == TEditorMode.em_DrawChain);
                }
                doUpdateFramework = true;
            }
        }
        if (this.inLassoMode) {
            this.fTrackingHandler.addPointToLasso(pos);
            doUpdateFramework = true;
        }
        if (doUpdateFramework) {
            this.fFramework.update();
        }
        this.fTrackingHandler.setItem(HLMol);
        if (HLMol != null && this.fTrackingHandler.setHLAreas(pos)) {
            return true;
        }
        this.fTrackingHandler.noHL();
        this.fFramework.update();
        return false;
    }

    public boolean highlightAtom(QUuid aMolId, int aAtomIndex, QRectF aHLRect) {
        QRectF updateRect = this.canvasToScrollArea(this.fTrackingHandler.oldHLAtomRect());
        updateRect = updateRect.united(this.canvasToScrollArea(aHLRect));
        this.fFramework.update(updateRect.toRect());
        return true;
    }

    public boolean highlightBond(QUuid aMolId, int aBondIndex, QPolygonF aHLPoly) {
        boolean needHighlightBond = false;
        boolean bl = needHighlightBond = this.fCurrMode != TEditorMode.em_None;
        if (needHighlightBond && !aHLPoly.isEmpty()) {
            QRectF updateRect = this.canvasToScrollArea(this.fTrackingHandler.oldHLBondPoly()).boundingRect();
            updateRect = updateRect.united(this.canvasToScrollArea(aHLPoly).boundingRect());
            this.fFramework.update(aHLPoly.toPolygon());
        }
        return true;
    }

    private TCanvasItem getItems(QList<TCanvasItem> items, QUuid aId) {
        for (TCanvasItem item : items) {
            if (item == null || !item.itemId().equals(aId)) continue;
            return item;
        }
        return null;
    }

    private TCanvasItem getItem(QList<TCanvasItem> items, QUuid aId) {
        for (TCanvasItem item : items) {
            if (item == null || !item.itemId().equals(aId)) continue;
            return item;
        }
        return null;
    }

    public void drawLasso(QPainter aPainter) {
        if (!this.inLassoMode) {
            return;
        }
        aPainter.save();
        QPen p = new QPen();
        QColor color = Qt.darkGray.getQColor();
        p.setColor(color);
        aPainter.setPen(p);
        aPainter.setBrush(QtBrushStyle.NoBrush);
        aPainter.drawPolyline(this.fTrackingHandler.lassoPoints());
        aPainter.restore();
    }

    public boolean drawTracking(QPainter aPainter) {
        if (this.fFramework.currentPage() == null) {
            return false;
        }
        QList items = this.fFramework.currentPage().allItems();
        QList selectedItems = items.sameDataIdItems(this.fTrackingHandler.selectedDataId());
        if (this.inLassoMode) {
            this.drawLasso(aPainter);
        }
        if (!this.fTrackingHandler.selectedAtoms().isEmpty()) {
            for (TCanvasItem item : selectedItems) {
                this.fTrackingHandler.drawSelectionAtomRect((TCanvasMolecule)item, aPainter);
            }
        } else if (this.fTrackingHandler.isCompoundSelected()) {
            for (TCanvasItem item : selectedItems) {
                this.fTrackingHandler.drawSelectionCompoundRect(item, aPainter);
            }
        }
        this.drawAtomLinked(aPainter);
        if (!this.fTrackingHandler.getHLMolId().isNull()) {
            QList<TCanvasItem> pageItems = this.fFramework.currentPage().allItems();
            TCanvasItem mainItem = this.getItem(pageItems, this.fTrackingHandler.getHLMolId());
            if (mainItem != null) {
                this.fTrackingHandler.drawHLMolecule(aPainter);
            }
            if (mainItem != null) {
                items = pageItems.sameDataIdItems(mainItem.dataId());
                for (TCanvasItem item : items) {
                    this.fTrackingHandler.drawHLCompound(item, aPainter);
                }
            }
        }
        return false;
    }

    public boolean editItem(TCanvasItem aCanvasItem) throws Exception {
        throw new Exception("method not implemented");
    }

    @Override
    public boolean eventMouseBtnPress(QMouseEvent aEvent) {
        QUuid HLMolId = this.fTrackingHandler.getHLMolId();
        QPoint pos = this.wndToCanvas(aEvent.pos());
        if (this.fFramework.currentMode().equals(ConstsCommon.assignmentModeID) && HLMolId.isNull() && this.pointedCanvasItem(TRtti.TRtti_NMRSpectrum, pos) != null) {
            return false;
        }
        if (HLMolId.isNull()) {
            if ((this.inCreateMode() || this.fCurrMode == TEditorMode.em_Template) && aEvent.getNativeButton() == 1) {
                QList<TCanvasItem> copy = new QList<TCanvasItem>();
                int atomCount = 1;
                if (this.fCurrMode == TEditorMode.em_Template) {
                    atomCount = TTemplateType.templateAtomCount(this.fCurrTemplate);
                }
                TMolecule mol = new TMolecule(atomCount, TTemplateType.templateBenzene(this.fCurrTemplate));
                TCanvasMolecule cnvMol = new TCanvasMolecule(mol, this.fFramework.currentPage(), this.activeMolecule().getSettings());
                QRectF rect = cnvMol.boundingRect();
                QPoint<Double> rectHalf = new QPoint<Double>(rect.width() / 2.0, rect.height() / 2.0);
                pos.setX((Double)pos.x() - rectHalf.x());
                pos.setY((Double)pos.y() - rectHalf.y());
                cnvMol.setXY(pos);
                copy.append(cnvMol);
                TCmdCreateItem cmd = new TCmdCreateItem(TCmdType.CreateItem, copy, this.fFramework, true);
                cmd.setAsSelected(true);
                this.fFramework.doCommand(cmd);
                this.fFramework.update();
                if (this.fCurrMode == TEditorMode.em_DrawChain) {
                    this.inDrawMode = true;
                    cnvMol.selectAtom(0, true);
                }
                return true;
            }
            return false;
        }
        boolean compoundClickedFlag = false;
        if (!HLMolId.isNull() && aEvent.getNativeButton() == 1) {
            QRectF rect = null;
            QPolygonF pol = null;
            for (TCanvasItem item : this.allCanvasItems()) {
                if (item.rtti() != TRtti.TRtti_Molecule) continue;
                rect = this.fTrackingHandler.HLAtomRect();
                this.fTrackingHandler.selectMolId(HLMolId);
                TCanvasMolecule canvasMol = this.getCanvasMolecule(this.fTrackingHandler.selectedMolId());
                if (canvasMol != null && canvasMol.atomRectContains(rect, pos)) {
                    return this.atomClicked(aEvent);
                }
                pol = this.fTrackingHandler.oldHLBondPoly();
                if (canvasMol == null || !pol.containsPoint(pos, QT_FillRule.OddEvenFill)) continue;
                return this.bondClicked(aEvent);
            }
            TCanvasItem compound = this.getItem(this.fFramework.allDocumentItems(), HLMolId);
            if (compound != null && compound.rtti() == TRtti.TRtti_Compound) {
                this.fTrackingHandler.selectMolId(HLMolId);
                compoundClickedFlag = true;
            }
        }
        if ((this.fCurrMode == TEditorMode.em_Move || this.fCurrMode == TEditorMode.em_Delete || this.fCurrMode == TEditorMode.em_FixNumbering) && aEvent.getNativeButton() == 1) {
            this.clearMoleculeSelections();
            this.fTrackingHandler.clearLasso();
            this.fTrackingHandler.addPointToLasso(pos);
            this.inLassoMode = true;
            return true;
        }
        if (compoundClickedFlag) {
            return true;
        }
        this.clearMoleculeSelections();
        return false;
    }

    public boolean atomClicked(QMouseEvent aEvent) {
        QUuid HLMolId = this.fTrackingHandler.getHLMolId();
        int HLAtom = this.fTrackingHandler.HLAtom();
        if (HLAtom == TMoleculeTrackingHandler.cNoIndex || HLMolId.isNull()) {
            return false;
        }
        TCanvasMolecule HLMol = this.getCanvasMolecule(HLMolId);
        if (HLMol == null) {
            return false;
        }
        TAtom atom = HLMol.getMolecule().atom(HLAtom);
        if (atom != null) {
            if (this.fFramework.currentMode() == ConstsCommon.assignmentModeID) {
                if (aEvent.isShiftKeyDown() || aEvent.isControlKeyDown()) {
                    this.fTrackingHandler.toggleAtomSelection(HLAtom);
                } else {
                    this.fTrackingHandler.selectAtom(HLAtom);
                }
                return true;
            }
            if (this.inCreateMode()) {
                this.inDrawMode = true;
                HLMol.selectAtom(HLAtom, true);
            }
            if (this.fCurrMode == TEditorMode.em_Delete) {
                TCmdDeleteAtoms cmd = null;
                if (this.fHoldSelection && HLMol.selectedAtoms().contains(HLAtom)) {
                    QVector<Integer> lst = HLMol.selectedAtoms();
                    cmd = new TCmdDeleteAtoms(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, -1, -1, lst, this.fCurrMode);
                } else {
                    cmd = new TCmdDeleteAtoms(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, HLAtom, -1, null, this.fCurrMode);
                }
                this.fFramework.doCommand(cmd);
                this.clearMoleculeSelections();
                this.fTrackingHandler.clearHLAtom();
                return true;
            }
            if (this.fCurrMode == TEditorMode.em_Move) {
                this.inDragMode = true;
                HLMol.storeAtomCoords();
                if (aEvent.isShiftKeyDown() || aEvent.isControlKeyDown()) {
                    HLMol.selectAtom(HLAtom, false);
                } else if (!HLMol.selectedAtoms().contains(HLAtom)) {
                    this.clearMoleculeSelections();
                    HLMol.selectAtom(HLAtom, true);
                }
            }
            if (this.fCurrMode == TEditorMode.em_Template) {
                TCmdAddTemplate cmd = new TCmdAddTemplate(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, HLAtom, -1, this.fCurrTemplate, this.fCurrMode);
                this.fFramework.doCommand(cmd);
                this.fTrackingHandler.clearHLAtom();
                return true;
            }
            if (this.fCurrMode == TEditorMode.em_ChangeAtomLabel) {
                QString elem = atom.elementSymbol();
                int newCharge = atom.getfCharge();
                if (this.fCurrChangeAtomMode == TChangeAtomType.cat_ChargePlus) {
                    ++newCharge;
                } else if (this.fCurrChangeAtomMode == TChangeAtomType.cat_ChargeMinus) {
                    --newCharge;
                }
                if (newCharge < -8 || newCharge > 8) {
                    newCharge = 0;
                }
                if (newCharge != atom.getfCharge()) {
                    TCmdChangeAtomLabel cmd = new TCmdChangeAtomLabel(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, new TAtomLabelInfo(HLAtom, new QString(""), newCharge, new QString(""), atom.getfIsotope(), atom.getTatomData().stereoNotation()), this.fCurrMode);
                    this.fFramework.doCommand(cmd);
                    this.fTrackingHandler.clearHLAtom();
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean bondClicked(QMouseEvent aEvent) {
        QUuid HLMolId = this.fTrackingHandler.getHLMolId();
        int HLBond = this.fTrackingHandler.HLBond();
        if (HLBond == TMoleculeTrackingHandler.cNoIndex || HLMolId.isNull()) {
            return false;
        }
        TCanvasMolecule HLMol = this.getCanvasMolecule(HLMolId);
        if (HLMol == null) {
            return false;
        }
        TBond bond = HLMol.getMolecule().bond(HLBond);
        if (bond != null) {
            if (this.fCurrMode == TEditorMode.em_Delete) {
                TCmdDeleteAtoms cmd = null;
                if (this.fHoldSelection && HLMol.selectedAtoms().contains(bond.atom1()) && HLMol.selectedAtoms().contains(bond.atom2())) {
                    QVector<Integer> lst = HLMol.selectedAtoms();
                    cmd = new TCmdDeleteAtoms(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, -1, -1, lst, this.fCurrMode);
                } else {
                    cmd = new TCmdDeleteAtoms(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, bond.atom1(), bond.atom2(), null, this.fCurrMode);
                }
                this.fFramework.doCommand(cmd);
                this.clearMoleculeSelections();
                this.fTrackingHandler.clearHLBond();
                return true;
            }
            if (this.inCreateMode()) {
                TCmdChangeBondType cmd = new TCmdChangeBondType(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, bond.atom1(), bond.atom2(), this.fCurrMode);
                this.fFramework.doCommand(cmd);
                return true;
            }
            if (this.fCurrMode == TEditorMode.em_Move) {
                this.inDragMode = true;
                HLMol.storeAtomCoords();
                if (!HLMol.selectedAtoms().contains(bond.atom1()) || !HLMol.selectedAtoms().contains(bond.atom2())) {
                    this.clearMoleculeSelections();
                    HLMol.selectAtom(bond.atom1(), true);
                    HLMol.selectAtom(bond.atom2(), false);
                }
                return true;
            }
            if (this.fCurrMode == TEditorMode.em_Template) {
                TCmdAddTemplate cmd = new TCmdAddTemplate(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, bond.atom1(), bond.atom2(), this.fCurrTemplate, this.fCurrMode);
                this.fFramework.doCommand(cmd);
                this.fTrackingHandler.clearHLBond();
                return true;
            }
        }
        return false;
    }

    public TCanvasMolecule getFirstMoleculeWithSelectedAtom() {
        QList<TCanvasItem> mols = this.getAllMolecules();
        for (int i = 0; i < mols.size(); ++i) {
            TCanvasMolecule mol = (TCanvasMolecule)mols.at(i);
            if (mol.selectedAtoms().size() != 1) continue;
            return mol;
        }
        return null;
    }

    @Override
    public boolean eventMouseBtnRelease(QMouseEvent aEvent) {
        if ((this.inDragMode || this.inDrawMode) && aEvent.getNativeButton() == 1) {
            TCmdEditMolecule cmd;
            QList<TCanvasItem> itemList;
            QPoint pos = this.fFramework.map(aEvent.pos(), IFrameworkServices.TMapMode.MAP_DOCWND, IFrameworkServices.TMapMode.MAP_CANVAS);
            TCanvasMolecule HLItem = this.pointedCanvasMoleculeHolder(pos);
            if (HLItem != null && HLItem.rtti() != TRtti.TRtti_Molecule) {
                return false;
            }
            TCanvasMolecule HLMol = HLItem;
            int atm2 = this.fTrackingHandler.HLAtom();
            if (this.inDrawMode && HLMol != null && atm2 != TMoleculeTrackingHandler.cNoIndex && (itemList = this.pointedCanvasItems(pos)).size() > 0) {
                TCanvasMolecule activeMol = this.activeMolecule();
                QList<TCanvasItem> lst = new QList<TCanvasMolecule>();
                if (activeMol == null || activeMol.selectedAtoms().isEmpty()) {
                    activeMol = this.getFirstMoleculeWithSelectedAtom();
                    lst.append(activeMol);
                } else {
                    lst = this.getSelectedMolecules();
                }
            }
            if (this.inDrawMode) {
                if (HLMol != null && atm2 != TMoleculeTrackingHandler.cNoIndex && HLMol.selectedAtoms().size() == 1) {
                    int atm1 = HLMol.selectedAtoms().get(0);
                    if (atm1 != atm2) {
                        if (HLMol.getMolecule().findBond(atm1, atm2) != null) {
                            cmd = new TCmdChangeBondType(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, atm1, atm2, this.fCurrMode);
                            this.fFramework.doCommand(cmd);
                            HLMol.clearSelection();
                        } else {
                            cmd = new TCmdAddBond(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, atm1, atm2, this.fCurrMode);
                            this.fFramework.doCommand(cmd);
                        }
                    } else if (HLMol != null && HLMol.selectedAtoms().size() == 1) {
                        atm1 = HLMol.selectedAtoms().get(0);
                        if (!HLMol.getMolecule().atomValenceExceeded(atm1)) {
                            QPoint<Double> newAtomPos = HLMol.calculateNewAtomPos(atm1, this.fCurrMode.getValue() == TEditorMode.em_DrawChain.getValue());
                            atm2 = HLMol.findAtomWithCoords(newAtomPos);
                            TCmdEditMolecule cmd2 = null;
                            if (atm2 >= 0) {
                                cmd2 = new TCmdAddBond(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, atm1, atm2, this.fCurrMode);
                            } else {
                                TEditorMode mode = this.fCurrMode;
                                if (this.fCurrMode == TEditorMode.em_DrawChain) {
                                    mode = TEditorMode.em_Draw;
                                }
                                cmd2 = new TCmdAddAtom(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, atm1, newAtomPos, false, mode);
                            }
                            this.fFramework.doCommand(cmd2);
                        }
                    }
                } else if (HLMol != null && HLMol.selectedAtoms().size() == 1) {
                    int atm1 = HLMol.selectedAtoms().get(0);
                    cmd = new TCmdAddAtom(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, atm1, pos, true, this.fCurrMode);
                    this.fFramework.doCommand(cmd);
                }
            }
            if (HLMol != null && this.inDragMode) {
                int atm1 = -1;
                if (HLMol.selectedAtoms().size() == 1) {
                    atm1 = HLMol.selectedAtoms().get(0);
                }
                cmd = null;
                if (atm1 > -1 && atm1 != atm2 && atm2 != TMoleculeTrackingHandler.cNoIndex) {
                    cmd = new TCmdMergeAtoms(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, atm1, atm2, pos, HLMol.getStoreAtomCoords(), this.fCurrMode);
                } else if (!HLMol.getAtomCoords().equals(HLMol.getStoreAtomCoords())) {
                    cmd = new TCmdMoveAtoms(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, HLMol.getAtomCoords(), HLMol.getStoreAtomCoords(), this.fCurrMode);
                }
                if (cmd != null) {
                    QVector<Integer> storeSelection = HLMol.selectedAtoms();
                    this.fFramework.doCommand(cmd);
                    if (this.fHoldSelection) {
                        HLMol.setSelectedAtoms(storeSelection);
                    }
                }
            }
            if (HLMol != null) {
                HLMol.setCursorPosition(new QPoint<Double>(0.0, 0.0));
            }
        }
        if (this.inLassoMode && aEvent.getNativeButton() == 1) {
            QPolygonF lasso = new QPolygonF(this.fTrackingHandler.lassoPoints());
            for (TCanvasItem item : this.allCanvasItems()) {
                if (item.rtti() != TRtti.TRtti_Molecule) continue;
                TCanvasMolecule mol = (TCanvasMolecule)item;
                QMatrix m = mol.fSizeToFSize(true);
                boolean foundFlag = false;
                QVector<Integer> atomSet = new QVector<Integer>();
                for (int i = 0; i < mol.getMolecule().atoms().size(); ++i) {
                    QPoint<Double> coord = m.map(mol.getAtomCoord(i));
                    if (!lasso.containsPoint(coord, QT_FillRule.OddEvenFill)) continue;
                    if (!foundFlag) {
                        this.fTrackingHandler.setItem(mol);
                        foundFlag = true;
                    }
                    if (this.fCurrMode == TEditorMode.em_FixNumbering) {
                        atomSet.append(i);
                        continue;
                    }
                    this.fTrackingHandler.selectAtom(i);
                    mol.selectAtom(i, false);
                }
                if (!foundFlag) continue;
                this.fHoldSelection = true;
                if (this.fCurrMode != TEditorMode.em_FixNumbering) break;
                boolean allFixed = mol.allFixed(atomSet);
                TCmdFixNumbering cmd = new TCmdFixNumbering(this.getSelectedMolecules(), this.getAllMolecules(), mol, atomSet, !allFixed, this.fCurrMode);
                this.fFramework.doCommand(cmd);
                break;
            }
            this.fTrackingHandler.clearLasso();
        }
        this.clearModeVariables();
        return this.fFramework.currentMode().equals(ConstsCommon.assignmentModeID) && !this.fTrackingHandler.getHLMolId().isNull();
    }

    public boolean eventMouseDoubleClick(QMouseEvent aEvent) {
        if (aEvent.getNativeButton() == 1) {
            TMoleculeHotArea curHotArea = this.currentHotArea(this.wndToCanvas(aEvent.pos()));
            if (curHotArea != null) {
                this.onEditAtomData(this.getCanvasMolecule(curHotArea.moleculeId()), curHotArea.index());
                return true;
            }
            QPolygonF pol = this.fTrackingHandler.oldHLBondPoly();
            if (pol.containsPoint(this.wndToCanvas(aEvent.pos()), QT_FillRule.OddEvenFill)) {
                this.onEditBondData(this.activeMolecule(), this.fTrackingHandler.HLBond());
                return true;
            }
            WMoleculePropertiesWidget widget = this.getPropertiesWidget(0);
            this.eventBus.fireEvent((GwtEvent)new ModalEnteredEvent((Widget)widget.getDialog()));
            widget.exec();
            return true;
        }
        return false;
    }

    public void drawRectSelection(TCanvasMolecule aSelectedMol, QPainter aPainter) {
        if (this.fTrackingHandler.selectedMolId().isNull()) {
            return;
        }
        this.fTrackingHandler.drawSelectionAtomRect(aSelectedMol, aPainter);
    }

    public void drawDragLines(TCanvasMolecule aSelectedMol, QPainter aPaint) {
        if (this.fTrackingHandler.selectedAtoms().isEmpty()) {
            return;
        }
        aPaint.save();
        QPen p = new QPen();
        p.setBrush(QtBrushStyle.NoBrush);
        QColor selColor = Qt.red.getQColor();
        selColor.setAlphaF(0.6);
        p.setColor(selColor);
        p.setStyle(QtPenStyle.SolidLine);
        aPaint.setPen(p);
        QMatrix m = aSelectedMol.moleculeToFSize();
        for (int i = 0; i < this.fTrackingHandler.selectedAtoms().size(); ++i) {
            TAtom atom = aSelectedMol.getMolecule().atoms().at(this.fTrackingHandler.selectedAtoms().at(i));
            QPoint<Double> atomPos = m.map(atom);
            atomPos.setX(atomPos.x() - aSelectedMol.canvasDx());
            atomPos.setY(atomPos.y() - aSelectedMol.canvasDy());
            atomPos = aSelectedMol.getRotationMatrix().map(atomPos);
            aPaint.drawLine(atomPos, this.fLastMousePos);
        }
        aPaint.restore();
    }

    public void drawAtomLinked(QPainter aPaint) {
        aPaint.save();
        QPen p = new QPen();
        QColor linkedColor = QColor.RED;
        p.setColor(linkedColor);
        aPaint.setPen(p);
        aPaint.setBrush(QtBrushStyle.NoBrush);
        QRectF atomRect = new QRectF();
        QRectF compoundRect = new QRectF();
        for (QUuid molId : this.fOutHLAtoms.keys()) {
            TCanvasItem mol = this.getItem(this.fFramework.allDocumentItems(), molId);
            if (mol == null) continue;
            if (mol.rtti() == TRtti.TRtti_Molecule) {
                Iterator iterator = this.fOutHLAtoms.find(molId).iterator();
                while (iterator.hasNext()) {
                    int atomIndex = (Integer)iterator.next();
                    atomRect = this.fTrackingHandler.calcHLAtomRect(mol, atomIndex);
                    this.drawRect(atomRect, aPaint, mol);
                }
                continue;
            }
            if (this.fOutHLAtoms.find(molId).isEmpty()) continue;
            compoundRect = this.fTrackingHandler.calcHLCompoundRect(mol);
            this.drawRect(compoundRect, aPaint, mol);
        }
        aPaint.restore();
    }

    public TCanvasMolecule pointedCanvasMoleculeHolder(QPoint<Double> aPos) {
        TCanvasMolecule firstHLMol = null;
        TCanvasMolecule HLMol = null;
        int n = 0;
        for (TCanvasItem item : this.pointedCanvasItems(aPos)) {
            if (item.rtti() != TRtti.TRtti_Molecule && item.rtti() != TRtti.TRtti_Compound) continue;
            HLMol = (TCanvasMolecule)item;
            if (firstHLMol == null) {
                firstHLMol = HLMol;
            }
            ++n;
        }
        if (n < 2) {
            return HLMol;
        }
        for (TCanvasItem item : this.pointedCanvasItems(aPos)) {
            if (item.rtti() != TRtti.TRtti_Molecule && item.rtti() != TRtti.TRtti_Compound) continue;
            HLMol = (TCanvasMolecule)item;
            this.fTrackingHandler.setItem(HLMol);
            if (!this.fTrackingHandler.setHLAreas(aPos) || this.fTrackingHandler.HLAtom() == TMoleculeTrackingHandler.cNoIndex && this.fTrackingHandler.HLBond() == TMoleculeTrackingHandler.cNoIndex) continue;
            return HLMol;
        }
        return firstHLMol;
    }

    public void drawRect(QRectF aRect, QPainter aPaint, TCanvasItem aMol) {
        aPaint.save();
        if (this.fTrackingHandler.isRotatingTextWithMol(aMol)) {
            aPaint.setMatrix(aMol.getRotationMatrix(), true);
        }
        aPaint.drawRect(aRect);
        aPaint.restore();
    }

    private QList<TCanvasItem> sameDataIdItems(QList<TCanvasItem> items, QUuid aId) {
        QList<TCanvasItem> result = new QList<TCanvasItem>();
        if (!aId.isNull()) {
            for (TCanvasItem item : items) {
                if (item == null || !item.dataId().equals(aId)) continue;
                result.append(item);
            }
        }
        return result;
    }

    private QList<TCanvasItem> sameDataIdItems(QList<TCanvasItem> items, TCanvasItem aItem) {
        if (aItem != null) {
            return this.sameDataIdItems(items, aItem.dataId());
        }
        return new QList<TCanvasItem>();
    }

    public void onUpdateHighlighting(QUuid aMolId, int aAtomIndex, QRectF aHLRect, boolean aFillOutHLAtoms) {
        if (aMolId.isNull()) {
            return;
        }
        boolean hasOldRect = !this.fTrackingHandler.oldHLAtomRect().isEmpty();
        QRectF updateRect = new QRectF();
        TCanvasItem mainItem = this.getItem(this.fFramework.allDocumentItems(), aMolId);
        QtCanvas currentPage = this.fFramework.currentPage();
        QList<TCanvasItem> pageItems = new QList<TCanvasItem>();
        if (currentPage != null) {
            pageItems = currentPage.allItems();
        }
        QList<TCanvasItem> sameDataIdItems = this.sameDataIdItems(pageItems, mainItem);
        if (mainItem != null && mainItem.isVisible() && mainItem.canvas().equals(currentPage)) {
            updateRect = aHLRect;
            if (hasOldRect) {
                updateRect = updateRect.united(this.fTrackingHandler.oldHLAtomRect());
            }
        }
        TCanvasMolecule friendMolecule = null;
        QRectF atomRect = new QRectF();
        if (this.fOutHLAtoms.keys().count() > 0) {
            QMap<QUuid, QSet<Integer>> mapIt = this.fOutHLAtoms;
            for (QUuid uuid : mapIt.keys()) {
                friendMolecule = null;
                friendMolecule = (TCanvasMolecule)this.getItem(sameDataIdItems, uuid);
                if (friendMolecule == null || !friendMolecule.canvas().equals(currentPage)) continue;
                QSet<Integer> atomsSet = mapIt.find(uuid);
                for (Integer value : atomsSet) {
                    atomRect = this.fTrackingHandler.calcHLAtomRect(friendMolecule, value);
                    if (friendMolecule.isRotatingTextWithMol()) {
                        atomRect = friendMolecule.getRotationMatrix().mapRect(atomRect);
                    }
                    updateRect = updateRect.united(atomRect);
                }
            }
            this.fOutHLAtoms.clear();
        }
        if (aFillOutHLAtoms && sameDataIdItems.count() > 1) {
            for (TCanvasItem friendItem : sameDataIdItems) {
                if (friendItem.equals(mainItem) || !friendItem.canvas().equals(currentPage)) continue;
                friendMolecule = (TCanvasMolecule)friendItem;
                this.fOutHLAtoms.find(friendItem.itemId()).append(aAtomIndex);
                atomRect = this.fTrackingHandler.calcHLAtomRect(friendMolecule, aAtomIndex);
                if (friendMolecule.isRotatingTextWithMol()) {
                    atomRect = friendMolecule.getRotationMatrix().mapRect(atomRect);
                }
                updateRect = updateRect.united(atomRect);
            }
        }
        if (!updateRect.isEmpty()) {
            this.fFramework.update(this.canvasToScrollArea(updateRect).toRect());
        }
    }

    public void grabShortcuts() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void releaseShortcuts() throws Exception {
        throw new Exception("Method not implemented");
    }

    @Override
    public void onAtomEntered(QUuid aMolId, int aAtomIndex, QRectF aHLRect) {
        if (aMolId.isNull()) {
            return;
        }
        this.onUpdateHighlighting(aMolId, aAtomIndex, aHLRect, true);
    }

    @Override
    public void onAtomLeft(QUuid aMolId, int aAtomIndex, QRectF aHLRect) {
        if (aMolId.isNull()) {
            return;
        }
        this.onUpdateHighlighting(aMolId, aAtomIndex, aHLRect, false);
    }

    @Override
    public void onAtomSelectionChanged(QUuid aDataId, int aAtomIndex, boolean aSelected) {
        if (aDataId.isNull() || aAtomIndex < 0) {
            this.fFramework.update();
        } else {
            QList itemList = this.fFramework.currentPage().allItems();
            itemList = itemList.sameDataIdItems(aDataId);
            TCanvasMolecule mainItem = null;
            for (TCanvasItem item : itemList) {
                mainItem = (TCanvasMolecule)item;
                QPoint atomPos = mainItem.atom(aAtomIndex);
                atomPos = mainItem.moleculeToFSize().map(atomPos);
                QRectF atomRect = mainItem.calcAtomRectSelection(aAtomIndex, atomPos);
                if (mainItem.isRotatingTextWithMol()) {
                    atomRect = mainItem.getRotationMatrix().mapRect(atomRect);
                }
                this.fFramework.update(this.canvasToScrollArea(atomRect).toRect(), true);
            }
        }
    }

    @Override
    public void onBondEntered(QUuid aMolId, int aBondIndex, QPolygonF aHLPoly) {
        if (aMolId.isNull()) {
            return;
        }
        QList<TCanvasItem> allItems = this.fFramework.allDocumentItems();
        TCanvasItem item = this.getItem(allItems, aMolId);
        if (item != null && item.isVisible() && item.canvas().equals(this.fFramework.currentPage())) {
            this.highlightBond(aMolId, aBondIndex, aHLPoly);
        }
    }

    @Override
    public void onBondLeft(QUuid aMolId, int aBondIndex, QPolygonF aHLPoly) {
        if (aMolId.isNull()) {
            return;
        }
        QList<TCanvasItem> allItems = this.fFramework.allDocumentItems();
        TCanvasItem item = this.getItem(allItems, aMolId);
        if (item != null && item.isVisible() && item.canvas().equals(this.fFramework.currentPage())) {
            this.highlightBond(aMolId, aBondIndex, aHLPoly);
        }
    }

    public QRectF canvasToScrollArea(QRectF aRect) {
        return this.fFramework.map(aRect.toRect(), IFrameworkServices.TMapMode.MAP_CANVAS, IFrameworkServices.TMapMode.MAP_SCROLLAREA).normalized();
    }

    public QPolygonF canvasToScrollArea(QPolygonF aPoly) {
        return this.fFramework.map(aPoly.toPolygon(), IFrameworkServices.TMapMode.MAP_CANVAS, IFrameworkServices.TMapMode.MAP_SCROLLAREA);
    }

    public QString htmlReport(QString aTable, TCanvasItem aItem) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void updateTable() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void highlight(QMap<QUuid, QList<TAtomIndex>> aHLAtoms) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void highlight(QUuid aMolId, QList<TAtomIndex> aAtomIndexes) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void highlight(QUuid aSpecId, QUuid aPeakId, double aPPMF1, double aPPMF2) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void highlightSameDataIdMols(QUuid aMolId, QList<Integer> aAtoms) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void onTransitionsHighlighted(QMap<QUuid, QList<TAtomIndex>> aTransitions, int aNucleus) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void highlight(QUuid aSpecId, QUuid aMultId, double aChemShift) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void setEditorMode(TEditorMode aMode) {
        if (this.fCurrMode == aMode) {
            this.fCurrMode = TEditorMode.em_None;
            this.fCurrTemplate = TTemplateType.tt_None;
            this.fCurrChangeAtomMode = TChangeAtomType.cat_None;
        } else {
            this.fCurrMode = aMode;
            if (this.fCurrMode != TEditorMode.em_Template) {
                this.fCurrTemplate = TTemplateType.tt_None;
            }
            if (this.fCurrMode != TEditorMode.em_ChangeAtomLabel) {
                this.fCurrChangeAtomMode = TChangeAtomType.cat_None;
            }
        }
        this.clearModeVariables();
    }

    public void setTemplate(TTemplateType aTemplate) {
        if (this.fCurrTemplate == aTemplate) {
            this.fCurrMode = TEditorMode.em_None;
            this.fCurrTemplate = TTemplateType.tt_None;
        } else {
            this.fCurrMode = TEditorMode.em_Template;
            this.fCurrTemplate = aTemplate;
        }
    }

    public void setChangeAtomMode(TChangeAtomType aChangeAtomMode) {
        if (this.fCurrChangeAtomMode == aChangeAtomMode) {
            this.fCurrMode = TEditorMode.em_None;
            this.fCurrChangeAtomMode = TChangeAtomType.cat_None;
        } else {
            this.fCurrMode = TEditorMode.em_ChangeAtomLabel;
            this.fCurrChangeAtomMode = aChangeAtomMode;
        }
    }

    @Override
    public void onAtom3DEntered(QUuid aMolId, int aAtomIndex) throws Exception {
        throw new Exception("Method not implemented");
    }

    public TCanvasItem activeMolTableItem() throws Exception {
        throw new Exception("Method not implemented");
    }

    public WMoleculePropertiesWidget getPropertiesWidget(int aType) {
        return new WMoleculePropertiesWidget(this);
    }

    public void clearMoleculeSelections() {
        this.fTrackingHandler.clearSelection();
        for (TCanvasItem item : this.allCanvasItems()) {
            if (item.rtti() != TRtti.TRtti_Molecule) continue;
            TCanvasMolecule mol = (TCanvasMolecule)item;
            mol.clearSelection();
        }
        this.fHoldSelection = false;
    }

    public QVector<TAtom> getCurrentMoleculeAtoms() {
        TCanvasMolecule mol = this.getCanvasMolecule(this.fTrackingHandler.selectedMolId());
        if (mol != null) {
            QVector<TAtom> result = mol.getMolecule().getAtoms();
            for (int i = 0; i < result.size(); ++i) {
                if (this.fTrackingHandler.selectedAtoms().contains(i)) continue;
                result.set(i, null);
            }
            return result;
        }
        return new QVector<TAtom>();
    }

    public boolean highlightAtoms(QMap<QUuid, QSet<Integer>> aMolAtoms) {
        if (this.fOutHLAtoms.equals(aMolAtoms)) {
            return false;
        }
        this.fOutHLAtoms.clear();
        for (QUuid id : aMolAtoms.keys()) {
            this.fOutHLAtoms.add(id, aMolAtoms.find(id));
        }
        for (QUuid molId : aMolAtoms.keys()) {
            TCanvasItem mol = this.getItem(this.fFramework.allDocumentItems(), molId);
            if (mol == null) continue;
            QRectF rect = new QRectF();
            QSet<Integer> atoms = aMolAtoms.find(molId);
            if (!atoms.isEmpty()) {
                if (mol.rtti() == TRtti.TRtti_Molecule) {
                    Iterator iterator = atoms.iterator();
                    while (iterator.hasNext()) {
                        int atomIndex = (Integer)iterator.next();
                        QRectF atomRect = this.fTrackingHandler.calcHLAtomRect(mol, atomIndex);
                        if (this.fTrackingHandler.isRotatingTextWithMol(mol)) {
                            atomRect = mol.getRotationMatrix().mapRect(atomRect);
                        }
                        rect = rect.unite(atomRect);
                    }
                } else {
                    rect = ((TCanvasCompound)mol).getHLRect();
                }
            } else {
                rect = mol.boundingRect();
            }
            this.fOutHLArea = new QRectF(this.fOutHLArea.unite(this.canvasToScrollArea(rect)));
        }
        this.fFramework.update(this.fOutHLArea.toRect(), true);
        if (aMolAtoms.isEmpty()) {
            this.fOutHLArea = new QRectF();
        }
        return true;
    }

    public void installSelectionHelper(TMoleculeSelectionHelper aHelper) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void registerAtomDataHandler(TAtomDataHandler aEditor) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void drawMolecule(QPainter aPainter, TMolecule aMolecule, QRectF aRect) throws Exception {
        throw new Exception("Method not implemented");
    }

    public QList<TCanvasItem> getSelection() throws Exception {
        throw new Exception("Method not implemented");
    }

    @Override
    public boolean eventShortcutOverride(QKeyEvent aEvent) {
        QUuid HLMolId = this.fTrackingHandler.getHLMolId();
        int HLAtom = this.fTrackingHandler.HLAtom();
        if (HLAtom == TMoleculeTrackingHandler.cNoIndex || HLMolId.isNull()) {
            return false;
        }
        TCanvasMolecule HLMol = this.getCanvasMolecule(HLMolId);
        if (HLMol == null) {
            return false;
        }
        QString txt = aEvent.text();
        if (txt.isEmpty()) {
            return false;
        }
        if (!(this.fEditAtomLabel.isEmpty() || this.fEditAtomTime.elapsed() <= 1000 && this.fEditAtomIndex == HLAtom)) {
            this.fEditAtomLabel.clear();
        }
        if (this.fEditAtomLabel.isEmpty()) {
            this.fStoreEditAtomNumber = HLMol.atom(HLAtom).getTatomData().number();
        }
        this.fEditAtomTime.start();
        this.fEditAtomLabel = this.fEditAtomLabel.append(txt);
        this.fEditAtomIndex = HLAtom;
        QString numStr = new QString();
        QString label = new QString();
        int charge = 0;
        int iso = 0;
        int nh = 0;
        SimpleAliasVO vo = TAtom.staticExpandSimpleAlias(this.fEditAtomLabel, label, nh, charge, iso);
        charge = vo.getChrg();
        iso = vo.getIso();
        nh = vo.getNh();
        label = vo.getS();
        if (vo.isResult()) {
            numStr = new QString().append(this.fStoreEditAtomNumber.toString());
        } else {
            boolean isNumber;
            label = new QString("");
            charge = HLMol.atom(HLAtom).getfCharge();
            iso = HLMol.atom(HLAtom).getfIsotope();
            boolean bl = isNumber = Character.isDigit(this.fEditAtomLabel.toString().charAt(0)) || this.fEditAtomLabel.toString().charAt(0) == '$';
            if (isNumber) {
                numStr = new QString().append(this.fEditAtomLabel.toString());
            } else {
                label = new QString().append(this.fEditAtomLabel.toString());
                QString chargeS = new QString("");
                if (label.endsWith(new QString("-")) || label.endsWith(new QString("+"))) {
                    chargeS.append(label.right(1).toString());
                    label.chop(1);
                }
                boolean isElement = false;
                if (!label.isEmpty()) {
                    TElement el = TPeriodicTable.getInstance().operatorElementSymbol(label.toUpperFirstLeter());
                    boolean bl2 = isElement = !el.equals(TPeriodicTable.getInstance().nullElement());
                }
                if (label.isEmpty() || isElement) {
                    if (isElement) {
                        charge = 0;
                    }
                    if (chargeS.equals(new QString("-"))) {
                        --charge;
                    } else if (chargeS.equals(new QString("+"))) {
                        ++charge;
                    }
                } else {
                    label = new QString().append(this.fEditAtomLabel);
                }
            }
        }
        TCmdChangeAtomLabel cmd = new TCmdChangeAtomLabel(this.getSelectedMolecules(), this.getAllMolecules(), HLMol, new TAtomLabelInfo(HLAtom, label, charge, numStr, iso, HLMol.atom(HLAtom).stereoNotation()), this.fCurrMode);
        this.fFramework.doCommand(cmd);
        return true;
    }

    public boolean wantsSetCursor(QPoint<Double> aPos, TCanvasItem aCurHoverItem, QCursor aCursor) {
        if (this.fCurrMode == TEditorMode.em_None || this.fCurrMode == TEditorMode.em_Move) {
            return false;
        }
        switch (this.fCurrMode) {
            case em_Draw: {
                aCursor.setQCursor(this.fDrawCursor);
                break;
            }
            case em_Up: {
                aCursor.setQCursor(this.fBondUpCursor);
                break;
            }
            case em_Down: {
                aCursor.setQCursor(this.fBondDownCursor);
                break;
            }
            case em_ChangeAtomLabel: {
                if (this.fCurrChangeAtomMode == TChangeAtomType.cat_ChargeMinus) {
                    aCursor.setQCursor(this.fChargeDownCursor);
                    break;
                }
                aCursor.setQCursor(this.fChargeUpCursor);
                break;
            }
            case em_Delete: {
                aCursor.setQCursor(this.fDeleteCursor);
                break;
            }
            case em_DrawChain: {
                aCursor.setQCursor(this.fDrawChainCursor);
                break;
            }
            case em_Template: {
                aCursor.setQCursor(this.fTemplateCursor);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void onEditExplicitHydrogens(TCanvasMolecule aCanvasMolecule, boolean aDoAdd) {
        if (aCanvasMolecule == null) {
            return;
        }
        TCmdEditExplicitHydrogens cmd = new TCmdEditExplicitHydrogens(this.getSelectedMolecules(), this.getAllMolecules(), aCanvasMolecule, aDoAdd, this.fCurrMode);
        this.fFramework.doCommand(cmd);
    }

    public void onNormalizeNumbering(TCanvasMolecule aCanvasMolecule, boolean aProtons) {
        if (aCanvasMolecule == null) {
            return;
        }
        TCmdNormalizeNumbering cmd = new TCmdNormalizeNumbering(this.getSelectedMolecules(), this.getAllMolecules(), aCanvasMolecule, aProtons, this.fCurrMode);
        this.fFramework.doCommand(cmd);
    }

    public void highlight(QUuid aMolId, int aNucleus, TAtomIndex aTAtomIndex) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void onCompoundEntered(QUuid aMolId, QRectF aHLRect) {
        this.updateHighlightingRect(aMolId, aHLRect);
    }

    void onCompoundLeft(QUuid aMolId, QRectF aHLRect) {
        this.updateHighlightingRect(aMolId, aHLRect);
    }

    public void updateHighlightingRect(QUuid aMolId, QRectF aHLRect) {
        TCanvasItem mainItem = this.getItem(this.fFramework.allDocumentItems(), aMolId);
        if (mainItem == null) {
            return;
        }
        boolean hasOldRect = !this.fTrackingHandler.oldHLCompoundRect().isEmpty();
        QRectF updateRect = new QRectF();
        QtCanvas currentPage = this.fFramework.currentPage();
        if (mainItem != null && mainItem.isVisible() && mainItem.canvas() == currentPage) {
            updateRect = aHLRect;
            if (hasOldRect) {
                updateRect.intersect(this.fTrackingHandler.oldHLCompoundRect().boundingRect());
            }
        }
        if (!updateRect.isEmpty()) {
            this.fFramework.update(this.canvasToScrollArea(updateRect).toRect());
        }
    }

    public boolean compoundClicked() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void onCompoundSelectionChanged(QUuid aDataId, boolean data) throws Exception {
        throw new Exception("Method not implemented");
    }

    public TCanvasItem activeMoleculeHolder() throws Exception {
        throw new Exception("Method not implemented");
    }

    public QList<TCanvasItem> getLinkedMolItems(QUuid aSpecId, QUuid aRole) throws Exception {
        throw new Exception("Method not implemented");
    }

    public void updateWidgets() throws Exception {
        throw new Exception("Method not implemented");
    }

    public void clearModeVariables() {
        this.inDragMode = false;
        this.inDrawMode = false;
        this.inLassoMode = false;
        this.fTrackingHandler.clearLasso();
    }

    public boolean inCreateMode() {
        return this.fCurrMode == TEditorMode.em_Draw || this.fCurrMode == TEditorMode.em_Up || this.fCurrMode == TEditorMode.em_Down || this.fCurrMode == TEditorMode.em_DrawChain;
    }

    @Override
    public boolean eventKeyRelease(QKeyEvent aEvent) {
        return false;
    }

    @Override
    public boolean eventWheel(QWheelEvent aEvent) {
        int zoom = 0;
        zoom = aEvent.getGwtEvent().getDeltaY() > 0 ? 1 : -1;
        QRectF bound = this.activeMolecule().boundingRect();
        QRectF areaMolecule = new QRectF(0.0, 0.0, bound.width(), bound.height());
        QPoint<Double> center = new QPoint<Double>((double)this.activeMolecule().canvas().getPainter().getWidth() * 0.5, (double)this.activeMolecule().canvas().getPainter().getHeight() * 0.5);
        areaMolecule.moveCenter(center);
        areaMolecule.adjust(-bound.width() * 0.1 * (double)zoom, -bound.height() * 0.1 * (double)zoom, bound.width() * 0.1 * (double)zoom, bound.height() * 0.1 * (double)zoom);
        this.activeMolecule().setBoundingRect(areaMolecule);
        return true;
    }

    public HandlerManager getEventBus() {
        return this.eventBus;
    }

    public void undo() {
        this.fFramework.undo();
        QRectF bound = this.activeMolecule().boundingRect();
        QRectF areaMolecule = new QRectF(this.activeMolecule().fDx, this.activeMolecule().fDy, bound.width(), bound.height());
        QRectF areaDraw = new QRectF(this.activeMolecule().fDx, this.activeMolecule().fDy, this.activeMolecule().canvas().getPainter().getWidth(), this.activeMolecule().canvas().getPainter().getHeight());
        if (areaDraw.contains(areaMolecule)) {
            this.activeMolecule().getSettings().scaleDraw = false;
        }
        this.activeMolecule().canvas().setCenter(this.activeMolecule().getSettings());
        this.activeMolecule().invalidate();
        this.activeMolecule().update();
    }

    public void redo() {
        this.fFramework.redo();
        QRectF bound = this.activeMolecule().boundingRect();
        QRectF areaMolecule = new QRectF(this.activeMolecule().fDx, this.activeMolecule().fDy, bound.width(), bound.height());
        QRectF areaDraw = new QRectF(this.activeMolecule().fDx, this.activeMolecule().fDy, this.activeMolecule().canvas().getPainter().getWidth(), this.activeMolecule().canvas().getPainter().getHeight());
        if (areaDraw.contains(areaMolecule)) {
            this.activeMolecule().getSettings().scaleDraw = false;
        }
        this.activeMolecule().canvas().setCenter(this.activeMolecule().getSettings());
        this.activeMolecule().invalidate();
        this.activeMolecule().update();
    }

    public boolean isStructureModified() {
        return this.fFramework.getNumberUndo() > 0;
    }

    public void resetMemory() {
        if (this.fFramework.getNumberUndo() > 0) {
            this.fFramework.resetMemento();
        }
    }

    public void updateTMolecule(TMolecule molecule, QtCanvas canvas) {
        if (molecule != null) {
            molecule.detectAromaticAtoms();
            TCanvasMolecule actual = this.activeMolecule();
            canvas.allItems().clear();
            TCanvasMolecule canvasMolecule = new TCanvasMolecule(molecule, canvas, actual.getSettings());
            canvas.allItems().append(canvasMolecule);
            canvas.setCenter(actual.getSettings());
            this.getfFramework().canvasView().setCanvas(canvas);
            this.activeMolecule().invalidate();
            this.activeMolecule().update();
        }
    }

    public void updateTMoleculeSameScale(TMolecule molecule, QtCanvas canvas) {
        if (molecule != null) {
            molecule.detectAromaticAtoms();
            TCanvasMolecule actual = this.activeMolecule();
            canvas.allItems().clear();
            TCanvasMolecule canvasMolecule = new TCanvasMolecule(molecule, canvas, actual.getSettings());
            canvasMolecule.fScaleFactor = 1.0;
            canvas.allItems().append(canvasMolecule);
            this.getfFramework().canvasView().setCanvas(canvas);
            this.activeMolecule().invalidate();
            this.activeMolecule().update();
        }
    }
}

